/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.google.android.exoplayer2.offline.Download;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.offline.DownloadRequest;
import com.google.android.exoplayer2.scheduler.Requirements;
import com.google.android.exoplayer2.scheduler.Scheduler;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NotificationUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.HashMap;
import java.util.List;

public abstract class DownloadService
extends Service {
    public static final String ACTION_INIT = "com.google.android.exoplayer.downloadService.action.INIT";
    private static final String ACTION_RESTART = "com.google.android.exoplayer.downloadService.action.RESTART";
    public static final String ACTION_ADD_DOWNLOAD = "com.google.android.exoplayer.downloadService.action.ADD_DOWNLOAD";
    public static final String ACTION_REMOVE_DOWNLOAD = "com.google.android.exoplayer.downloadService.action.REMOVE_DOWNLOAD";
    public static final String ACTION_REMOVE_ALL_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.REMOVE_ALL_DOWNLOADS";
    public static final String ACTION_RESUME_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.RESUME_DOWNLOADS";
    public static final String ACTION_PAUSE_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.PAUSE_DOWNLOADS";
    public static final String ACTION_SET_STOP_REASON = "com.google.android.exoplayer.downloadService.action.SET_STOP_REASON";
    public static final String ACTION_SET_REQUIREMENTS = "com.google.android.exoplayer.downloadService.action.SET_REQUIREMENTS";
    public static final String KEY_DOWNLOAD_REQUEST = "download_request";
    public static final String KEY_CONTENT_ID = "content_id";
    public static final String KEY_STOP_REASON = "stop_reason";
    public static final String KEY_REQUIREMENTS = "requirements";
    public static final String KEY_FOREGROUND = "foreground";
    public static final int FOREGROUND_NOTIFICATION_ID_NONE = 0;
    public static final long DEFAULT_FOREGROUND_NOTIFICATION_UPDATE_INTERVAL = 1000L;
    private static final String TAG = "DownloadService";
    private static final HashMap<Class<? extends DownloadService>, DownloadManagerHelper> downloadManagerListeners = new HashMap();
    @Nullable
    private final ForegroundNotificationUpdater foregroundNotificationUpdater;
    @Nullable
    private final String channelId;
    @StringRes
    private final int channelNameResourceId;
    private DownloadManager downloadManager;
    private int lastStartId;
    private boolean startedInForeground;
    private boolean taskRemoved;
    private boolean isDestroyed;

    protected DownloadService(int foregroundNotificationId) {
        this(foregroundNotificationId, 1000L);
    }

    protected DownloadService(int foregroundNotificationId, long foregroundNotificationUpdateInterval) {
        this(foregroundNotificationId, foregroundNotificationUpdateInterval, null, 0);
    }

    protected DownloadService(int foregroundNotificationId, long foregroundNotificationUpdateInterval, @Nullable String channelId, @StringRes int channelNameResourceId) {
        if (foregroundNotificationId == 0) {
            this.foregroundNotificationUpdater = null;
            this.channelId = null;
            this.channelNameResourceId = 0;
        } else {
            this.foregroundNotificationUpdater = new ForegroundNotificationUpdater(foregroundNotificationId, foregroundNotificationUpdateInterval);
            this.channelId = channelId;
            this.channelNameResourceId = channelNameResourceId;
        }
    }

    public static Intent buildAddDownloadIntent(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, boolean foreground) {
        return DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, 0, foreground);
    }

    public static Intent buildAddDownloadIntent(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, int stopReason, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_ADD_DOWNLOAD, foreground).putExtra(KEY_DOWNLOAD_REQUEST, (Parcelable)downloadRequest).putExtra(KEY_STOP_REASON, stopReason);
    }

    public static Intent buildRemoveDownloadIntent(Context context, Class<? extends DownloadService> clazz, String id, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_REMOVE_DOWNLOAD, foreground).putExtra(KEY_CONTENT_ID, id);
    }

    public static Intent buildRemoveAllDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_REMOVE_ALL_DOWNLOADS, foreground);
    }

    public static Intent buildResumeDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_RESUME_DOWNLOADS, foreground);
    }

    public static Intent buildPauseDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_PAUSE_DOWNLOADS, foreground);
    }

    public static Intent buildSetStopReasonIntent(Context context, Class<? extends DownloadService> clazz, @Nullable String id, int stopReason, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_SET_STOP_REASON, foreground).putExtra(KEY_CONTENT_ID, id).putExtra(KEY_STOP_REASON, stopReason);
    }

    public static Intent buildSetRequirementsIntent(Context context, Class<? extends DownloadService> clazz, Requirements requirements, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_SET_REQUIREMENTS, foreground).putExtra(KEY_REQUIREMENTS, (Parcelable)requirements);
    }

    public static void sendAddDownload(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, boolean foreground) {
        Intent intent = DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendAddDownload(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, int stopReason, boolean foreground) {
        Intent intent = DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, stopReason, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendRemoveDownload(Context context, Class<? extends DownloadService> clazz, String id, boolean foreground) {
        Intent intent = DownloadService.buildRemoveDownloadIntent(context, clazz, id, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendRemoveAllDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildRemoveAllDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendResumeDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildResumeDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendPauseDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildPauseDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendSetStopReason(Context context, Class<? extends DownloadService> clazz, @Nullable String id, int stopReason, boolean foreground) {
        Intent intent = DownloadService.buildSetStopReasonIntent(context, clazz, id, stopReason, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendSetRequirements(Context context, Class<? extends DownloadService> clazz, Requirements requirements, boolean foreground) {
        Intent intent = DownloadService.buildSetRequirementsIntent(context, clazz, requirements, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void start(Context context, Class<? extends DownloadService> clazz) {
        context.startService(DownloadService.getIntent(context, clazz, ACTION_INIT));
    }

    public static void startForeground(Context context, Class<? extends DownloadService> clazz) {
        Intent intent = DownloadService.getIntent(context, clazz, ACTION_INIT, true);
        Util.startForegroundService(context, intent);
    }

    public void onCreate() {
        Class<?> clazz;
        DownloadManagerHelper downloadManagerHelper;
        if (this.channelId != null) {
            NotificationUtil.createNotificationChannel((Context)this, this.channelId, this.channelNameResourceId, 2);
        }
        if ((downloadManagerHelper = downloadManagerListeners.get(clazz = ((Object)((Object)this)).getClass())) == null) {
            DownloadManager downloadManager = this.getDownloadManager();
            downloadManager.resumeDownloads();
            downloadManagerHelper = new DownloadManagerHelper(this.getApplicationContext(), downloadManager, this.getScheduler(), clazz);
            downloadManagerListeners.put(clazz, downloadManagerHelper);
        }
        this.downloadManager = downloadManagerHelper.downloadManager;
        downloadManagerHelper.attachService(this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.lastStartId = startId;
        this.taskRemoved = false;
        String intentAction = null;
        String contentId = null;
        if (intent != null) {
            intentAction = intent.getAction();
            this.startedInForeground |= intent.getBooleanExtra(KEY_FOREGROUND, false) || ACTION_RESTART.equals(intentAction);
            contentId = intent.getStringExtra(KEY_CONTENT_ID);
        }
        if (intentAction == null) {
            intentAction = ACTION_INIT;
        }
        switch (intentAction) {
            case "com.google.android.exoplayer.downloadService.action.INIT": 
            case "com.google.android.exoplayer.downloadService.action.RESTART": {
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.ADD_DOWNLOAD": {
                DownloadRequest downloadRequest = (DownloadRequest)intent.getParcelableExtra(KEY_DOWNLOAD_REQUEST);
                if (downloadRequest == null) {
                    Log.e(TAG, "Ignored ADD_DOWNLOAD: Missing download_request extra");
                    break;
                }
                int stopReason = intent.getIntExtra(KEY_STOP_REASON, 0);
                this.downloadManager.addDownload(downloadRequest, stopReason);
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.REMOVE_DOWNLOAD": {
                if (contentId == null) {
                    Log.e(TAG, "Ignored REMOVE_DOWNLOAD: Missing content_id extra");
                    break;
                }
                this.downloadManager.removeDownload(contentId);
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.REMOVE_ALL_DOWNLOADS": {
                this.downloadManager.removeAllDownloads();
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.RESUME_DOWNLOADS": {
                this.downloadManager.resumeDownloads();
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.PAUSE_DOWNLOADS": {
                this.downloadManager.pauseDownloads();
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.SET_STOP_REASON": {
                if (!intent.hasExtra(KEY_STOP_REASON)) {
                    Log.e(TAG, "Ignored SET_STOP_REASON: Missing stop_reason extra");
                    break;
                }
                int stopReason = intent.getIntExtra(KEY_STOP_REASON, 0);
                this.downloadManager.setStopReason(contentId, stopReason);
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.SET_REQUIREMENTS": {
                Requirements requirements = (Requirements)intent.getParcelableExtra(KEY_REQUIREMENTS);
                if (requirements == null) {
                    Log.e(TAG, "Ignored SET_REQUIREMENTS: Missing requirements extra");
                    break;
                }
                this.downloadManager.setRequirements(requirements);
                break;
            }
            default: {
                Log.e(TAG, "Ignored unrecognized action: " + intentAction);
            }
        }
        if (this.downloadManager.isIdle()) {
            this.stop();
        }
        return 1;
    }

    public void onTaskRemoved(Intent rootIntent) {
        this.taskRemoved = true;
    }

    public void onDestroy() {
        this.isDestroyed = true;
        DownloadManagerHelper downloadManagerHelper = downloadManagerListeners.get(((Object)((Object)this)).getClass());
        boolean unschedule = !this.downloadManager.isWaitingForRequirements();
        downloadManagerHelper.detachService(this, unschedule);
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.stopPeriodicUpdates();
        }
    }

    @Nullable
    public final IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException();
    }

    protected abstract DownloadManager getDownloadManager();

    @Nullable
    protected abstract Scheduler getScheduler();

    protected abstract Notification getForegroundNotification(List<Download> var1);

    protected final void invalidateForegroundNotification() {
        if (this.foregroundNotificationUpdater != null && !this.isDestroyed) {
            this.foregroundNotificationUpdater.invalidate();
        }
    }

    protected void onDownloadChanged(Download download) {
    }

    protected void onDownloadRemoved(Download download) {
    }

    private void notifyDownloadChanged(Download download) {
        this.onDownloadChanged(download);
        if (this.foregroundNotificationUpdater != null) {
            if (download.state == 2 || download.state == 5 || download.state == 7) {
                this.foregroundNotificationUpdater.startPeriodicUpdates();
            } else {
                this.foregroundNotificationUpdater.invalidate();
            }
        }
    }

    private void notifyDownloadRemoved(Download download) {
        this.onDownloadRemoved(download);
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.invalidate();
        }
    }

    private void stop() {
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.stopPeriodicUpdates();
            if (this.startedInForeground && Util.SDK_INT >= 26) {
                this.foregroundNotificationUpdater.showNotificationIfNotAlready();
            }
        }
        if (Util.SDK_INT < 28 && this.taskRemoved) {
            this.stopSelf();
        } else {
            this.stopSelfResult(this.lastStartId);
        }
    }

    private static Intent getIntent(Context context, Class<? extends DownloadService> clazz, String action, boolean foreground) {
        return DownloadService.getIntent(context, clazz, action).putExtra(KEY_FOREGROUND, foreground);
    }

    private static Intent getIntent(Context context, Class<? extends DownloadService> clazz, String action) {
        return new Intent(context, clazz).setAction(action);
    }

    private static void startService(Context context, Intent intent, boolean foreground) {
        if (foreground) {
            Util.startForegroundService(context, intent);
        } else {
            context.startService(intent);
        }
    }

    private static final class DownloadManagerHelper
    implements DownloadManager.Listener {
        private final Context context;
        private final DownloadManager downloadManager;
        @Nullable
        private final Scheduler scheduler;
        private final Class<? extends DownloadService> serviceClass;
        @Nullable
        private DownloadService downloadService;

        private DownloadManagerHelper(Context context, DownloadManager downloadManager, @Nullable Scheduler scheduler, Class<? extends DownloadService> serviceClass) {
            this.context = context;
            this.downloadManager = downloadManager;
            this.scheduler = scheduler;
            this.serviceClass = serviceClass;
            downloadManager.addListener(this);
            if (scheduler != null) {
                Requirements requirements = downloadManager.getRequirements();
                this.setSchedulerEnabled(!requirements.checkRequirements(context), requirements);
            }
        }

        public void attachService(DownloadService downloadService) {
            Assertions.checkState(this.downloadService == null);
            this.downloadService = downloadService;
        }

        public void detachService(DownloadService downloadService, boolean unschedule) {
            Assertions.checkState(this.downloadService == downloadService);
            this.downloadService = null;
            if (this.scheduler != null && unschedule) {
                this.scheduler.cancel();
            }
        }

        @Override
        public void onDownloadChanged(DownloadManager downloadManager, Download download) {
            if (this.downloadService != null) {
                this.downloadService.notifyDownloadChanged(download);
            }
        }

        @Override
        public void onDownloadRemoved(DownloadManager downloadManager, Download download) {
            if (this.downloadService != null) {
                this.downloadService.notifyDownloadRemoved(download);
            }
        }

        @Override
        public final void onIdle(DownloadManager downloadManager) {
            if (this.downloadService != null) {
                this.downloadService.stop();
            }
        }

        @Override
        public void onRequirementsStateChanged(DownloadManager downloadManager, Requirements requirements, int notMetRequirements) {
            boolean requirementsMet;
            boolean bl = requirementsMet = notMetRequirements == 0;
            if (this.downloadService == null && requirementsMet) {
                try {
                    Intent intent = DownloadService.getIntent(this.context, this.serviceClass, DownloadService.ACTION_INIT);
                    this.context.startService(intent);
                }
                catch (IllegalStateException e) {
                    return;
                }
            }
            if (this.scheduler != null) {
                this.setSchedulerEnabled(!requirementsMet, requirements);
            }
        }

        private void setSchedulerEnabled(boolean enabled, Requirements requirements) {
            if (!enabled) {
                this.scheduler.cancel();
            } else {
                String servicePackage = this.context.getPackageName();
                boolean success = this.scheduler.schedule(requirements, servicePackage, DownloadService.ACTION_RESTART);
                if (!success) {
                    Log.e(DownloadService.TAG, "Scheduling downloads failed.");
                }
            }
        }
    }

    private final class ForegroundNotificationUpdater {
        private final int notificationId;
        private final long updateInterval;
        private final Handler handler;
        private final Runnable updateRunnable;
        private boolean periodicUpdatesStarted;
        private boolean notificationDisplayed;

        public ForegroundNotificationUpdater(int notificationId, long updateInterval) {
            this.notificationId = notificationId;
            this.updateInterval = updateInterval;
            this.handler = new Handler(Looper.getMainLooper());
            this.updateRunnable = this::update;
        }

        public void startPeriodicUpdates() {
            this.periodicUpdatesStarted = true;
            this.update();
        }

        public void stopPeriodicUpdates() {
            this.periodicUpdatesStarted = false;
            this.handler.removeCallbacks(this.updateRunnable);
        }

        public void showNotificationIfNotAlready() {
            if (!this.notificationDisplayed) {
                this.update();
            }
        }

        public void invalidate() {
            if (this.notificationDisplayed) {
                this.update();
            }
        }

        private void update() {
            List<Download> downloads = DownloadService.this.downloadManager.getCurrentDownloads();
            DownloadService.this.startForeground(this.notificationId, DownloadService.this.getForegroundNotification(downloads));
            this.notificationDisplayed = true;
            if (this.periodicUpdatesStarted) {
                this.handler.removeCallbacks(this.updateRunnable);
                this.handler.postDelayed(this.updateRunnable, this.updateInterval);
            }
        }
    }
}

