/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DownloadRequest
implements Parcelable {
    public static final String TYPE_PROGRESSIVE = "progressive";
    public static final String TYPE_DASH = "dash";
    public static final String TYPE_HLS = "hls";
    public static final String TYPE_SS = "ss";
    public final String id;
    public final String type;
    public final Uri uri;
    public final List<StreamKey> streamKeys;
    @Nullable
    public final String customCacheKey;
    public final byte[] data;
    public static final Parcelable.Creator<DownloadRequest> CREATOR = new Parcelable.Creator<DownloadRequest>(){

        public DownloadRequest createFromParcel(Parcel in) {
            return new DownloadRequest(in);
        }

        public DownloadRequest[] newArray(int size) {
            return new DownloadRequest[size];
        }
    };

    public DownloadRequest(String id, String type, Uri uri, List<StreamKey> streamKeys, @Nullable String customCacheKey, @Nullable byte[] data) {
        if (TYPE_DASH.equals(type) || TYPE_HLS.equals(type) || TYPE_SS.equals(type)) {
            Assertions.checkArgument(customCacheKey == null, "customCacheKey must be null for type: " + type);
        }
        this.id = id;
        this.type = type;
        this.uri = uri;
        ArrayList<StreamKey> mutableKeys = new ArrayList<StreamKey>(streamKeys);
        Collections.sort(mutableKeys);
        this.streamKeys = Collections.unmodifiableList(mutableKeys);
        this.customCacheKey = customCacheKey;
        this.data = data != null ? Arrays.copyOf(data, data.length) : Util.EMPTY_BYTE_ARRAY;
    }

    DownloadRequest(Parcel in) {
        this.id = Util.castNonNull(in.readString());
        this.type = Util.castNonNull(in.readString());
        this.uri = Uri.parse((String)Util.castNonNull(in.readString()));
        int streamKeyCount = in.readInt();
        ArrayList<Parcelable> mutableStreamKeys = new ArrayList<Parcelable>(streamKeyCount);
        for (int i = 0; i < streamKeyCount; ++i) {
            mutableStreamKeys.add(in.readParcelable(StreamKey.class.getClassLoader()));
        }
        this.streamKeys = Collections.unmodifiableList(mutableStreamKeys);
        this.customCacheKey = in.readString();
        this.data = new byte[in.readInt()];
        in.readByteArray(this.data);
    }

    public DownloadRequest copyWithId(String id) {
        return new DownloadRequest(id, this.type, this.uri, this.streamKeys, this.customCacheKey, this.data);
    }

    public DownloadRequest copyWithMergedRequest(DownloadRequest newRequest) {
        List<StreamKey> mergedKeys;
        Assertions.checkArgument(this.id.equals(newRequest.id));
        Assertions.checkArgument(this.type.equals(newRequest.type));
        if (this.streamKeys.isEmpty() || newRequest.streamKeys.isEmpty()) {
            mergedKeys = Collections.emptyList();
        } else {
            mergedKeys = new ArrayList<StreamKey>(this.streamKeys);
            for (int i = 0; i < newRequest.streamKeys.size(); ++i) {
                StreamKey newKey = newRequest.streamKeys.get(i);
                if (mergedKeys.contains(newKey)) continue;
                mergedKeys.add(newKey);
            }
        }
        return new DownloadRequest(this.id, this.type, newRequest.uri, mergedKeys, newRequest.customCacheKey, newRequest.data);
    }

    public String toString() {
        return this.type + ":" + this.id;
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof DownloadRequest)) {
            return false;
        }
        DownloadRequest that = (DownloadRequest)o;
        return this.id.equals(that.id) && this.type.equals(that.type) && this.uri.equals((Object)that.uri) && this.streamKeys.equals(that.streamKeys) && Util.areEqual(this.customCacheKey, that.customCacheKey) && Arrays.equals(this.data, that.data);
    }

    public final int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + this.streamKeys.hashCode();
        result = 31 * result + (this.customCacheKey != null ? this.customCacheKey.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.type);
        dest.writeString(this.uri.toString());
        dest.writeInt(this.streamKeys.size());
        for (int i = 0; i < this.streamKeys.size(); ++i) {
            dest.writeParcelable((Parcelable)this.streamKeys.get(i), 0);
        }
        dest.writeString(this.customCacheKey);
        dest.writeInt(this.data.length);
        dest.writeByteArray(this.data);
    }

    public static class UnsupportedRequestException
    extends IOException {
    }
}

