/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.offline.DownloadRequest;
import com.google.android.exoplayer2.offline.Downloader;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.DownloaderFactory;
import com.google.android.exoplayer2.offline.ProgressiveDownloader;
import java.lang.reflect.Constructor;
import java.util.List;

public class DefaultDownloaderFactory
implements DownloaderFactory {
    @Nullable
    private static final Constructor<? extends Downloader> DASH_DOWNLOADER_CONSTRUCTOR;
    @Nullable
    private static final Constructor<? extends Downloader> HLS_DOWNLOADER_CONSTRUCTOR;
    @Nullable
    private static final Constructor<? extends Downloader> SS_DOWNLOADER_CONSTRUCTOR;
    private final DownloaderConstructorHelper downloaderConstructorHelper;

    public DefaultDownloaderFactory(DownloaderConstructorHelper downloaderConstructorHelper) {
        this.downloaderConstructorHelper = downloaderConstructorHelper;
    }

    @Override
    public Downloader createDownloader(DownloadRequest request) {
        switch (request.type) {
            case "progressive": {
                return new ProgressiveDownloader(request.uri, request.customCacheKey, this.downloaderConstructorHelper);
            }
            case "dash": {
                return this.createDownloader(request, DASH_DOWNLOADER_CONSTRUCTOR);
            }
            case "hls": {
                return this.createDownloader(request, HLS_DOWNLOADER_CONSTRUCTOR);
            }
            case "ss": {
                return this.createDownloader(request, SS_DOWNLOADER_CONSTRUCTOR);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + request.type);
    }

    private Downloader createDownloader(DownloadRequest request, @Nullable Constructor<? extends Downloader> constructor) {
        if (constructor == null) {
            throw new IllegalStateException("Module missing for: " + request.type);
        }
        try {
            return constructor.newInstance(request.uri, request.streamKeys, this.downloaderConstructorHelper);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate downloader for: " + request.type, e);
        }
    }

    private static Constructor<? extends Downloader> getDownloaderConstructor(Class<?> clazz) {
        try {
            return clazz.asSubclass(Downloader.class).getConstructor(Uri.class, List.class, DownloaderConstructorHelper.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Downloader constructor missing", e);
        }
    }

    static {
        Constructor<? extends Downloader> dashDownloaderConstructor = null;
        try {
            dashDownloaderConstructor = DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.google.android.exoplayer2.source.dash.offline.DashDownloader"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DASH_DOWNLOADER_CONSTRUCTOR = dashDownloaderConstructor;
        Constructor<? extends Downloader> hlsDownloaderConstructor = null;
        try {
            hlsDownloaderConstructor = DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.google.android.exoplayer2.source.hls.offline.HlsDownloader"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HLS_DOWNLOADER_CONSTRUCTOR = hlsDownloaderConstructor;
        Constructor<? extends Downloader> ssDownloaderConstructor = null;
        try {
            ssDownloaderConstructor = DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.google.android.exoplayer2.source.smoothstreaming.offline.SsDownloader"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SS_DOWNLOADER_CONSTRUCTOR = ssDownloaderConstructor;
    }
}

