/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.icy;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.util.List;
import java.util.Map;

public final class IcyHeaders
implements Metadata.Entry {
    public static final String REQUEST_HEADER_ENABLE_METADATA_NAME = "Icy-MetaData";
    public static final String REQUEST_HEADER_ENABLE_METADATA_VALUE = "1";
    private static final String TAG = "IcyHeaders";
    private static final String RESPONSE_HEADER_BITRATE = "icy-br";
    private static final String RESPONSE_HEADER_GENRE = "icy-genre";
    private static final String RESPONSE_HEADER_NAME = "icy-name";
    private static final String RESPONSE_HEADER_URL = "icy-url";
    private static final String RESPONSE_HEADER_PUB = "icy-pub";
    private static final String RESPONSE_HEADER_METADATA_INTERVAL = "icy-metaint";
    public final int bitrate;
    @Nullable
    public final String genre;
    @Nullable
    public final String name;
    @Nullable
    public final String url;
    public final boolean isPublic;
    public final int metadataInterval;
    public static final Parcelable.Creator<IcyHeaders> CREATOR = new Parcelable.Creator<IcyHeaders>(){

        public IcyHeaders createFromParcel(Parcel in) {
            return new IcyHeaders(in);
        }

        public IcyHeaders[] newArray(int size) {
            return new IcyHeaders[size];
        }
    };

    @Nullable
    public static IcyHeaders parse(Map<String, List<String>> responseHeaders) {
        boolean icyHeadersPresent = false;
        int bitrate = -1;
        String genre = null;
        String name = null;
        String url = null;
        boolean isPublic = false;
        int metadataInterval = -1;
        List<String> headers = responseHeaders.get(RESPONSE_HEADER_BITRATE);
        if (headers != null) {
            String bitrateHeader = headers.get(0);
            try {
                bitrate = Integer.parseInt(bitrateHeader) * 1000;
                if (bitrate > 0) {
                    icyHeadersPresent = true;
                } else {
                    Log.w(TAG, "Invalid bitrate: " + bitrateHeader);
                    bitrate = -1;
                }
            }
            catch (NumberFormatException e) {
                Log.w(TAG, "Invalid bitrate header: " + bitrateHeader);
            }
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_GENRE)) != null) {
            genre = headers.get(0);
            icyHeadersPresent = true;
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_NAME)) != null) {
            name = headers.get(0);
            icyHeadersPresent = true;
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_URL)) != null) {
            url = headers.get(0);
            icyHeadersPresent = true;
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_PUB)) != null) {
            isPublic = headers.get(0).equals(REQUEST_HEADER_ENABLE_METADATA_VALUE);
            icyHeadersPresent = true;
        }
        if ((headers = responseHeaders.get(RESPONSE_HEADER_METADATA_INTERVAL)) != null) {
            String metadataIntervalHeader = headers.get(0);
            try {
                metadataInterval = Integer.parseInt(metadataIntervalHeader);
                if (metadataInterval > 0) {
                    icyHeadersPresent = true;
                } else {
                    Log.w(TAG, "Invalid metadata interval: " + metadataIntervalHeader);
                    metadataInterval = -1;
                }
            }
            catch (NumberFormatException e) {
                Log.w(TAG, "Invalid metadata interval: " + metadataIntervalHeader);
            }
        }
        return icyHeadersPresent ? new IcyHeaders(bitrate, genre, name, url, isPublic, metadataInterval) : null;
    }

    public IcyHeaders(int bitrate, @Nullable String genre, @Nullable String name, @Nullable String url, boolean isPublic, int metadataInterval) {
        Assertions.checkArgument(metadataInterval == -1 || metadataInterval > 0);
        this.bitrate = bitrate;
        this.genre = genre;
        this.name = name;
        this.url = url;
        this.isPublic = isPublic;
        this.metadataInterval = metadataInterval;
    }

    IcyHeaders(Parcel in) {
        this.bitrate = in.readInt();
        this.genre = in.readString();
        this.name = in.readString();
        this.url = in.readString();
        this.isPublic = Util.readBoolean(in);
        this.metadataInterval = in.readInt();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IcyHeaders other = (IcyHeaders)obj;
        return this.bitrate == other.bitrate && Util.areEqual(this.genre, other.genre) && Util.areEqual(this.name, other.name) && Util.areEqual(this.url, other.url) && this.isPublic == other.isPublic && this.metadataInterval == other.metadataInterval;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.bitrate;
        result = 31 * result + (this.genre != null ? this.genre.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.isPublic ? 1 : 0);
        result = 31 * result + this.metadataInterval;
        return result;
    }

    public String toString() {
        return "IcyHeaders: name=\"" + this.name + "\", genre=\"" + this.genre + "\", bitrate=" + this.bitrate + ", metadataInterval=" + this.metadataInterval;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.bitrate);
        dest.writeString(this.genre);
        dest.writeString(this.name);
        dest.writeString(this.url);
        Util.writeBoolean(dest, this.isPublic);
        dest.writeInt(this.metadataInterval);
    }

    public int describeContents() {
        return 0;
    }
}

