/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.icy;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataDecoder;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.icy.IcyInfo;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IcyDecoder
implements MetadataDecoder {
    private static final String TAG = "IcyDecoder";
    private static final Pattern METADATA_ELEMENT = Pattern.compile("(.+?)='(.*?)';", 32);
    private static final String STREAM_KEY_NAME = "streamtitle";
    private static final String STREAM_KEY_URL = "streamurl";

    @Override
    @Nullable
    public Metadata decode(MetadataInputBuffer inputBuffer) {
        ByteBuffer buffer = inputBuffer.data;
        byte[] data = buffer.array();
        int length = buffer.limit();
        return this.decode(Util.fromUtf8Bytes(data, 0, length));
    }

    @Nullable
    @VisibleForTesting
    Metadata decode(String metadata) {
        String name = null;
        String url = null;
        int index = 0;
        Matcher matcher = METADATA_ELEMENT.matcher(metadata);
        while (matcher.find(index)) {
            String key = Util.toLowerInvariant(matcher.group(1));
            String value = matcher.group(2);
            switch (key) {
                case "streamtitle": {
                    name = value;
                    break;
                }
                case "streamurl": {
                    url = value;
                    break;
                }
                default: {
                    Log.w(TAG, "Unrecognized ICY tag: " + name);
                }
            }
            index = matcher.end();
        }
        return name != null || url != null ? new Metadata(new IcyInfo(name, url)) : null;
    }
}

