/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.emsg;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class EventMessageEncoder {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
    private final DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);

    @Nullable
    public byte[] encode(EventMessage eventMessage) {
        this.byteArrayOutputStream.reset();
        try {
            EventMessageEncoder.writeNullTerminatedString(this.dataOutputStream, eventMessage.schemeIdUri);
            String nonNullValue = eventMessage.value != null ? eventMessage.value : "";
            EventMessageEncoder.writeNullTerminatedString(this.dataOutputStream, nonNullValue);
            EventMessageEncoder.writeUnsignedInt(this.dataOutputStream, 1000L);
            EventMessageEncoder.writeUnsignedInt(this.dataOutputStream, 0L);
            EventMessageEncoder.writeUnsignedInt(this.dataOutputStream, eventMessage.durationMs);
            EventMessageEncoder.writeUnsignedInt(this.dataOutputStream, eventMessage.id);
            this.dataOutputStream.write(eventMessage.messageData);
            this.dataOutputStream.flush();
            return this.byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeNullTerminatedString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeBytes(value);
        dataOutputStream.writeByte(0);
    }

    private static void writeUnsignedInt(DataOutputStream outputStream, long value) throws IOException {
        outputStream.writeByte((int)(value >>> 24) & 0xFF);
        outputStream.writeByte((int)(value >>> 16) & 0xFF);
        outputStream.writeByte((int)(value >>> 8) & 0xFF);
        outputStream.writeByte((int)value & 0xFF);
    }
}

