/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.emsg;

import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataDecoder;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class EventMessageDecoder
implements MetadataDecoder {
    private static final String TAG = "EventMessageDecoder";

    @Override
    public Metadata decode(MetadataInputBuffer inputBuffer) {
        ByteBuffer buffer = inputBuffer.data;
        byte[] data = buffer.array();
        int size = buffer.limit();
        ParsableByteArray emsgData = new ParsableByteArray(data, size);
        String schemeIdUri = Assertions.checkNotNull(emsgData.readNullTerminatedString());
        String value = Assertions.checkNotNull(emsgData.readNullTerminatedString());
        long timescale = emsgData.readUnsignedInt();
        long presentationTimeDelta = emsgData.readUnsignedInt();
        if (presentationTimeDelta != 0L) {
            Log.w(TAG, "Ignoring non-zero presentation_time_delta: " + presentationTimeDelta);
        }
        long durationMs = Util.scaleLargeTimestamp(emsgData.readUnsignedInt(), 1000L, timescale);
        long id = emsgData.readUnsignedInt();
        byte[] messageData = Arrays.copyOfRange(data, emsgData.getPosition(), size);
        return new Metadata(new EventMessage(schemeIdUri, value, durationMs, id, messageData));
    }
}

