/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataDecoder;
import com.google.android.exoplayer2.metadata.MetadataDecoderFactory;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;

public final class MetadataRenderer
extends BaseRenderer
implements Handler.Callback {
    private static final int MSG_INVOKE_RENDERER = 0;
    private static final int MAX_PENDING_METADATA_COUNT = 5;
    private final MetadataDecoderFactory decoderFactory;
    private final MetadataOutput output;
    @Nullable
    private final Handler outputHandler;
    private final FormatHolder formatHolder;
    private final MetadataInputBuffer buffer;
    private final Metadata[] pendingMetadata;
    private final long[] pendingMetadataTimestamps;
    private int pendingMetadataIndex;
    private int pendingMetadataCount;
    private MetadataDecoder decoder;
    private boolean inputStreamEnded;

    public MetadataRenderer(MetadataOutput output, @Nullable Looper outputLooper) {
        this(output, outputLooper, MetadataDecoderFactory.DEFAULT);
    }

    public MetadataRenderer(MetadataOutput output, @Nullable Looper outputLooper, MetadataDecoderFactory decoderFactory) {
        super(4);
        this.output = Assertions.checkNotNull(output);
        this.outputHandler = outputLooper == null ? null : Util.createHandler(outputLooper, this);
        this.decoderFactory = Assertions.checkNotNull(decoderFactory);
        this.formatHolder = new FormatHolder();
        this.buffer = new MetadataInputBuffer();
        this.pendingMetadata = new Metadata[5];
        this.pendingMetadataTimestamps = new long[5];
    }

    @Override
    public int supportsFormat(Format format) {
        if (this.decoderFactory.supportsFormat(format)) {
            return MetadataRenderer.supportsFormatDrm(null, format.drmInitData) ? 4 : 2;
        }
        return 0;
    }

    @Override
    protected void onStreamChanged(Format[] formats, long offsetUs) throws ExoPlaybackException {
        this.decoder = this.decoderFactory.createDecoder(formats[0]);
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.flushPendingMetadata();
        this.inputStreamEnded = false;
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (!this.inputStreamEnded && this.pendingMetadataCount < 5) {
            this.buffer.clear();
            int result = this.readSource(this.formatHolder, this.buffer, false);
            if (result == -4) {
                if (this.buffer.isEndOfStream()) {
                    this.inputStreamEnded = true;
                } else if (!this.buffer.isDecodeOnly()) {
                    this.buffer.subsampleOffsetUs = this.formatHolder.format.subsampleOffsetUs;
                    this.buffer.flip();
                    int index = (this.pendingMetadataIndex + this.pendingMetadataCount) % 5;
                    Metadata metadata = this.decoder.decode(this.buffer);
                    if (metadata != null) {
                        this.pendingMetadata[index] = metadata;
                        this.pendingMetadataTimestamps[index] = this.buffer.timeUs;
                        ++this.pendingMetadataCount;
                    }
                }
            }
        }
        if (this.pendingMetadataCount > 0 && this.pendingMetadataTimestamps[this.pendingMetadataIndex] <= positionUs) {
            this.invokeRenderer(this.pendingMetadata[this.pendingMetadataIndex]);
            this.pendingMetadata[this.pendingMetadataIndex] = null;
            this.pendingMetadataIndex = (this.pendingMetadataIndex + 1) % 5;
            --this.pendingMetadataCount;
        }
    }

    @Override
    protected void onDisabled() {
        this.flushPendingMetadata();
        this.decoder = null;
    }

    @Override
    public boolean isEnded() {
        return this.inputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private void invokeRenderer(Metadata metadata) {
        if (this.outputHandler != null) {
            this.outputHandler.obtainMessage(0, (Object)metadata).sendToTarget();
        } else {
            this.invokeRendererInternal(metadata);
        }
    }

    private void flushPendingMetadata() {
        Arrays.fill(this.pendingMetadata, null);
        this.pendingMetadataIndex = 0;
        this.pendingMetadataCount = 0;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeRendererInternal((Metadata)msg.obj);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private void invokeRendererInternal(Metadata metadata) {
        this.output.onMetadata(metadata);
    }

    @Deprecated
    public static interface Output
    extends MetadataOutput {
    }
}

