/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.metadata.MetadataDecoder;
import com.google.android.exoplayer2.metadata.emsg.EventMessageDecoder;
import com.google.android.exoplayer2.metadata.icy.IcyDecoder;
import com.google.android.exoplayer2.metadata.id3.Id3Decoder;
import com.google.android.exoplayer2.metadata.scte35.SpliceInfoDecoder;

public interface MetadataDecoderFactory {
    public static final MetadataDecoderFactory DEFAULT = new MetadataDecoderFactory(){

        @Override
        public boolean supportsFormat(Format format) {
            String mimeType = format.sampleMimeType;
            return "application/id3".equals(mimeType) || "application/x-emsg".equals(mimeType) || "application/x-scte35".equals(mimeType) || "application/x-icy".equals(mimeType);
        }

        @Override
        public MetadataDecoder createDecoder(Format format) {
            switch (format.sampleMimeType) {
                case "application/id3": {
                    return new Id3Decoder();
                }
                case "application/x-emsg": {
                    return new EventMessageDecoder();
                }
                case "application/x-scte35": {
                    return new SpliceInfoDecoder();
                }
                case "application/x-icy": {
                    return new IcyDecoder();
                }
            }
            throw new IllegalArgumentException("Attempted to create decoder for unsupported format");
        }
    };

    public boolean supportsFormat(Format var1);

    public MetadataDecoder createDecoder(Format var1);
}

