/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseIntArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressLint(value={"InlinedApi"})
public final class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    private static final Pattern PROFILE_PATTERN = Pattern.compile("^\\D?(\\d+)$");
    private static final HashMap<CodecKey, List<MediaCodecInfo>> decoderInfosCache = new HashMap();
    private static final SparseIntArray AVC_PROFILE_NUMBER_TO_CONST;
    private static final SparseIntArray AVC_LEVEL_NUMBER_TO_CONST;
    private static final String CODEC_ID_AVC1 = "avc1";
    private static final String CODEC_ID_AVC2 = "avc2";
    private static final Map<String, Integer> HEVC_CODEC_STRING_TO_PROFILE_LEVEL;
    private static final String CODEC_ID_HEV1 = "hev1";
    private static final String CODEC_ID_HVC1 = "hvc1";
    private static final Map<String, Integer> DOLBY_VISION_STRING_TO_PROFILE;
    private static final Map<String, Integer> DOLBY_VISION_STRING_TO_LEVEL;
    private static final String CODEC_ID_DVHE = "dvhe";
    private static final String CODEC_ID_DVH1 = "dvh1";
    private static final SparseIntArray MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE;
    private static final String CODEC_ID_MP4A = "mp4a";
    private static int maxH264DecodableFrameSize;

    private MediaCodecUtil() {
    }

    public static void warmDecoderInfoCache(String mimeType, boolean secure, boolean tunneling) {
        try {
            MediaCodecUtil.getDecoderInfos(mimeType, secure, tunneling);
        }
        catch (DecoderQueryException e) {
            Log.e(TAG, "Codec warming failed", e);
        }
    }

    @Nullable
    public static MediaCodecInfo getPassthroughDecoderInfo() throws DecoderQueryException {
        MediaCodecInfo decoderInfo = MediaCodecUtil.getDecoderInfo("audio/raw", false, false);
        return decoderInfo == null ? null : MediaCodecInfo.newPassthroughInstance(decoderInfo.name);
    }

    @Nullable
    public static MediaCodecInfo getDecoderInfo(String mimeType, boolean secure, boolean tunneling) throws DecoderQueryException {
        List<MediaCodecInfo> decoderInfos = MediaCodecUtil.getDecoderInfos(mimeType, secure, tunneling);
        return decoderInfos.isEmpty() ? null : decoderInfos.get(0);
    }

    public static synchronized List<MediaCodecInfo> getDecoderInfos(String mimeType, boolean secure, boolean tunneling) throws DecoderQueryException {
        CodecKey key = new CodecKey(mimeType, secure, tunneling);
        List<MediaCodecInfo> cachedDecoderInfos = decoderInfosCache.get(key);
        if (cachedDecoderInfos != null) {
            return cachedDecoderInfos;
        }
        MediaCodecListCompat mediaCodecList = Util.SDK_INT >= 21 ? new MediaCodecListCompatV21(secure, tunneling) : new MediaCodecListCompatV16();
        ArrayList<MediaCodecInfo> decoderInfos = MediaCodecUtil.getDecoderInfosInternal(key, mediaCodecList, mimeType);
        if (secure && decoderInfos.isEmpty() && 21 <= Util.SDK_INT && Util.SDK_INT <= 23 && !(decoderInfos = MediaCodecUtil.getDecoderInfosInternal(key, mediaCodecList = new MediaCodecListCompatV16(), mimeType)).isEmpty()) {
            Log.w(TAG, "MediaCodecList API didn't list secure decoder for: " + mimeType + ". Assuming: " + decoderInfos.get((int)0).name);
        }
        if ("audio/eac3-joc".equals(mimeType)) {
            CodecKey eac3Key = new CodecKey("audio/eac3", key.secure, key.tunneling);
            ArrayList<MediaCodecInfo> eac3DecoderInfos = MediaCodecUtil.getDecoderInfosInternal(eac3Key, mediaCodecList, mimeType);
            decoderInfos.addAll(eac3DecoderInfos);
        }
        MediaCodecUtil.applyWorkarounds(mimeType, decoderInfos);
        List<MediaCodecInfo> unmodifiableDecoderInfos = Collections.unmodifiableList(decoderInfos);
        decoderInfosCache.put(key, unmodifiableDecoderInfos);
        return unmodifiableDecoderInfos;
    }

    public static int maxH264DecodableFrameSize() throws DecoderQueryException {
        if (maxH264DecodableFrameSize == -1) {
            int result = 0;
            MediaCodecInfo decoderInfo = MediaCodecUtil.getDecoderInfo("video/avc", false, false);
            if (decoderInfo != null) {
                for (MediaCodecInfo.CodecProfileLevel profileLevel : decoderInfo.getProfileLevels()) {
                    result = Math.max(MediaCodecUtil.avcLevelToMaxFrameSize(profileLevel.level), result);
                }
                result = Math.max(result, Util.SDK_INT >= 21 ? 345600 : 172800);
            }
            maxH264DecodableFrameSize = result;
        }
        return maxH264DecodableFrameSize;
    }

    @Nullable
    public static Pair<Integer, Integer> getCodecProfileAndLevel(@Nullable String codec) {
        if (codec == null) {
            return null;
        }
        String[] parts = codec.split("\\.");
        switch (parts[0]) {
            case "avc1": 
            case "avc2": {
                return MediaCodecUtil.getAvcProfileAndLevel(codec, parts);
            }
            case "hev1": 
            case "hvc1": {
                return MediaCodecUtil.getHevcProfileAndLevel(codec, parts);
            }
            case "dvhe": 
            case "dvh1": {
                return MediaCodecUtil.getDolbyVisionProfileAndLevel(codec, parts);
            }
            case "mp4a": {
                return MediaCodecUtil.getAacCodecProfileAndLevel(codec, parts);
            }
        }
        return null;
    }

    private static ArrayList<MediaCodecInfo> getDecoderInfosInternal(CodecKey key, MediaCodecListCompat mediaCodecList, String requestedMimeType) throws DecoderQueryException {
        try {
            ArrayList<MediaCodecInfo> decoderInfos = new ArrayList<MediaCodecInfo>();
            String mimeType = key.mimeType;
            int numberOfCodecs = mediaCodecList.getCodecCount();
            boolean secureDecodersExplicit = mediaCodecList.secureDecodersExplicit();
            for (int i = 0; i < numberOfCodecs; ++i) {
                String name;
                android.media.MediaCodecInfo codecInfo = mediaCodecList.getCodecInfoAt(i);
                String supportedType = MediaCodecUtil.getCodecSupportedType(codecInfo, name = codecInfo.getName(), secureDecodersExplicit, requestedMimeType);
                if (supportedType == null) continue;
                try {
                    MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(supportedType);
                    boolean tunnelingSupported = mediaCodecList.isFeatureSupported("tunneled-playback", supportedType, capabilities);
                    boolean tunnelingRequired = mediaCodecList.isFeatureRequired("tunneled-playback", supportedType, capabilities);
                    if (!key.tunneling && tunnelingRequired || key.tunneling && !tunnelingSupported) continue;
                    boolean secureSupported = mediaCodecList.isFeatureSupported("secure-playback", supportedType, capabilities);
                    boolean secureRequired = mediaCodecList.isFeatureRequired("secure-playback", supportedType, capabilities);
                    if (!key.secure && secureRequired || key.secure && !secureSupported) continue;
                    boolean forceDisableAdaptive = MediaCodecUtil.codecNeedsDisableAdaptationWorkaround(name);
                    if (secureDecodersExplicit && key.secure == secureSupported || !secureDecodersExplicit && !key.secure) {
                        decoderInfos.add(MediaCodecInfo.newInstance(name, mimeType, capabilities, forceDisableAdaptive, false));
                        continue;
                    }
                    if (secureDecodersExplicit || !secureSupported) continue;
                    decoderInfos.add(MediaCodecInfo.newInstance(name + ".secure", mimeType, capabilities, forceDisableAdaptive, true));
                    return decoderInfos;
                }
                catch (Exception e) {
                    if (Util.SDK_INT <= 23 && !decoderInfos.isEmpty()) {
                        Log.e(TAG, "Skipping codec " + name + " (failed to query capabilities)");
                        continue;
                    }
                    Log.e(TAG, "Failed to query codec " + name + " (" + supportedType + ")");
                    throw e;
                }
            }
            return decoderInfos;
        }
        catch (Exception e) {
            throw new DecoderQueryException(e);
        }
    }

    @Nullable
    private static String getCodecSupportedType(android.media.MediaCodecInfo info, String name, boolean secureDecodersExplicit, String requestedMimeType) {
        if (MediaCodecUtil.isCodecUsableDecoder(info, name, secureDecodersExplicit, requestedMimeType)) {
            String[] supportedTypes;
            if (requestedMimeType.equals("video/dolby-vision")) {
                if ("OMX.MS.HEVCDV.Decoder".equals(name)) {
                    return "video/hevcdv";
                }
                if ("OMX.RTK.video.decoder".equals(name) || "OMX.realtek.video.decoder.tunneled".equals(name)) {
                    return "video/dv_hevc";
                }
            }
            for (String supportedType : supportedTypes = info.getSupportedTypes()) {
                if (!supportedType.equalsIgnoreCase(requestedMimeType)) continue;
                return supportedType;
            }
        }
        return null;
    }

    private static boolean isCodecUsableDecoder(android.media.MediaCodecInfo info, String name, boolean secureDecodersExplicit, String requestedMimeType) {
        if (info.isEncoder() || !secureDecodersExplicit && name.endsWith(".secure")) {
            return false;
        }
        if (Util.SDK_INT < 21 && ("CIPAACDecoder".equals(name) || "CIPMP3Decoder".equals(name) || "CIPVorbisDecoder".equals(name) || "CIPAMRNBDecoder".equals(name) || "AACDecoder".equals(name) || "MP3Decoder".equals(name))) {
            return false;
        }
        if (Util.SDK_INT < 18 && "OMX.MTK.AUDIO.DECODER.AAC".equals(name) && ("a70".equals(Util.DEVICE) || "Xiaomi".equals(Util.MANUFACTURER) && Util.DEVICE.startsWith("HM"))) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.mp3".equals(name) && ("dlxu".equals(Util.DEVICE) || "protou".equals(Util.DEVICE) || "ville".equals(Util.DEVICE) || "villeplus".equals(Util.DEVICE) || "villec2".equals(Util.DEVICE) || Util.DEVICE.startsWith("gee") || "C6602".equals(Util.DEVICE) || "C6603".equals(Util.DEVICE) || "C6606".equals(Util.DEVICE) || "C6616".equals(Util.DEVICE) || "L36h".equals(Util.DEVICE) || "SO-02E".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.aac".equals(name) && ("C1504".equals(Util.DEVICE) || "C1505".equals(Util.DEVICE) || "C1604".equals(Util.DEVICE) || "C1605".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT < 24 && ("OMX.SEC.aac.dec".equals(name) || "OMX.Exynos.AAC.Decoder".equals(name)) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("zeroflte") || Util.DEVICE.startsWith("zerolte") || Util.DEVICE.startsWith("zenlte") || "SC-05G".equals(Util.DEVICE) || "marinelteatt".equals(Util.DEVICE) || "404SC".equals(Util.DEVICE) || "SC-04G".equals(Util.DEVICE) || "SCV31".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT <= 19 && "OMX.SEC.vp8.dec".equals(name) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("d2") || Util.DEVICE.startsWith("serrano") || Util.DEVICE.startsWith("jflte") || Util.DEVICE.startsWith("santos") || Util.DEVICE.startsWith("t0"))) {
            return false;
        }
        if (Util.SDK_INT <= 19 && Util.DEVICE.startsWith("jflte") && "OMX.qcom.video.decoder.vp8".equals(name)) {
            return false;
        }
        return !"audio/eac3-joc".equals(requestedMimeType) || !"OMX.MTK.AUDIO.DECODER.DSPAC3".equals(name);
    }

    private static void applyWorkarounds(String mimeType, List<MediaCodecInfo> decoderInfos) {
        String firstCodecName;
        if ("audio/raw".equals(mimeType)) {
            Collections.sort(decoderInfos, new RawAudioCodecComparator());
        } else if (Util.SDK_INT < 21 && decoderInfos.size() > 1 && ("OMX.SEC.mp3.dec".equals(firstCodecName = decoderInfos.get((int)0).name) || "OMX.SEC.MP3.Decoder".equals(firstCodecName) || "OMX.brcm.audio.mp3.decoder".equals(firstCodecName))) {
            Collections.sort(decoderInfos, new PreferOmxGoogleCodecComparator());
        }
    }

    private static boolean codecNeedsDisableAdaptationWorkaround(String name) {
        return !(Util.SDK_INT > 22 || !"ODROID-XU3".equals(Util.MODEL) && !"Nexus 10".equals(Util.MODEL) || !"OMX.Exynos.AVC.Decoder".equals(name) && !"OMX.Exynos.AVC.Decoder.secure".equals(name));
    }

    private static Pair<Integer, Integer> getDolbyVisionProfileAndLevel(String codec, String[] parts) {
        if (parts.length < 3) {
            Log.w(TAG, "Ignoring malformed Dolby Vision codec string: " + codec);
            return null;
        }
        Matcher matcher = PROFILE_PATTERN.matcher(parts[1]);
        if (!matcher.matches()) {
            Log.w(TAG, "Ignoring malformed Dolby Vision codec string: " + codec);
            return null;
        }
        String profileString = matcher.group(1);
        Integer profile = DOLBY_VISION_STRING_TO_PROFILE.get(profileString);
        if (profile == null) {
            Log.w(TAG, "Unknown Dolby Vision profile string: " + profileString);
            return null;
        }
        String levelString = parts[2];
        Integer level = DOLBY_VISION_STRING_TO_LEVEL.get(levelString);
        if (level == null) {
            Log.w(TAG, "Unknown Dolby Vision level string: " + levelString);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    private static Pair<Integer, Integer> getHevcProfileAndLevel(String codec, String[] parts) {
        int profile;
        if (parts.length < 4) {
            Log.w(TAG, "Ignoring malformed HEVC codec string: " + codec);
            return null;
        }
        Matcher matcher = PROFILE_PATTERN.matcher(parts[1]);
        if (!matcher.matches()) {
            Log.w(TAG, "Ignoring malformed HEVC codec string: " + codec);
            return null;
        }
        String profileString = matcher.group(1);
        if ("1".equals(profileString)) {
            profile = 1;
        } else if ("2".equals(profileString)) {
            profile = 2;
        } else {
            Log.w(TAG, "Unknown HEVC profile string: " + profileString);
            return null;
        }
        String levelString = parts[3];
        Integer level = HEVC_CODEC_STRING_TO_PROFILE_LEVEL.get(levelString);
        if (level == null) {
            Log.w(TAG, "Unknown HEVC level string: " + levelString);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    private static Pair<Integer, Integer> getAvcProfileAndLevel(String codec, String[] parts) {
        int levelInteger;
        int profileInteger;
        block7: {
            if (parts.length < 2) {
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
            try {
                if (parts[1].length() == 6) {
                    profileInteger = Integer.parseInt(parts[1].substring(0, 2), 16);
                    levelInteger = Integer.parseInt(parts[1].substring(4), 16);
                    break block7;
                }
                if (parts.length >= 3) {
                    profileInteger = Integer.parseInt(parts[1]);
                    levelInteger = Integer.parseInt(parts[2]);
                    break block7;
                }
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
            catch (NumberFormatException e) {
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
        }
        int profile = AVC_PROFILE_NUMBER_TO_CONST.get(profileInteger, -1);
        if (profile == -1) {
            Log.w(TAG, "Unknown AVC profile: " + profileInteger);
            return null;
        }
        int level = AVC_LEVEL_NUMBER_TO_CONST.get(levelInteger, -1);
        if (level == -1) {
            Log.w(TAG, "Unknown AVC level: " + levelInteger);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    private static int avcLevelToMaxFrameSize(int avcLevel) {
        switch (avcLevel) {
            case 1: 
            case 2: {
                return 25344;
            }
            case 8: 
            case 16: 
            case 32: {
                return 101376;
            }
            case 64: {
                return 202752;
            }
            case 128: 
            case 256: {
                return 414720;
            }
            case 512: {
                return 921600;
            }
            case 1024: {
                return 0x140000;
            }
            case 2048: 
            case 4096: {
                return 0x200000;
            }
            case 8192: {
                return 0x220000;
            }
            case 16384: {
                return 5652480;
            }
            case 32768: 
            case 65536: {
                return 0x900000;
            }
        }
        return -1;
    }

    @Nullable
    private static Pair<Integer, Integer> getAacCodecProfileAndLevel(String codec, String[] parts) {
        if (parts.length != 3) {
            Log.w(TAG, "Ignoring malformed MP4A codec string: " + codec);
            return null;
        }
        try {
            int audioObjectTypeIndication;
            int profile;
            int objectTypeIndication = Integer.parseInt(parts[1], 16);
            String mimeType = MimeTypes.getMimeTypeFromMp4ObjectType(objectTypeIndication);
            if ("audio/mp4a-latm".equals(mimeType) && (profile = MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.get(audioObjectTypeIndication = Integer.parseInt(parts[2]), -1)) != -1) {
                return new Pair((Object)profile, (Object)0);
            }
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Ignoring malformed MP4A codec string: " + codec);
        }
        return null;
    }

    static {
        maxH264DecodableFrameSize = -1;
        AVC_PROFILE_NUMBER_TO_CONST = new SparseIntArray();
        AVC_PROFILE_NUMBER_TO_CONST.put(66, 1);
        AVC_PROFILE_NUMBER_TO_CONST.put(77, 2);
        AVC_PROFILE_NUMBER_TO_CONST.put(88, 4);
        AVC_PROFILE_NUMBER_TO_CONST.put(100, 8);
        AVC_PROFILE_NUMBER_TO_CONST.put(110, 16);
        AVC_PROFILE_NUMBER_TO_CONST.put(122, 32);
        AVC_PROFILE_NUMBER_TO_CONST.put(244, 64);
        AVC_LEVEL_NUMBER_TO_CONST = new SparseIntArray();
        AVC_LEVEL_NUMBER_TO_CONST.put(10, 1);
        AVC_LEVEL_NUMBER_TO_CONST.put(11, 4);
        AVC_LEVEL_NUMBER_TO_CONST.put(12, 8);
        AVC_LEVEL_NUMBER_TO_CONST.put(13, 16);
        AVC_LEVEL_NUMBER_TO_CONST.put(20, 32);
        AVC_LEVEL_NUMBER_TO_CONST.put(21, 64);
        AVC_LEVEL_NUMBER_TO_CONST.put(22, 128);
        AVC_LEVEL_NUMBER_TO_CONST.put(30, 256);
        AVC_LEVEL_NUMBER_TO_CONST.put(31, 512);
        AVC_LEVEL_NUMBER_TO_CONST.put(32, 1024);
        AVC_LEVEL_NUMBER_TO_CONST.put(40, 2048);
        AVC_LEVEL_NUMBER_TO_CONST.put(41, 4096);
        AVC_LEVEL_NUMBER_TO_CONST.put(42, 8192);
        AVC_LEVEL_NUMBER_TO_CONST.put(50, 16384);
        AVC_LEVEL_NUMBER_TO_CONST.put(51, 32768);
        AVC_LEVEL_NUMBER_TO_CONST.put(52, 65536);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL = new HashMap<String, Integer>();
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L30", 1);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L60", 4);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L63", 16);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L90", 64);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L93", 256);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L120", 1024);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L123", 4096);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L150", 16384);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L153", 65536);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L156", 262144);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L180", 0x100000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L183", 0x400000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L186", 0x1000000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H30", 2);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H60", 8);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H63", 32);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H90", 128);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H93", 512);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H120", 2048);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H123", 8192);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H150", 32768);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H153", 131072);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H156", 524288);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H180", 0x200000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H183", 0x800000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H186", 0x2000000);
        DOLBY_VISION_STRING_TO_PROFILE = new HashMap<String, Integer>();
        DOLBY_VISION_STRING_TO_PROFILE.put("00", 1);
        DOLBY_VISION_STRING_TO_PROFILE.put("01", 2);
        DOLBY_VISION_STRING_TO_PROFILE.put("02", 4);
        DOLBY_VISION_STRING_TO_PROFILE.put("03", 8);
        DOLBY_VISION_STRING_TO_PROFILE.put("04", 16);
        DOLBY_VISION_STRING_TO_PROFILE.put("05", 32);
        DOLBY_VISION_STRING_TO_PROFILE.put("06", 64);
        DOLBY_VISION_STRING_TO_PROFILE.put("07", 128);
        DOLBY_VISION_STRING_TO_PROFILE.put("08", 256);
        DOLBY_VISION_STRING_TO_PROFILE.put("09", 512);
        DOLBY_VISION_STRING_TO_LEVEL = new HashMap<String, Integer>();
        DOLBY_VISION_STRING_TO_LEVEL.put("01", 1);
        DOLBY_VISION_STRING_TO_LEVEL.put("02", 2);
        DOLBY_VISION_STRING_TO_LEVEL.put("03", 4);
        DOLBY_VISION_STRING_TO_LEVEL.put("04", 8);
        DOLBY_VISION_STRING_TO_LEVEL.put("05", 16);
        DOLBY_VISION_STRING_TO_LEVEL.put("06", 32);
        DOLBY_VISION_STRING_TO_LEVEL.put("07", 64);
        DOLBY_VISION_STRING_TO_LEVEL.put("08", 128);
        DOLBY_VISION_STRING_TO_LEVEL.put("09", 256);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE = new SparseIntArray();
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(1, 1);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(2, 2);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(3, 3);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(4, 4);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(5, 5);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(6, 6);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(17, 17);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(20, 20);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(23, 23);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(29, 29);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(39, 39);
        MP4A_AUDIO_OBJECT_TYPE_TO_PROFILE.put(42, 42);
    }

    private static final class PreferOmxGoogleCodecComparator
    implements Comparator<MediaCodecInfo> {
        private PreferOmxGoogleCodecComparator() {
        }

        @Override
        public int compare(MediaCodecInfo a, MediaCodecInfo b) {
            return PreferOmxGoogleCodecComparator.scoreMediaCodecInfo(a) - PreferOmxGoogleCodecComparator.scoreMediaCodecInfo(b);
        }

        private static int scoreMediaCodecInfo(MediaCodecInfo mediaCodecInfo) {
            return mediaCodecInfo.name.startsWith("OMX.google") ? -1 : 0;
        }
    }

    private static final class RawAudioCodecComparator
    implements Comparator<MediaCodecInfo> {
        private RawAudioCodecComparator() {
        }

        @Override
        public int compare(MediaCodecInfo a, MediaCodecInfo b) {
            return RawAudioCodecComparator.scoreMediaCodecInfo(a) - RawAudioCodecComparator.scoreMediaCodecInfo(b);
        }

        private static int scoreMediaCodecInfo(MediaCodecInfo mediaCodecInfo) {
            String name = mediaCodecInfo.name;
            if (name.startsWith("OMX.google") || name.startsWith("c2.android")) {
                return -1;
            }
            if (Util.SDK_INT < 26 && name.equals("OMX.MTK.AUDIO.DECODER.RAW")) {
                return 1;
            }
            return 0;
        }
    }

    private static final class CodecKey {
        public final String mimeType;
        public final boolean secure;
        public final boolean tunneling;

        public CodecKey(String mimeType, boolean secure, boolean tunneling) {
            this.mimeType = mimeType;
            this.secure = secure;
            this.tunneling = tunneling;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.secure ? 1231 : 1237);
            result = 31 * result + (this.tunneling ? 1231 : 1237);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != CodecKey.class) {
                return false;
            }
            CodecKey other = (CodecKey)obj;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)other.mimeType) && this.secure == other.secure && this.tunneling == other.tunneling;
        }
    }

    private static final class MediaCodecListCompatV16
    implements MediaCodecListCompat {
        private MediaCodecListCompatV16() {
        }

        @Override
        public int getCodecCount() {
            return MediaCodecList.getCodecCount();
        }

        @Override
        public android.media.MediaCodecInfo getCodecInfoAt(int index) {
            return MediaCodecList.getCodecInfoAt((int)index);
        }

        @Override
        public boolean secureDecodersExplicit() {
            return false;
        }

        @Override
        public boolean isFeatureSupported(String feature, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return "secure-playback".equals(feature) && "video/avc".equals(mimeType);
        }

        @Override
        public boolean isFeatureRequired(String feature, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return false;
        }
    }

    @TargetApi(value=21)
    private static final class MediaCodecListCompatV21
    implements MediaCodecListCompat {
        private final int codecKind;
        private android.media.MediaCodecInfo[] mediaCodecInfos;

        public MediaCodecListCompatV21(boolean includeSecure, boolean includeTunneling) {
            this.codecKind = includeSecure || includeTunneling ? 1 : 0;
        }

        @Override
        public int getCodecCount() {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos.length;
        }

        @Override
        public android.media.MediaCodecInfo getCodecInfoAt(int index) {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos[index];
        }

        @Override
        public boolean secureDecodersExplicit() {
            return true;
        }

        @Override
        public boolean isFeatureSupported(String feature, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return capabilities.isFeatureSupported(feature);
        }

        @Override
        public boolean isFeatureRequired(String feature, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return capabilities.isFeatureRequired(feature);
        }

        private void ensureMediaCodecInfosInitialized() {
            if (this.mediaCodecInfos == null) {
                this.mediaCodecInfos = new MediaCodecList(this.codecKind).getCodecInfos();
            }
        }
    }

    private static interface MediaCodecListCompat {
        public int getCodecCount();

        public android.media.MediaCodecInfo getCodecInfoAt(int var1);

        public boolean secureDecodersExplicit();

        public boolean isFeatureSupported(String var1, String var2, MediaCodecInfo.CodecCapabilities var3);

        public boolean isFeatureRequired(String var1, String var2, MediaCodecInfo.CodecCapabilities var3);
    }

    public static class DecoderQueryException
    extends Exception {
        private DecoderQueryException(Throwable cause) {
            super("Failed to query underlying media codecs", cause);
        }
    }
}

