/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.TimedValueQueue;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class MediaCodecRenderer
extends BaseRenderer {
    protected static final float CODEC_OPERATING_RATE_UNSET = -1.0f;
    private static final String TAG = "MediaCodecRenderer";
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    protected static final int KEEP_CODEC_RESULT_NO = 0;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_FLUSH = 1;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_RECONFIGURATION = 2;
    protected static final int KEEP_CODEC_RESULT_YES_WITHOUT_RECONFIGURATION = 3;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int DRAIN_STATE_WAIT_END_OF_STREAM = 2;
    private static final int DRAIN_ACTION_NONE = 0;
    private static final int DRAIN_ACTION_FLUSH = 1;
    private static final int DRAIN_ACTION_UPDATE_DRM_SESSION = 2;
    private static final int DRAIN_ACTION_REINITIALIZE = 3;
    private static final int ADAPTATION_WORKAROUND_MODE_NEVER = 0;
    private static final int ADAPTATION_WORKAROUND_MODE_SAME_RESOLUTION = 1;
    private static final int ADAPTATION_WORKAROUND_MODE_ALWAYS = 2;
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = Util.getBytesFromHexString("0000016742C00BDA259000000168CE0F13200000016588840DCE7118A0002FBF1C31C3275D78");
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    private final MediaCodecSelector mediaCodecSelector;
    @Nullable
    private final DrmSessionManager<FrameworkMediaCrypto> drmSessionManager;
    private final boolean playClearSamplesWithoutKeys;
    private final boolean enableDecoderFallback;
    private final float assumedMinimumCodecOperatingRate;
    private final DecoderInputBuffer buffer;
    private final DecoderInputBuffer flagsOnlyBuffer;
    private final FormatHolder formatHolder;
    private final TimedValueQueue<Format> formatQueue;
    private final ArrayList<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    @Nullable
    private Format inputFormat;
    private Format outputFormat;
    @Nullable
    private DrmSession<FrameworkMediaCrypto> codecDrmSession;
    @Nullable
    private DrmSession<FrameworkMediaCrypto> sourceDrmSession;
    @Nullable
    private MediaCrypto mediaCrypto;
    private boolean mediaCryptoRequiresSecureDecoder;
    private long renderTimeLimitMs;
    private float rendererOperatingRate;
    @Nullable
    private MediaCodec codec;
    @Nullable
    private Format codecFormat;
    private float codecOperatingRate;
    @Nullable
    private ArrayDeque<MediaCodecInfo> availableCodecInfos;
    @Nullable
    private DecoderInitializationException preferredDecoderInitializationException;
    @Nullable
    private MediaCodecInfo codecInfo;
    private int codecAdaptationWorkaroundMode;
    private boolean codecNeedsReconfigureWorkaround;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private boolean codecNeedsEosPropagation;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapDeadlineMs;
    private int inputIndex;
    private int outputIndex;
    private ByteBuffer outputBuffer;
    private boolean shouldSkipOutputBuffer;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecDrainState;
    private int codecDrainAction;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeys;
    private boolean waitingForFirstSyncSample;
    private boolean waitingForFirstSampleInFormat;
    protected DecoderCounters decoderCounters;

    public MediaCodecRenderer(int trackType, MediaCodecSelector mediaCodecSelector, @Nullable DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean playClearSamplesWithoutKeys, boolean enableDecoderFallback, float assumedMinimumCodecOperatingRate) {
        super(trackType);
        this.mediaCodecSelector = Assertions.checkNotNull(mediaCodecSelector);
        this.drmSessionManager = drmSessionManager;
        this.playClearSamplesWithoutKeys = playClearSamplesWithoutKeys;
        this.enableDecoderFallback = enableDecoderFallback;
        this.assumedMinimumCodecOperatingRate = assumedMinimumCodecOperatingRate;
        this.buffer = new DecoderInputBuffer(0);
        this.flagsOnlyBuffer = DecoderInputBuffer.newFlagsOnlyInstance();
        this.formatHolder = new FormatHolder();
        this.formatQueue = new TimedValueQueue();
        this.decodeOnlyPresentationTimestamps = new ArrayList();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.codecReconfigurationState = 0;
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
        this.codecOperatingRate = -1.0f;
        this.rendererOperatingRate = 1.0f;
        this.renderTimeLimitMs = -9223372036854775807L;
    }

    public void experimental_setRenderTimeLimitMs(long renderTimeLimitMs) {
        this.renderTimeLimitMs = renderTimeLimitMs;
    }

    @Override
    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    @Override
    public final int supportsFormat(Format format) throws ExoPlaybackException {
        try {
            return this.supportsFormat(this.mediaCodecSelector, this.drmSessionManager, format);
        }
        catch (MediaCodecUtil.DecoderQueryException e) {
            throw ExoPlaybackException.createForRenderer(e, this.getIndex());
        }
    }

    protected abstract int supportsFormat(MediaCodecSelector var1, DrmSessionManager<FrameworkMediaCrypto> var2, Format var3) throws MediaCodecUtil.DecoderQueryException;

    protected abstract List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector var1, Format var2, boolean var3) throws MediaCodecUtil.DecoderQueryException;

    protected abstract void configureCodec(MediaCodecInfo var1, MediaCodec var2, Format var3, MediaCrypto var4, float var5) throws MediaCodecUtil.DecoderQueryException;

    protected final void maybeInitCodec() throws ExoPlaybackException {
        if (this.codec != null || this.inputFormat == null) {
            return;
        }
        this.setCodecDrmSession(this.sourceDrmSession);
        String mimeType = this.inputFormat.sampleMimeType;
        if (this.codecDrmSession != null) {
            if (this.mediaCrypto == null) {
                FrameworkMediaCrypto sessionMediaCrypto = this.codecDrmSession.getMediaCrypto();
                if (sessionMediaCrypto == null) {
                    DrmSession.DrmSessionException drmError = this.codecDrmSession.getError();
                    if (drmError == null) {
                        return;
                    }
                } else {
                    try {
                        this.mediaCrypto = new MediaCrypto(sessionMediaCrypto.uuid, sessionMediaCrypto.sessionId);
                    }
                    catch (MediaCryptoException e) {
                        throw ExoPlaybackException.createForRenderer((Exception)((Object)e), this.getIndex());
                    }
                    boolean bl = this.mediaCryptoRequiresSecureDecoder = !sessionMediaCrypto.forceAllowInsecureDecoderComponents && this.mediaCrypto.requiresSecureDecoderComponent(mimeType);
                }
            }
            if (this.deviceNeedsDrmKeysToConfigureCodecWorkaround()) {
                int drmSessionState = this.codecDrmSession.getState();
                if (drmSessionState == 1) {
                    throw ExoPlaybackException.createForRenderer(this.codecDrmSession.getError(), this.getIndex());
                }
                if (drmSessionState != 4) {
                    return;
                }
            }
        }
        try {
            this.maybeInitCodecWithFallback(this.mediaCrypto, this.mediaCryptoRequiresSecureDecoder);
        }
        catch (DecoderInitializationException e) {
            throw ExoPlaybackException.createForRenderer(e, this.getIndex());
        }
    }

    protected boolean shouldInitCodec(MediaCodecInfo codecInfo) {
        return true;
    }

    protected boolean getCodecNeedsEosPropagation() {
        return false;
    }

    @Nullable
    protected final Format updateOutputFormatForTime(long presentationTimeUs) {
        Format format = this.formatQueue.pollFloor(presentationTimeUs);
        if (format != null) {
            this.outputFormat = format;
        }
        return format;
    }

    protected final MediaCodec getCodec() {
        return this.codec;
    }

    @Nullable
    protected final MediaCodecInfo getCodecInfo() {
        return this.codecInfo;
    }

    @Override
    protected void onEnabled(boolean joining) throws ExoPlaybackException {
        this.decoderCounters = new DecoderCounters();
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        this.flushOrReinitializeCodec();
        this.formatQueue.clear();
    }

    @Override
    public final void setOperatingRate(float operatingRate) throws ExoPlaybackException {
        this.rendererOperatingRate = operatingRate;
        if (this.codec != null && this.codecDrainAction != 3 && this.getState() != 0) {
            this.updateCodecOperatingRate();
        }
    }

    @Override
    protected void onDisabled() {
        this.inputFormat = null;
        if (this.sourceDrmSession != null || this.codecDrmSession != null) {
            this.onReset();
        } else {
            this.flushOrReleaseCodec();
        }
    }

    @Override
    protected void onReset() {
        try {
            this.releaseCodec();
        }
        finally {
            this.setSourceDrmSession(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCodec() {
        block12: {
            this.availableCodecInfos = null;
            this.codecInfo = null;
            this.codecFormat = null;
            this.resetInputBuffer();
            this.resetOutputBuffer();
            this.resetCodecBuffers();
            this.waitingForKeys = false;
            this.codecHotswapDeadlineMs = -9223372036854775807L;
            this.decodeOnlyPresentationTimestamps.clear();
            try {
                if (this.codec == null) break block12;
                ++this.decoderCounters.decoderReleaseCount;
                try {
                    this.codec.stop();
                }
                finally {
                    this.codec.release();
                }
            }
            finally {
                this.codec = null;
                try {
                    if (this.mediaCrypto != null) {
                        this.mediaCrypto.release();
                    }
                }
                finally {
                    this.mediaCrypto = null;
                    this.mediaCryptoRequiresSecureDecoder = false;
                    this.setCodecDrmSession(null);
                }
            }
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.outputStreamEnded) {
            this.renderToEndOfStream();
            return;
        }
        if (this.inputFormat == null && !this.readToFlagsOnlyBuffer(true)) {
            return;
        }
        this.maybeInitCodec();
        if (this.codec != null) {
            long drainStartTimeMs = SystemClock.elapsedRealtime();
            TraceUtil.beginSection("drainAndFeed");
            while (this.drainOutputBuffer(positionUs, elapsedRealtimeUs)) {
            }
            while (this.feedInputBuffer() && this.shouldContinueFeeding(drainStartTimeMs)) {
            }
            TraceUtil.endSection();
        } else {
            this.decoderCounters.skippedInputBufferCount += this.skipSource(positionUs);
            this.readToFlagsOnlyBuffer(false);
        }
        this.decoderCounters.ensureUpdated();
    }

    protected final boolean flushOrReinitializeCodec() throws ExoPlaybackException {
        boolean released = this.flushOrReleaseCodec();
        if (released) {
            this.maybeInitCodec();
        }
        return released;
    }

    protected boolean flushOrReleaseCodec() {
        if (this.codec == null) {
            return false;
        }
        if (this.codecDrainAction == 3 || this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            return true;
        }
        this.codec.flush();
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.codecReceivedEos = false;
        this.codecReceivedBuffers = false;
        this.waitingForFirstSyncSample = true;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.shouldSkipOutputBuffer = false;
        this.waitingForKeys = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
        this.codecReconfigurationState = this.codecReconfigured ? 1 : 0;
        return false;
    }

    private boolean readToFlagsOnlyBuffer(boolean requireFormat) throws ExoPlaybackException {
        this.flagsOnlyBuffer.clear();
        int result = this.readSource(this.formatHolder, this.flagsOnlyBuffer, requireFormat);
        if (result == -5) {
            this.onInputFormatChanged(this.formatHolder.format);
            return true;
        }
        if (result == -4 && this.flagsOnlyBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            this.processEndOfStream();
        }
        return false;
    }

    private void maybeInitCodecWithFallback(MediaCrypto crypto, boolean mediaCryptoRequiresSecureDecoder) throws DecoderInitializationException {
        if (this.availableCodecInfos == null) {
            try {
                List<MediaCodecInfo> allAvailableCodecInfos = this.getAvailableCodecInfos(mediaCryptoRequiresSecureDecoder);
                this.availableCodecInfos = this.enableDecoderFallback ? new ArrayDeque<MediaCodecInfo>(allAvailableCodecInfos) : new ArrayDeque<MediaCodecInfo>(Collections.singletonList(allAvailableCodecInfos.get(0)));
                this.preferredDecoderInitializationException = null;
            }
            catch (MediaCodecUtil.DecoderQueryException e) {
                throw new DecoderInitializationException(this.inputFormat, (Throwable)e, mediaCryptoRequiresSecureDecoder, -49998);
            }
        }
        if (this.availableCodecInfos.isEmpty()) {
            throw new DecoderInitializationException(this.inputFormat, null, mediaCryptoRequiresSecureDecoder, -49999);
        }
        while (this.codec == null) {
            MediaCodecInfo codecInfo = this.availableCodecInfos.peekFirst();
            if (!this.shouldInitCodec(codecInfo)) {
                return;
            }
            try {
                this.initCodec(codecInfo, crypto);
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to initialize decoder: " + codecInfo, e);
                this.availableCodecInfos.removeFirst();
                DecoderInitializationException exception = new DecoderInitializationException(this.inputFormat, (Throwable)e, mediaCryptoRequiresSecureDecoder, codecInfo.name);
                this.preferredDecoderInitializationException = this.preferredDecoderInitializationException == null ? exception : this.preferredDecoderInitializationException.copyWithFallbackException(exception);
                if (!this.availableCodecInfos.isEmpty()) continue;
                throw this.preferredDecoderInitializationException;
            }
        }
        this.availableCodecInfos = null;
    }

    private List<MediaCodecInfo> getAvailableCodecInfos(boolean mediaCryptoRequiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        List<MediaCodecInfo> codecInfos = this.getDecoderInfos(this.mediaCodecSelector, this.inputFormat, mediaCryptoRequiresSecureDecoder);
        if (codecInfos.isEmpty() && mediaCryptoRequiresSecureDecoder && !(codecInfos = this.getDecoderInfos(this.mediaCodecSelector, this.inputFormat, false)).isEmpty()) {
            Log.w(TAG, "Drm session requires secure decoder for " + this.inputFormat.sampleMimeType + ", but no secure decoder available. Trying to proceed with " + codecInfos + ".");
        }
        return codecInfos;
    }

    private void initCodec(MediaCodecInfo codecInfo, MediaCrypto crypto) throws Exception {
        long codecInitializedTimestamp;
        long codecInitializingTimestamp;
        float codecOperatingRate;
        MediaCodec codec = null;
        String codecName = codecInfo.name;
        float f = codecOperatingRate = Util.SDK_INT < 23 ? -1.0f : this.getCodecOperatingRateV23(this.rendererOperatingRate, this.inputFormat, this.getStreamFormats());
        if (codecOperatingRate <= this.assumedMinimumCodecOperatingRate) {
            codecOperatingRate = -1.0f;
        }
        try {
            codecInitializingTimestamp = SystemClock.elapsedRealtime();
            TraceUtil.beginSection("createCodec:" + codecName);
            codec = MediaCodec.createByCodecName((String)codecName);
            TraceUtil.endSection();
            TraceUtil.beginSection("configureCodec");
            this.configureCodec(codecInfo, codec, this.inputFormat, crypto, codecOperatingRate);
            TraceUtil.endSection();
            TraceUtil.beginSection("startCodec");
            codec.start();
            TraceUtil.endSection();
            codecInitializedTimestamp = SystemClock.elapsedRealtime();
            this.getCodecBuffers(codec);
        }
        catch (Exception e) {
            if (codec != null) {
                this.resetCodecBuffers();
                codec.release();
            }
            throw e;
        }
        this.codec = codec;
        this.codecInfo = codecInfo;
        this.codecOperatingRate = codecOperatingRate;
        this.codecFormat = this.inputFormat;
        this.codecAdaptationWorkaroundMode = this.codecAdaptationWorkaroundMode(codecName);
        this.codecNeedsReconfigureWorkaround = MediaCodecRenderer.codecNeedsReconfigureWorkaround(codecName);
        this.codecNeedsDiscardToSpsWorkaround = MediaCodecRenderer.codecNeedsDiscardToSpsWorkaround(codecName, this.codecFormat);
        this.codecNeedsFlushWorkaround = MediaCodecRenderer.codecNeedsFlushWorkaround(codecName);
        this.codecNeedsEosFlushWorkaround = MediaCodecRenderer.codecNeedsEosFlushWorkaround(codecName);
        this.codecNeedsEosOutputExceptionWorkaround = MediaCodecRenderer.codecNeedsEosOutputExceptionWorkaround(codecName);
        this.codecNeedsMonoChannelCountWorkaround = MediaCodecRenderer.codecNeedsMonoChannelCountWorkaround(codecName, this.codecFormat);
        this.codecNeedsEosPropagation = MediaCodecRenderer.codecNeedsEosPropagationWorkaround(codecInfo) || this.getCodecNeedsEosPropagation();
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.codecHotswapDeadlineMs = this.getState() == 2 ? SystemClock.elapsedRealtime() + 1000L : -9223372036854775807L;
        this.codecReconfigured = false;
        this.codecReconfigurationState = 0;
        this.codecReceivedEos = false;
        this.codecReceivedBuffers = false;
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.shouldSkipOutputBuffer = false;
        this.waitingForFirstSyncSample = true;
        ++this.decoderCounters.decoderInitCount;
        long elapsed = codecInitializedTimestamp - codecInitializingTimestamp;
        this.onCodecInitialized(codecName, codecInitializedTimestamp, elapsed);
    }

    private boolean shouldContinueFeeding(long drainStartTimeMs) {
        return this.renderTimeLimitMs == -9223372036854775807L || SystemClock.elapsedRealtime() - drainStartTimeMs < this.renderTimeLimitMs;
    }

    private void getCodecBuffers(MediaCodec codec) {
        if (Util.SDK_INT < 21) {
            this.inputBuffers = codec.getInputBuffers();
            this.outputBuffers = codec.getOutputBuffers();
        }
    }

    private void resetCodecBuffers() {
        if (Util.SDK_INT < 21) {
            this.inputBuffers = null;
            this.outputBuffers = null;
        }
    }

    private ByteBuffer getInputBuffer(int inputIndex) {
        if (Util.SDK_INT >= 21) {
            return this.codec.getInputBuffer(inputIndex);
        }
        return this.inputBuffers[inputIndex];
    }

    private ByteBuffer getOutputBuffer(int outputIndex) {
        if (Util.SDK_INT >= 21) {
            return this.codec.getOutputBuffer(outputIndex);
        }
        return this.outputBuffers[outputIndex];
    }

    private boolean hasOutputBuffer() {
        return this.outputIndex >= 0;
    }

    private void resetInputBuffer() {
        this.inputIndex = -1;
        this.buffer.data = null;
    }

    private void resetOutputBuffer() {
        this.outputIndex = -1;
        this.outputBuffer = null;
    }

    private void setSourceDrmSession(@Nullable DrmSession<FrameworkMediaCrypto> session) {
        DrmSession<FrameworkMediaCrypto> previous = this.sourceDrmSession;
        this.sourceDrmSession = session;
        this.releaseDrmSessionIfUnused(previous);
    }

    private void setCodecDrmSession(@Nullable DrmSession<FrameworkMediaCrypto> session) {
        DrmSession<FrameworkMediaCrypto> previous = this.codecDrmSession;
        this.codecDrmSession = session;
        this.releaseDrmSessionIfUnused(previous);
    }

    private void releaseDrmSessionIfUnused(@Nullable DrmSession<FrameworkMediaCrypto> session) {
        if (session != null && session != this.sourceDrmSession && session != this.codecDrmSession) {
            this.drmSessionManager.releaseSession(session);
        }
    }

    private boolean feedInputBuffer() throws ExoPlaybackException {
        int result;
        if (this.codec == null || this.codecDrainState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBuffer(0L);
            if (this.inputIndex < 0) {
                return false;
            }
            this.buffer.data = this.getInputBuffer(this.inputIndex);
            this.buffer.clear();
        }
        if (this.codecDrainState == 1) {
            if (!this.codecNeedsEosPropagation) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
            }
            this.codecDrainState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.data.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codec.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            return true;
        }
        int adaptiveReconfigurationBytes = 0;
        if (this.waitingForKeys) {
            result = -4;
        } else {
            if (this.codecReconfigurationState == 1) {
                for (int i = 0; i < this.codecFormat.initializationData.size(); ++i) {
                    byte[] data = this.codecFormat.initializationData.get(i);
                    this.buffer.data.put(data);
                }
                this.codecReconfigurationState = 2;
            }
            adaptiveReconfigurationBytes = this.buffer.data.position();
            result = this.readSource(this.formatHolder, this.buffer, false);
        }
        if (result == -3) {
            return false;
        }
        if (result == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.clear();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder.format);
            return true;
        }
        if (this.buffer.isEndOfStream()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.clear();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagation) {
                    this.codecReceivedEos = true;
                    this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.resetInputBuffer();
                }
            }
            catch (MediaCodec.CryptoException e) {
                throw ExoPlaybackException.createForRenderer((Exception)((Object)e), this.getIndex());
            }
            return false;
        }
        if (this.waitingForFirstSyncSample && !this.buffer.isKeyFrame()) {
            this.buffer.clear();
            if (this.codecReconfigurationState == 2) {
                this.codecReconfigurationState = 1;
            }
            return true;
        }
        this.waitingForFirstSyncSample = false;
        boolean bufferEncrypted = this.buffer.isEncrypted();
        this.waitingForKeys = this.shouldWaitForKeys(bufferEncrypted);
        if (this.waitingForKeys) {
            return false;
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !bufferEncrypted) {
            NalUnitUtil.discardToSps(this.buffer.data);
            if (this.buffer.data.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        try {
            long presentationTimeUs = this.buffer.timeUs;
            if (this.buffer.isDecodeOnly()) {
                this.decodeOnlyPresentationTimestamps.add(presentationTimeUs);
            }
            if (this.waitingForFirstSampleInFormat) {
                this.formatQueue.add(presentationTimeUs, this.inputFormat);
                this.waitingForFirstSampleInFormat = false;
            }
            this.buffer.flip();
            this.onQueueInputBuffer(this.buffer);
            if (bufferEncrypted) {
                MediaCodec.CryptoInfo cryptoInfo = MediaCodecRenderer.getFrameworkCryptoInfo(this.buffer, adaptiveReconfigurationBytes);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, presentationTimeUs, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, this.buffer.data.limit(), presentationTimeUs, 0);
            }
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            this.codecReconfigurationState = 0;
            ++this.decoderCounters.inputBufferCount;
        }
        catch (MediaCodec.CryptoException e) {
            throw ExoPlaybackException.createForRenderer((Exception)((Object)e), this.getIndex());
        }
        return true;
    }

    private boolean shouldWaitForKeys(boolean bufferEncrypted) throws ExoPlaybackException {
        if (this.codecDrmSession == null || !bufferEncrypted && this.playClearSamplesWithoutKeys) {
            return false;
        }
        int drmSessionState = this.codecDrmSession.getState();
        if (drmSessionState == 1) {
            throw ExoPlaybackException.createForRenderer(this.codecDrmSession.getError(), this.getIndex());
        }
        return drmSessionState != 4;
    }

    protected void onCodecInitialized(String name, long initializedTimestampMs, long initializationDurationMs) {
    }

    protected void onInputFormatChanged(Format newFormat) throws ExoPlaybackException {
        boolean drmInitDataChanged;
        Format oldFormat = this.inputFormat;
        this.inputFormat = newFormat;
        this.waitingForFirstSampleInFormat = true;
        boolean bl = drmInitDataChanged = !Util.areEqual(newFormat.drmInitData, oldFormat == null ? null : oldFormat.drmInitData);
        if (drmInitDataChanged) {
            if (newFormat.drmInitData != null) {
                if (this.drmSessionManager == null) {
                    throw ExoPlaybackException.createForRenderer(new IllegalStateException("Media requires a DrmSessionManager"), this.getIndex());
                }
                DrmSession<FrameworkMediaCrypto> session = this.drmSessionManager.acquireSession(Looper.myLooper(), newFormat.drmInitData);
                if (session == this.sourceDrmSession || session == this.codecDrmSession) {
                    this.drmSessionManager.releaseSession(session);
                }
                this.setSourceDrmSession(session);
            } else {
                this.setSourceDrmSession(null);
            }
        }
        if (this.codec == null) {
            this.maybeInitCodec();
            return;
        }
        if (this.sourceDrmSession == null && this.codecDrmSession != null || this.sourceDrmSession != null && this.codecDrmSession == null || this.sourceDrmSession != null && !this.codecInfo.secure || Util.SDK_INT < 23 && this.sourceDrmSession != this.codecDrmSession) {
            this.drainAndReinitializeCodec();
            return;
        }
        switch (this.canKeepCodec(this.codec, this.codecInfo, this.codecFormat, newFormat)) {
            case 0: {
                this.drainAndReinitializeCodec();
                break;
            }
            case 1: {
                this.codecFormat = newFormat;
                this.updateCodecOperatingRate();
                if (this.sourceDrmSession != this.codecDrmSession) {
                    this.drainAndUpdateCodecDrmSession();
                    break;
                }
                this.drainAndFlushCodec();
                break;
            }
            case 2: {
                if (this.codecNeedsReconfigureWorkaround) {
                    this.drainAndReinitializeCodec();
                    break;
                }
                this.codecReconfigured = true;
                this.codecReconfigurationState = 1;
                this.codecNeedsAdaptationWorkaroundBuffer = this.codecAdaptationWorkaroundMode == 2 || this.codecAdaptationWorkaroundMode == 1 && newFormat.width == this.codecFormat.width && newFormat.height == this.codecFormat.height;
                this.codecFormat = newFormat;
                this.updateCodecOperatingRate();
                if (this.sourceDrmSession == this.codecDrmSession) break;
                this.drainAndUpdateCodecDrmSession();
                break;
            }
            case 3: {
                this.codecFormat = newFormat;
                this.updateCodecOperatingRate();
                if (this.sourceDrmSession == this.codecDrmSession) break;
                this.drainAndUpdateCodecDrmSession();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void onOutputFormatChanged(MediaCodec codec, MediaFormat outputFormat) throws ExoPlaybackException {
    }

    protected void onQueueInputBuffer(DecoderInputBuffer buffer) {
    }

    protected void onProcessedOutputBuffer(long presentationTimeUs) {
    }

    protected int canKeepCodec(MediaCodec codec, MediaCodecInfo codecInfo, Format oldFormat, Format newFormat) {
        return 0;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return this.inputFormat != null && !this.waitingForKeys && (this.isSourceReady() || this.hasOutputBuffer() || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
    }

    protected long getDequeueOutputBufferTimeoutUs() {
        return 0L;
    }

    protected float getCodecOperatingRateV23(float operatingRate, Format format, Format[] streamFormats) {
        return -1.0f;
    }

    private void updateCodecOperatingRate() throws ExoPlaybackException {
        if (Util.SDK_INT < 23) {
            return;
        }
        float newCodecOperatingRate = this.getCodecOperatingRateV23(this.rendererOperatingRate, this.codecFormat, this.getStreamFormats());
        if (this.codecOperatingRate != newCodecOperatingRate) {
            if (newCodecOperatingRate == -1.0f) {
                this.drainAndReinitializeCodec();
            } else if (this.codecOperatingRate != -1.0f || newCodecOperatingRate > this.assumedMinimumCodecOperatingRate) {
                Bundle codecParameters = new Bundle();
                codecParameters.putFloat("operating-rate", newCodecOperatingRate);
                this.codec.setParameters(codecParameters);
                this.codecOperatingRate = newCodecOperatingRate;
            }
        }
    }

    private void drainAndFlushCodec() {
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            this.codecDrainAction = 1;
        }
    }

    private void drainAndUpdateCodecDrmSession() throws ExoPlaybackException {
        if (Util.SDK_INT < 23) {
            this.drainAndReinitializeCodec();
            return;
        }
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            this.codecDrainAction = 2;
        } else {
            this.updateDrmSessionOrReinitializeCodecV23();
        }
    }

    private void drainAndReinitializeCodec() throws ExoPlaybackException {
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            this.codecDrainAction = 3;
        } else {
            this.reinitializeCodec();
        }
    }

    private boolean drainOutputBuffer(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        boolean processedOutputBuffer;
        if (!this.hasOutputBuffer()) {
            int outputIndex;
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    outputIndex = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
                }
                catch (IllegalStateException e) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                outputIndex = this.codec.dequeueOutputBuffer(this.outputBufferInfo, this.getDequeueOutputBufferTimeoutUs());
            }
            if (outputIndex < 0) {
                if (outputIndex == -2) {
                    this.processOutputFormat();
                    return true;
                }
                if (outputIndex == -3) {
                    this.processOutputBuffersChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagation && (this.inputStreamEnded || this.codecDrainState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
            if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                this.codec.releaseOutputBuffer(outputIndex, false);
                return true;
            }
            if (this.outputBufferInfo.size == 0 && (this.outputBufferInfo.flags & 4) != 0) {
                this.processEndOfStream();
                return false;
            }
            this.outputIndex = outputIndex;
            this.outputBuffer = this.getOutputBuffer(outputIndex);
            if (this.outputBuffer != null) {
                this.outputBuffer.position(this.outputBufferInfo.offset);
                this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
            }
            this.shouldSkipOutputBuffer = this.shouldSkipOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            this.updateOutputFormatForTime(this.outputBufferInfo.presentationTimeUs);
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                processedOutputBuffer = this.processOutputBuffer(positionUs, elapsedRealtimeUs, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer, this.outputFormat);
            }
            catch (IllegalStateException e) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            processedOutputBuffer = this.processOutputBuffer(positionUs, elapsedRealtimeUs, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, this.outputBufferInfo.presentationTimeUs, this.shouldSkipOutputBuffer, this.outputFormat);
        }
        if (processedOutputBuffer) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            boolean isEndOfStream = (this.outputBufferInfo.flags & 4) != 0;
            this.resetOutputBuffer();
            if (!isEndOfStream) {
                return true;
            }
            this.processEndOfStream();
        }
        return false;
    }

    private void processOutputFormat() throws ExoPlaybackException {
        MediaFormat format = this.codec.getOutputFormat();
        if (this.codecAdaptationWorkaroundMode != 0 && format.getInteger("width") == 32 && format.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            format.setInteger("channel-count", 1);
        }
        this.onOutputFormatChanged(this.codec, format);
    }

    private void processOutputBuffersChanged() {
        if (Util.SDK_INT < 21) {
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, MediaCodec var5, ByteBuffer var6, int var7, int var8, long var9, boolean var11, Format var12) throws ExoPlaybackException;

    protected void renderToEndOfStream() throws ExoPlaybackException {
    }

    private void processEndOfStream() throws ExoPlaybackException {
        switch (this.codecDrainAction) {
            case 3: {
                this.reinitializeCodec();
                break;
            }
            case 2: {
                this.updateDrmSessionOrReinitializeCodecV23();
                break;
            }
            case 1: {
                this.flushOrReinitializeCodec();
                break;
            }
            default: {
                this.outputStreamEnded = true;
                this.renderToEndOfStream();
            }
        }
    }

    private void reinitializeCodec() throws ExoPlaybackException {
        this.releaseCodec();
        this.maybeInitCodec();
    }

    @TargetApi(value=23)
    private void updateDrmSessionOrReinitializeCodecV23() throws ExoPlaybackException {
        FrameworkMediaCrypto sessionMediaCrypto = this.sourceDrmSession.getMediaCrypto();
        if (sessionMediaCrypto == null) {
            this.reinitializeCodec();
            return;
        }
        if (C.PLAYREADY_UUID.equals(sessionMediaCrypto.uuid)) {
            this.reinitializeCodec();
            return;
        }
        if (this.flushOrReinitializeCodec()) {
            return;
        }
        try {
            this.mediaCrypto.setMediaDrmSession(sessionMediaCrypto.sessionId);
        }
        catch (MediaCryptoException e) {
            throw ExoPlaybackException.createForRenderer((Exception)((Object)e), this.getIndex());
        }
        this.setCodecDrmSession(this.sourceDrmSession);
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
    }

    private boolean shouldSkipOutputBuffer(long presentationTimeUs) {
        int size = this.decodeOnlyPresentationTimestamps.size();
        for (int i = 0; i < size; ++i) {
            if (this.decodeOnlyPresentationTimestamps.get(i) != presentationTimeUs) continue;
            this.decodeOnlyPresentationTimestamps.remove(i);
            return true;
        }
        return false;
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(DecoderInputBuffer buffer, int adaptiveReconfigurationBytes) {
        MediaCodec.CryptoInfo cryptoInfo = buffer.cryptoInfo.getFrameworkCryptoInfo();
        if (adaptiveReconfigurationBytes == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        cryptoInfo.numBytesOfClearData[0] = cryptoInfo.numBytesOfClearData[0] + adaptiveReconfigurationBytes;
        return cryptoInfo;
    }

    private boolean deviceNeedsDrmKeysToConfigureCodecWorkaround() {
        return "Amazon".equals(Util.MANUFACTURER) && ("AFTM".equals(Util.MODEL) || "AFTB".equals(Util.MODEL));
    }

    private static boolean codecNeedsFlushWorkaround(String name) {
        return Util.SDK_INT < 18 || Util.SDK_INT == 18 && ("OMX.SEC.avc.dec".equals(name) || "OMX.SEC.avc.dec.secure".equals(name)) || Util.SDK_INT == 19 && Util.MODEL.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(name) || "OMX.Exynos.avc.dec.secure".equals(name));
    }

    private int codecAdaptationWorkaroundMode(String name) {
        if (Util.SDK_INT <= 25 && "OMX.Exynos.avc.dec.secure".equals(name) && (Util.MODEL.startsWith("SM-T585") || Util.MODEL.startsWith("SM-A510") || Util.MODEL.startsWith("SM-A520") || Util.MODEL.startsWith("SM-J700"))) {
            return 2;
        }
        if (Util.SDK_INT < 24 && ("OMX.Nvidia.h264.decode".equals(name) || "OMX.Nvidia.h264.decode.secure".equals(name)) && ("flounder".equals(Util.DEVICE) || "flounder_lte".equals(Util.DEVICE) || "grouper".equals(Util.DEVICE) || "tilapia".equals(Util.DEVICE))) {
            return 1;
        }
        return 0;
    }

    private static boolean codecNeedsReconfigureWorkaround(String name) {
        return Util.MODEL.startsWith("SM-T230") && "OMX.MARVELL.VIDEO.HW.CODA7542DECODER".equals(name);
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String name, Format format) {
        return Util.SDK_INT < 21 && format.initializationData.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(name);
    }

    private static boolean codecNeedsEosPropagationWorkaround(MediaCodecInfo codecInfo) {
        String name = codecInfo.name;
        return Util.SDK_INT <= 17 && ("OMX.rk.video_decoder.avc".equals(name) || "OMX.allwinner.video.decoder.avc".equals(name)) || "Amazon".equals(Util.MANUFACTURER) && "AFTS".equals(Util.MODEL) && codecInfo.secure;
    }

    private static boolean codecNeedsEosFlushWorkaround(String name) {
        return Util.SDK_INT <= 23 && "OMX.google.vorbis.decoder".equals(name) || Util.SDK_INT <= 19 && ("hb2000".equals(Util.DEVICE) || "stvm8".equals(Util.DEVICE)) && ("OMX.amlogic.avc.decoder.awesome".equals(name) || "OMX.amlogic.avc.decoder.awesome.secure".equals(name));
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String name) {
        return Util.SDK_INT == 21 && "OMX.google.aac.decoder".equals(name);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String name, Format format) {
        return Util.SDK_INT <= 18 && format.channelCount == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(name);
    }

    public static class DecoderInitializationException
    extends Exception {
        private static final int CUSTOM_ERROR_CODE_BASE = -50000;
        private static final int NO_SUITABLE_DECODER_ERROR = -49999;
        private static final int DECODER_QUERY_ERROR = -49998;
        public final String mimeType;
        public final boolean secureDecoderRequired;
        public final String decoderName;
        public final String diagnosticInfo;
        @Nullable
        public final DecoderInitializationException fallbackDecoderInitializationException;

        public DecoderInitializationException(Format format, Throwable cause, boolean secureDecoderRequired, int errorCode) {
            this("Decoder init failed: [" + errorCode + "], " + format, cause, format.sampleMimeType, secureDecoderRequired, null, DecoderInitializationException.buildCustomDiagnosticInfo(errorCode), null);
        }

        public DecoderInitializationException(Format format, Throwable cause, boolean secureDecoderRequired, String decoderName) {
            this("Decoder init failed: " + decoderName + ", " + format, cause, format.sampleMimeType, secureDecoderRequired, decoderName, Util.SDK_INT >= 21 ? DecoderInitializationException.getDiagnosticInfoV21(cause) : null, null);
        }

        private DecoderInitializationException(String message, Throwable cause, String mimeType, boolean secureDecoderRequired, @Nullable String decoderName, @Nullable String diagnosticInfo, @Nullable DecoderInitializationException fallbackDecoderInitializationException) {
            super(message, cause);
            this.mimeType = mimeType;
            this.secureDecoderRequired = secureDecoderRequired;
            this.decoderName = decoderName;
            this.diagnosticInfo = diagnosticInfo;
            this.fallbackDecoderInitializationException = fallbackDecoderInitializationException;
        }

        @CheckResult
        private DecoderInitializationException copyWithFallbackException(DecoderInitializationException fallbackException) {
            return new DecoderInitializationException(this.getMessage(), this.getCause(), this.mimeType, this.secureDecoderRequired, this.decoderName, this.diagnosticInfo, fallbackException);
        }

        @TargetApi(value=21)
        private static String getDiagnosticInfoV21(Throwable cause) {
            if (cause instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)cause).getDiagnosticInfo();
            }
            return null;
        }

        private static String buildCustomDiagnosticInfo(int errorCode) {
            String sign = errorCode < 0 ? "neg_" : "";
            return "com.google.android.exoplayer.MediaCodecTrackRenderer_" + sign + Math.abs(errorCode);
        }
    }
}

