/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.google.android.exoplayer2.extractor.ts.SectionPayloadReader;
import com.google.android.exoplayer2.extractor.ts.SectionReader;
import com.google.android.exoplayer2.extractor.ts.TsBinarySearchSeeker;
import com.google.android.exoplayer2.extractor.ts.TsDurationReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.extractor.ts.TsUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TsExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new TsExtractor()};
    public static final int MODE_MULTI_PMT = 0;
    public static final int MODE_SINGLE_PMT = 1;
    public static final int MODE_HLS = 2;
    public static final int TS_STREAM_TYPE_MPA = 3;
    public static final int TS_STREAM_TYPE_MPA_LSF = 4;
    public static final int TS_STREAM_TYPE_AAC_ADTS = 15;
    public static final int TS_STREAM_TYPE_AAC_LATM = 17;
    public static final int TS_STREAM_TYPE_AC3 = 129;
    public static final int TS_STREAM_TYPE_DTS = 138;
    public static final int TS_STREAM_TYPE_HDMV_DTS = 130;
    public static final int TS_STREAM_TYPE_E_AC3 = 135;
    public static final int TS_STREAM_TYPE_AC4 = 172;
    public static final int TS_STREAM_TYPE_H262 = 2;
    public static final int TS_STREAM_TYPE_H264 = 27;
    public static final int TS_STREAM_TYPE_H265 = 36;
    public static final int TS_STREAM_TYPE_ID3 = 21;
    public static final int TS_STREAM_TYPE_SPLICE_INFO = 134;
    public static final int TS_STREAM_TYPE_DVBSUBS = 89;
    public static final int TS_PACKET_SIZE = 188;
    public static final int TS_SYNC_BYTE = 71;
    private static final int TS_PAT_PID = 0;
    private static final int MAX_PID_PLUS_ONE = 8192;
    private static final long AC3_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("AC-3");
    private static final long E_AC3_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("EAC3");
    private static final long AC4_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("AC-4");
    private static final long HEVC_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("HEVC");
    private static final int BUFFER_SIZE = 9400;
    private static final int SNIFF_TS_PACKET_COUNT = 5;
    private final int mode;
    private final List<TimestampAdjuster> timestampAdjusters;
    private final ParsableByteArray tsPacketBuffer;
    private final SparseIntArray continuityCounters;
    private final TsPayloadReader.Factory payloadReaderFactory;
    private final SparseArray<TsPayloadReader> tsPayloadReaders;
    private final SparseBooleanArray trackIds;
    private final SparseBooleanArray trackPids;
    private final TsDurationReader durationReader;
    private TsBinarySearchSeeker tsBinarySearchSeeker;
    private ExtractorOutput output;
    private int remainingPmts;
    private boolean tracksEnded;
    private boolean hasOutputSeekMap;
    private boolean pendingSeekToStart;
    private TsPayloadReader id3Reader;
    private int bytesSinceLastSync;
    private int pcrPid;

    public TsExtractor() {
        this(0);
    }

    public TsExtractor(int defaultTsPayloadReaderFlags) {
        this(1, defaultTsPayloadReaderFlags);
    }

    public TsExtractor(int mode, int defaultTsPayloadReaderFlags) {
        this(mode, new TimestampAdjuster(0L), new DefaultTsPayloadReaderFactory(defaultTsPayloadReaderFlags));
    }

    public TsExtractor(int mode, TimestampAdjuster timestampAdjuster, TsPayloadReader.Factory payloadReaderFactory) {
        this.payloadReaderFactory = Assertions.checkNotNull(payloadReaderFactory);
        this.mode = mode;
        if (mode == 1 || mode == 2) {
            this.timestampAdjusters = Collections.singletonList(timestampAdjuster);
        } else {
            this.timestampAdjusters = new ArrayList<TimestampAdjuster>();
            this.timestampAdjusters.add(timestampAdjuster);
        }
        this.tsPacketBuffer = new ParsableByteArray(new byte[9400], 0);
        this.trackIds = new SparseBooleanArray();
        this.trackPids = new SparseBooleanArray();
        this.tsPayloadReaders = new SparseArray();
        this.continuityCounters = new SparseIntArray();
        this.durationReader = new TsDurationReader();
        this.pcrPid = -1;
        this.resetPayloadReaders();
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        byte[] buffer = this.tsPacketBuffer.data;
        input.peekFully(buffer, 0, 940);
        for (int startPosCandidate = 0; startPosCandidate < 188; ++startPosCandidate) {
            boolean isSyncBytePatternCorrect = true;
            for (int i = 0; i < 5; ++i) {
                if (buffer[startPosCandidate + i * 188] == 71) continue;
                isSyncBytePatternCorrect = false;
                break;
            }
            if (!isSyncBytePatternCorrect) continue;
            input.skipFully(startPosCandidate);
            return true;
        }
        return false;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.output = output;
    }

    @Override
    public void seek(long position, long timeUs) {
        int i;
        Assertions.checkState(this.mode != 2);
        int timestampAdjustersCount = this.timestampAdjusters.size();
        for (i = 0; i < timestampAdjustersCount; ++i) {
            boolean hasNotEncounteredFirstTimestamp;
            TimestampAdjuster timestampAdjuster = this.timestampAdjusters.get(i);
            boolean bl = hasNotEncounteredFirstTimestamp = timestampAdjuster.getTimestampOffsetUs() == -9223372036854775807L;
            if (!hasNotEncounteredFirstTimestamp && (timestampAdjuster.getTimestampOffsetUs() == 0L || timestampAdjuster.getFirstSampleTimestampUs() == timeUs)) continue;
            timestampAdjuster.reset();
            timestampAdjuster.setFirstSampleTimestampUs(timeUs);
        }
        if (timeUs != 0L && this.tsBinarySearchSeeker != null) {
            this.tsBinarySearchSeeker.setSeekTargetUs(timeUs);
        }
        this.tsPacketBuffer.reset();
        this.continuityCounters.clear();
        for (i = 0; i < this.tsPayloadReaders.size(); ++i) {
            ((TsPayloadReader)this.tsPayloadReaders.valueAt(i)).seek();
        }
        this.bytesSinceLastSync = 0;
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        TsPayloadReader payloadReader;
        int limit;
        long inputLength = input.getLength();
        if (this.tracksEnded) {
            boolean canReadDuration;
            boolean bl = canReadDuration = inputLength != -1L && this.mode != 2;
            if (canReadDuration && !this.durationReader.isDurationReadFinished()) {
                return this.durationReader.readDuration(input, seekPosition, this.pcrPid);
            }
            this.maybeOutputSeekMap(inputLength);
            if (this.pendingSeekToStart) {
                this.pendingSeekToStart = false;
                this.seek(0L, 0L);
                if (input.getPosition() != 0L) {
                    seekPosition.position = 0L;
                    return 1;
                }
            }
            if (this.tsBinarySearchSeeker != null && this.tsBinarySearchSeeker.isSeeking()) {
                return this.tsBinarySearchSeeker.handlePendingSeek(input, seekPosition, null);
            }
        }
        if (!this.fillBufferWithAtLeastOnePacket(input)) {
            return -1;
        }
        int endOfPacket = this.findEndOfFirstTsPacketInBuffer();
        if (endOfPacket > (limit = this.tsPacketBuffer.limit())) {
            return 0;
        }
        int packetHeaderFlags = 0;
        int tsPacketHeader = this.tsPacketBuffer.readInt();
        if ((tsPacketHeader & 0x800000) != 0) {
            this.tsPacketBuffer.setPosition(endOfPacket);
            return 0;
        }
        packetHeaderFlags |= (tsPacketHeader & 0x400000) != 0 ? 1 : 0;
        int pid = (tsPacketHeader & 0x1FFF00) >> 8;
        boolean adaptationFieldExists = (tsPacketHeader & 0x20) != 0;
        boolean payloadExists = (tsPacketHeader & 0x10) != 0;
        TsPayloadReader tsPayloadReader = payloadReader = payloadExists ? (TsPayloadReader)this.tsPayloadReaders.get(pid) : null;
        if (payloadReader == null) {
            this.tsPacketBuffer.setPosition(endOfPacket);
            return 0;
        }
        if (this.mode != 2) {
            int continuityCounter = tsPacketHeader & 0xF;
            int previousCounter = this.continuityCounters.get(pid, continuityCounter - 1);
            this.continuityCounters.put(pid, continuityCounter);
            if (previousCounter == continuityCounter) {
                this.tsPacketBuffer.setPosition(endOfPacket);
                return 0;
            }
            if (continuityCounter != (previousCounter + 1 & 0xF)) {
                payloadReader.seek();
            }
        }
        if (adaptationFieldExists) {
            int adaptationFieldLength = this.tsPacketBuffer.readUnsignedByte();
            int adaptationFieldFlags = this.tsPacketBuffer.readUnsignedByte();
            packetHeaderFlags |= (adaptationFieldFlags & 0x40) != 0 ? 2 : 0;
            this.tsPacketBuffer.skipBytes(adaptationFieldLength - 1);
        }
        boolean wereTracksEnded = this.tracksEnded;
        if (this.shouldConsumePacketPayload(pid)) {
            this.tsPacketBuffer.setLimit(endOfPacket);
            payloadReader.consume(this.tsPacketBuffer, packetHeaderFlags);
            this.tsPacketBuffer.setLimit(limit);
        }
        if (this.mode != 2 && !wereTracksEnded && this.tracksEnded && inputLength != -1L) {
            this.pendingSeekToStart = true;
        }
        this.tsPacketBuffer.setPosition(endOfPacket);
        return 0;
    }

    private void maybeOutputSeekMap(long inputLength) {
        if (!this.hasOutputSeekMap) {
            this.hasOutputSeekMap = true;
            if (this.durationReader.getDurationUs() != -9223372036854775807L) {
                this.tsBinarySearchSeeker = new TsBinarySearchSeeker(this.durationReader.getPcrTimestampAdjuster(), this.durationReader.getDurationUs(), inputLength, this.pcrPid);
                this.output.seekMap(this.tsBinarySearchSeeker.getSeekMap());
            } else {
                this.output.seekMap(new SeekMap.Unseekable(this.durationReader.getDurationUs()));
            }
        }
    }

    private boolean fillBufferWithAtLeastOnePacket(ExtractorInput input) throws IOException, InterruptedException {
        byte[] data = this.tsPacketBuffer.data;
        if (9400 - this.tsPacketBuffer.getPosition() < 188) {
            int bytesLeft = this.tsPacketBuffer.bytesLeft();
            if (bytesLeft > 0) {
                System.arraycopy(data, this.tsPacketBuffer.getPosition(), data, 0, bytesLeft);
            }
            this.tsPacketBuffer.reset(data, bytesLeft);
        }
        while (this.tsPacketBuffer.bytesLeft() < 188) {
            int limit = this.tsPacketBuffer.limit();
            int read = input.read(data, limit, 9400 - limit);
            if (read == -1) {
                return false;
            }
            this.tsPacketBuffer.setLimit(limit + read);
        }
        return true;
    }

    private int findEndOfFirstTsPacketInBuffer() throws ParserException {
        int searchStart = this.tsPacketBuffer.getPosition();
        int limit = this.tsPacketBuffer.limit();
        int syncBytePosition = TsUtil.findSyncBytePosition(this.tsPacketBuffer.data, searchStart, limit);
        this.tsPacketBuffer.setPosition(syncBytePosition);
        int endOfPacket = syncBytePosition + 188;
        if (endOfPacket > limit) {
            this.bytesSinceLastSync += syncBytePosition - searchStart;
            if (this.mode == 2 && this.bytesSinceLastSync > 376) {
                throw new ParserException("Cannot find sync byte. Most likely not a Transport Stream.");
            }
        } else {
            this.bytesSinceLastSync = 0;
        }
        return endOfPacket;
    }

    private boolean shouldConsumePacketPayload(int packetPid) {
        return this.mode == 2 || this.tracksEnded || !this.trackPids.get(packetPid, false);
    }

    private void resetPayloadReaders() {
        this.trackIds.clear();
        this.tsPayloadReaders.clear();
        SparseArray<TsPayloadReader> initialPayloadReaders = this.payloadReaderFactory.createInitialPayloadReaders();
        int initialPayloadReadersSize = initialPayloadReaders.size();
        for (int i = 0; i < initialPayloadReadersSize; ++i) {
            this.tsPayloadReaders.put(initialPayloadReaders.keyAt(i), initialPayloadReaders.valueAt(i));
        }
        this.tsPayloadReaders.put(0, (Object)new SectionReader(new PatReader()));
        this.id3Reader = null;
    }

    private class PmtReader
    implements SectionPayloadReader {
        private static final int TS_PMT_DESC_REGISTRATION = 5;
        private static final int TS_PMT_DESC_ISO639_LANG = 10;
        private static final int TS_PMT_DESC_AC3 = 106;
        private static final int TS_PMT_DESC_EAC3 = 122;
        private static final int TS_PMT_DESC_DTS = 123;
        private static final int TS_PMT_DESC_DVB_EXT = 127;
        private static final int TS_PMT_DESC_DVBSUBS = 89;
        private static final int TS_PMT_DESC_DVB_EXT_AC4 = 21;
        private final ParsableBitArray pmtScratch = new ParsableBitArray(new byte[5]);
        private final SparseArray<TsPayloadReader> trackIdToReaderScratch = new SparseArray();
        private final SparseIntArray trackIdToPidScratch = new SparseIntArray();
        private final int pid;

        public PmtReader(int pid) {
            this.pid = pid;
        }

        @Override
        public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        }

        @Override
        public void consume(ParsableByteArray sectionData) {
            int esInfoLength;
            TimestampAdjuster timestampAdjuster;
            int tableId = sectionData.readUnsignedByte();
            if (tableId != 2) {
                return;
            }
            if (TsExtractor.this.mode == 1 || TsExtractor.this.mode == 2 || TsExtractor.this.remainingPmts == 1) {
                timestampAdjuster = (TimestampAdjuster)TsExtractor.this.timestampAdjusters.get(0);
            } else {
                timestampAdjuster = new TimestampAdjuster(((TimestampAdjuster)TsExtractor.this.timestampAdjusters.get(0)).getFirstSampleTimestampUs());
                TsExtractor.this.timestampAdjusters.add(timestampAdjuster);
            }
            sectionData.skipBytes(2);
            int programNumber = sectionData.readUnsignedShort();
            sectionData.skipBytes(3);
            sectionData.readBytes(this.pmtScratch, 2);
            this.pmtScratch.skipBits(3);
            TsExtractor.this.pcrPid = this.pmtScratch.readBits(13);
            sectionData.readBytes(this.pmtScratch, 2);
            this.pmtScratch.skipBits(4);
            int programInfoLength = this.pmtScratch.readBits(12);
            sectionData.skipBytes(programInfoLength);
            if (TsExtractor.this.mode == 2 && TsExtractor.this.id3Reader == null) {
                TsPayloadReader.EsInfo dummyEsInfo = new TsPayloadReader.EsInfo(21, null, null, Util.EMPTY_BYTE_ARRAY);
                TsExtractor.this.id3Reader = TsExtractor.this.payloadReaderFactory.createPayloadReader(21, dummyEsInfo);
                TsExtractor.this.id3Reader.init(timestampAdjuster, TsExtractor.this.output, new TsPayloadReader.TrackIdGenerator(programNumber, 21, 8192));
            }
            this.trackIdToReaderScratch.clear();
            this.trackIdToPidScratch.clear();
            for (int remainingEntriesLength = sectionData.bytesLeft(); remainingEntriesLength > 0; remainingEntriesLength -= esInfoLength + 5) {
                TsPayloadReader reader;
                int trackId;
                sectionData.readBytes(this.pmtScratch, 5);
                int streamType = this.pmtScratch.readBits(8);
                this.pmtScratch.skipBits(3);
                int elementaryPid = this.pmtScratch.readBits(13);
                this.pmtScratch.skipBits(4);
                esInfoLength = this.pmtScratch.readBits(12);
                TsPayloadReader.EsInfo esInfo = this.readEsInfo(sectionData, esInfoLength);
                if (streamType == 6) {
                    streamType = esInfo.streamType;
                }
                int n = trackId = TsExtractor.this.mode == 2 ? streamType : elementaryPid;
                if (TsExtractor.this.trackIds.get(trackId)) continue;
                TsPayloadReader tsPayloadReader = reader = TsExtractor.this.mode == 2 && streamType == 21 ? TsExtractor.this.id3Reader : TsExtractor.this.payloadReaderFactory.createPayloadReader(streamType, esInfo);
                if (TsExtractor.this.mode == 2 && elementaryPid >= this.trackIdToPidScratch.get(trackId, 8192)) continue;
                this.trackIdToPidScratch.put(trackId, elementaryPid);
                this.trackIdToReaderScratch.put(trackId, (Object)reader);
            }
            int trackIdCount = this.trackIdToPidScratch.size();
            for (int i = 0; i < trackIdCount; ++i) {
                int trackId = this.trackIdToPidScratch.keyAt(i);
                int trackPid = this.trackIdToPidScratch.valueAt(i);
                TsExtractor.this.trackIds.put(trackId, true);
                TsExtractor.this.trackPids.put(trackPid, true);
                TsPayloadReader reader = (TsPayloadReader)this.trackIdToReaderScratch.valueAt(i);
                if (reader == null) continue;
                if (reader != TsExtractor.this.id3Reader) {
                    reader.init(timestampAdjuster, TsExtractor.this.output, new TsPayloadReader.TrackIdGenerator(programNumber, trackId, 8192));
                }
                TsExtractor.this.tsPayloadReaders.put(trackPid, (Object)reader);
            }
            if (TsExtractor.this.mode == 2) {
                if (!TsExtractor.this.tracksEnded) {
                    TsExtractor.this.output.endTracks();
                    TsExtractor.this.remainingPmts = 0;
                    TsExtractor.this.tracksEnded = true;
                }
            } else {
                TsExtractor.this.tsPayloadReaders.remove(this.pid);
                TsExtractor.this.remainingPmts = TsExtractor.this.mode == 1 ? 0 : TsExtractor.this.remainingPmts - 1;
                if (TsExtractor.this.remainingPmts == 0) {
                    TsExtractor.this.output.endTracks();
                    TsExtractor.this.tracksEnded = true;
                }
            }
        }

        private TsPayloadReader.EsInfo readEsInfo(ParsableByteArray data, int length) {
            int descriptorsStartPosition = data.getPosition();
            int descriptorsEndPosition = descriptorsStartPosition + length;
            int streamType = -1;
            String language = null;
            ArrayList<TsPayloadReader.DvbSubtitleInfo> dvbSubtitleInfos = null;
            while (data.getPosition() < descriptorsEndPosition) {
                int positionOfNextDescriptor;
                block16: {
                    int descriptorTag;
                    block14: {
                        long formatIdentifier;
                        block18: {
                            block17: {
                                block15: {
                                    descriptorTag = data.readUnsignedByte();
                                    int descriptorLength = data.readUnsignedByte();
                                    positionOfNextDescriptor = data.getPosition() + descriptorLength;
                                    if (descriptorTag != 5) break block14;
                                    formatIdentifier = data.readUnsignedInt();
                                    if (formatIdentifier != AC3_FORMAT_IDENTIFIER) break block15;
                                    streamType = 129;
                                    break block16;
                                }
                                if (formatIdentifier != E_AC3_FORMAT_IDENTIFIER) break block17;
                                streamType = 135;
                                break block16;
                            }
                            if (formatIdentifier != AC4_FORMAT_IDENTIFIER) break block18;
                            streamType = 172;
                            break block16;
                        }
                        if (formatIdentifier != HEVC_FORMAT_IDENTIFIER) break block16;
                        streamType = 36;
                        break block16;
                    }
                    if (descriptorTag == 106) {
                        streamType = 129;
                    } else if (descriptorTag == 122) {
                        streamType = 135;
                    } else if (descriptorTag == 127) {
                        int descriptorTagExt = data.readUnsignedByte();
                        if (descriptorTagExt == 21) {
                            streamType = 172;
                        }
                    } else if (descriptorTag == 123) {
                        streamType = 138;
                    } else if (descriptorTag == 10) {
                        language = data.readString(3).trim();
                    } else if (descriptorTag == 89) {
                        streamType = 89;
                        dvbSubtitleInfos = new ArrayList<TsPayloadReader.DvbSubtitleInfo>();
                        while (data.getPosition() < positionOfNextDescriptor) {
                            String dvbLanguage = data.readString(3).trim();
                            int dvbSubtitlingType = data.readUnsignedByte();
                            byte[] initializationData = new byte[4];
                            data.readBytes(initializationData, 0, 4);
                            dvbSubtitleInfos.add(new TsPayloadReader.DvbSubtitleInfo(dvbLanguage, dvbSubtitlingType, initializationData));
                        }
                    }
                }
                data.skipBytes(positionOfNextDescriptor - data.getPosition());
            }
            data.setPosition(descriptorsEndPosition);
            return new TsPayloadReader.EsInfo(streamType, language, dvbSubtitleInfos, Arrays.copyOfRange(data.data, descriptorsStartPosition, descriptorsEndPosition));
        }
    }

    private class PatReader
    implements SectionPayloadReader {
        private final ParsableBitArray patScratch = new ParsableBitArray(new byte[4]);

        @Override
        public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        }

        @Override
        public void consume(ParsableByteArray sectionData) {
            int tableId = sectionData.readUnsignedByte();
            if (tableId != 0) {
                return;
            }
            sectionData.skipBytes(7);
            int programCount = sectionData.bytesLeft() / 4;
            for (int i = 0; i < programCount; ++i) {
                sectionData.readBytes(this.patScratch, 4);
                int programNumber = this.patScratch.readBits(16);
                this.patScratch.skipBits(3);
                if (programNumber == 0) {
                    this.patScratch.skipBits(13);
                    continue;
                }
                int pid = this.patScratch.readBits(13);
                TsExtractor.this.tsPayloadReaders.put(pid, (Object)new SectionReader(new PmtReader(pid)));
                TsExtractor.this.remainingPmts++;
            }
            if (TsExtractor.this.mode != 2) {
                TsExtractor.this.tsPayloadReaders.remove(0);
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

