/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ts.Ac3Reader;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.H262Reader;
import com.google.android.exoplayer2.extractor.ts.MpegAudioReader;
import com.google.android.exoplayer2.extractor.ts.PsBinarySearchSeeker;
import com.google.android.exoplayer2.extractor.ts.PsDurationReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.io.IOException;

public final class PsExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new PsExtractor()};
    static final int PACK_START_CODE = 442;
    static final int SYSTEM_HEADER_START_CODE = 443;
    static final int PACKET_START_CODE_PREFIX = 1;
    static final int MPEG_PROGRAM_END_CODE = 441;
    private static final int MAX_STREAM_ID_PLUS_ONE = 256;
    private static final long MAX_SEARCH_LENGTH = 0x100000L;
    private static final long MAX_SEARCH_LENGTH_AFTER_AUDIO_AND_VIDEO_FOUND = 8192L;
    public static final int PRIVATE_STREAM_1 = 189;
    public static final int AUDIO_STREAM = 192;
    public static final int AUDIO_STREAM_MASK = 224;
    public static final int VIDEO_STREAM = 224;
    public static final int VIDEO_STREAM_MASK = 240;
    private final TimestampAdjuster timestampAdjuster;
    private final SparseArray<PesReader> psPayloadReaders;
    private final ParsableByteArray psPacketBuffer;
    private final PsDurationReader durationReader;
    private boolean foundAllTracks;
    private boolean foundAudioTrack;
    private boolean foundVideoTrack;
    private long lastTrackPosition;
    private PsBinarySearchSeeker psBinarySearchSeeker;
    private ExtractorOutput output;
    private boolean hasOutputSeekMap;

    public PsExtractor() {
        this(new TimestampAdjuster(0L));
    }

    public PsExtractor(TimestampAdjuster timestampAdjuster) {
        this.timestampAdjuster = timestampAdjuster;
        this.psPacketBuffer = new ParsableByteArray(4096);
        this.psPayloadReaders = new SparseArray();
        this.durationReader = new PsDurationReader();
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        byte[] scratch = new byte[14];
        input.peekFully(scratch, 0, 14);
        if (442 != ((scratch[0] & 0xFF) << 24 | (scratch[1] & 0xFF) << 16 | (scratch[2] & 0xFF) << 8 | scratch[3] & 0xFF)) {
            return false;
        }
        if ((scratch[4] & 0xC4) != 68) {
            return false;
        }
        if ((scratch[6] & 4) != 4) {
            return false;
        }
        if ((scratch[8] & 4) != 4) {
            return false;
        }
        if ((scratch[9] & 1) != 1) {
            return false;
        }
        if ((scratch[12] & 3) != 3) {
            return false;
        }
        int packStuffingLength = scratch[13] & 7;
        input.advancePeekPosition(packStuffingLength);
        input.peekFully(scratch, 0, 3);
        return 1 == ((scratch[0] & 0xFF) << 16 | (scratch[1] & 0xFF) << 8 | scratch[2] & 0xFF);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.output = output;
    }

    @Override
    public void seek(long position, long timeUs) {
        boolean hasNotEncounteredFirstTimestamp;
        boolean bl = hasNotEncounteredFirstTimestamp = this.timestampAdjuster.getTimestampOffsetUs() == -9223372036854775807L;
        if (hasNotEncounteredFirstTimestamp || this.timestampAdjuster.getFirstSampleTimestampUs() != 0L && this.timestampAdjuster.getFirstSampleTimestampUs() != timeUs) {
            this.timestampAdjuster.reset();
            this.timestampAdjuster.setFirstSampleTimestampUs(timeUs);
        }
        if (this.psBinarySearchSeeker != null) {
            this.psBinarySearchSeeker.setSeekTargetUs(timeUs);
        }
        for (int i = 0; i < this.psPayloadReaders.size(); ++i) {
            ((PesReader)this.psPayloadReaders.valueAt(i)).seek();
        }
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        long peekBytesLeft;
        boolean canReadDuration;
        long inputLength = input.getLength();
        boolean bl = canReadDuration = inputLength != -1L;
        if (canReadDuration && !this.durationReader.isDurationReadFinished()) {
            return this.durationReader.readDuration(input, seekPosition);
        }
        this.maybeOutputSeekMap(inputLength);
        if (this.psBinarySearchSeeker != null && this.psBinarySearchSeeker.isSeeking()) {
            return this.psBinarySearchSeeker.handlePendingSeek(input, seekPosition, null);
        }
        input.resetPeekPosition();
        long l = peekBytesLeft = inputLength != -1L ? inputLength - input.getPeekPosition() : -1L;
        if (peekBytesLeft != -1L && peekBytesLeft < 4L) {
            return -1;
        }
        if (!input.peekFully(this.psPacketBuffer.data, 0, 4, true)) {
            return -1;
        }
        this.psPacketBuffer.setPosition(0);
        int nextStartCode = this.psPacketBuffer.readInt();
        if (nextStartCode == 441) {
            return -1;
        }
        if (nextStartCode == 442) {
            input.peekFully(this.psPacketBuffer.data, 0, 10);
            this.psPacketBuffer.setPosition(9);
            int packStuffingLength = this.psPacketBuffer.readUnsignedByte() & 7;
            input.skipFully(packStuffingLength + 14);
            return 0;
        }
        if (nextStartCode == 443) {
            input.peekFully(this.psPacketBuffer.data, 0, 2);
            this.psPacketBuffer.setPosition(0);
            int systemHeaderLength = this.psPacketBuffer.readUnsignedShort();
            input.skipFully(systemHeaderLength + 6);
            return 0;
        }
        if ((nextStartCode & 0xFFFFFF00) >> 8 != 1) {
            input.skipFully(1);
            return 0;
        }
        int streamId = nextStartCode & 0xFF;
        PesReader payloadReader = (PesReader)this.psPayloadReaders.get(streamId);
        if (!this.foundAllTracks) {
            long maxSearchPosition;
            if (payloadReader == null) {
                ElementaryStreamReader elementaryStreamReader = null;
                if (streamId == 189) {
                    elementaryStreamReader = new Ac3Reader();
                    this.foundAudioTrack = true;
                    this.lastTrackPosition = input.getPosition();
                } else if ((streamId & 0xE0) == 192) {
                    elementaryStreamReader = new MpegAudioReader();
                    this.foundAudioTrack = true;
                    this.lastTrackPosition = input.getPosition();
                } else if ((streamId & 0xF0) == 224) {
                    elementaryStreamReader = new H262Reader();
                    this.foundVideoTrack = true;
                    this.lastTrackPosition = input.getPosition();
                }
                if (elementaryStreamReader != null) {
                    TsPayloadReader.TrackIdGenerator idGenerator = new TsPayloadReader.TrackIdGenerator(streamId, 256);
                    elementaryStreamReader.createTracks(this.output, idGenerator);
                    payloadReader = new PesReader(elementaryStreamReader, this.timestampAdjuster);
                    this.psPayloadReaders.put(streamId, (Object)payloadReader);
                }
            }
            long l2 = maxSearchPosition = this.foundAudioTrack && this.foundVideoTrack ? this.lastTrackPosition + 8192L : 0x100000L;
            if (input.getPosition() > maxSearchPosition) {
                this.foundAllTracks = true;
                this.output.endTracks();
            }
        }
        input.peekFully(this.psPacketBuffer.data, 0, 2);
        this.psPacketBuffer.setPosition(0);
        int payloadLength = this.psPacketBuffer.readUnsignedShort();
        int pesLength = payloadLength + 6;
        if (payloadReader == null) {
            input.skipFully(pesLength);
        } else {
            this.psPacketBuffer.reset(pesLength);
            input.readFully(this.psPacketBuffer.data, 0, pesLength);
            this.psPacketBuffer.setPosition(6);
            payloadReader.consume(this.psPacketBuffer);
            this.psPacketBuffer.setLimit(this.psPacketBuffer.capacity());
        }
        return 0;
    }

    private void maybeOutputSeekMap(long inputLength) {
        if (!this.hasOutputSeekMap) {
            this.hasOutputSeekMap = true;
            if (this.durationReader.getDurationUs() != -9223372036854775807L) {
                this.psBinarySearchSeeker = new PsBinarySearchSeeker(this.durationReader.getScrTimestampAdjuster(), this.durationReader.getDurationUs(), inputLength);
                this.output.seekMap(this.psBinarySearchSeeker.getSeekMap());
            } else {
                this.output.seekMap(new SeekMap.Unseekable(this.durationReader.getDurationUs()));
            }
        }
    }

    private static final class PesReader {
        private static final int PES_SCRATCH_SIZE = 64;
        private final ElementaryStreamReader pesPayloadReader;
        private final TimestampAdjuster timestampAdjuster;
        private final ParsableBitArray pesScratch;
        private boolean ptsFlag;
        private boolean dtsFlag;
        private boolean seenFirstDts;
        private int extendedHeaderLength;
        private long timeUs;

        public PesReader(ElementaryStreamReader pesPayloadReader, TimestampAdjuster timestampAdjuster) {
            this.pesPayloadReader = pesPayloadReader;
            this.timestampAdjuster = timestampAdjuster;
            this.pesScratch = new ParsableBitArray(new byte[64]);
        }

        public void seek() {
            this.seenFirstDts = false;
            this.pesPayloadReader.seek();
        }

        public void consume(ParsableByteArray data) throws ParserException {
            data.readBytes(this.pesScratch.data, 0, 3);
            this.pesScratch.setPosition(0);
            this.parseHeader();
            data.readBytes(this.pesScratch.data, 0, this.extendedHeaderLength);
            this.pesScratch.setPosition(0);
            this.parseHeaderExtension();
            this.pesPayloadReader.packetStarted(this.timeUs, 4);
            this.pesPayloadReader.consume(data);
            this.pesPayloadReader.packetFinished();
        }

        private void parseHeader() {
            this.pesScratch.skipBits(8);
            this.ptsFlag = this.pesScratch.readBit();
            this.dtsFlag = this.pesScratch.readBit();
            this.pesScratch.skipBits(6);
            this.extendedHeaderLength = this.pesScratch.readBits(8);
        }

        private void parseHeaderExtension() {
            this.timeUs = 0L;
            if (this.ptsFlag) {
                this.pesScratch.skipBits(4);
                long pts = (long)this.pesScratch.readBits(3) << 30;
                this.pesScratch.skipBits(1);
                pts |= (long)(this.pesScratch.readBits(15) << 15);
                this.pesScratch.skipBits(1);
                pts |= (long)this.pesScratch.readBits(15);
                this.pesScratch.skipBits(1);
                if (!this.seenFirstDts && this.dtsFlag) {
                    this.pesScratch.skipBits(4);
                    long dts = (long)this.pesScratch.readBits(3) << 30;
                    this.pesScratch.skipBits(1);
                    dts |= (long)(this.pesScratch.readBits(15) << 15);
                    this.pesScratch.skipBits(1);
                    this.pesScratch.skipBits(1);
                    this.timestampAdjuster.adjustTsTimestamp(dts |= (long)this.pesScratch.readBits(15));
                    this.seenFirstDts = true;
                }
                this.timeUs = this.timestampAdjuster.adjustTsTimestamp(pts);
            }
        }
    }
}

