/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.extractor.BinarySearchSeeker;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ts.PsDurationReader;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

final class PsBinarySearchSeeker
extends BinarySearchSeeker {
    private static final long SEEK_TOLERANCE_US = 100000L;
    private static final int MINIMUM_SEARCH_RANGE_BYTES = 1000;
    private static final int TIMESTAMP_SEARCH_BYTES = 20000;

    public PsBinarySearchSeeker(TimestampAdjuster scrTimestampAdjuster, long streamDurationUs, long inputLength) {
        super(new BinarySearchSeeker.DefaultSeekTimestampConverter(), new PsScrSeeker(scrTimestampAdjuster), streamDurationUs, 0L, streamDurationUs + 1L, 0L, inputLength, 188L, 1000);
    }

    private static int peekIntAtPosition(byte[] data, int position) {
        return (data[position] & 0xFF) << 24 | (data[position + 1] & 0xFF) << 16 | (data[position + 2] & 0xFF) << 8 | data[position + 3] & 0xFF;
    }

    private static final class PsScrSeeker
    implements BinarySearchSeeker.TimestampSeeker {
        private final TimestampAdjuster scrTimestampAdjuster;
        private final ParsableByteArray packetBuffer;

        private PsScrSeeker(TimestampAdjuster scrTimestampAdjuster) {
            this.scrTimestampAdjuster = scrTimestampAdjuster;
            this.packetBuffer = new ParsableByteArray();
        }

        @Override
        public BinarySearchSeeker.TimestampSearchResult searchForTimestamp(ExtractorInput input, long targetTimestamp, BinarySearchSeeker.OutputFrameHolder outputFrameHolder) throws IOException, InterruptedException {
            long inputPosition = input.getPosition();
            int bytesToSearch = (int)Math.min(20000L, input.getLength() - inputPosition);
            this.packetBuffer.reset(bytesToSearch);
            input.peekFully(this.packetBuffer.data, 0, bytesToSearch);
            return this.searchForScrValueInBuffer(this.packetBuffer, targetTimestamp, inputPosition);
        }

        @Override
        public void onSeekFinished() {
            this.packetBuffer.reset(Util.EMPTY_BYTE_ARRAY);
        }

        private BinarySearchSeeker.TimestampSearchResult searchForScrValueInBuffer(ParsableByteArray packetBuffer, long targetScrTimeUs, long bufferStartOffset) {
            int startOfLastPacketPosition = -1;
            int endOfLastPacketPosition = -1;
            long lastScrTimeUsInRange = -9223372036854775807L;
            while (packetBuffer.bytesLeft() >= 4) {
                int nextStartCode = PsBinarySearchSeeker.peekIntAtPosition(packetBuffer.data, packetBuffer.getPosition());
                if (nextStartCode != 442) {
                    packetBuffer.skipBytes(1);
                    continue;
                }
                packetBuffer.skipBytes(4);
                long scrValue = PsDurationReader.readScrValueFromPack(packetBuffer);
                if (scrValue != -9223372036854775807L) {
                    long scrTimeUs = this.scrTimestampAdjuster.adjustTsTimestamp(scrValue);
                    if (scrTimeUs > targetScrTimeUs) {
                        if (lastScrTimeUsInRange == -9223372036854775807L) {
                            return BinarySearchSeeker.TimestampSearchResult.overestimatedResult(scrTimeUs, bufferStartOffset);
                        }
                        return BinarySearchSeeker.TimestampSearchResult.targetFoundResult(bufferStartOffset + (long)startOfLastPacketPosition);
                    }
                    if (scrTimeUs + 100000L > targetScrTimeUs) {
                        long startOfPacketInStream = bufferStartOffset + (long)packetBuffer.getPosition();
                        return BinarySearchSeeker.TimestampSearchResult.targetFoundResult(startOfPacketInStream);
                    }
                    lastScrTimeUsInRange = scrTimeUs;
                    startOfLastPacketPosition = packetBuffer.getPosition();
                }
                PsScrSeeker.skipToEndOfCurrentPack(packetBuffer);
                endOfLastPacketPosition = packetBuffer.getPosition();
            }
            if (lastScrTimeUsInRange != -9223372036854775807L) {
                long endOfLastPacketPositionInStream = bufferStartOffset + (long)endOfLastPacketPosition;
                return BinarySearchSeeker.TimestampSearchResult.underestimatedResult(lastScrTimeUsInRange, endOfLastPacketPositionInStream);
            }
            return BinarySearchSeeker.TimestampSearchResult.NO_TIMESTAMP_IN_RANGE_RESULT;
        }

        private static void skipToEndOfCurrentPack(ParsableByteArray packetBuffer) {
            int limit = packetBuffer.limit();
            if (packetBuffer.bytesLeft() < 10) {
                packetBuffer.setPosition(limit);
                return;
            }
            packetBuffer.skipBytes(9);
            int packStuffingLength = packetBuffer.readUnsignedByte() & 7;
            if (packetBuffer.bytesLeft() < packStuffingLength) {
                packetBuffer.setPosition(limit);
                return;
            }
            packetBuffer.skipBytes(packStuffingLength);
            if (packetBuffer.bytesLeft() < 4) {
                packetBuffer.setPosition(limit);
                return;
            }
            int nextStartCode = PsBinarySearchSeeker.peekIntAtPosition(packetBuffer.data, packetBuffer.getPosition());
            if (nextStartCode == 443) {
                packetBuffer.skipBytes(4);
                int systemHeaderLength = packetBuffer.readUnsignedShort();
                if (packetBuffer.bytesLeft() < systemHeaderLength) {
                    packetBuffer.setPosition(limit);
                    return;
                }
                packetBuffer.skipBytes(systemHeaderLength);
            }
            while (packetBuffer.bytesLeft() >= 4 && (nextStartCode = PsBinarySearchSeeker.peekIntAtPosition(packetBuffer.data, packetBuffer.getPosition())) != 442 && nextStartCode != 441 && nextStartCode >>> 8 == 1) {
                packetBuffer.skipBytes(4);
                if (packetBuffer.bytesLeft() < 2) {
                    packetBuffer.setPosition(limit);
                    return;
                }
                int pesPacketLength = packetBuffer.readUnsignedShort();
                packetBuffer.setPosition(Math.min(packetBuffer.limit(), packetBuffer.getPosition() + pesPacketLength));
            }
        }
    }
}

