/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.NalUnitTargetBuffer;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.extractor.ts.UserDataReader;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Arrays;
import java.util.Collections;

public final class H262Reader
implements ElementaryStreamReader {
    private static final int START_PICTURE = 0;
    private static final int START_SEQUENCE_HEADER = 179;
    private static final int START_EXTENSION = 181;
    private static final int START_GROUP = 184;
    private static final int START_USER_DATA = 178;
    private String formatId;
    private TrackOutput output;
    private static final double[] FRAME_RATE_VALUES = new double[]{23.976023976023978, 24.0, 25.0, 29.97002997002997, 30.0, 50.0, 59.94005994005994, 60.0};
    private boolean hasOutputFormat;
    private long frameDurationUs;
    private final UserDataReader userDataReader;
    private final ParsableByteArray userDataParsable;
    private final boolean[] prefixFlags;
    private final CsdBuffer csdBuffer;
    private final NalUnitTargetBuffer userData;
    private long totalBytesWritten;
    private boolean startedFirstSample;
    private long pesTimeUs;
    private long samplePosition;
    private long sampleTimeUs;
    private boolean sampleIsKeyframe;
    private boolean sampleHasPicture;

    public H262Reader() {
        this(null);
    }

    public H262Reader(UserDataReader userDataReader) {
        this.userDataReader = userDataReader;
        this.prefixFlags = new boolean[4];
        this.csdBuffer = new CsdBuffer(128);
        if (userDataReader != null) {
            this.userData = new NalUnitTargetBuffer(178, 128);
            this.userDataParsable = new ParsableByteArray();
        } else {
            this.userData = null;
            this.userDataParsable = null;
        }
    }

    @Override
    public void seek() {
        NalUnitUtil.clearPrefixFlags(this.prefixFlags);
        this.csdBuffer.reset();
        if (this.userDataReader != null) {
            this.userData.reset();
        }
        this.totalBytesWritten = 0L;
        this.startedFirstSample = false;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 2);
        if (this.userDataReader != null) {
            this.userDataReader.createTracks(extractorOutput, idGenerator);
        }
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        this.pesTimeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) {
        int offset = data.getPosition();
        int limit = data.limit();
        byte[] dataArray = data.data;
        this.totalBytesWritten += (long)data.bytesLeft();
        this.output.sampleData(data, data.bytesLeft());
        while (true) {
            int bytesAlreadyPassed;
            int startCodeOffset;
            if ((startCodeOffset = NalUnitUtil.findNalUnit(dataArray, offset, limit, this.prefixFlags)) == limit) {
                if (!this.hasOutputFormat) {
                    this.csdBuffer.onData(dataArray, offset, limit);
                }
                if (this.userDataReader != null) {
                    this.userData.appendToNalUnit(dataArray, offset, limit);
                }
                return;
            }
            int startCodeValue = data.data[startCodeOffset + 3] & 0xFF;
            int lengthToStartCode = startCodeOffset - offset;
            if (!this.hasOutputFormat) {
                if (lengthToStartCode > 0) {
                    this.csdBuffer.onData(dataArray, offset, startCodeOffset);
                }
                int n = bytesAlreadyPassed = lengthToStartCode < 0 ? -lengthToStartCode : 0;
                if (this.csdBuffer.onStartCode(startCodeValue, bytesAlreadyPassed)) {
                    Pair<Format, Long> result = H262Reader.parseCsdBuffer(this.csdBuffer, this.formatId);
                    this.output.format((Format)result.first);
                    this.frameDurationUs = (Long)result.second;
                    this.hasOutputFormat = true;
                }
            }
            if (this.userDataReader != null) {
                bytesAlreadyPassed = 0;
                if (lengthToStartCode > 0) {
                    this.userData.appendToNalUnit(dataArray, offset, startCodeOffset);
                } else {
                    bytesAlreadyPassed = -lengthToStartCode;
                }
                if (this.userData.endNalUnit(bytesAlreadyPassed)) {
                    int unescapedLength = NalUnitUtil.unescapeStream(this.userData.nalData, this.userData.nalLength);
                    this.userDataParsable.reset(this.userData.nalData, unescapedLength);
                    this.userDataReader.consume(this.sampleTimeUs, this.userDataParsable);
                }
                if (startCodeValue == 178 && data.data[startCodeOffset + 2] == 1) {
                    this.userData.startNalUnit(startCodeValue);
                }
            }
            if (startCodeValue == 0 || startCodeValue == 179) {
                int bytesWrittenPastStartCode = limit - startCodeOffset;
                if (this.startedFirstSample && this.sampleHasPicture && this.hasOutputFormat) {
                    int flags = this.sampleIsKeyframe ? 1 : 0;
                    int size = (int)(this.totalBytesWritten - this.samplePosition) - bytesWrittenPastStartCode;
                    this.output.sampleMetadata(this.sampleTimeUs, flags, size, bytesWrittenPastStartCode, null);
                }
                if (!this.startedFirstSample || this.sampleHasPicture) {
                    this.samplePosition = this.totalBytesWritten - (long)bytesWrittenPastStartCode;
                    this.sampleTimeUs = this.pesTimeUs != -9223372036854775807L ? this.pesTimeUs : (this.startedFirstSample ? this.sampleTimeUs + this.frameDurationUs : 0L);
                    this.sampleIsKeyframe = false;
                    this.pesTimeUs = -9223372036854775807L;
                    this.startedFirstSample = true;
                }
                this.sampleHasPicture = startCodeValue == 0;
            } else if (startCodeValue == 184) {
                this.sampleIsKeyframe = true;
            }
            offset = startCodeOffset + 3;
        }
    }

    @Override
    public void packetFinished() {
    }

    private static Pair<Format, Long> parseCsdBuffer(CsdBuffer csdBuffer, String formatId) {
        byte[] csdData = Arrays.copyOf(csdBuffer.data, csdBuffer.length);
        int firstByte = csdData[4] & 0xFF;
        int secondByte = csdData[5] & 0xFF;
        int thirdByte = csdData[6] & 0xFF;
        int width = firstByte << 4 | secondByte >> 4;
        int height = (secondByte & 0xF) << 8 | thirdByte;
        float pixelWidthHeightRatio = 1.0f;
        int aspectRatioCode = (csdData[7] & 0xF0) >> 4;
        switch (aspectRatioCode) {
            case 2: {
                pixelWidthHeightRatio = (float)(4 * height) / (float)(3 * width);
                break;
            }
            case 3: {
                pixelWidthHeightRatio = (float)(16 * height) / (float)(9 * width);
                break;
            }
            case 4: {
                pixelWidthHeightRatio = (float)(121 * height) / (float)(100 * width);
                break;
            }
        }
        Format format = Format.createVideoSampleFormat(formatId, "video/mpeg2", null, -1, -1, width, height, -1.0f, Collections.singletonList(csdData), -1, pixelWidthHeightRatio, null);
        long frameDurationUs = 0L;
        int frameRateCodeMinusOne = (csdData[7] & 0xF) - 1;
        if (0 <= frameRateCodeMinusOne && frameRateCodeMinusOne < FRAME_RATE_VALUES.length) {
            double frameRate = FRAME_RATE_VALUES[frameRateCodeMinusOne];
            int sequenceExtensionPosition = csdBuffer.sequenceExtensionPosition;
            int frameRateExtensionN = (csdData[sequenceExtensionPosition + 9] & 0x60) >> 5;
            int frameRateExtensionD = csdData[sequenceExtensionPosition + 9] & 0x1F;
            if (frameRateExtensionN != frameRateExtensionD) {
                frameRate *= ((double)frameRateExtensionN + 1.0) / (double)(frameRateExtensionD + 1);
            }
            frameDurationUs = (long)(1000000.0 / frameRate);
        }
        return Pair.create((Object)format, (Object)frameDurationUs);
    }

    private static final class CsdBuffer {
        private static final byte[] START_CODE = new byte[]{0, 0, 1};
        private boolean isFilling;
        public int length;
        public int sequenceExtensionPosition;
        public byte[] data;

        public CsdBuffer(int initialCapacity) {
            this.data = new byte[initialCapacity];
        }

        public void reset() {
            this.isFilling = false;
            this.length = 0;
            this.sequenceExtensionPosition = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onStartCode(int startCodeValue, int bytesAlreadyPassed) {
            block4: {
                if (this.isFilling) {
                    this.length -= bytesAlreadyPassed;
                    if (this.sequenceExtensionPosition == 0 && startCodeValue == 181) {
                        this.sequenceExtensionPosition = this.length;
                        break block4;
                    } else {
                        this.isFilling = false;
                        return true;
                    }
                }
                if (startCodeValue == 179) {
                    this.isFilling = true;
                }
            }
            this.onData(START_CODE, 0, START_CODE.length);
            return false;
        }

        public void onData(byte[] newData, int offset, int limit) {
            if (!this.isFilling) {
                return;
            }
            int readLength = limit - offset;
            if (this.data.length < this.length + readLength) {
                this.data = Arrays.copyOf(this.data, (this.length + readLength) * 2);
            }
            System.arraycopy(newData, offset, this.data, this.length, readLength);
            this.length += readLength;
        }
    }
}

