/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Arrays;
import java.util.Collections;

public final class AdtsReader
implements ElementaryStreamReader {
    private static final String TAG = "AdtsReader";
    private static final int STATE_FINDING_SAMPLE = 0;
    private static final int STATE_CHECKING_ADTS_HEADER = 1;
    private static final int STATE_READING_ID3_HEADER = 2;
    private static final int STATE_READING_ADTS_HEADER = 3;
    private static final int STATE_READING_SAMPLE = 4;
    private static final int HEADER_SIZE = 5;
    private static final int CRC_SIZE = 2;
    private static final int MATCH_STATE_VALUE_SHIFT = 8;
    private static final int MATCH_STATE_START = 256;
    private static final int MATCH_STATE_FF = 512;
    private static final int MATCH_STATE_I = 768;
    private static final int MATCH_STATE_ID = 1024;
    private static final int ID3_HEADER_SIZE = 10;
    private static final int ID3_SIZE_OFFSET = 6;
    private static final byte[] ID3_IDENTIFIER = new byte[]{73, 68, 51};
    private static final int VERSION_UNSET = -1;
    private final boolean exposeId3;
    private final ParsableBitArray adtsScratch = new ParsableBitArray(new byte[7]);
    private final ParsableByteArray id3HeaderBuffer = new ParsableByteArray(Arrays.copyOf(ID3_IDENTIFIER, 10));
    private final String language;
    private String formatId;
    private TrackOutput output;
    private TrackOutput id3Output;
    private int state;
    private int bytesRead;
    private int matchState;
    private boolean hasCrc;
    private boolean foundFirstFrame;
    private int firstFrameVersion;
    private int firstFrameSampleRateIndex;
    private int currentFrameVersion;
    private boolean hasOutputFormat;
    private long sampleDurationUs;
    private int sampleSize;
    private long timeUs;
    private TrackOutput currentOutput;
    private long currentSampleDuration;

    public AdtsReader(boolean exposeId3) {
        this(exposeId3, null);
    }

    public AdtsReader(boolean exposeId3, String language) {
        this.setFindingSampleState();
        this.firstFrameVersion = -1;
        this.firstFrameSampleRateIndex = -1;
        this.sampleDurationUs = -9223372036854775807L;
        this.exposeId3 = exposeId3;
        this.language = language;
    }

    public static boolean isAdtsSyncWord(int candidateSyncWord) {
        return (candidateSyncWord & 0xFFF6) == 65520;
    }

    @Override
    public void seek() {
        this.resetSync();
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 1);
        if (this.exposeId3) {
            idGenerator.generateNewId();
            this.id3Output = extractorOutput.track(idGenerator.getTrackId(), 4);
            this.id3Output.format(Format.createSampleFormat(idGenerator.getFormatId(), "application/id3", null, -1, null));
        } else {
            this.id3Output = new DummyTrackOutput();
        }
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        this.timeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) throws ParserException {
        block7: while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    this.findNextSample(data);
                    continue block7;
                }
                case 2: {
                    if (!this.continueRead(data, this.id3HeaderBuffer.data, 10)) continue block7;
                    this.parseId3Header();
                    continue block7;
                }
                case 1: {
                    this.checkAdtsHeader(data);
                    continue block7;
                }
                case 3: {
                    int targetLength = this.hasCrc ? 7 : 5;
                    if (!this.continueRead(data, this.adtsScratch.data, targetLength)) continue block7;
                    this.parseAdtsHeader();
                    continue block7;
                }
                case 4: {
                    this.readSample(data);
                    continue block7;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public void packetFinished() {
    }

    public long getSampleDurationUs() {
        return this.sampleDurationUs;
    }

    private void resetSync() {
        this.foundFirstFrame = false;
        this.setFindingSampleState();
    }

    private boolean continueRead(ParsableByteArray source, byte[] target, int targetLength) {
        int bytesToRead = Math.min(source.bytesLeft(), targetLength - this.bytesRead);
        source.readBytes(target, this.bytesRead, bytesToRead);
        this.bytesRead += bytesToRead;
        return this.bytesRead == targetLength;
    }

    private void setFindingSampleState() {
        this.state = 0;
        this.bytesRead = 0;
        this.matchState = 256;
    }

    private void setReadingId3HeaderState() {
        this.state = 2;
        this.bytesRead = ID3_IDENTIFIER.length;
        this.sampleSize = 0;
        this.id3HeaderBuffer.setPosition(0);
    }

    private void setReadingSampleState(TrackOutput outputToUse, long currentSampleDuration, int priorReadBytes, int sampleSize) {
        this.state = 4;
        this.bytesRead = priorReadBytes;
        this.currentOutput = outputToUse;
        this.currentSampleDuration = currentSampleDuration;
        this.sampleSize = sampleSize;
    }

    private void setReadingAdtsHeaderState() {
        this.state = 3;
        this.bytesRead = 0;
    }

    private void setCheckingAdtsHeaderState() {
        this.state = 1;
        this.bytesRead = 0;
    }

    private void findNextSample(ParsableByteArray pesBuffer) {
        byte[] adtsData = pesBuffer.data;
        int position = pesBuffer.getPosition();
        int endOffset = pesBuffer.limit();
        block6: while (position < endOffset) {
            int data = adtsData[position++] & 0xFF;
            if (this.matchState == 512 && this.isAdtsSyncBytes((byte)-1, (byte)data) && (this.foundFirstFrame || this.checkSyncPositionValid(pesBuffer, position - 2))) {
                this.currentFrameVersion = (data & 8) >> 3;
                boolean bl = this.hasCrc = (data & 1) == 0;
                if (!this.foundFirstFrame) {
                    this.setCheckingAdtsHeaderState();
                } else {
                    this.setReadingAdtsHeaderState();
                }
                pesBuffer.setPosition(position);
                return;
            }
            switch (this.matchState | data) {
                case 511: {
                    this.matchState = 512;
                    continue block6;
                }
                case 329: {
                    this.matchState = 768;
                    continue block6;
                }
                case 836: {
                    this.matchState = 1024;
                    continue block6;
                }
                case 1075: {
                    this.setReadingId3HeaderState();
                    pesBuffer.setPosition(position);
                    return;
                }
            }
            if (this.matchState == 256) continue;
            this.matchState = 256;
            --position;
        }
        pesBuffer.setPosition(position);
    }

    private void checkAdtsHeader(ParsableByteArray buffer) {
        if (buffer.bytesLeft() == 0) {
            return;
        }
        this.adtsScratch.data[0] = buffer.data[buffer.getPosition()];
        this.adtsScratch.setPosition(2);
        int currentFrameSampleRateIndex = this.adtsScratch.readBits(4);
        if (this.firstFrameSampleRateIndex != -1 && currentFrameSampleRateIndex != this.firstFrameSampleRateIndex) {
            this.resetSync();
            return;
        }
        if (!this.foundFirstFrame) {
            this.foundFirstFrame = true;
            this.firstFrameVersion = this.currentFrameVersion;
            this.firstFrameSampleRateIndex = currentFrameSampleRateIndex;
        }
        this.setReadingAdtsHeaderState();
    }

    private boolean checkSyncPositionValid(ParsableByteArray pesBuffer, int syncPositionCandidate) {
        pesBuffer.setPosition(syncPositionCandidate + 1);
        if (!this.tryRead(pesBuffer, this.adtsScratch.data, 1)) {
            return false;
        }
        this.adtsScratch.setPosition(4);
        int currentFrameVersion = this.adtsScratch.readBits(1);
        if (this.firstFrameVersion != -1 && currentFrameVersion != this.firstFrameVersion) {
            return false;
        }
        if (this.firstFrameSampleRateIndex != -1) {
            if (!this.tryRead(pesBuffer, this.adtsScratch.data, 1)) {
                return true;
            }
            this.adtsScratch.setPosition(2);
            int currentFrameSampleRateIndex = this.adtsScratch.readBits(4);
            if (currentFrameSampleRateIndex != this.firstFrameSampleRateIndex) {
                return false;
            }
            pesBuffer.setPosition(syncPositionCandidate + 2);
        }
        if (!this.tryRead(pesBuffer, this.adtsScratch.data, 4)) {
            return true;
        }
        this.adtsScratch.setPosition(14);
        int frameSize = this.adtsScratch.readBits(13);
        if (frameSize <= 6) {
            return false;
        }
        int nextSyncPosition = syncPositionCandidate + frameSize;
        if (nextSyncPosition + 1 >= pesBuffer.limit()) {
            return true;
        }
        return this.isAdtsSyncBytes(pesBuffer.data[nextSyncPosition], pesBuffer.data[nextSyncPosition + 1]) && (this.firstFrameVersion == -1 || (pesBuffer.data[nextSyncPosition + 1] & 8) >> 3 == currentFrameVersion);
    }

    private boolean isAdtsSyncBytes(byte firstByte, byte secondByte) {
        int syncWord = (firstByte & 0xFF) << 8 | secondByte & 0xFF;
        return AdtsReader.isAdtsSyncWord(syncWord);
    }

    private boolean tryRead(ParsableByteArray source, byte[] target, int targetLength) {
        if (source.bytesLeft() < targetLength) {
            return false;
        }
        source.readBytes(target, 0, targetLength);
        return true;
    }

    private void parseId3Header() {
        this.id3Output.sampleData(this.id3HeaderBuffer, 10);
        this.id3HeaderBuffer.setPosition(6);
        this.setReadingSampleState(this.id3Output, 0L, 10, this.id3HeaderBuffer.readSynchSafeInt() + 10);
    }

    private void parseAdtsHeader() throws ParserException {
        this.adtsScratch.setPosition(0);
        if (!this.hasOutputFormat) {
            int audioObjectType = this.adtsScratch.readBits(2) + 1;
            if (audioObjectType != 2) {
                Log.w(TAG, "Detected audio object type: " + audioObjectType + ", but assuming AAC LC.");
                audioObjectType = 2;
            }
            this.adtsScratch.skipBits(5);
            int channelConfig = this.adtsScratch.readBits(3);
            byte[] audioSpecificConfig = CodecSpecificDataUtil.buildAacAudioSpecificConfig(audioObjectType, this.firstFrameSampleRateIndex, channelConfig);
            Pair<Integer, Integer> audioParams = CodecSpecificDataUtil.parseAacAudioSpecificConfig(audioSpecificConfig);
            Format format = Format.createAudioSampleFormat(this.formatId, "audio/mp4a-latm", null, -1, -1, (Integer)audioParams.second, (Integer)audioParams.first, Collections.singletonList(audioSpecificConfig), null, 0, this.language);
            this.sampleDurationUs = 1024000000L / (long)format.sampleRate;
            this.output.format(format);
            this.hasOutputFormat = true;
        } else {
            this.adtsScratch.skipBits(10);
        }
        this.adtsScratch.skipBits(4);
        int sampleSize = this.adtsScratch.readBits(13) - 2 - 5;
        if (this.hasCrc) {
            sampleSize -= 2;
        }
        this.setReadingSampleState(this.output, this.sampleDurationUs, 0, sampleSize);
    }

    private void readSample(ParsableByteArray data) {
        int bytesToRead = Math.min(data.bytesLeft(), this.sampleSize - this.bytesRead);
        this.currentOutput.sampleData(data, bytesToRead);
        this.bytesRead += bytesToRead;
        if (this.bytesRead == this.sampleSize) {
            this.currentOutput.sampleMetadata(this.timeUs, 1, this.sampleSize, 0, null);
            this.timeUs += this.currentSampleDuration;
            this.setFindingSampleState();
        }
    }
}

