/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ConstantBitrateSeekMap;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ts.AdtsReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AdtsExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new AdtsExtractor()};
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING = 1;
    private static final int MAX_PACKET_SIZE = 2048;
    private static final int ID3_TAG = Util.getIntegerCodeForString("ID3");
    private static final int MAX_SNIFF_BYTES = 8192;
    private static final int NUM_FRAMES_FOR_AVERAGE_FRAME_SIZE = 1000;
    private final int flags;
    private final AdtsReader reader;
    private final ParsableByteArray packetBuffer;
    private final ParsableByteArray scratch;
    private final ParsableBitArray scratchBits;
    private final long firstStreamSampleTimestampUs;
    @Nullable
    private ExtractorOutput extractorOutput;
    private long firstSampleTimestampUs;
    private long firstFramePosition;
    private int averageFrameSize;
    private boolean hasCalculatedAverageFrameSize;
    private boolean startedPacket;
    private boolean hasOutputSeekMap;

    public AdtsExtractor() {
        this(0L);
    }

    public AdtsExtractor(long firstStreamSampleTimestampUs) {
        this(firstStreamSampleTimestampUs, 0);
    }

    public AdtsExtractor(long firstStreamSampleTimestampUs, int flags) {
        this.firstStreamSampleTimestampUs = firstStreamSampleTimestampUs;
        this.firstSampleTimestampUs = firstStreamSampleTimestampUs;
        this.flags = flags;
        this.reader = new AdtsReader(true);
        this.packetBuffer = new ParsableByteArray(2048);
        this.averageFrameSize = -1;
        this.firstFramePosition = -1L;
        this.scratch = new ParsableByteArray(10);
        this.scratchBits = new ParsableBitArray(this.scratch.data);
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        int startPosition;
        int headerPosition = startPosition = this.peekId3Header(input);
        int totalValidFramesSize = 0;
        int validFramesCount = 0;
        while (true) {
            input.peekFully(this.scratch.data, 0, 2);
            this.scratch.setPosition(0);
            int syncBytes = this.scratch.readUnsignedShort();
            if (!AdtsReader.isAdtsSyncWord(syncBytes)) {
                validFramesCount = 0;
                totalValidFramesSize = 0;
                input.resetPeekPosition();
                if (++headerPosition - startPosition >= 8192) {
                    return false;
                }
                input.advancePeekPosition(headerPosition);
                continue;
            }
            if (++validFramesCount >= 4 && totalValidFramesSize > 188) {
                return true;
            }
            input.peekFully(this.scratch.data, 0, 4);
            this.scratchBits.setPosition(14);
            int frameSize = this.scratchBits.readBits(13);
            if (frameSize <= 6) {
                return false;
            }
            input.advancePeekPosition(frameSize - 6);
            totalValidFramesSize += frameSize;
        }
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.reader.createTracks(output, new TsPayloadReader.TrackIdGenerator(0, 1));
        output.endTracks();
    }

    @Override
    public void seek(long position, long timeUs) {
        this.startedPacket = false;
        this.reader.seek();
        this.firstSampleTimestampUs = this.firstStreamSampleTimestampUs + timeUs;
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        int bytesRead;
        boolean canUseConstantBitrateSeeking;
        long inputLength = input.getLength();
        boolean bl = canUseConstantBitrateSeeking = (this.flags & 1) != 0 && inputLength != -1L;
        if (canUseConstantBitrateSeeking) {
            this.calculateAverageFrameSize(input);
        }
        boolean readEndOfStream = (bytesRead = input.read(this.packetBuffer.data, 0, 2048)) == -1;
        this.maybeOutputSeekMap(inputLength, canUseConstantBitrateSeeking, readEndOfStream);
        if (readEndOfStream) {
            return -1;
        }
        this.packetBuffer.setPosition(0);
        this.packetBuffer.setLimit(bytesRead);
        if (!this.startedPacket) {
            this.reader.packetStarted(this.firstSampleTimestampUs, 4);
            this.startedPacket = true;
        }
        this.reader.consume(this.packetBuffer);
        return 0;
    }

    private int peekId3Header(ExtractorInput input) throws IOException, InterruptedException {
        int firstFramePosition = 0;
        while (true) {
            input.peekFully(this.scratch.data, 0, 10);
            this.scratch.setPosition(0);
            if (this.scratch.readUnsignedInt24() != ID3_TAG) break;
            this.scratch.skipBytes(3);
            int length = this.scratch.readSynchSafeInt();
            firstFramePosition += 10 + length;
            input.advancePeekPosition(length);
        }
        input.resetPeekPosition();
        input.advancePeekPosition(firstFramePosition);
        if (this.firstFramePosition == -1L) {
            this.firstFramePosition = firstFramePosition;
        }
        return firstFramePosition;
    }

    private void maybeOutputSeekMap(long inputLength, boolean canUseConstantBitrateSeeking, boolean readEndOfStream) {
        boolean useConstantBitrateSeeking;
        if (this.hasOutputSeekMap) {
            return;
        }
        boolean bl = useConstantBitrateSeeking = canUseConstantBitrateSeeking && this.averageFrameSize > 0;
        if (useConstantBitrateSeeking && this.reader.getSampleDurationUs() == -9223372036854775807L && !readEndOfStream) {
            return;
        }
        ExtractorOutput extractorOutput = Assertions.checkNotNull(this.extractorOutput);
        if (useConstantBitrateSeeking && this.reader.getSampleDurationUs() != -9223372036854775807L) {
            extractorOutput.seekMap(this.getConstantBitrateSeekMap(inputLength));
        } else {
            extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
        }
        this.hasOutputSeekMap = true;
    }

    private void calculateAverageFrameSize(ExtractorInput input) throws IOException, InterruptedException {
        if (this.hasCalculatedAverageFrameSize) {
            return;
        }
        this.averageFrameSize = -1;
        input.resetPeekPosition();
        if (input.getPosition() == 0L) {
            this.peekId3Header(input);
        }
        int numValidFrames = 0;
        long totalValidFramesSize = 0L;
        while (input.peekFully(this.scratch.data, 0, 2, true)) {
            this.scratch.setPosition(0);
            int syncBytes = this.scratch.readUnsignedShort();
            if (!AdtsReader.isAdtsSyncWord(syncBytes)) {
                numValidFrames = 0;
                break;
            }
            if (!input.peekFully(this.scratch.data, 0, 4, true)) break;
            this.scratchBits.setPosition(14);
            int currentFrameSize = this.scratchBits.readBits(13);
            if (currentFrameSize <= 6) {
                this.hasCalculatedAverageFrameSize = true;
                throw new ParserException("Malformed ADTS stream");
            }
            totalValidFramesSize += (long)currentFrameSize;
            if (++numValidFrames != 1000 && input.advancePeekPosition(currentFrameSize - 6, true)) continue;
            break;
        }
        input.resetPeekPosition();
        this.averageFrameSize = numValidFrames > 0 ? (int)(totalValidFramesSize / (long)numValidFrames) : -1;
        this.hasCalculatedAverageFrameSize = true;
    }

    private SeekMap getConstantBitrateSeekMap(long inputLength) {
        int bitrate = AdtsExtractor.getBitrateFromFrameSize(this.averageFrameSize, this.reader.getSampleDurationUs());
        return new ConstantBitrateSeekMap(inputLength, this.firstFramePosition, bitrate, this.averageFrameSize);
    }

    private static int getBitrateFromFrameSize(int frameSize, long durationUsPerFrame) {
        return (int)((long)(frameSize * 8) * 1000000L / durationUsPerFrame);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

