/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class OpusReader
extends StreamReader {
    private static final int DEFAULT_SEEK_PRE_ROLL_SAMPLES = 3840;
    private static final int SAMPLE_RATE = 48000;
    private static final int OPUS_CODE = Util.getIntegerCodeForString("Opus");
    private static final byte[] OPUS_SIGNATURE = new byte[]{79, 112, 117, 115, 72, 101, 97, 100};
    private boolean headerRead;

    OpusReader() {
    }

    public static boolean verifyBitstreamType(ParsableByteArray data) {
        if (data.bytesLeft() < OPUS_SIGNATURE.length) {
            return false;
        }
        byte[] header = new byte[OPUS_SIGNATURE.length];
        data.readBytes(header, 0, OPUS_SIGNATURE.length);
        return Arrays.equals(header, OPUS_SIGNATURE);
    }

    @Override
    protected void reset(boolean headerData) {
        super.reset(headerData);
        if (headerData) {
            this.headerRead = false;
        }
    }

    @Override
    protected long preparePayload(ParsableByteArray packet) {
        return this.convertTimeToGranule(this.getPacketDurationUs(packet.data));
    }

    @Override
    protected boolean readHeaders(ParsableByteArray packet, long position, StreamReader.SetupData setupData) {
        if (this.headerRead) {
            boolean headerPacket = packet.readInt() == OPUS_CODE;
            packet.setPosition(0);
            return headerPacket;
        }
        byte[] metadata = Arrays.copyOf(packet.data, packet.limit());
        int channelCount = metadata[9] & 0xFF;
        int preskip = (metadata[11] & 0xFF) << 8 | metadata[10] & 0xFF;
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>(3);
        initializationData.add(metadata);
        this.putNativeOrderLong(initializationData, preskip);
        this.putNativeOrderLong(initializationData, 3840);
        setupData.format = Format.createAudioSampleFormat(null, "audio/opus", null, -1, -1, channelCount, 48000, initializationData, null, 0, null);
        this.headerRead = true;
        return true;
    }

    private void putNativeOrderLong(List<byte[]> initializationData, int samples) {
        long ns = (long)samples * 1000000000L / 48000L;
        byte[] array = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(ns).array();
        initializationData.add(array);
    }

    private long getPacketDurationUs(byte[] packet) {
        int frames;
        int toc = packet[0] & 0xFF;
        switch (toc & 3) {
            case 0: {
                frames = 1;
                break;
            }
            case 1: 
            case 2: {
                frames = 2;
                break;
            }
            default: {
                frames = packet[1] & 0x3F;
            }
        }
        int config = toc >> 3;
        int length = config & 3;
        length = config >= 16 ? 2500 << length : (config >= 12 ? 10000 << (length & 1) : (length == 3 ? 60000 : 10000 << length));
        return (long)frames * (long)length;
    }
}

