/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import com.google.android.exoplayer2.extractor.mp4.Track;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;

final class TrackSampleTable {
    public final Track track;
    public final int sampleCount;
    public final long[] offsets;
    public final int[] sizes;
    public final int maximumSize;
    public final long[] timestampsUs;
    public final int[] flags;
    public final long durationUs;

    public TrackSampleTable(Track track, long[] offsets, int[] sizes, int maximumSize, long[] timestampsUs, int[] flags, long durationUs) {
        Assertions.checkArgument(sizes.length == timestampsUs.length);
        Assertions.checkArgument(offsets.length == timestampsUs.length);
        Assertions.checkArgument(flags.length == timestampsUs.length);
        this.track = track;
        this.offsets = offsets;
        this.sizes = sizes;
        this.maximumSize = maximumSize;
        this.timestampsUs = timestampsUs;
        this.flags = flags;
        this.durationUs = durationUs;
        this.sampleCount = offsets.length;
        if (flags.length > 0) {
            int n = flags.length - 1;
            flags[n] = flags[n] | 0x20000000;
        }
    }

    public int getIndexOfEarlierOrEqualSynchronizationSample(long timeUs) {
        int startIndex;
        for (int i = startIndex = Util.binarySearchFloor(this.timestampsUs, timeUs, true, false); i >= 0; --i) {
            if ((this.flags[i] & 1) == 0) continue;
            return i;
        }
        return -1;
    }

    public int getIndexOfLaterOrEqualSynchronizationSample(long timeUs) {
        int startIndex;
        for (int i = startIndex = Util.binarySearchCeil(this.timestampsUs, timeUs, true, false); i < this.timestampsUs.length; ++i) {
            if ((this.flags[i] & 1) == 0) continue;
            return i;
        }
        return -1;
    }
}

