/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.Ac4Util;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.mp4.Atom;
import com.google.android.exoplayer2.extractor.mp4.AtomParsers;
import com.google.android.exoplayer2.extractor.mp4.MetadataUtil;
import com.google.android.exoplayer2.extractor.mp4.Sniffer;
import com.google.android.exoplayer2.extractor.mp4.Track;
import com.google.android.exoplayer2.extractor.mp4.TrackSampleTable;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.ArrayList;

public final class Mp4Extractor
implements Extractor,
SeekMap {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new Mp4Extractor()};
    public static final int FLAG_WORKAROUND_IGNORE_EDIT_LISTS = 1;
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private static final int BRAND_QUICKTIME = Util.getIntegerCodeForString("qt  ");
    private static final long RELOAD_MINIMUM_SEEK_DISTANCE = 262144L;
    private static final long MAXIMUM_READ_AHEAD_BYTES_STREAM = 0xA00000L;
    private final int flags;
    private final ParsableByteArray nalStartCode;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray scratch;
    private final ParsableByteArray atomHeader;
    private final ArrayDeque<Atom.ContainerAtom> containerAtoms;
    private int parserState;
    private int atomType;
    private long atomSize;
    private int atomHeaderBytesRead;
    private ParsableByteArray atomData;
    private int sampleTrackIndex;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private boolean isAc4HeaderRequired;
    private ExtractorOutput extractorOutput;
    private Mp4Track[] tracks;
    private long[][] accumulatedSampleSizes;
    private int firstVideoTrackIndex;
    private long durationUs;
    private boolean isQuickTime;

    public Mp4Extractor() {
        this(0);
    }

    public Mp4Extractor(int flags) {
        this.flags = flags;
        this.atomHeader = new ParsableByteArray(16);
        this.containerAtoms = new ArrayDeque();
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.scratch = new ParsableByteArray();
        this.sampleTrackIndex = -1;
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        return Sniffer.sniffUnfragmented(input);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
    }

    @Override
    public void seek(long position, long timeUs) {
        this.containerAtoms.clear();
        this.atomHeaderBytesRead = 0;
        this.sampleTrackIndex = -1;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        this.isAc4HeaderRequired = false;
        if (position == 0L) {
            this.enterReadingAtomHeaderState();
        } else if (this.tracks != null) {
            this.updateSampleIndices(timeUs);
        }
    }

    @Override
    public void release() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        block5: while (true) {
            switch (this.parserState) {
                case 0: {
                    if (this.readAtomHeader(input)) continue block5;
                    return -1;
                }
                case 1: {
                    if (this.readAtomPayload(input, seekPosition)) return 1;
                    continue block5;
                }
                case 2: {
                    return this.readSample(input, seekPosition);
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        long firstOffset;
        long firstTimeUs;
        if (this.tracks.length == 0) {
            return new SeekMap.SeekPoints(SeekPoint.START);
        }
        long secondTimeUs = -9223372036854775807L;
        long secondOffset = -1L;
        if (this.firstVideoTrackIndex != -1) {
            int secondSampleIndex;
            long sampleTimeUs;
            TrackSampleTable sampleTable = this.tracks[this.firstVideoTrackIndex].sampleTable;
            int sampleIndex = Mp4Extractor.getSynchronizationSampleIndex(sampleTable, timeUs);
            if (sampleIndex == -1) {
                return new SeekMap.SeekPoints(SeekPoint.START);
            }
            firstTimeUs = sampleTimeUs = sampleTable.timestampsUs[sampleIndex];
            firstOffset = sampleTable.offsets[sampleIndex];
            if (sampleTimeUs < timeUs && sampleIndex < sampleTable.sampleCount - 1 && (secondSampleIndex = sampleTable.getIndexOfLaterOrEqualSynchronizationSample(timeUs)) != -1 && secondSampleIndex != sampleIndex) {
                secondTimeUs = sampleTable.timestampsUs[secondSampleIndex];
                secondOffset = sampleTable.offsets[secondSampleIndex];
            }
        } else {
            firstTimeUs = timeUs;
            firstOffset = Long.MAX_VALUE;
        }
        for (int i = 0; i < this.tracks.length; ++i) {
            if (i == this.firstVideoTrackIndex) continue;
            TrackSampleTable sampleTable = this.tracks[i].sampleTable;
            firstOffset = Mp4Extractor.maybeAdjustSeekOffset(sampleTable, firstTimeUs, firstOffset);
            if (secondTimeUs == -9223372036854775807L) continue;
            secondOffset = Mp4Extractor.maybeAdjustSeekOffset(sampleTable, secondTimeUs, secondOffset);
        }
        SeekPoint firstSeekPoint = new SeekPoint(firstTimeUs, firstOffset);
        if (secondTimeUs == -9223372036854775807L) {
            return new SeekMap.SeekPoints(firstSeekPoint);
        }
        SeekPoint secondSeekPoint = new SeekPoint(secondTimeUs, secondOffset);
        return new SeekMap.SeekPoints(firstSeekPoint, secondSeekPoint);
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 0;
        this.atomHeaderBytesRead = 0;
    }

    private boolean readAtomHeader(ExtractorInput input) throws IOException, InterruptedException {
        if (this.atomHeaderBytesRead == 0) {
            if (!input.readFully(this.atomHeader.data, 0, 8, true)) {
                return false;
            }
            this.atomHeaderBytesRead = 8;
            this.atomHeader.setPosition(0);
            this.atomSize = this.atomHeader.readUnsignedInt();
            this.atomType = this.atomHeader.readInt();
        }
        if (this.atomSize == 1L) {
            int headerBytesRemaining = 8;
            input.readFully(this.atomHeader.data, 8, headerBytesRemaining);
            this.atomHeaderBytesRead += headerBytesRemaining;
            this.atomSize = this.atomHeader.readUnsignedLongToLong();
        } else if (this.atomSize == 0L) {
            long endPosition = input.getLength();
            if (endPosition == -1L && !this.containerAtoms.isEmpty()) {
                endPosition = this.containerAtoms.peek().endPosition;
            }
            if (endPosition != -1L) {
                this.atomSize = endPosition - input.getPosition() + (long)this.atomHeaderBytesRead;
            }
        }
        if (this.atomSize < (long)this.atomHeaderBytesRead) {
            throw new ParserException("Atom size less than header length (unsupported).");
        }
        if (Mp4Extractor.shouldParseContainerAtom(this.atomType)) {
            long endPosition = input.getPosition() + this.atomSize - (long)this.atomHeaderBytesRead;
            this.containerAtoms.push(new Atom.ContainerAtom(this.atomType, endPosition));
            if (this.atomSize == (long)this.atomHeaderBytesRead) {
                this.processAtomEnded(endPosition);
            } else {
                if (this.atomType == Atom.TYPE_meta) {
                    this.maybeSkipRemainingMetaAtomHeaderBytes(input);
                }
                this.enterReadingAtomHeaderState();
            }
        } else if (Mp4Extractor.shouldParseLeafAtom(this.atomType)) {
            Assertions.checkState(this.atomHeaderBytesRead == 8);
            Assertions.checkState(this.atomSize <= Integer.MAX_VALUE);
            this.atomData = new ParsableByteArray((int)this.atomSize);
            System.arraycopy(this.atomHeader.data, 0, this.atomData.data, 0, 8);
            this.parserState = 1;
        } else {
            this.atomData = null;
            this.parserState = 1;
        }
        return true;
    }

    private boolean readAtomPayload(ExtractorInput input, PositionHolder positionHolder) throws IOException, InterruptedException {
        long atomPayloadSize = this.atomSize - (long)this.atomHeaderBytesRead;
        long atomEndPosition = input.getPosition() + atomPayloadSize;
        boolean seekRequired = false;
        if (this.atomData != null) {
            input.readFully(this.atomData.data, this.atomHeaderBytesRead, (int)atomPayloadSize);
            if (this.atomType == Atom.TYPE_ftyp) {
                this.isQuickTime = Mp4Extractor.processFtypAtom(this.atomData);
            } else if (!this.containerAtoms.isEmpty()) {
                this.containerAtoms.peek().add(new Atom.LeafAtom(this.atomType, this.atomData));
            }
        } else if (atomPayloadSize < 262144L) {
            input.skipFully((int)atomPayloadSize);
        } else {
            positionHolder.position = input.getPosition() + atomPayloadSize;
            seekRequired = true;
        }
        this.processAtomEnded(atomEndPosition);
        return seekRequired && this.parserState != 2;
    }

    private void processAtomEnded(long atomEndPosition) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == atomEndPosition) {
            Atom.ContainerAtom containerAtom = this.containerAtoms.pop();
            if (containerAtom.type == Atom.TYPE_moov) {
                this.processMoovAtom(containerAtom);
                this.containerAtoms.clear();
                this.parserState = 2;
                continue;
            }
            if (this.containerAtoms.isEmpty()) continue;
            this.containerAtoms.peek().add(containerAtom);
        }
        if (this.parserState != 2) {
            this.enterReadingAtomHeaderState();
        }
    }

    private void processMoovAtom(Atom.ContainerAtom moov) throws ParserException {
        int firstVideoTrackIndex = -1;
        long durationUs = -9223372036854775807L;
        ArrayList<Mp4Track> tracks = new ArrayList<Mp4Track>();
        Metadata udtaMetadata = null;
        GaplessInfoHolder gaplessInfoHolder = new GaplessInfoHolder();
        Atom.LeafAtom udta = moov.getLeafAtomOfType(Atom.TYPE_udta);
        if (udta != null && (udtaMetadata = AtomParsers.parseUdta(udta, this.isQuickTime)) != null) {
            gaplessInfoHolder.setFromMetadata(udtaMetadata);
        }
        Metadata mdtaMetadata = null;
        Atom.ContainerAtom meta = moov.getContainerAtomOfType(Atom.TYPE_meta);
        if (meta != null) {
            mdtaMetadata = AtomParsers.parseMdtaFromMeta(meta);
        }
        boolean ignoreEditLists = (this.flags & 1) != 0;
        ArrayList<TrackSampleTable> trackSampleTables = this.getTrackSampleTables(moov, gaplessInfoHolder, ignoreEditLists);
        int trackCount = trackSampleTables.size();
        for (int i = 0; i < trackCount; ++i) {
            TrackSampleTable trackSampleTable = trackSampleTables.get(i);
            Track track = trackSampleTable.track;
            long trackDurationUs = track.durationUs != -9223372036854775807L ? track.durationUs : trackSampleTable.durationUs;
            durationUs = Math.max(durationUs, trackDurationUs);
            Mp4Track mp4Track = new Mp4Track(track, trackSampleTable, this.extractorOutput.track(i, track.type));
            int maxInputSize = trackSampleTable.maximumSize + 30;
            Format format = track.format.copyWithMaxInputSize(maxInputSize);
            if (track.type == 2 && trackDurationUs > 0L && trackSampleTable.sampleCount > 1) {
                float frameRate = (float)trackSampleTable.sampleCount / ((float)trackDurationUs / 1000000.0f);
                format = format.copyWithFrameRate(frameRate);
            }
            format = MetadataUtil.getFormatWithMetadata(track.type, format, udtaMetadata, mdtaMetadata, gaplessInfoHolder);
            mp4Track.trackOutput.format(format);
            if (track.type == 2 && firstVideoTrackIndex == -1) {
                firstVideoTrackIndex = tracks.size();
            }
            tracks.add(mp4Track);
        }
        this.firstVideoTrackIndex = firstVideoTrackIndex;
        this.durationUs = durationUs;
        this.tracks = tracks.toArray(new Mp4Track[0]);
        this.accumulatedSampleSizes = Mp4Extractor.calculateAccumulatedSampleSizes(this.tracks);
        this.extractorOutput.endTracks();
        this.extractorOutput.seekMap(this);
    }

    private ArrayList<TrackSampleTable> getTrackSampleTables(Atom.ContainerAtom moov, GaplessInfoHolder gaplessInfoHolder, boolean ignoreEditLists) throws ParserException {
        ArrayList<TrackSampleTable> trackSampleTables = new ArrayList<TrackSampleTable>();
        for (int i = 0; i < moov.containerChildren.size(); ++i) {
            Track track;
            Atom.ContainerAtom atom = moov.containerChildren.get(i);
            if (atom.type != Atom.TYPE_trak || (track = AtomParsers.parseTrak(atom, moov.getLeafAtomOfType(Atom.TYPE_mvhd), -9223372036854775807L, null, ignoreEditLists, this.isQuickTime)) == null) continue;
            Atom.ContainerAtom stblAtom = atom.getContainerAtomOfType(Atom.TYPE_mdia).getContainerAtomOfType(Atom.TYPE_minf).getContainerAtomOfType(Atom.TYPE_stbl);
            TrackSampleTable trackSampleTable = AtomParsers.parseStbl(track, stblAtom, gaplessInfoHolder);
            if (trackSampleTable.sampleCount == 0) continue;
            trackSampleTables.add(trackSampleTable);
        }
        return trackSampleTables;
    }

    private int readSample(ExtractorInput input, PositionHolder positionHolder) throws IOException, InterruptedException {
        long inputPosition = input.getPosition();
        if (this.sampleTrackIndex == -1) {
            this.sampleTrackIndex = this.getTrackIndexOfNextReadSample(inputPosition);
            if (this.sampleTrackIndex == -1) {
                return -1;
            }
            this.isAc4HeaderRequired = "audio/ac4".equals(this.tracks[this.sampleTrackIndex].track.format.sampleMimeType);
        }
        Mp4Track track = this.tracks[this.sampleTrackIndex];
        TrackOutput trackOutput = track.trackOutput;
        int sampleIndex = track.sampleIndex;
        long position = track.sampleTable.offsets[sampleIndex];
        int sampleSize = track.sampleTable.sizes[sampleIndex];
        long skipAmount = position - inputPosition + (long)this.sampleBytesWritten;
        if (skipAmount < 0L || skipAmount >= 262144L) {
            positionHolder.position = position;
            return 1;
        }
        if (track.track.sampleTransformation == 1) {
            skipAmount += 8L;
            sampleSize -= 8;
        }
        input.skipFully((int)skipAmount);
        if (track.track.nalUnitLengthFieldLength != 0) {
            byte[] nalLengthData = this.nalLength.data;
            nalLengthData[0] = 0;
            nalLengthData[1] = 0;
            nalLengthData[2] = 0;
            int nalUnitLengthFieldLength = track.track.nalUnitLengthFieldLength;
            int nalUnitLengthFieldLengthDiff = 4 - track.track.nalUnitLengthFieldLength;
            while (this.sampleBytesWritten < sampleSize) {
                if (this.sampleCurrentNalBytesRemaining == 0) {
                    input.readFully(nalLengthData, nalUnitLengthFieldLengthDiff, nalUnitLengthFieldLength);
                    this.nalLength.setPosition(0);
                    int nalLengthInt = this.nalLength.readInt();
                    if (nalLengthInt < 0) {
                        throw new ParserException("Invalid NAL length");
                    }
                    this.sampleCurrentNalBytesRemaining = nalLengthInt;
                    this.nalStartCode.setPosition(0);
                    trackOutput.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    sampleSize += nalUnitLengthFieldLengthDiff;
                    continue;
                }
                int writtenBytes = trackOutput.sampleData(input, this.sampleCurrentNalBytesRemaining, false);
                this.sampleBytesWritten += writtenBytes;
                this.sampleCurrentNalBytesRemaining -= writtenBytes;
            }
        } else {
            if (this.isAc4HeaderRequired) {
                Ac4Util.getAc4SampleHeader(sampleSize, this.scratch);
                int length = this.scratch.limit();
                trackOutput.sampleData(this.scratch, length);
                sampleSize += length;
                this.sampleBytesWritten += length;
                this.isAc4HeaderRequired = false;
            }
            while (this.sampleBytesWritten < sampleSize) {
                int writtenBytes = trackOutput.sampleData(input, sampleSize - this.sampleBytesWritten, false);
                this.sampleBytesWritten += writtenBytes;
                this.sampleCurrentNalBytesRemaining -= writtenBytes;
            }
        }
        trackOutput.sampleMetadata(track.sampleTable.timestampsUs[sampleIndex], track.sampleTable.flags[sampleIndex], sampleSize, 0, null);
        ++track.sampleIndex;
        this.sampleTrackIndex = -1;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        return 0;
    }

    private int getTrackIndexOfNextReadSample(long inputPosition) {
        long preferredSkipAmount = Long.MAX_VALUE;
        boolean preferredRequiresReload = true;
        int preferredTrackIndex = -1;
        long preferredAccumulatedBytes = Long.MAX_VALUE;
        long minAccumulatedBytes = Long.MAX_VALUE;
        boolean minAccumulatedBytesRequiresReload = true;
        int minAccumulatedBytesTrackIndex = -1;
        for (int trackIndex = 0; trackIndex < this.tracks.length; ++trackIndex) {
            boolean requiresReload;
            Mp4Track track = this.tracks[trackIndex];
            int sampleIndex = track.sampleIndex;
            if (sampleIndex == track.sampleTable.sampleCount) continue;
            long sampleOffset = track.sampleTable.offsets[sampleIndex];
            long sampleAccumulatedBytes = this.accumulatedSampleSizes[trackIndex][sampleIndex];
            long skipAmount = sampleOffset - inputPosition;
            boolean bl = requiresReload = skipAmount < 0L || skipAmount >= 262144L;
            if (!requiresReload && preferredRequiresReload || requiresReload == preferredRequiresReload && skipAmount < preferredSkipAmount) {
                preferredRequiresReload = requiresReload;
                preferredSkipAmount = skipAmount;
                preferredTrackIndex = trackIndex;
                preferredAccumulatedBytes = sampleAccumulatedBytes;
            }
            if (sampleAccumulatedBytes >= minAccumulatedBytes) continue;
            minAccumulatedBytes = sampleAccumulatedBytes;
            minAccumulatedBytesRequiresReload = requiresReload;
            minAccumulatedBytesTrackIndex = trackIndex;
        }
        return minAccumulatedBytes == Long.MAX_VALUE || !minAccumulatedBytesRequiresReload || preferredAccumulatedBytes < minAccumulatedBytes + 0xA00000L ? preferredTrackIndex : minAccumulatedBytesTrackIndex;
    }

    private void updateSampleIndices(long timeUs) {
        for (Mp4Track track : this.tracks) {
            TrackSampleTable sampleTable = track.sampleTable;
            int sampleIndex = sampleTable.getIndexOfEarlierOrEqualSynchronizationSample(timeUs);
            if (sampleIndex == -1) {
                sampleIndex = sampleTable.getIndexOfLaterOrEqualSynchronizationSample(timeUs);
            }
            track.sampleIndex = sampleIndex;
        }
    }

    private void maybeSkipRemainingMetaAtomHeaderBytes(ExtractorInput input) throws IOException, InterruptedException {
        this.scratch.reset(8);
        input.peekFully(this.scratch.data, 0, 8);
        this.scratch.skipBytes(4);
        if (this.scratch.readInt() == Atom.TYPE_hdlr) {
            input.resetPeekPosition();
        } else {
            input.skipFully(4);
        }
    }

    private static long[][] calculateAccumulatedSampleSizes(Mp4Track[] tracks) {
        long[][] accumulatedSampleSizes = new long[tracks.length][];
        int[] nextSampleIndex = new int[tracks.length];
        long[] nextSampleTimesUs = new long[tracks.length];
        boolean[] tracksFinished = new boolean[tracks.length];
        for (int i = 0; i < tracks.length; ++i) {
            accumulatedSampleSizes[i] = new long[tracks[i].sampleTable.sampleCount];
            nextSampleTimesUs[i] = tracks[i].sampleTable.timestampsUs[0];
        }
        long accumulatedSampleSize = 0L;
        int finishedTracks = 0;
        while (finishedTracks < tracks.length) {
            long minTimeUs = Long.MAX_VALUE;
            int minTimeTrackIndex = -1;
            for (int i = 0; i < tracks.length; ++i) {
                if (tracksFinished[i] || nextSampleTimesUs[i] > minTimeUs) continue;
                minTimeTrackIndex = i;
                minTimeUs = nextSampleTimesUs[i];
            }
            int trackSampleIndex = nextSampleIndex[minTimeTrackIndex];
            accumulatedSampleSizes[minTimeTrackIndex][trackSampleIndex] = accumulatedSampleSize;
            accumulatedSampleSize += (long)tracks[minTimeTrackIndex].sampleTable.sizes[trackSampleIndex];
            nextSampleIndex[minTimeTrackIndex] = ++trackSampleIndex;
            if (trackSampleIndex < accumulatedSampleSizes[minTimeTrackIndex].length) {
                nextSampleTimesUs[minTimeTrackIndex] = tracks[minTimeTrackIndex].sampleTable.timestampsUs[trackSampleIndex];
                continue;
            }
            tracksFinished[minTimeTrackIndex] = true;
            ++finishedTracks;
        }
        return accumulatedSampleSizes;
    }

    private static long maybeAdjustSeekOffset(TrackSampleTable sampleTable, long seekTimeUs, long offset) {
        int sampleIndex = Mp4Extractor.getSynchronizationSampleIndex(sampleTable, seekTimeUs);
        if (sampleIndex == -1) {
            return offset;
        }
        long sampleOffset = sampleTable.offsets[sampleIndex];
        return Math.min(sampleOffset, offset);
    }

    private static int getSynchronizationSampleIndex(TrackSampleTable sampleTable, long timeUs) {
        int sampleIndex = sampleTable.getIndexOfEarlierOrEqualSynchronizationSample(timeUs);
        if (sampleIndex == -1) {
            sampleIndex = sampleTable.getIndexOfLaterOrEqualSynchronizationSample(timeUs);
        }
        return sampleIndex;
    }

    private static boolean processFtypAtom(ParsableByteArray atomData) {
        atomData.setPosition(8);
        int majorBrand = atomData.readInt();
        if (majorBrand == BRAND_QUICKTIME) {
            return true;
        }
        atomData.skipBytes(4);
        while (atomData.bytesLeft() > 0) {
            if (atomData.readInt() != BRAND_QUICKTIME) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldParseLeafAtom(int atom) {
        return atom == Atom.TYPE_mdhd || atom == Atom.TYPE_mvhd || atom == Atom.TYPE_hdlr || atom == Atom.TYPE_stsd || atom == Atom.TYPE_stts || atom == Atom.TYPE_stss || atom == Atom.TYPE_ctts || atom == Atom.TYPE_elst || atom == Atom.TYPE_stsc || atom == Atom.TYPE_stsz || atom == Atom.TYPE_stz2 || atom == Atom.TYPE_stco || atom == Atom.TYPE_co64 || atom == Atom.TYPE_tkhd || atom == Atom.TYPE_ftyp || atom == Atom.TYPE_udta || atom == Atom.TYPE_keys || atom == Atom.TYPE_ilst;
    }

    private static boolean shouldParseContainerAtom(int atom) {
        return atom == Atom.TYPE_moov || atom == Atom.TYPE_trak || atom == Atom.TYPE_mdia || atom == Atom.TYPE_minf || atom == Atom.TYPE_stbl || atom == Atom.TYPE_edts || atom == Atom.TYPE_meta;
    }

    private static final class Mp4Track {
        public final Track track;
        public final TrackSampleTable sampleTable;
        public final TrackOutput trackOutput;
        public int sampleIndex;

        public Mp4Track(Track track, TrackSampleTable sampleTable, TrackOutput trackOutput) {
            this.track = track;
            this.sampleTable = sampleTable;
            this.trackOutput = trackOutput;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

