/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.mp4.Atom;
import com.google.android.exoplayer2.extractor.mp4.MdtaMetadataEntry;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.ApicFrame;
import com.google.android.exoplayer2.metadata.id3.CommentFrame;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.metadata.id3.InternalFrame;
import com.google.android.exoplayer2.metadata.id3.TextInformationFrame;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;

final class MetadataUtil {
    private static final String TAG = "MetadataUtil";
    private static final int SHORT_TYPE_NAME_1 = Util.getIntegerCodeForString("nam");
    private static final int SHORT_TYPE_NAME_2 = Util.getIntegerCodeForString("trk");
    private static final int SHORT_TYPE_COMMENT = Util.getIntegerCodeForString("cmt");
    private static final int SHORT_TYPE_YEAR = Util.getIntegerCodeForString("day");
    private static final int SHORT_TYPE_ARTIST = Util.getIntegerCodeForString("ART");
    private static final int SHORT_TYPE_ENCODER = Util.getIntegerCodeForString("too");
    private static final int SHORT_TYPE_ALBUM = Util.getIntegerCodeForString("alb");
    private static final int SHORT_TYPE_COMPOSER_1 = Util.getIntegerCodeForString("com");
    private static final int SHORT_TYPE_COMPOSER_2 = Util.getIntegerCodeForString("wrt");
    private static final int SHORT_TYPE_LYRICS = Util.getIntegerCodeForString("lyr");
    private static final int SHORT_TYPE_GENRE = Util.getIntegerCodeForString("gen");
    private static final int TYPE_COVER_ART = Util.getIntegerCodeForString("covr");
    private static final int TYPE_GENRE = Util.getIntegerCodeForString("gnre");
    private static final int TYPE_GROUPING = Util.getIntegerCodeForString("grp");
    private static final int TYPE_DISK_NUMBER = Util.getIntegerCodeForString("disk");
    private static final int TYPE_TRACK_NUMBER = Util.getIntegerCodeForString("trkn");
    private static final int TYPE_TEMPO = Util.getIntegerCodeForString("tmpo");
    private static final int TYPE_COMPILATION = Util.getIntegerCodeForString("cpil");
    private static final int TYPE_ALBUM_ARTIST = Util.getIntegerCodeForString("aART");
    private static final int TYPE_SORT_TRACK_NAME = Util.getIntegerCodeForString("sonm");
    private static final int TYPE_SORT_ALBUM = Util.getIntegerCodeForString("soal");
    private static final int TYPE_SORT_ARTIST = Util.getIntegerCodeForString("soar");
    private static final int TYPE_SORT_ALBUM_ARTIST = Util.getIntegerCodeForString("soaa");
    private static final int TYPE_SORT_COMPOSER = Util.getIntegerCodeForString("soco");
    private static final int TYPE_RATING = Util.getIntegerCodeForString("rtng");
    private static final int TYPE_GAPLESS_ALBUM = Util.getIntegerCodeForString("pgap");
    private static final int TYPE_TV_SORT_SHOW = Util.getIntegerCodeForString("sosn");
    private static final int TYPE_TV_SHOW = Util.getIntegerCodeForString("tvsh");
    private static final int TYPE_INTERNAL = Util.getIntegerCodeForString("----");
    private static final int PICTURE_TYPE_FRONT_COVER = 3;
    private static final String[] STANDARD_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "Jpop", "Synthpop"};
    private static final String LANGUAGE_UNDEFINED = "und";
    private static final int TYPE_TOP_BYTE_COPYRIGHT = 169;
    private static final int TYPE_TOP_BYTE_REPLACEMENT = 253;
    private static final String MDTA_KEY_ANDROID_CAPTURE_FPS = "com.android.capture.fps";
    private static final int MDTA_TYPE_INDICATOR_FLOAT = 23;

    private MetadataUtil() {
    }

    public static Format getFormatWithMetadata(int trackType, Format format, @Nullable Metadata udtaMetadata, @Nullable Metadata mdtaMetadata, GaplessInfoHolder gaplessInfoHolder) {
        if (trackType == 1) {
            if (gaplessInfoHolder.hasGaplessInfo()) {
                format = format.copyWithGaplessInfo(gaplessInfoHolder.encoderDelay, gaplessInfoHolder.encoderPadding);
            }
            if (udtaMetadata != null) {
                format = format.copyWithMetadata(udtaMetadata);
            }
        } else if (trackType == 2 && mdtaMetadata != null) {
            for (int i = 0; i < mdtaMetadata.length(); ++i) {
                Metadata.Entry entry = mdtaMetadata.get(i);
                if (!(entry instanceof MdtaMetadataEntry)) continue;
                MdtaMetadataEntry mdtaMetadataEntry = (MdtaMetadataEntry)entry;
                if (!MDTA_KEY_ANDROID_CAPTURE_FPS.equals(mdtaMetadataEntry.key) || mdtaMetadataEntry.typeIndicator != 23) continue;
                try {
                    float fps = ByteBuffer.wrap(mdtaMetadataEntry.value).asFloatBuffer().get();
                    format = format.copyWithFrameRate(fps);
                    format = format.copyWithMetadata(new Metadata(mdtaMetadataEntry));
                    continue;
                }
                catch (NumberFormatException e) {
                    Log.w(TAG, "Ignoring invalid framerate");
                }
            }
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Metadata.Entry parseIlstElement(ParsableByteArray ilst) {
        int position = ilst.getPosition();
        int endPosition = position + ilst.readInt();
        int type = ilst.readInt();
        int typeTopByte = type >> 24 & 0xFF;
        try {
            if (typeTopByte == 169 || typeTopByte == 253) {
                int shortType = type & 0xFFFFFF;
                if (shortType == SHORT_TYPE_COMMENT) {
                    CommentFrame commentFrame = MetadataUtil.parseCommentAttribute(type, ilst);
                    return commentFrame;
                }
                if (shortType == SHORT_TYPE_NAME_1 || shortType == SHORT_TYPE_NAME_2) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TIT2", ilst);
                    return textInformationFrame;
                }
                if (shortType == SHORT_TYPE_COMPOSER_1 || shortType == SHORT_TYPE_COMPOSER_2) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TCOM", ilst);
                    return textInformationFrame;
                }
                if (shortType == SHORT_TYPE_YEAR) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TDRC", ilst);
                    return textInformationFrame;
                }
                if (shortType == SHORT_TYPE_ARTIST) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TPE1", ilst);
                    return textInformationFrame;
                }
                if (shortType == SHORT_TYPE_ENCODER) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSSE", ilst);
                    return textInformationFrame;
                }
                if (shortType == SHORT_TYPE_ALBUM) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TALB", ilst);
                    return textInformationFrame;
                }
                if (shortType == SHORT_TYPE_LYRICS) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "USLT", ilst);
                    return textInformationFrame;
                }
                if (shortType == SHORT_TYPE_GENRE) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TCON", ilst);
                    return textInformationFrame;
                }
                if (shortType == TYPE_GROUPING) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TIT1", ilst);
                    return textInformationFrame;
                }
            } else {
                if (type == TYPE_GENRE) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseStandardGenreAttribute(ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_DISK_NUMBER) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseIndexAndCountAttribute(type, "TPOS", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_TRACK_NUMBER) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseIndexAndCountAttribute(type, "TRCK", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_TEMPO) {
                    Id3Frame id3Frame = MetadataUtil.parseUint8Attribute(type, "TBPM", ilst, true, false);
                    return id3Frame;
                }
                if (type == TYPE_COMPILATION) {
                    Id3Frame id3Frame = MetadataUtil.parseUint8Attribute(type, "TCMP", ilst, true, true);
                    return id3Frame;
                }
                if (type == TYPE_COVER_ART) {
                    ApicFrame apicFrame = MetadataUtil.parseCoverArt(ilst);
                    return apicFrame;
                }
                if (type == TYPE_ALBUM_ARTIST) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TPE2", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_SORT_TRACK_NAME) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOT", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_SORT_ALBUM) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSO2", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_SORT_ARTIST) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOA", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_SORT_ALBUM_ARTIST) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOP", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_SORT_COMPOSER) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOC", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_RATING) {
                    Id3Frame id3Frame = MetadataUtil.parseUint8Attribute(type, "ITUNESADVISORY", ilst, false, false);
                    return id3Frame;
                }
                if (type == TYPE_GAPLESS_ALBUM) {
                    Id3Frame id3Frame = MetadataUtil.parseUint8Attribute(type, "ITUNESGAPLESS", ilst, false, true);
                    return id3Frame;
                }
                if (type == TYPE_TV_SORT_SHOW) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TVSHOWSORT", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_TV_SHOW) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TVSHOW", ilst);
                    return textInformationFrame;
                }
                if (type == TYPE_INTERNAL) {
                    Id3Frame id3Frame = MetadataUtil.parseInternalAttribute(ilst, endPosition);
                    return id3Frame;
                }
            }
            Log.d(TAG, "Skipped unknown metadata entry: " + Atom.getAtomTypeString(type));
            Metadata.Entry entry = null;
            return entry;
        }
        finally {
            ilst.setPosition(endPosition);
        }
    }

    @Nullable
    public static MdtaMetadataEntry parseMdtaMetadataEntryFromIlst(ParsableByteArray ilst, int endPosition, String key) {
        int atomPosition;
        while ((atomPosition = ilst.getPosition()) < endPosition) {
            int atomSize = ilst.readInt();
            int atomType = ilst.readInt();
            if (atomType == Atom.TYPE_data) {
                int typeIndicator = ilst.readInt();
                int localeIndicator = ilst.readInt();
                int dataSize = atomSize - 16;
                byte[] value = new byte[dataSize];
                ilst.readBytes(value, 0, dataSize);
                return new MdtaMetadataEntry(key, value, localeIndicator, typeIndicator);
            }
            ilst.setPosition(atomPosition + atomSize);
        }
        return null;
    }

    @Nullable
    private static TextInformationFrame parseTextAttribute(int type, String id, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == Atom.TYPE_data) {
            data.skipBytes(8);
            String value = data.readNullTerminatedString(atomSize - 16);
            return new TextInformationFrame(id, null, value);
        }
        Log.w(TAG, "Failed to parse text attribute: " + Atom.getAtomTypeString(type));
        return null;
    }

    @Nullable
    private static CommentFrame parseCommentAttribute(int type, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == Atom.TYPE_data) {
            data.skipBytes(8);
            String value = data.readNullTerminatedString(atomSize - 16);
            return new CommentFrame(LANGUAGE_UNDEFINED, value, value);
        }
        Log.w(TAG, "Failed to parse comment attribute: " + Atom.getAtomTypeString(type));
        return null;
    }

    @Nullable
    private static Id3Frame parseUint8Attribute(int type, String id, ParsableByteArray data, boolean isTextInformationFrame, boolean isBoolean) {
        int value = MetadataUtil.parseUint8AttributeValue(data);
        if (isBoolean) {
            value = Math.min(1, value);
        }
        if (value >= 0) {
            return isTextInformationFrame ? new TextInformationFrame(id, null, Integer.toString(value)) : new CommentFrame(LANGUAGE_UNDEFINED, id, Integer.toString(value));
        }
        Log.w(TAG, "Failed to parse uint8 attribute: " + Atom.getAtomTypeString(type));
        return null;
    }

    @Nullable
    private static TextInformationFrame parseIndexAndCountAttribute(int type, String attributeName, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == Atom.TYPE_data && atomSize >= 22) {
            data.skipBytes(10);
            int index = data.readUnsignedShort();
            if (index > 0) {
                String value = "" + index;
                int count = data.readUnsignedShort();
                if (count > 0) {
                    value = value + "/" + count;
                }
                return new TextInformationFrame(attributeName, null, value);
            }
        }
        Log.w(TAG, "Failed to parse index/count attribute: " + Atom.getAtomTypeString(type));
        return null;
    }

    @Nullable
    private static TextInformationFrame parseStandardGenreAttribute(ParsableByteArray data) {
        String genreString;
        int genreCode = MetadataUtil.parseUint8AttributeValue(data);
        String string = genreString = 0 < genreCode && genreCode <= STANDARD_GENRES.length ? STANDARD_GENRES[genreCode - 1] : null;
        if (genreString != null) {
            return new TextInformationFrame("TCON", null, genreString);
        }
        Log.w(TAG, "Failed to parse standard genre code");
        return null;
    }

    @Nullable
    private static ApicFrame parseCoverArt(ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == Atom.TYPE_data) {
            String mimeType;
            int fullVersionInt = data.readInt();
            int flags = Atom.parseFullAtomFlags(fullVersionInt);
            String string = flags == 13 ? "image/jpeg" : (mimeType = flags == 14 ? "image/png" : null);
            if (mimeType == null) {
                Log.w(TAG, "Unrecognized cover art flags: " + flags);
                return null;
            }
            data.skipBytes(4);
            byte[] pictureData = new byte[atomSize - 16];
            data.readBytes(pictureData, 0, pictureData.length);
            return new ApicFrame(mimeType, null, 3, pictureData);
        }
        Log.w(TAG, "Failed to parse cover art attribute");
        return null;
    }

    @Nullable
    private static Id3Frame parseInternalAttribute(ParsableByteArray data, int endPosition) {
        String domain = null;
        String name = null;
        int dataAtomPosition = -1;
        int dataAtomSize = -1;
        while (data.getPosition() < endPosition) {
            int atomPosition = data.getPosition();
            int atomSize = data.readInt();
            int atomType = data.readInt();
            data.skipBytes(4);
            if (atomType == Atom.TYPE_mean) {
                domain = data.readNullTerminatedString(atomSize - 12);
                continue;
            }
            if (atomType == Atom.TYPE_name) {
                name = data.readNullTerminatedString(atomSize - 12);
                continue;
            }
            if (atomType == Atom.TYPE_data) {
                dataAtomPosition = atomPosition;
                dataAtomSize = atomSize;
            }
            data.skipBytes(atomSize - 12);
        }
        if (domain == null || name == null || dataAtomPosition == -1) {
            return null;
        }
        data.setPosition(dataAtomPosition);
        data.skipBytes(16);
        String value = data.readNullTerminatedString(dataAtomSize - 16);
        return new InternalFrame(domain, name, value);
    }

    private static int parseUint8AttributeValue(ParsableByteArray data) {
        data.skipBytes(4);
        int atomType = data.readInt();
        if (atomType == Atom.TYPE_data) {
            data.skipBytes(8);
            return data.readUnsignedByte();
        }
        Log.w(TAG, "Failed to parse uint8 attribute value");
        return -1;
    }
}

