/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp3;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.extractor.MpegAudioHeader;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;

final class XingSeeker
implements Mp3Extractor.Seeker {
    private static final String TAG = "XingSeeker";
    private final long dataStartPosition;
    private final int xingFrameSize;
    private final long durationUs;
    private final long dataSize;
    private final long dataEndPosition;
    @Nullable
    private final long[] tableOfContents;

    @Nullable
    public static XingSeeker create(long inputLength, long position, MpegAudioHeader mpegAudioHeader, ParsableByteArray frame) {
        int frameCount;
        int samplesPerFrame = mpegAudioHeader.samplesPerFrame;
        int sampleRate = mpegAudioHeader.sampleRate;
        int flags = frame.readInt();
        if ((flags & 1) != 1 || (frameCount = frame.readUnsignedIntToInt()) == 0) {
            return null;
        }
        long durationUs = Util.scaleLargeTimestamp(frameCount, (long)samplesPerFrame * 1000000L, sampleRate);
        if ((flags & 6) != 6) {
            return new XingSeeker(position, mpegAudioHeader.frameSize, durationUs);
        }
        long dataSize = frame.readUnsignedIntToInt();
        long[] tableOfContents = new long[100];
        for (int i = 0; i < 100; ++i) {
            tableOfContents[i] = frame.readUnsignedByte();
        }
        if (inputLength != -1L && inputLength != position + dataSize) {
            Log.w(TAG, "XING data size mismatch: " + inputLength + ", " + (position + dataSize));
        }
        return new XingSeeker(position, mpegAudioHeader.frameSize, durationUs, dataSize, tableOfContents);
    }

    private XingSeeker(long dataStartPosition, int xingFrameSize, long durationUs) {
        this(dataStartPosition, xingFrameSize, durationUs, -1L, null);
    }

    private XingSeeker(long dataStartPosition, int xingFrameSize, long durationUs, long dataSize, @Nullable long[] tableOfContents) {
        this.dataStartPosition = dataStartPosition;
        this.xingFrameSize = xingFrameSize;
        this.durationUs = durationUs;
        this.tableOfContents = tableOfContents;
        this.dataSize = dataSize;
        this.dataEndPosition = dataSize == -1L ? -1L : dataStartPosition + dataSize;
    }

    @Override
    public boolean isSeekable() {
        return this.tableOfContents != null;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        double scaledPosition;
        if (!this.isSeekable()) {
            return new SeekMap.SeekPoints(new SeekPoint(0L, this.dataStartPosition + (long)this.xingFrameSize));
        }
        double percent = (double)(timeUs = Util.constrainValue(timeUs, 0L, this.durationUs)) * 100.0 / (double)this.durationUs;
        if (percent <= 0.0) {
            scaledPosition = 0.0;
        } else if (percent >= 100.0) {
            scaledPosition = 256.0;
        } else {
            int prevTableIndex = (int)percent;
            long[] tableOfContents = Assertions.checkNotNull(this.tableOfContents);
            double prevScaledPosition = tableOfContents[prevTableIndex];
            double nextScaledPosition = prevTableIndex == 99 ? 256.0 : (double)tableOfContents[prevTableIndex + 1];
            double interpolateFraction = percent - (double)prevTableIndex;
            scaledPosition = prevScaledPosition + interpolateFraction * (nextScaledPosition - prevScaledPosition);
        }
        long positionOffset = Math.round(scaledPosition / 256.0 * (double)this.dataSize);
        positionOffset = Util.constrainValue(positionOffset, (long)this.xingFrameSize, this.dataSize - 1L);
        return new SeekMap.SeekPoints(new SeekPoint(timeUs, this.dataStartPosition + positionOffset));
    }

    @Override
    public long getTimeUs(long position) {
        long positionOffset = position - this.dataStartPosition;
        if (!this.isSeekable() || positionOffset <= (long)this.xingFrameSize) {
            return 0L;
        }
        long[] tableOfContents = Assertions.checkNotNull(this.tableOfContents);
        double scaledPosition = (double)positionOffset * 256.0 / (double)this.dataSize;
        int prevTableIndex = Util.binarySearchFloor(tableOfContents, (long)scaledPosition, true, true);
        long prevTimeUs = this.getTimeUsForTableIndex(prevTableIndex);
        long prevScaledPosition = tableOfContents[prevTableIndex];
        long nextTimeUs = this.getTimeUsForTableIndex(prevTableIndex + 1);
        long nextScaledPosition = prevTableIndex == 99 ? 256L : tableOfContents[prevTableIndex + 1];
        double interpolateFraction = prevScaledPosition == nextScaledPosition ? 0.0 : (scaledPosition - (double)prevScaledPosition) / (double)(nextScaledPosition - prevScaledPosition);
        return prevTimeUs + Math.round(interpolateFraction * (double)(nextTimeUs - prevTimeUs));
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public long getDataEndPosition() {
        return this.dataEndPosition;
    }

    private long getTimeUsForTableIndex(int tableIndex) {
        return this.durationUs * (long)tableIndex / 100L;
    }
}

