/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import java.util.Arrays;

public interface TrackOutput {
    public void format(Format var1);

    public int sampleData(ExtractorInput var1, int var2, boolean var3) throws IOException, InterruptedException;

    public void sampleData(ParsableByteArray var1, int var2);

    public void sampleMetadata(long var1, int var3, int var4, int var5, @Nullable CryptoData var6);

    public static final class CryptoData {
        public final int cryptoMode;
        public final byte[] encryptionKey;
        public final int encryptedBlocks;
        public final int clearBlocks;

        public CryptoData(int cryptoMode, byte[] encryptionKey, int encryptedBlocks, int clearBlocks) {
            this.cryptoMode = cryptoMode;
            this.encryptionKey = encryptionKey;
            this.encryptedBlocks = encryptedBlocks;
            this.clearBlocks = clearBlocks;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CryptoData other = (CryptoData)obj;
            return this.cryptoMode == other.cryptoMode && this.encryptedBlocks == other.encryptedBlocks && this.clearBlocks == other.clearBlocks && Arrays.equals(this.encryptionKey, other.encryptionKey);
        }

        public int hashCode() {
            int result = this.cryptoMode;
            result = 31 * result + Arrays.hashCode(this.encryptionKey);
            result = 31 * result + this.encryptedBlocks;
            result = 31 * result + this.clearBlocks;
            return result;
        }
    }
}

