/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.annotation.TargetApi;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.upstream.DataSourceInputStream;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@TargetApi(value=18)
public final class HttpMediaDrmCallback
implements MediaDrmCallback {
    private static final int MAX_MANUAL_REDIRECTS = 5;
    private final HttpDataSource.Factory dataSourceFactory;
    private final String defaultLicenseUrl;
    private final boolean forceDefaultLicenseUrl;
    private final Map<String, String> keyRequestProperties;

    public HttpMediaDrmCallback(String defaultLicenseUrl, HttpDataSource.Factory dataSourceFactory) {
        this(defaultLicenseUrl, false, dataSourceFactory);
    }

    public HttpMediaDrmCallback(String defaultLicenseUrl, boolean forceDefaultLicenseUrl, HttpDataSource.Factory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.defaultLicenseUrl = defaultLicenseUrl;
        this.forceDefaultLicenseUrl = forceDefaultLicenseUrl;
        this.keyRequestProperties = new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyRequestProperty(String name, String value) {
        Assertions.checkNotNull(name);
        Assertions.checkNotNull(value);
        Map<String, String> map = this.keyRequestProperties;
        synchronized (map) {
            this.keyRequestProperties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeyRequestProperty(String name) {
        Assertions.checkNotNull(name);
        Map<String, String> map = this.keyRequestProperties;
        synchronized (map) {
            this.keyRequestProperties.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllKeyRequestProperties() {
        Map<String, String> map = this.keyRequestProperties;
        synchronized (map) {
            this.keyRequestProperties.clear();
        }
    }

    @Override
    public byte[] executeProvisionRequest(UUID uuid, ExoMediaDrm.ProvisionRequest request) throws IOException {
        String url = request.getDefaultUrl() + "&signedRequest=" + Util.fromUtf8Bytes(request.getData());
        return HttpMediaDrmCallback.executePost(this.dataSourceFactory, url, Util.EMPTY_BYTE_ARRAY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] executeKeyRequest(UUID uuid, ExoMediaDrm.KeyRequest request) throws Exception {
        String url = request.getLicenseServerUrl();
        if (this.forceDefaultLicenseUrl || TextUtils.isEmpty((CharSequence)url)) {
            url = this.defaultLicenseUrl;
        }
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        String contentType = C.PLAYREADY_UUID.equals(uuid) ? "text/xml" : (C.CLEARKEY_UUID.equals(uuid) ? "application/json" : "application/octet-stream");
        requestProperties.put("Content-Type", contentType);
        if (C.PLAYREADY_UUID.equals(uuid)) {
            requestProperties.put("SOAPAction", "http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense");
        }
        Map<String, String> map = this.keyRequestProperties;
        synchronized (map) {
            requestProperties.putAll(this.keyRequestProperties);
        }
        return HttpMediaDrmCallback.executePost(this.dataSourceFactory, url, request.getData(), requestProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] executePost(HttpDataSource.Factory dataSourceFactory, String url, byte[] data, @Nullable Map<String, String> requestProperties) throws IOException {
        HttpDataSource dataSource = dataSourceFactory.createDataSource();
        if (requestProperties != null) {
            for (Map.Entry<String, String> requestProperty : requestProperties.entrySet()) {
                dataSource.setRequestProperty(requestProperty.getKey(), requestProperty.getValue());
            }
        }
        int manualRedirectCount = 0;
        while (true) {
            DataSpec dataSpec = new DataSpec(Uri.parse((String)url), data, 0L, 0L, -1L, null, 1);
            DataSourceInputStream inputStream = new DataSourceInputStream(dataSource, dataSpec);
            try {
                byte[] byArray = Util.toByteArray(inputStream);
                return byArray;
            }
            catch (HttpDataSource.InvalidResponseCodeException e) {
                String redirectUrl;
                boolean manuallyRedirect = (e.responseCode == 307 || e.responseCode == 308) && manualRedirectCount++ < 5;
                String string = redirectUrl = manuallyRedirect ? HttpMediaDrmCallback.getRedirectUrl(e) : null;
                if (redirectUrl == null) {
                    throw e;
                }
                url = redirectUrl;
                continue;
            }
            finally {
                Util.closeQuietly(inputStream);
                continue;
            }
            break;
        }
    }

    @Nullable
    private static String getRedirectUrl(HttpDataSource.InvalidResponseCodeException exception) {
        List<String> locationHeaders;
        Map<String, List<String>> headerFields = exception.headerFields;
        if (headerFields != null && (locationHeaders = headerFields.get("Location")) != null && !locationHeaders.isEmpty()) {
            return locationHeaders.get(0);
        }
        return null;
    }
}

