/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.drm.DefaultDrmSession;
import com.google.android.exoplayer2.drm.DefaultDrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.ErrorStateDrmSession;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.EventDispatcher;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

@TargetApi(value=18)
public class DefaultDrmSessionManager<T extends ExoMediaCrypto>
implements DrmSessionManager<T>,
DefaultDrmSession.ProvisioningManager<T> {
    public static final String PLAYREADY_CUSTOM_DATA_KEY = "PRCustomData";
    public static final int MODE_PLAYBACK = 0;
    public static final int MODE_QUERY = 1;
    public static final int MODE_DOWNLOAD = 2;
    public static final int MODE_RELEASE = 3;
    public static final int INITIAL_DRM_REQUEST_RETRY_COUNT = 3;
    private static final String TAG = "DefaultDrmSessionMgr";
    private final UUID uuid;
    private final ExoMediaDrm<T> mediaDrm;
    private final MediaDrmCallback callback;
    @Nullable
    private final HashMap<String, String> optionalKeyRequestParameters;
    private final EventDispatcher<DefaultDrmSessionEventListener> eventDispatcher;
    private final boolean multiSession;
    private final int initialDrmRequestRetryCount;
    private final List<DefaultDrmSession<T>> sessions;
    private final List<DefaultDrmSession<T>> provisioningSessions;
    @Nullable
    private Looper playbackLooper;
    private int mode;
    @Nullable
    private byte[] offlineLicenseKeySetId;
    @Nullable
    volatile MediaDrmHandler mediaDrmHandler;

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newWidevineInstance(MediaDrmCallback callback, @Nullable HashMap<String, String> optionalKeyRequestParameters) throws UnsupportedDrmException {
        return DefaultDrmSessionManager.newFrameworkInstance(C.WIDEVINE_UUID, callback, optionalKeyRequestParameters);
    }

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newPlayReadyInstance(MediaDrmCallback callback, @Nullable String customData) throws UnsupportedDrmException {
        HashMap<String, String> optionalKeyRequestParameters;
        if (!TextUtils.isEmpty((CharSequence)customData)) {
            optionalKeyRequestParameters = new HashMap<String, String>();
            optionalKeyRequestParameters.put(PLAYREADY_CUSTOM_DATA_KEY, customData);
        } else {
            optionalKeyRequestParameters = null;
        }
        return DefaultDrmSessionManager.newFrameworkInstance(C.PLAYREADY_UUID, callback, optionalKeyRequestParameters);
    }

    public static DefaultDrmSessionManager<FrameworkMediaCrypto> newFrameworkInstance(UUID uuid, MediaDrmCallback callback, @Nullable HashMap<String, String> optionalKeyRequestParameters) throws UnsupportedDrmException {
        return new DefaultDrmSessionManager<FrameworkMediaCrypto>(uuid, FrameworkMediaDrm.newInstance(uuid), callback, optionalKeyRequestParameters, false, 3);
    }

    public DefaultDrmSessionManager(UUID uuid, ExoMediaDrm<T> mediaDrm, MediaDrmCallback callback, @Nullable HashMap<String, String> optionalKeyRequestParameters) {
        this(uuid, mediaDrm, callback, optionalKeyRequestParameters, false, 3);
    }

    public DefaultDrmSessionManager(UUID uuid, ExoMediaDrm<T> mediaDrm, MediaDrmCallback callback, @Nullable HashMap<String, String> optionalKeyRequestParameters, boolean multiSession) {
        this(uuid, mediaDrm, callback, optionalKeyRequestParameters, multiSession, 3);
    }

    public DefaultDrmSessionManager(UUID uuid, ExoMediaDrm<T> mediaDrm, MediaDrmCallback callback, @Nullable HashMap<String, String> optionalKeyRequestParameters, boolean multiSession, int initialDrmRequestRetryCount) {
        Assertions.checkNotNull(uuid);
        Assertions.checkNotNull(mediaDrm);
        Assertions.checkArgument(!C.COMMON_PSSH_UUID.equals(uuid), "Use C.CLEARKEY_UUID instead");
        this.uuid = uuid;
        this.mediaDrm = mediaDrm;
        this.callback = callback;
        this.optionalKeyRequestParameters = optionalKeyRequestParameters;
        this.eventDispatcher = new EventDispatcher();
        this.multiSession = multiSession;
        this.initialDrmRequestRetryCount = initialDrmRequestRetryCount;
        this.mode = 0;
        this.sessions = new ArrayList<DefaultDrmSession<T>>();
        this.provisioningSessions = new ArrayList<DefaultDrmSession<T>>();
        if (multiSession && C.WIDEVINE_UUID.equals(uuid) && Util.SDK_INT >= 19) {
            mediaDrm.setPropertyString("sessionSharing", "enable");
        }
        mediaDrm.setOnEventListener(new MediaDrmEventListener());
    }

    public final void addListener(Handler handler, DefaultDrmSessionEventListener eventListener) {
        this.eventDispatcher.addListener(handler, eventListener);
    }

    public final void removeListener(DefaultDrmSessionEventListener eventListener) {
        this.eventDispatcher.removeListener(eventListener);
    }

    public final String getPropertyString(String key) {
        return this.mediaDrm.getPropertyString(key);
    }

    public final void setPropertyString(String key, String value) {
        this.mediaDrm.setPropertyString(key, value);
    }

    public final byte[] getPropertyByteArray(String key) {
        return this.mediaDrm.getPropertyByteArray(key);
    }

    public final void setPropertyByteArray(String key, byte[] value) {
        this.mediaDrm.setPropertyByteArray(key, value);
    }

    public void setMode(int mode, @Nullable byte[] offlineLicenseKeySetId) {
        Assertions.checkState(this.sessions.isEmpty());
        if (mode == 1 || mode == 3) {
            Assertions.checkNotNull(offlineLicenseKeySetId);
        }
        this.mode = mode;
        this.offlineLicenseKeySetId = offlineLicenseKeySetId;
    }

    @Override
    public boolean canAcquireSession(DrmInitData drmInitData) {
        String schemeType;
        if (this.offlineLicenseKeySetId != null) {
            return true;
        }
        List<DrmInitData.SchemeData> schemeDatas = DefaultDrmSessionManager.getSchemeDatas(drmInitData, this.uuid, true);
        if (schemeDatas.isEmpty()) {
            if (drmInitData.schemeDataCount == 1 && drmInitData.get(0).matches(C.COMMON_PSSH_UUID)) {
                Log.w(TAG, "DrmInitData only contains common PSSH SchemeData. Assuming support for: " + this.uuid);
            } else {
                return false;
            }
        }
        if ((schemeType = drmInitData.schemeType) == null || "cenc".equals(schemeType)) {
            return true;
        }
        if ("cbc1".equals(schemeType) || "cbcs".equals(schemeType) || "cens".equals(schemeType)) {
            return Util.SDK_INT >= 25;
        }
        return true;
    }

    @Override
    public DrmSession<T> acquireSession(Looper playbackLooper, DrmInitData drmInitData) {
        DefaultDrmSession<T> session;
        Assertions.checkState(this.playbackLooper == null || this.playbackLooper == playbackLooper);
        if (this.sessions.isEmpty()) {
            this.playbackLooper = playbackLooper;
            if (this.mediaDrmHandler == null) {
                this.mediaDrmHandler = new MediaDrmHandler(playbackLooper);
            }
        }
        List<DrmInitData.SchemeData> schemeDatas = null;
        if (this.offlineLicenseKeySetId == null && (schemeDatas = DefaultDrmSessionManager.getSchemeDatas(drmInitData, this.uuid, false)).isEmpty()) {
            MissingSchemeDataException error = new MissingSchemeDataException(this.uuid);
            this.eventDispatcher.dispatch(listener -> listener.onDrmSessionManagerError(error));
            return new ErrorStateDrmSession(new DrmSession.DrmSessionException(error));
        }
        if (!this.multiSession) {
            session = this.sessions.isEmpty() ? null : this.sessions.get(0);
        } else {
            session = null;
            for (DefaultDrmSession<T> existingSession : this.sessions) {
                if (!Util.areEqual(existingSession.schemeDatas, schemeDatas)) continue;
                session = existingSession;
                break;
            }
        }
        if (session == null) {
            session = new DefaultDrmSession<T>(this.uuid, this.mediaDrm, this, schemeDatas, this.mode, this.offlineLicenseKeySetId, this.optionalKeyRequestParameters, this.callback, playbackLooper, this.eventDispatcher, this.initialDrmRequestRetryCount);
            this.sessions.add(session);
        }
        session.acquire();
        return session;
    }

    @Override
    public void releaseSession(DrmSession<T> session) {
        if (session instanceof ErrorStateDrmSession) {
            return;
        }
        DefaultDrmSession drmSession = (DefaultDrmSession)session;
        if (drmSession.release()) {
            this.sessions.remove(drmSession);
            if (this.provisioningSessions.size() > 1 && this.provisioningSessions.get(0) == drmSession) {
                this.provisioningSessions.get(1).provision();
            }
            this.provisioningSessions.remove(drmSession);
        }
    }

    @Override
    public void provisionRequired(DefaultDrmSession<T> session) {
        if (this.provisioningSessions.contains(session)) {
            return;
        }
        this.provisioningSessions.add(session);
        if (this.provisioningSessions.size() == 1) {
            session.provision();
        }
    }

    @Override
    public void onProvisionCompleted() {
        for (DefaultDrmSession<T> session : this.provisioningSessions) {
            session.onProvisionCompleted();
        }
        this.provisioningSessions.clear();
    }

    @Override
    public void onProvisionError(Exception error) {
        for (DefaultDrmSession<T> session : this.provisioningSessions) {
            session.onProvisionError(error);
        }
        this.provisioningSessions.clear();
    }

    private static List<DrmInitData.SchemeData> getSchemeDatas(DrmInitData drmInitData, UUID uuid, boolean allowMissingData) {
        ArrayList<DrmInitData.SchemeData> matchingSchemeDatas = new ArrayList<DrmInitData.SchemeData>(drmInitData.schemeDataCount);
        for (int i = 0; i < drmInitData.schemeDataCount; ++i) {
            boolean uuidMatches;
            DrmInitData.SchemeData schemeData = drmInitData.get(i);
            boolean bl = uuidMatches = schemeData.matches(uuid) || C.CLEARKEY_UUID.equals(uuid) && schemeData.matches(C.COMMON_PSSH_UUID);
            if (!uuidMatches || schemeData.data == null && !allowMissingData) continue;
            matchingSchemeDatas.add(schemeData);
        }
        return matchingSchemeDatas;
    }

    private class MediaDrmEventListener
    implements ExoMediaDrm.OnEventListener<T> {
        private MediaDrmEventListener() {
        }

        @Override
        public void onEvent(ExoMediaDrm<? extends T> md, byte[] sessionId, int event, int extra, @Nullable byte[] data) {
            Assertions.checkNotNull(DefaultDrmSessionManager.this.mediaDrmHandler).obtainMessage(event, sessionId).sendToTarget();
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class MediaDrmHandler
    extends Handler {
        public MediaDrmHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            byte[] sessionId = (byte[])msg.obj;
            if (sessionId == null) {
                return;
            }
            for (DefaultDrmSession session : DefaultDrmSessionManager.this.sessions) {
                if (!session.hasSessionId(sessionId)) continue;
                session.onMediaDrmEvent(msg.what);
                return;
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }

    public static final class MissingSchemeDataException
    extends Exception {
        private MissingSchemeDataException(UUID uuid) {
            super("Media does not support uuid: " + uuid);
        }
    }
}

