/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.NotProvisionedException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.drm.DefaultDrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.KeysExpiredException;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.WidevineUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.EventDispatcher;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@TargetApi(value=18)
class DefaultDrmSession<T extends ExoMediaCrypto>
implements DrmSession<T> {
    private static final String TAG = "DefaultDrmSession";
    private static final int MSG_PROVISION = 0;
    private static final int MSG_KEYS = 1;
    private static final int MAX_LICENSE_DURATION_TO_RENEW = 60;
    @Nullable
    public final List<DrmInitData.SchemeData> schemeDatas;
    private final ExoMediaDrm<T> mediaDrm;
    private final ProvisioningManager<T> provisioningManager;
    private final int mode;
    @Nullable
    private final HashMap<String, String> optionalKeyRequestParameters;
    private final EventDispatcher<DefaultDrmSessionEventListener> eventDispatcher;
    private final int initialDrmRequestRetryCount;
    final MediaDrmCallback callback;
    final UUID uuid;
    final PostResponseHandler postResponseHandler;
    private int state;
    private int openCount;
    private HandlerThread requestHandlerThread;
    private PostRequestHandler postRequestHandler;
    @Nullable
    private T mediaCrypto;
    @Nullable
    private DrmSession.DrmSessionException lastException;
    private byte @MonotonicNonNull [] sessionId;
    private byte @MonotonicNonNull [] offlineLicenseKeySetId;
    @Nullable
    private ExoMediaDrm.KeyRequest currentKeyRequest;
    @Nullable
    private ExoMediaDrm.ProvisionRequest currentProvisionRequest;

    public DefaultDrmSession(UUID uuid, ExoMediaDrm<T> mediaDrm, ProvisioningManager<T> provisioningManager, @Nullable List<DrmInitData.SchemeData> schemeDatas, int mode, @Nullable byte[] offlineLicenseKeySetId, @Nullable HashMap<String, String> optionalKeyRequestParameters, MediaDrmCallback callback, Looper playbackLooper, EventDispatcher<DefaultDrmSessionEventListener> eventDispatcher, int initialDrmRequestRetryCount) {
        if (mode == 1 || mode == 3) {
            Assertions.checkNotNull(offlineLicenseKeySetId);
        }
        this.uuid = uuid;
        this.provisioningManager = provisioningManager;
        this.mediaDrm = mediaDrm;
        this.mode = mode;
        if (offlineLicenseKeySetId != null) {
            this.offlineLicenseKeySetId = offlineLicenseKeySetId;
            this.schemeDatas = null;
        } else {
            this.schemeDatas = Collections.unmodifiableList(Assertions.checkNotNull(schemeDatas));
        }
        this.optionalKeyRequestParameters = optionalKeyRequestParameters;
        this.callback = callback;
        this.initialDrmRequestRetryCount = initialDrmRequestRetryCount;
        this.eventDispatcher = eventDispatcher;
        this.state = 2;
        this.postResponseHandler = new PostResponseHandler(playbackLooper);
        this.requestHandlerThread = new HandlerThread("DrmRequestHandler");
        this.requestHandlerThread.start();
        this.postRequestHandler = new PostRequestHandler(this.requestHandlerThread.getLooper());
    }

    public void acquire() {
        if (++this.openCount == 1) {
            if (this.state == 1) {
                return;
            }
            if (this.openInternal(true)) {
                this.doLicense(true);
            }
        }
    }

    public boolean release() {
        if (--this.openCount == 0) {
            this.state = 0;
            this.postResponseHandler.removeCallbacksAndMessages(null);
            this.postRequestHandler.removeCallbacksAndMessages(null);
            this.postRequestHandler = null;
            this.requestHandlerThread.quit();
            this.requestHandlerThread = null;
            this.mediaCrypto = null;
            this.lastException = null;
            this.currentKeyRequest = null;
            this.currentProvisionRequest = null;
            if (this.sessionId != null) {
                this.mediaDrm.closeSession(this.sessionId);
                this.sessionId = null;
                this.eventDispatcher.dispatch(DefaultDrmSessionEventListener::onDrmSessionReleased);
            }
            return true;
        }
        return false;
    }

    public boolean hasSessionId(byte[] sessionId) {
        return Arrays.equals(this.sessionId, sessionId);
    }

    public void onMediaDrmEvent(int what) {
        switch (what) {
            case 2: {
                this.onKeysRequired();
                break;
            }
        }
    }

    public void provision() {
        this.currentProvisionRequest = this.mediaDrm.getProvisionRequest();
        this.postRequestHandler.post(0, this.currentProvisionRequest, true);
    }

    public void onProvisionCompleted() {
        if (this.openInternal(false)) {
            this.doLicense(true);
        }
    }

    public void onProvisionError(Exception error) {
        this.onError(error);
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    @Nullable
    public final DrmSession.DrmSessionException getError() {
        return this.state == 1 ? this.lastException : null;
    }

    @Override
    @Nullable
    public final T getMediaCrypto() {
        return this.mediaCrypto;
    }

    @Override
    @Nullable
    public Map<String, String> queryKeyStatus() {
        return this.sessionId == null ? null : this.mediaDrm.queryKeyStatus(this.sessionId);
    }

    @Override
    @Nullable
    public byte[] getOfflineLicenseKeySetId() {
        return this.offlineLicenseKeySetId;
    }

    @EnsuresNonNullIf(result=true, expression={"sessionId"})
    private boolean openInternal(boolean allowProvisioning) {
        if (this.isOpen()) {
            return true;
        }
        try {
            this.sessionId = this.mediaDrm.openSession();
            this.eventDispatcher.dispatch(DefaultDrmSessionEventListener::onDrmSessionAcquired);
            this.mediaCrypto = this.mediaDrm.createMediaCrypto(this.sessionId);
            this.state = 3;
            return true;
        }
        catch (NotProvisionedException e) {
            if (allowProvisioning) {
                this.provisioningManager.provisionRequired(this);
            } else {
                this.onError((Exception)((Object)e));
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        return false;
    }

    private void onProvisionResponse(Object request, Object response) {
        if (request != this.currentProvisionRequest || this.state != 2 && !this.isOpen()) {
            return;
        }
        this.currentProvisionRequest = null;
        if (response instanceof Exception) {
            this.provisioningManager.onProvisionError((Exception)response);
            return;
        }
        try {
            this.mediaDrm.provideProvisionResponse((byte[])response);
        }
        catch (Exception e) {
            this.provisioningManager.onProvisionError(e);
            return;
        }
        this.provisioningManager.onProvisionCompleted();
    }

    @RequiresNonNull(value={"sessionId"})
    private void doLicense(boolean allowRetry) {
        switch (this.mode) {
            case 0: 
            case 1: {
                if (this.offlineLicenseKeySetId == null) {
                    this.postKeyRequest(this.sessionId, 1, allowRetry);
                    break;
                }
                if (this.state != 4 && !this.restoreKeys()) break;
                long licenseDurationRemainingSec = this.getLicenseDurationRemainingSec();
                if (this.mode == 0 && licenseDurationRemainingSec <= 60L) {
                    Log.d(TAG, "Offline license has expired or will expire soon. Remaining seconds: " + licenseDurationRemainingSec);
                    this.postKeyRequest(this.sessionId, 2, allowRetry);
                    break;
                }
                if (licenseDurationRemainingSec <= 0L) {
                    this.onError(new KeysExpiredException());
                    break;
                }
                this.state = 4;
                this.eventDispatcher.dispatch(DefaultDrmSessionEventListener::onDrmKeysRestored);
                break;
            }
            case 2: {
                if (this.offlineLicenseKeySetId == null) {
                    this.postKeyRequest(this.sessionId, 2, allowRetry);
                    break;
                }
                if (!this.restoreKeys()) break;
                this.postKeyRequest(this.sessionId, 2, allowRetry);
                break;
            }
            case 3: {
                Assertions.checkNotNull(this.offlineLicenseKeySetId);
                if (!this.restoreKeys()) break;
                this.postKeyRequest(this.offlineLicenseKeySetId, 3, allowRetry);
                break;
            }
        }
    }

    @RequiresNonNull(value={"sessionId", "offlineLicenseKeySetId"})
    private boolean restoreKeys() {
        try {
            this.mediaDrm.restoreKeys(this.sessionId, this.offlineLicenseKeySetId);
            return true;
        }
        catch (Exception e) {
            Log.e(TAG, "Error trying to restore Widevine keys.", e);
            this.onError(e);
            return false;
        }
    }

    private long getLicenseDurationRemainingSec() {
        if (!C.WIDEVINE_UUID.equals(this.uuid)) {
            return Long.MAX_VALUE;
        }
        Pair<Long, Long> pair = Assertions.checkNotNull(WidevineUtil.getLicenseDurationRemainingSec(this));
        return Math.min((Long)pair.first, (Long)pair.second);
    }

    private void postKeyRequest(byte[] scope, int type, boolean allowRetry) {
        try {
            this.currentKeyRequest = this.mediaDrm.getKeyRequest(scope, this.schemeDatas, type, this.optionalKeyRequestParameters);
            this.postRequestHandler.post(1, this.currentKeyRequest, allowRetry);
        }
        catch (Exception e) {
            this.onKeysError(e);
        }
    }

    private void onKeyResponse(Object request, Object response) {
        if (request != this.currentKeyRequest || !this.isOpen()) {
            return;
        }
        this.currentKeyRequest = null;
        if (response instanceof Exception) {
            this.onKeysError((Exception)response);
            return;
        }
        try {
            byte[] responseData = (byte[])response;
            if (this.mode == 3) {
                this.mediaDrm.provideKeyResponse(Util.castNonNull(this.offlineLicenseKeySetId), responseData);
                this.eventDispatcher.dispatch(DefaultDrmSessionEventListener::onDrmKeysRestored);
            } else {
                byte[] keySetId = this.mediaDrm.provideKeyResponse(this.sessionId, responseData);
                if ((this.mode == 2 || this.mode == 0 && this.offlineLicenseKeySetId != null) && keySetId != null && keySetId.length != 0) {
                    this.offlineLicenseKeySetId = keySetId;
                }
                this.state = 4;
                this.eventDispatcher.dispatch(DefaultDrmSessionEventListener::onDrmKeysLoaded);
            }
        }
        catch (Exception e) {
            this.onKeysError(e);
        }
    }

    private void onKeysRequired() {
        if (this.mode == 0 && this.state == 4) {
            Util.castNonNull(this.sessionId);
            this.doLicense(false);
        }
    }

    private void onKeysError(Exception e) {
        if (e instanceof NotProvisionedException) {
            this.provisioningManager.provisionRequired(this);
        } else {
            this.onError(e);
        }
    }

    private void onError(Exception e) {
        this.lastException = new DrmSession.DrmSessionException(e);
        this.eventDispatcher.dispatch(listener -> listener.onDrmSessionManagerError(e));
        if (this.state != 4) {
            this.state = 1;
        }
    }

    @EnsuresNonNullIf(result=true, expression={"sessionId"})
    private boolean isOpen() {
        return this.state == 3 || this.state == 4;
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PostRequestHandler
    extends Handler {
        public PostRequestHandler(Looper backgroundLooper) {
            super(backgroundLooper);
        }

        void post(int what, Object request, boolean allowRetry) {
            int allowRetryInt = allowRetry ? 1 : 0;
            int errorCount = 0;
            this.obtainMessage(what, allowRetryInt, errorCount, request).sendToTarget();
        }

        public void handleMessage(Message msg) {
            Object response;
            Object request = msg.obj;
            try {
                switch (msg.what) {
                    case 0: {
                        response = DefaultDrmSession.this.callback.executeProvisionRequest(DefaultDrmSession.this.uuid, (ExoMediaDrm.ProvisionRequest)request);
                        break;
                    }
                    case 1: {
                        response = DefaultDrmSession.this.callback.executeKeyRequest(DefaultDrmSession.this.uuid, (ExoMediaDrm.KeyRequest)request);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            catch (Exception e) {
                if (this.maybeRetryRequest(msg)) {
                    return;
                }
                response = e;
            }
            DefaultDrmSession.this.postResponseHandler.obtainMessage(msg.what, Pair.create((Object)request, (Object)response)).sendToTarget();
        }

        private boolean maybeRetryRequest(Message originalMsg) {
            boolean allowRetry;
            boolean bl = allowRetry = originalMsg.arg1 == 1;
            if (!allowRetry) {
                return false;
            }
            int errorCount = originalMsg.arg2 + 1;
            if (errorCount > DefaultDrmSession.this.initialDrmRequestRetryCount) {
                return false;
            }
            Message retryMsg = Message.obtain((Message)originalMsg);
            retryMsg.arg2 = errorCount;
            this.sendMessageDelayed(retryMsg, this.getRetryDelayMillis(errorCount));
            return true;
        }

        private long getRetryDelayMillis(int errorCount) {
            return Math.min((errorCount - 1) * 1000, 5000);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PostResponseHandler
    extends Handler {
        public PostResponseHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            Pair requestAndResponse = (Pair)msg.obj;
            Object request = requestAndResponse.first;
            Object response = requestAndResponse.second;
            switch (msg.what) {
                case 0: {
                    DefaultDrmSession.this.onProvisionResponse(request, response);
                    break;
                }
                case 1: {
                    DefaultDrmSession.this.onKeyResponse(request, response);
                    break;
                }
            }
        }
    }

    public static interface ProvisioningManager<T extends ExoMediaCrypto> {
        public void provisionRequired(DefaultDrmSession<T> var1);

        public void onProvisionError(Exception var1);

        public void onProvisionCompleted();
    }
}

