/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

public abstract class DecryptionResource<T extends DecryptionResource<T>> {
    private final Owner<T> owner;
    private int referenceCount;

    public DecryptionResource(Owner<T> owner) {
        this.owner = owner;
        this.referenceCount = 0;
    }

    public void acquireReference() {
        ++this.referenceCount;
    }

    public void releaseReference() {
        if (--this.referenceCount == 0) {
            this.owner.onLastReferenceReleased(this);
        } else if (this.referenceCount < 0) {
            throw new IllegalStateException("Illegal release of resource.");
        }
    }

    public static interface Owner<T extends DecryptionResource<T>> {
        public void onLastReferenceReleased(T var1);
    }
}

