/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.decoder;

import com.google.android.exoplayer2.decoder.Buffer;
import com.google.android.exoplayer2.decoder.CryptoInfo;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public class DecoderInputBuffer
extends Buffer {
    public static final int BUFFER_REPLACEMENT_MODE_DISABLED = 0;
    public static final int BUFFER_REPLACEMENT_MODE_NORMAL = 1;
    public static final int BUFFER_REPLACEMENT_MODE_DIRECT = 2;
    public final CryptoInfo cryptoInfo = new CryptoInfo();
    public ByteBuffer data;
    public long timeUs;
    private final int bufferReplacementMode;

    public static DecoderInputBuffer newFlagsOnlyInstance() {
        return new DecoderInputBuffer(0);
    }

    public DecoderInputBuffer(int bufferReplacementMode) {
        this.bufferReplacementMode = bufferReplacementMode;
    }

    public void ensureSpaceForWrite(int length) {
        int position;
        int requiredCapacity;
        if (this.data == null) {
            this.data = this.createReplacementByteBuffer(length);
            return;
        }
        int capacity = this.data.capacity();
        if (capacity >= (requiredCapacity = (position = this.data.position()) + length)) {
            return;
        }
        ByteBuffer newData = this.createReplacementByteBuffer(requiredCapacity);
        if (position > 0) {
            this.data.position(0);
            this.data.limit(position);
            newData.put(this.data);
        }
        this.data = newData;
    }

    public final boolean isFlagsOnly() {
        return this.data == null && this.bufferReplacementMode == 0;
    }

    public final boolean isEncrypted() {
        return this.getFlag(0x40000000);
    }

    public final void flip() {
        this.data.flip();
    }

    @Override
    public void clear() {
        super.clear();
        if (this.data != null) {
            this.data.clear();
        }
    }

    private ByteBuffer createReplacementByteBuffer(int requiredCapacity) {
        if (this.bufferReplacementMode == 1) {
            return ByteBuffer.allocate(requiredCapacity);
        }
        if (this.bufferReplacementMode == 2) {
            return ByteBuffer.allocateDirect(requiredCapacity);
        }
        int currentCapacity = this.data == null ? 0 : this.data.capacity();
        throw new IllegalStateException("Buffer too small (" + currentCapacity + " < " + requiredCapacity + ")");
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BufferReplacementMode {
    }
}

