/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;

final class TrimmingAudioProcessor
extends BaseAudioProcessor {
    private static final int OUTPUT_ENCODING = 2;
    private boolean isActive;
    private int trimStartFrames;
    private int trimEndFrames;
    private int bytesPerFrame;
    private boolean receivedInputSinceConfigure;
    private int pendingTrimStartBytes;
    private byte[] endBuffer = Util.EMPTY_BYTE_ARRAY;
    private int endBufferSize;
    private long trimmedFrameCount;

    public void setTrimFrameCount(int trimStartFrames, int trimEndFrames) {
        this.trimStartFrames = trimStartFrames;
        this.trimEndFrames = trimEndFrames;
    }

    public void resetTrimmedFrameCount() {
        this.trimmedFrameCount = 0L;
    }

    public long getTrimmedFrameCount() {
        return this.trimmedFrameCount;
    }

    @Override
    public boolean configure(int sampleRateHz, int channelCount, int encoding) throws AudioProcessor.UnhandledFormatException {
        if (encoding != 2) {
            throw new AudioProcessor.UnhandledFormatException(sampleRateHz, channelCount, encoding);
        }
        if (this.endBufferSize > 0) {
            this.trimmedFrameCount += (long)(this.endBufferSize / this.bytesPerFrame);
        }
        this.bytesPerFrame = Util.getPcmFrameSize(2, channelCount);
        this.endBuffer = new byte[this.trimEndFrames * this.bytesPerFrame];
        this.endBufferSize = 0;
        this.pendingTrimStartBytes = this.trimStartFrames * this.bytesPerFrame;
        boolean wasActive = this.isActive;
        this.isActive = this.trimStartFrames != 0 || this.trimEndFrames != 0;
        this.receivedInputSinceConfigure = false;
        this.setInputFormat(sampleRateHz, channelCount, encoding);
        return wasActive != this.isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        int position = inputBuffer.position();
        int limit = inputBuffer.limit();
        int remaining = limit - position;
        if (remaining == 0) {
            return;
        }
        this.receivedInputSinceConfigure = true;
        int trimBytes = Math.min(remaining, this.pendingTrimStartBytes);
        this.trimmedFrameCount += (long)(trimBytes / this.bytesPerFrame);
        this.pendingTrimStartBytes -= trimBytes;
        inputBuffer.position(position + trimBytes);
        if (this.pendingTrimStartBytes > 0) {
            return;
        }
        int remainingBytesToOutput = this.endBufferSize + (remaining -= trimBytes) - this.endBuffer.length;
        ByteBuffer buffer = this.replaceOutputBuffer(remainingBytesToOutput);
        int endBufferBytesToOutput = Util.constrainValue(remainingBytesToOutput, 0, this.endBufferSize);
        buffer.put(this.endBuffer, 0, endBufferBytesToOutput);
        int inputBufferBytesToOutput = Util.constrainValue(remainingBytesToOutput -= endBufferBytesToOutput, 0, remaining);
        inputBuffer.limit(inputBuffer.position() + inputBufferBytesToOutput);
        buffer.put(inputBuffer);
        inputBuffer.limit(limit);
        this.endBufferSize -= endBufferBytesToOutput;
        System.arraycopy(this.endBuffer, endBufferBytesToOutput, this.endBuffer, 0, this.endBufferSize);
        inputBuffer.get(this.endBuffer, this.endBufferSize, remaining -= inputBufferBytesToOutput);
        this.endBufferSize += remaining;
        buffer.flip();
    }

    @Override
    public ByteBuffer getOutput() {
        if (super.isEnded() && this.endBufferSize > 0) {
            this.replaceOutputBuffer(this.endBufferSize).put(this.endBuffer, 0, this.endBufferSize).flip();
            this.endBufferSize = 0;
        }
        return super.getOutput();
    }

    @Override
    public boolean isEnded() {
        return super.isEnded() && this.endBufferSize == 0;
    }

    @Override
    protected void onFlush() {
        if (this.receivedInputSinceConfigure) {
            this.pendingTrimStartBytes = 0;
        }
        this.endBufferSize = 0;
    }

    @Override
    protected void onReset() {
        this.endBuffer = Util.EMPTY_BYTE_ARRAY;
    }
}

