/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.Sonic;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public final class SonicAudioProcessor
implements AudioProcessor {
    public static final float MAXIMUM_SPEED = 8.0f;
    public static final float MINIMUM_SPEED = 0.1f;
    public static final float MAXIMUM_PITCH = 8.0f;
    public static final float MINIMUM_PITCH = 0.1f;
    public static final int SAMPLE_RATE_NO_CHANGE = -1;
    private static final float CLOSE_THRESHOLD = 0.01f;
    private static final int MIN_BYTES_FOR_SPEEDUP_CALCULATION = 1024;
    private int channelCount = -1;
    private int sampleRateHz = -1;
    private float speed = 1.0f;
    private float pitch = 1.0f;
    private int outputSampleRateHz = -1;
    private int pendingOutputSampleRateHz = -1;
    private boolean pendingSonicRecreation;
    @Nullable
    private Sonic sonic;
    private ByteBuffer buffer = EMPTY_BUFFER;
    private ShortBuffer shortBuffer = this.buffer.asShortBuffer();
    private ByteBuffer outputBuffer = EMPTY_BUFFER;
    private long inputBytes;
    private long outputBytes;
    private boolean inputEnded;

    public float setSpeed(float speed) {
        if (this.speed != (speed = Util.constrainValue(speed, 0.1f, 8.0f))) {
            this.speed = speed;
            this.pendingSonicRecreation = true;
        }
        this.flush();
        return speed;
    }

    public float setPitch(float pitch) {
        if (this.pitch != (pitch = Util.constrainValue(pitch, 0.1f, 8.0f))) {
            this.pitch = pitch;
            this.pendingSonicRecreation = true;
        }
        this.flush();
        return pitch;
    }

    public void setOutputSampleRateHz(int sampleRateHz) {
        this.pendingOutputSampleRateHz = sampleRateHz;
    }

    public long scaleDurationForSpeedup(long duration) {
        if (this.outputBytes >= 1024L) {
            return this.outputSampleRateHz == this.sampleRateHz ? Util.scaleLargeTimestamp(duration, this.inputBytes, this.outputBytes) : Util.scaleLargeTimestamp(duration, this.inputBytes * (long)this.outputSampleRateHz, this.outputBytes * (long)this.sampleRateHz);
        }
        return (long)((double)this.speed * (double)duration);
    }

    @Override
    public boolean configure(int sampleRateHz, int channelCount, int encoding) throws AudioProcessor.UnhandledFormatException {
        int outputSampleRateHz;
        if (encoding != 2) {
            throw new AudioProcessor.UnhandledFormatException(sampleRateHz, channelCount, encoding);
        }
        int n = outputSampleRateHz = this.pendingOutputSampleRateHz == -1 ? sampleRateHz : this.pendingOutputSampleRateHz;
        if (this.sampleRateHz == sampleRateHz && this.channelCount == channelCount && this.outputSampleRateHz == outputSampleRateHz) {
            return false;
        }
        this.sampleRateHz = sampleRateHz;
        this.channelCount = channelCount;
        this.outputSampleRateHz = outputSampleRateHz;
        this.pendingSonicRecreation = true;
        return true;
    }

    @Override
    public boolean isActive() {
        return this.sampleRateHz != -1 && (Math.abs(this.speed - 1.0f) >= 0.01f || Math.abs(this.pitch - 1.0f) >= 0.01f || this.outputSampleRateHz != this.sampleRateHz);
    }

    @Override
    public int getOutputChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getOutputEncoding() {
        return 2;
    }

    @Override
    public int getOutputSampleRateHz() {
        return this.outputSampleRateHz;
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        int outputSize;
        Sonic sonic = Assertions.checkNotNull(this.sonic);
        if (inputBuffer.hasRemaining()) {
            ShortBuffer shortBuffer = inputBuffer.asShortBuffer();
            int inputSize = inputBuffer.remaining();
            this.inputBytes += (long)inputSize;
            sonic.queueInput(shortBuffer);
            inputBuffer.position(inputBuffer.position() + inputSize);
        }
        if ((outputSize = sonic.getFramesAvailable() * this.channelCount * 2) > 0) {
            if (this.buffer.capacity() < outputSize) {
                this.buffer = ByteBuffer.allocateDirect(outputSize).order(ByteOrder.nativeOrder());
                this.shortBuffer = this.buffer.asShortBuffer();
            } else {
                this.buffer.clear();
                this.shortBuffer.clear();
            }
            sonic.getOutput(this.shortBuffer);
            this.outputBytes += (long)outputSize;
            this.buffer.limit(outputSize);
            this.outputBuffer = this.buffer;
        }
    }

    @Override
    public void queueEndOfStream() {
        if (this.sonic != null) {
            this.sonic.queueEndOfStream();
        }
        this.inputEnded = true;
    }

    @Override
    public ByteBuffer getOutput() {
        ByteBuffer outputBuffer = this.outputBuffer;
        this.outputBuffer = EMPTY_BUFFER;
        return outputBuffer;
    }

    @Override
    public boolean isEnded() {
        return this.inputEnded && (this.sonic == null || this.sonic.getFramesAvailable() == 0);
    }

    @Override
    public void flush() {
        if (this.isActive()) {
            if (this.pendingSonicRecreation) {
                this.sonic = new Sonic(this.sampleRateHz, this.channelCount, this.speed, this.pitch, this.outputSampleRateHz);
            } else if (this.sonic != null) {
                this.sonic.flush();
            }
        }
        this.outputBuffer = EMPTY_BUFFER;
        this.inputBytes = 0L;
        this.outputBytes = 0L;
        this.inputEnded = false;
    }

    @Override
    public void reset() {
        this.speed = 1.0f;
        this.pitch = 1.0f;
        this.channelCount = -1;
        this.sampleRateHz = -1;
        this.outputSampleRateHz = -1;
        this.buffer = EMPTY_BUFFER;
        this.shortBuffer = this.buffer.asShortBuffer();
        this.outputBuffer = EMPTY_BUFFER;
        this.pendingOutputSampleRateHz = -1;
        this.pendingSonicRecreation = false;
        this.sonic = null;
        this.inputBytes = 0L;
        this.outputBytes = 0L;
        this.inputEnded = false;
    }
}

