/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;

public final class SilenceSkippingAudioProcessor
extends BaseAudioProcessor {
    private static final long MINIMUM_SILENCE_DURATION_US = 150000L;
    private static final long PADDING_SILENCE_US = 20000L;
    private static final short SILENCE_THRESHOLD_LEVEL = 1024;
    private static final byte SILENCE_THRESHOLD_LEVEL_MSB = 4;
    private static final int STATE_NOISY = 0;
    private static final int STATE_MAYBE_SILENT = 1;
    private static final int STATE_SILENT = 2;
    private int bytesPerFrame;
    private boolean enabled;
    private byte[] maybeSilenceBuffer = Util.EMPTY_BYTE_ARRAY;
    private byte[] paddingBuffer = Util.EMPTY_BYTE_ARRAY;
    private int state;
    private int maybeSilenceBufferSize;
    private int paddingSize;
    private boolean hasOutputNoise;
    private long skippedFrames;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.flush();
    }

    public long getSkippedFrames() {
        return this.skippedFrames;
    }

    @Override
    public boolean configure(int sampleRateHz, int channelCount, int encoding) throws AudioProcessor.UnhandledFormatException {
        if (encoding != 2) {
            throw new AudioProcessor.UnhandledFormatException(sampleRateHz, channelCount, encoding);
        }
        this.bytesPerFrame = channelCount * 2;
        return this.setInputFormat(sampleRateHz, channelCount, encoding);
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.enabled;
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        block5: while (inputBuffer.hasRemaining() && !this.hasPendingOutput()) {
            switch (this.state) {
                case 0: {
                    this.processNoisy(inputBuffer);
                    continue block5;
                }
                case 1: {
                    this.processMaybeSilence(inputBuffer);
                    continue block5;
                }
                case 2: {
                    this.processSilence(inputBuffer);
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    protected void onQueueEndOfStream() {
        if (this.maybeSilenceBufferSize > 0) {
            this.output(this.maybeSilenceBuffer, this.maybeSilenceBufferSize);
        }
        if (!this.hasOutputNoise) {
            this.skippedFrames += (long)(this.paddingSize / this.bytesPerFrame);
        }
    }

    @Override
    protected void onFlush() {
        if (this.isActive()) {
            int maybeSilenceBufferSize = this.durationUsToFrames(150000L) * this.bytesPerFrame;
            if (this.maybeSilenceBuffer.length != maybeSilenceBufferSize) {
                this.maybeSilenceBuffer = new byte[maybeSilenceBufferSize];
            }
            this.paddingSize = this.durationUsToFrames(20000L) * this.bytesPerFrame;
            if (this.paddingBuffer.length != this.paddingSize) {
                this.paddingBuffer = new byte[this.paddingSize];
            }
        }
        this.state = 0;
        this.skippedFrames = 0L;
        this.maybeSilenceBufferSize = 0;
        this.hasOutputNoise = false;
    }

    @Override
    protected void onReset() {
        this.enabled = false;
        this.paddingSize = 0;
        this.maybeSilenceBuffer = Util.EMPTY_BYTE_ARRAY;
        this.paddingBuffer = Util.EMPTY_BYTE_ARRAY;
    }

    private void processNoisy(ByteBuffer inputBuffer) {
        int limit = inputBuffer.limit();
        inputBuffer.limit(Math.min(limit, inputBuffer.position() + this.maybeSilenceBuffer.length));
        int noiseLimit = this.findNoiseLimit(inputBuffer);
        if (noiseLimit == inputBuffer.position()) {
            this.state = 1;
        } else {
            inputBuffer.limit(noiseLimit);
            this.output(inputBuffer);
        }
        inputBuffer.limit(limit);
    }

    private void processMaybeSilence(ByteBuffer inputBuffer) {
        int limit = inputBuffer.limit();
        int noisePosition = this.findNoisePosition(inputBuffer);
        int maybeSilenceInputSize = noisePosition - inputBuffer.position();
        int maybeSilenceBufferRemaining = this.maybeSilenceBuffer.length - this.maybeSilenceBufferSize;
        if (noisePosition < limit && maybeSilenceInputSize < maybeSilenceBufferRemaining) {
            this.output(this.maybeSilenceBuffer, this.maybeSilenceBufferSize);
            this.maybeSilenceBufferSize = 0;
            this.state = 0;
        } else {
            int bytesToWrite = Math.min(maybeSilenceInputSize, maybeSilenceBufferRemaining);
            inputBuffer.limit(inputBuffer.position() + bytesToWrite);
            inputBuffer.get(this.maybeSilenceBuffer, this.maybeSilenceBufferSize, bytesToWrite);
            this.maybeSilenceBufferSize += bytesToWrite;
            if (this.maybeSilenceBufferSize == this.maybeSilenceBuffer.length) {
                if (this.hasOutputNoise) {
                    this.output(this.maybeSilenceBuffer, this.paddingSize);
                    this.skippedFrames += (long)((this.maybeSilenceBufferSize - this.paddingSize * 2) / this.bytesPerFrame);
                } else {
                    this.skippedFrames += (long)((this.maybeSilenceBufferSize - this.paddingSize) / this.bytesPerFrame);
                }
                this.updatePaddingBuffer(inputBuffer, this.maybeSilenceBuffer, this.maybeSilenceBufferSize);
                this.maybeSilenceBufferSize = 0;
                this.state = 2;
            }
            inputBuffer.limit(limit);
        }
    }

    private void processSilence(ByteBuffer inputBuffer) {
        int limit = inputBuffer.limit();
        int noisyPosition = this.findNoisePosition(inputBuffer);
        inputBuffer.limit(noisyPosition);
        this.skippedFrames += (long)(inputBuffer.remaining() / this.bytesPerFrame);
        this.updatePaddingBuffer(inputBuffer, this.paddingBuffer, this.paddingSize);
        if (noisyPosition < limit) {
            this.output(this.paddingBuffer, this.paddingSize);
            this.state = 0;
            inputBuffer.limit(limit);
        }
    }

    private void output(byte[] data, int length) {
        this.replaceOutputBuffer(length).put(data, 0, length).flip();
        if (length > 0) {
            this.hasOutputNoise = true;
        }
    }

    private void output(ByteBuffer data) {
        int length = data.remaining();
        this.replaceOutputBuffer(length).put(data).flip();
        if (length > 0) {
            this.hasOutputNoise = true;
        }
    }

    private void updatePaddingBuffer(ByteBuffer input, byte[] buffer, int size) {
        int fromInputSize = Math.min(input.remaining(), this.paddingSize);
        int fromBufferSize = this.paddingSize - fromInputSize;
        System.arraycopy(buffer, size - fromBufferSize, this.paddingBuffer, 0, fromBufferSize);
        input.position(input.limit() - fromInputSize);
        input.get(this.paddingBuffer, fromBufferSize, fromInputSize);
    }

    private int durationUsToFrames(long durationUs) {
        return (int)(durationUs * (long)this.sampleRateHz / 1000000L);
    }

    private int findNoisePosition(ByteBuffer buffer) {
        for (int i = buffer.position() + 1; i < buffer.limit(); i += 2) {
            if (Math.abs(buffer.get(i)) <= 4) continue;
            return this.bytesPerFrame * (i / this.bytesPerFrame);
        }
        return buffer.limit();
    }

    private int findNoiseLimit(ByteBuffer buffer) {
        for (int i = buffer.limit() - 1; i >= buffer.position(); i -= 2) {
            if (Math.abs(buffer.get(i)) <= 4) continue;
            return this.bytesPerFrame * (i / this.bytesPerFrame) + this.bytesPerFrame;
        }
        return buffer.position();
    }
}

