/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import java.nio.ByteBuffer;

final class ResamplingAudioProcessor
extends BaseAudioProcessor {
    ResamplingAudioProcessor() {
    }

    @Override
    public boolean configure(int sampleRateHz, int channelCount, int encoding) throws AudioProcessor.UnhandledFormatException {
        if (encoding != 3 && encoding != 2 && encoding != Integer.MIN_VALUE && encoding != 0x40000000) {
            throw new AudioProcessor.UnhandledFormatException(sampleRateHz, channelCount, encoding);
        }
        return this.setInputFormat(sampleRateHz, channelCount, encoding);
    }

    @Override
    public boolean isActive() {
        return this.encoding != 0 && this.encoding != 2;
    }

    @Override
    public int getOutputEncoding() {
        return 2;
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        int resampledSize;
        int position = inputBuffer.position();
        int limit = inputBuffer.limit();
        int size = limit - position;
        switch (this.encoding) {
            case 3: {
                resampledSize = size * 2;
                break;
            }
            case -2147483648: {
                resampledSize = size / 3 * 2;
                break;
            }
            case 0x40000000: {
                resampledSize = size / 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ByteBuffer buffer = this.replaceOutputBuffer(resampledSize);
        switch (this.encoding) {
            case 3: {
                for (int i = position; i < limit; ++i) {
                    buffer.put((byte)0);
                    buffer.put((byte)((inputBuffer.get(i) & 0xFF) - 128));
                }
                break;
            }
            case -2147483648: {
                for (int i = position; i < limit; i += 3) {
                    buffer.put(inputBuffer.get(i + 1));
                    buffer.put(inputBuffer.get(i + 2));
                }
                break;
            }
            case 0x40000000: {
                for (int i = position; i < limit; i += 4) {
                    buffer.put(inputBuffer.get(i + 2));
                    buffer.put(inputBuffer.get(i + 3));
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        inputBuffer.position(inputBuffer.limit());
        buffer.flip();
    }
}

