/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;

final class FloatResamplingAudioProcessor
extends BaseAudioProcessor {
    private static final int FLOAT_NAN_AS_INT = Float.floatToIntBits(Float.NaN);
    private static final double PCM_32_BIT_INT_TO_PCM_32_BIT_FLOAT_FACTOR = 4.656612875245797E-10;

    FloatResamplingAudioProcessor() {
    }

    @Override
    public boolean configure(int sampleRateHz, int channelCount, int encoding) throws AudioProcessor.UnhandledFormatException {
        if (!Util.isEncodingHighResolutionIntegerPcm(encoding)) {
            throw new AudioProcessor.UnhandledFormatException(sampleRateHz, channelCount, encoding);
        }
        return this.setInputFormat(sampleRateHz, channelCount, encoding);
    }

    @Override
    public boolean isActive() {
        return Util.isEncodingHighResolutionIntegerPcm(this.encoding);
    }

    @Override
    public int getOutputEncoding() {
        return 4;
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        boolean isInput32Bit = this.encoding == 0x40000000;
        int position = inputBuffer.position();
        int limit = inputBuffer.limit();
        int size = limit - position;
        int resampledSize = isInput32Bit ? size : size / 3 * 4;
        ByteBuffer buffer = this.replaceOutputBuffer(resampledSize);
        if (isInput32Bit) {
            for (int i = position; i < limit; i += 4) {
                int pcm32BitInteger = inputBuffer.get(i) & 0xFF | (inputBuffer.get(i + 1) & 0xFF) << 8 | (inputBuffer.get(i + 2) & 0xFF) << 16 | (inputBuffer.get(i + 3) & 0xFF) << 24;
                FloatResamplingAudioProcessor.writePcm32BitFloat(pcm32BitInteger, buffer);
            }
        } else {
            for (int i = position; i < limit; i += 3) {
                int pcm32BitInteger = (inputBuffer.get(i) & 0xFF) << 8 | (inputBuffer.get(i + 1) & 0xFF) << 16 | (inputBuffer.get(i + 2) & 0xFF) << 24;
                FloatResamplingAudioProcessor.writePcm32BitFloat(pcm32BitInteger, buffer);
            }
        }
        inputBuffer.position(inputBuffer.limit());
        buffer.flip();
    }

    private static void writePcm32BitFloat(int pcm32BitInt, ByteBuffer buffer) {
        float pcm32BitFloat = (float)(4.656612875245797E-10 * (double)pcm32BitInt);
        int floatBits = Float.floatToIntBits(pcm32BitFloat);
        if (floatBits == FLOAT_NAN_AS_INT) {
            floatBits = Float.floatToIntBits(0.0f);
        }
        buffer.putInt(floatBits);
    }
}

