/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.os.ConditionVariable;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.audio.Ac4Util;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioSink;
import com.google.android.exoplayer2.audio.AudioTrackPositionTracker;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.audio.ChannelMappingAudioProcessor;
import com.google.android.exoplayer2.audio.DtsUtil;
import com.google.android.exoplayer2.audio.FloatResamplingAudioProcessor;
import com.google.android.exoplayer2.audio.ResamplingAudioProcessor;
import com.google.android.exoplayer2.audio.SilenceSkippingAudioProcessor;
import com.google.android.exoplayer2.audio.SonicAudioProcessor;
import com.google.android.exoplayer2.audio.TrimmingAudioProcessor;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public final class DefaultAudioSink
implements AudioSink {
    private static final long MIN_BUFFER_DURATION_US = 250000L;
    private static final long MAX_BUFFER_DURATION_US = 750000L;
    private static final long PASSTHROUGH_BUFFER_DURATION_US = 250000L;
    private static final int BUFFER_MULTIPLICATION_FACTOR = 4;
    private static final int AC3_BUFFER_MULTIPLICATION_FACTOR = 2;
    private static final int ERROR_BAD_VALUE = -2;
    private static final int MODE_STATIC = 0;
    private static final int MODE_STREAM = 1;
    private static final int STATE_INITIALIZED = 1;
    @SuppressLint(value={"InlinedApi"})
    private static final int WRITE_NON_BLOCKING = 1;
    private static final String TAG = "AudioTrack";
    private static final int START_NOT_SET = 0;
    private static final int START_IN_SYNC = 1;
    private static final int START_NEED_SYNC = 2;
    public static boolean enablePreV21AudioSessionWorkaround = false;
    public static boolean failOnSpuriousAudioTimestamp = false;
    @Nullable
    private final AudioCapabilities audioCapabilities;
    private final AudioProcessorChain audioProcessorChain;
    private final boolean enableConvertHighResIntPcmToFloat;
    private final ChannelMappingAudioProcessor channelMappingAudioProcessor;
    private final TrimmingAudioProcessor trimmingAudioProcessor;
    private final AudioProcessor[] toIntPcmAvailableAudioProcessors;
    private final AudioProcessor[] toFloatPcmAvailableAudioProcessors;
    private final ConditionVariable releasingConditionVariable;
    private final AudioTrackPositionTracker audioTrackPositionTracker;
    private final ArrayDeque<PlaybackParametersCheckpoint> playbackParametersCheckpoints;
    @Nullable
    private AudioSink.Listener listener;
    @Nullable
    private AudioTrack keepSessionIdAudioTrack;
    @Nullable
    private Configuration pendingConfiguration;
    private Configuration configuration;
    private AudioTrack audioTrack;
    private AudioAttributes audioAttributes;
    @Nullable
    private PlaybackParameters afterDrainPlaybackParameters;
    private PlaybackParameters playbackParameters;
    private long playbackParametersOffsetUs;
    private long playbackParametersPositionUs;
    @Nullable
    private ByteBuffer avSyncHeader;
    private int bytesUntilNextAvSync;
    private long submittedPcmBytes;
    private long submittedEncodedFrames;
    private long writtenPcmBytes;
    private long writtenEncodedFrames;
    private int framesPerEncodedSample;
    private int startMediaTimeState;
    private long startMediaTimeUs;
    private float volume;
    private AudioProcessor[] activeAudioProcessors;
    private ByteBuffer[] outputBuffers;
    @Nullable
    private ByteBuffer inputBuffer;
    @Nullable
    private ByteBuffer outputBuffer;
    private byte[] preV21OutputBuffer;
    private int preV21OutputBufferOffset;
    private int drainingAudioProcessorIndex;
    private boolean handledEndOfStream;
    private boolean playing;
    private int audioSessionId;
    private AuxEffectInfo auxEffectInfo;
    private boolean tunneling;
    private long lastFeedElapsedRealtimeMs;

    public DefaultAudioSink(@Nullable AudioCapabilities audioCapabilities, AudioProcessor[] audioProcessors) {
        this(audioCapabilities, audioProcessors, false);
    }

    public DefaultAudioSink(@Nullable AudioCapabilities audioCapabilities, AudioProcessor[] audioProcessors, boolean enableConvertHighResIntPcmToFloat) {
        this(audioCapabilities, new DefaultAudioProcessorChain(audioProcessors), enableConvertHighResIntPcmToFloat);
    }

    public DefaultAudioSink(@Nullable AudioCapabilities audioCapabilities, AudioProcessorChain audioProcessorChain, boolean enableConvertHighResIntPcmToFloat) {
        this.audioCapabilities = audioCapabilities;
        this.audioProcessorChain = Assertions.checkNotNull(audioProcessorChain);
        this.enableConvertHighResIntPcmToFloat = enableConvertHighResIntPcmToFloat;
        this.releasingConditionVariable = new ConditionVariable(true);
        this.audioTrackPositionTracker = new AudioTrackPositionTracker(new PositionTrackerListener());
        this.channelMappingAudioProcessor = new ChannelMappingAudioProcessor();
        this.trimmingAudioProcessor = new TrimmingAudioProcessor();
        ArrayList toIntPcmAudioProcessors = new ArrayList();
        Collections.addAll(toIntPcmAudioProcessors, new ResamplingAudioProcessor(), this.channelMappingAudioProcessor, this.trimmingAudioProcessor);
        Collections.addAll(toIntPcmAudioProcessors, audioProcessorChain.getAudioProcessors());
        this.toIntPcmAvailableAudioProcessors = toIntPcmAudioProcessors.toArray(new AudioProcessor[0]);
        this.toFloatPcmAvailableAudioProcessors = new AudioProcessor[]{new FloatResamplingAudioProcessor()};
        this.volume = 1.0f;
        this.startMediaTimeState = 0;
        this.audioAttributes = AudioAttributes.DEFAULT;
        this.audioSessionId = 0;
        this.auxEffectInfo = new AuxEffectInfo(0, 0.0f);
        this.playbackParameters = PlaybackParameters.DEFAULT;
        this.drainingAudioProcessorIndex = -1;
        this.activeAudioProcessors = new AudioProcessor[0];
        this.outputBuffers = new ByteBuffer[0];
        this.playbackParametersCheckpoints = new ArrayDeque();
    }

    @Override
    public void setListener(AudioSink.Listener listener) {
        this.listener = listener;
    }

    @Override
    public boolean supportsOutput(int channelCount, int encoding) {
        if (Util.isEncodingLinearPcm(encoding)) {
            return encoding != 4 || Util.SDK_INT >= 21;
        }
        return this.audioCapabilities != null && this.audioCapabilities.supportsEncoding(encoding) && (channelCount == -1 || channelCount <= this.audioCapabilities.getMaxChannelCount());
    }

    @Override
    public long getCurrentPositionUs(boolean sourceEnded) {
        if (!this.isInitialized() || this.startMediaTimeState == 0) {
            return Long.MIN_VALUE;
        }
        long positionUs = this.audioTrackPositionTracker.getCurrentPositionUs(sourceEnded);
        positionUs = Math.min(positionUs, this.configuration.framesToDurationUs(this.getWrittenFrames()));
        return this.startMediaTimeUs + this.applySkipping(this.applySpeedup(positionUs));
    }

    @Override
    public void configure(int inputEncoding, int inputChannelCount, int inputSampleRate, int specifiedBufferSize, @Nullable int[] outputChannels, int trimStartFrames, int trimEndFrames) throws AudioSink.ConfigurationException {
        int outputChannelConfig;
        boolean isInputPcm;
        if (Util.SDK_INT < 21 && inputChannelCount == 8 && outputChannels == null) {
            outputChannels = new int[6];
            for (int i = 0; i < outputChannels.length; ++i) {
                outputChannels[i] = i;
            }
        }
        boolean processingEnabled = (isInputPcm = Util.isEncodingLinearPcm(inputEncoding)) && inputEncoding != 4;
        int sampleRate = inputSampleRate;
        int channelCount = inputChannelCount;
        int encoding = inputEncoding;
        boolean shouldConvertHighResIntPcmToFloat = this.enableConvertHighResIntPcmToFloat && this.supportsOutput(inputChannelCount, 4) && Util.isEncodingHighResolutionIntegerPcm(inputEncoding);
        AudioProcessor[] availableAudioProcessors = shouldConvertHighResIntPcmToFloat ? this.toFloatPcmAvailableAudioProcessors : this.toIntPcmAvailableAudioProcessors;
        boolean flushAudioProcessors = false;
        if (processingEnabled) {
            this.trimmingAudioProcessor.setTrimFrameCount(trimStartFrames, trimEndFrames);
            this.channelMappingAudioProcessor.setChannelMap(outputChannels);
            for (AudioProcessor audioProcessor : availableAudioProcessors) {
                try {
                    flushAudioProcessors |= audioProcessor.configure(sampleRate, channelCount, encoding);
                }
                catch (AudioProcessor.UnhandledFormatException e) {
                    throw new AudioSink.ConfigurationException(e);
                }
                if (!audioProcessor.isActive()) continue;
                channelCount = audioProcessor.getOutputChannelCount();
                sampleRate = audioProcessor.getOutputSampleRateHz();
                encoding = audioProcessor.getOutputEncoding();
            }
        }
        if ((outputChannelConfig = DefaultAudioSink.getChannelConfig(channelCount, isInputPcm)) == 0) {
            throw new AudioSink.ConfigurationException("Unsupported channel count: " + channelCount);
        }
        int inputPcmFrameSize = isInputPcm ? Util.getPcmFrameSize(inputEncoding, inputChannelCount) : -1;
        int outputPcmFrameSize = isInputPcm ? Util.getPcmFrameSize(encoding, channelCount) : -1;
        boolean canApplyPlaybackParameters = processingEnabled && !shouldConvertHighResIntPcmToFloat;
        Configuration pendingConfiguration = new Configuration(isInputPcm, inputPcmFrameSize, inputSampleRate, outputPcmFrameSize, sampleRate, outputChannelConfig, encoding, specifiedBufferSize, processingEnabled, canApplyPlaybackParameters, availableAudioProcessors);
        if (this.isInitialized()) {
            if (!pendingConfiguration.canReuseAudioTrack(this.configuration)) {
                this.flush();
            } else if (flushAudioProcessors) {
                this.pendingConfiguration = pendingConfiguration;
                return;
            }
        }
        this.configuration = pendingConfiguration;
    }

    private void setupAudioProcessors() {
        AudioProcessor[] audioProcessors = this.configuration.availableAudioProcessors;
        ArrayList<AudioProcessor> newAudioProcessors = new ArrayList<AudioProcessor>();
        for (AudioProcessor audioProcessor : audioProcessors) {
            if (audioProcessor.isActive()) {
                newAudioProcessors.add(audioProcessor);
                continue;
            }
            audioProcessor.flush();
        }
        int count = newAudioProcessors.size();
        this.activeAudioProcessors = newAudioProcessors.toArray(new AudioProcessor[count]);
        this.outputBuffers = new ByteBuffer[count];
        this.flushAudioProcessors();
    }

    private void flushAudioProcessors() {
        for (int i = 0; i < this.activeAudioProcessors.length; ++i) {
            AudioProcessor audioProcessor = this.activeAudioProcessors[i];
            audioProcessor.flush();
            this.outputBuffers[i] = audioProcessor.getOutput();
        }
    }

    private void initialize() throws AudioSink.InitializationException {
        this.releasingConditionVariable.block();
        this.audioTrack = Assertions.checkNotNull(this.configuration).buildAudioTrack(this.tunneling, this.audioAttributes, this.audioSessionId);
        int audioSessionId = this.audioTrack.getAudioSessionId();
        if (enablePreV21AudioSessionWorkaround && Util.SDK_INT < 21) {
            if (this.keepSessionIdAudioTrack != null && audioSessionId != this.keepSessionIdAudioTrack.getAudioSessionId()) {
                this.releaseKeepSessionIdAudioTrack();
            }
            if (this.keepSessionIdAudioTrack == null) {
                this.keepSessionIdAudioTrack = DefaultAudioSink.initializeKeepSessionIdAudioTrack(audioSessionId);
            }
        }
        if (this.audioSessionId != audioSessionId) {
            this.audioSessionId = audioSessionId;
            if (this.listener != null) {
                this.listener.onAudioSessionId(audioSessionId);
            }
        }
        this.playbackParameters = this.configuration.canApplyPlaybackParameters ? this.audioProcessorChain.applyPlaybackParameters(this.playbackParameters) : PlaybackParameters.DEFAULT;
        this.setupAudioProcessors();
        this.audioTrackPositionTracker.setAudioTrack(this.audioTrack, this.configuration.outputEncoding, this.configuration.outputPcmFrameSize, this.configuration.bufferSize);
        this.setVolumeInternal();
        if (this.auxEffectInfo.effectId != 0) {
            this.audioTrack.attachAuxEffect(this.auxEffectInfo.effectId);
            this.audioTrack.setAuxEffectSendLevel(this.auxEffectInfo.sendLevel);
        }
    }

    @Override
    public void play() {
        this.playing = true;
        if (this.isInitialized()) {
            this.audioTrackPositionTracker.start();
            this.audioTrack.play();
        }
    }

    @Override
    public void handleDiscontinuity() {
        if (this.startMediaTimeState == 1) {
            this.startMediaTimeState = 2;
        }
    }

    @Override
    public boolean handleBuffer(ByteBuffer buffer, long presentationTimeUs) throws AudioSink.InitializationException, AudioSink.WriteException {
        Assertions.checkArgument(this.inputBuffer == null || buffer == this.inputBuffer);
        if (this.pendingConfiguration != null) {
            if (!this.drainAudioProcessorsToEndOfStream()) {
                return false;
            }
            this.configuration = this.pendingConfiguration;
            this.pendingConfiguration = null;
            this.playbackParameters = this.configuration.canApplyPlaybackParameters ? this.audioProcessorChain.applyPlaybackParameters(this.playbackParameters) : PlaybackParameters.DEFAULT;
            this.setupAudioProcessors();
        }
        if (!this.isInitialized()) {
            this.initialize();
            if (this.playing) {
                this.play();
            }
        }
        if (!this.audioTrackPositionTracker.mayHandleBuffer(this.getWrittenFrames())) {
            return false;
        }
        if (this.inputBuffer == null) {
            if (!buffer.hasRemaining()) {
                return true;
            }
            if (!this.configuration.isInputPcm && this.framesPerEncodedSample == 0) {
                this.framesPerEncodedSample = DefaultAudioSink.getFramesPerEncodedSample(this.configuration.outputEncoding, buffer);
                if (this.framesPerEncodedSample == 0) {
                    return true;
                }
            }
            if (this.afterDrainPlaybackParameters != null) {
                if (!this.drainAudioProcessorsToEndOfStream()) {
                    return false;
                }
                PlaybackParameters newPlaybackParameters = this.afterDrainPlaybackParameters;
                this.afterDrainPlaybackParameters = null;
                newPlaybackParameters = this.audioProcessorChain.applyPlaybackParameters(newPlaybackParameters);
                this.playbackParametersCheckpoints.add(new PlaybackParametersCheckpoint(newPlaybackParameters, Math.max(0L, presentationTimeUs), this.configuration.framesToDurationUs(this.getWrittenFrames())));
                this.setupAudioProcessors();
            }
            if (this.startMediaTimeState == 0) {
                this.startMediaTimeUs = Math.max(0L, presentationTimeUs);
                this.startMediaTimeState = 1;
            } else {
                long expectedPresentationTimeUs = this.startMediaTimeUs + this.configuration.inputFramesToDurationUs(this.getSubmittedFrames() - this.trimmingAudioProcessor.getTrimmedFrameCount());
                if (this.startMediaTimeState == 1 && Math.abs(expectedPresentationTimeUs - presentationTimeUs) > 200000L) {
                    Log.e(TAG, "Discontinuity detected [expected " + expectedPresentationTimeUs + ", got " + presentationTimeUs + "]");
                    this.startMediaTimeState = 2;
                }
                if (this.startMediaTimeState == 2) {
                    long adjustmentUs = presentationTimeUs - expectedPresentationTimeUs;
                    this.startMediaTimeUs += adjustmentUs;
                    this.startMediaTimeState = 1;
                    if (this.listener != null && adjustmentUs != 0L) {
                        this.listener.onPositionDiscontinuity();
                    }
                }
            }
            if (this.configuration.isInputPcm) {
                this.submittedPcmBytes += (long)buffer.remaining();
            } else {
                this.submittedEncodedFrames += (long)this.framesPerEncodedSample;
            }
            this.inputBuffer = buffer;
        }
        if (this.configuration.processingEnabled) {
            this.processBuffers(presentationTimeUs);
        } else {
            this.writeBuffer(this.inputBuffer, presentationTimeUs);
        }
        if (!this.inputBuffer.hasRemaining()) {
            this.inputBuffer = null;
            return true;
        }
        if (this.audioTrackPositionTracker.isStalled(this.getWrittenFrames())) {
            Log.w(TAG, "Resetting stalled audio track");
            this.flush();
            return true;
        }
        return false;
    }

    private void processBuffers(long avSyncPresentationTimeUs) throws AudioSink.WriteException {
        int count;
        int index = count = this.activeAudioProcessors.length;
        while (index >= 0) {
            ByteBuffer input;
            ByteBuffer byteBuffer = index > 0 ? this.outputBuffers[index - 1] : (input = this.inputBuffer != null ? this.inputBuffer : AudioProcessor.EMPTY_BUFFER);
            if (index == count) {
                this.writeBuffer(input, avSyncPresentationTimeUs);
            } else {
                ByteBuffer output;
                AudioProcessor audioProcessor = this.activeAudioProcessors[index];
                audioProcessor.queueInput(input);
                this.outputBuffers[index] = output = audioProcessor.getOutput();
                if (output.hasRemaining()) {
                    ++index;
                    continue;
                }
            }
            if (input.hasRemaining()) {
                return;
            }
            --index;
        }
    }

    private void writeBuffer(ByteBuffer buffer, long avSyncPresentationTimeUs) throws AudioSink.WriteException {
        int bytesRemaining;
        if (!buffer.hasRemaining()) {
            return;
        }
        if (this.outputBuffer != null) {
            Assertions.checkArgument(this.outputBuffer == buffer);
        } else {
            this.outputBuffer = buffer;
            if (Util.SDK_INT < 21) {
                bytesRemaining = buffer.remaining();
                if (this.preV21OutputBuffer == null || this.preV21OutputBuffer.length < bytesRemaining) {
                    this.preV21OutputBuffer = new byte[bytesRemaining];
                }
                int originalPosition = buffer.position();
                buffer.get(this.preV21OutputBuffer, 0, bytesRemaining);
                buffer.position(originalPosition);
                this.preV21OutputBufferOffset = 0;
            }
        }
        bytesRemaining = buffer.remaining();
        int bytesWritten = 0;
        if (Util.SDK_INT < 21) {
            int bytesToWrite = this.audioTrackPositionTracker.getAvailableBufferSize(this.writtenPcmBytes);
            if (bytesToWrite > 0 && (bytesWritten = this.audioTrack.write(this.preV21OutputBuffer, this.preV21OutputBufferOffset, bytesToWrite = Math.min(bytesRemaining, bytesToWrite))) > 0) {
                this.preV21OutputBufferOffset += bytesWritten;
                buffer.position(buffer.position() + bytesWritten);
            }
        } else if (this.tunneling) {
            Assertions.checkState(avSyncPresentationTimeUs != -9223372036854775807L);
            bytesWritten = this.writeNonBlockingWithAvSyncV21(this.audioTrack, buffer, bytesRemaining, avSyncPresentationTimeUs);
        } else {
            bytesWritten = DefaultAudioSink.writeNonBlockingV21(this.audioTrack, buffer, bytesRemaining);
        }
        this.lastFeedElapsedRealtimeMs = SystemClock.elapsedRealtime();
        if (bytesWritten < 0) {
            throw new AudioSink.WriteException(bytesWritten);
        }
        if (this.configuration.isInputPcm) {
            this.writtenPcmBytes += (long)bytesWritten;
        }
        if (bytesWritten == bytesRemaining) {
            if (!this.configuration.isInputPcm) {
                this.writtenEncodedFrames += (long)this.framesPerEncodedSample;
            }
            this.outputBuffer = null;
        }
    }

    @Override
    public void playToEndOfStream() throws AudioSink.WriteException {
        if (this.handledEndOfStream || !this.isInitialized()) {
            return;
        }
        if (this.drainAudioProcessorsToEndOfStream()) {
            this.audioTrackPositionTracker.handleEndOfStream(this.getWrittenFrames());
            this.audioTrack.stop();
            this.bytesUntilNextAvSync = 0;
            this.handledEndOfStream = true;
        }
    }

    private boolean drainAudioProcessorsToEndOfStream() throws AudioSink.WriteException {
        boolean audioProcessorNeedsEndOfStream = false;
        if (this.drainingAudioProcessorIndex == -1) {
            this.drainingAudioProcessorIndex = this.configuration.processingEnabled ? 0 : this.activeAudioProcessors.length;
            audioProcessorNeedsEndOfStream = true;
        }
        while (this.drainingAudioProcessorIndex < this.activeAudioProcessors.length) {
            AudioProcessor audioProcessor = this.activeAudioProcessors[this.drainingAudioProcessorIndex];
            if (audioProcessorNeedsEndOfStream) {
                audioProcessor.queueEndOfStream();
            }
            this.processBuffers(-9223372036854775807L);
            if (!audioProcessor.isEnded()) {
                return false;
            }
            audioProcessorNeedsEndOfStream = true;
            ++this.drainingAudioProcessorIndex;
        }
        if (this.outputBuffer != null) {
            this.writeBuffer(this.outputBuffer, -9223372036854775807L);
            if (this.outputBuffer != null) {
                return false;
            }
        }
        this.drainingAudioProcessorIndex = -1;
        return true;
    }

    @Override
    public boolean isEnded() {
        return !this.isInitialized() || this.handledEndOfStream && !this.hasPendingData();
    }

    @Override
    public boolean hasPendingData() {
        return this.isInitialized() && this.audioTrackPositionTracker.hasPendingData(this.getWrittenFrames());
    }

    @Override
    public PlaybackParameters setPlaybackParameters(PlaybackParameters playbackParameters) {
        PlaybackParameters lastSetPlaybackParameters;
        if (this.configuration != null && !this.configuration.canApplyPlaybackParameters) {
            this.playbackParameters = PlaybackParameters.DEFAULT;
            return this.playbackParameters;
        }
        PlaybackParameters playbackParameters2 = this.afterDrainPlaybackParameters != null ? this.afterDrainPlaybackParameters : (lastSetPlaybackParameters = !this.playbackParametersCheckpoints.isEmpty() ? this.playbackParametersCheckpoints.getLast().playbackParameters : this.playbackParameters);
        if (!playbackParameters.equals(lastSetPlaybackParameters)) {
            if (this.isInitialized()) {
                this.afterDrainPlaybackParameters = playbackParameters;
            } else {
                this.playbackParameters = this.audioProcessorChain.applyPlaybackParameters(playbackParameters);
            }
        }
        return this.playbackParameters;
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.playbackParameters;
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        if (this.audioAttributes.equals(audioAttributes)) {
            return;
        }
        this.audioAttributes = audioAttributes;
        if (this.tunneling) {
            return;
        }
        this.flush();
        this.audioSessionId = 0;
    }

    @Override
    public void setAudioSessionId(int audioSessionId) {
        if (this.audioSessionId != audioSessionId) {
            this.audioSessionId = audioSessionId;
            this.flush();
        }
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        if (this.auxEffectInfo.equals(auxEffectInfo)) {
            return;
        }
        int effectId = auxEffectInfo.effectId;
        float sendLevel = auxEffectInfo.sendLevel;
        if (this.audioTrack != null) {
            if (this.auxEffectInfo.effectId != effectId) {
                this.audioTrack.attachAuxEffect(effectId);
            }
            if (effectId != 0) {
                this.audioTrack.setAuxEffectSendLevel(sendLevel);
            }
        }
        this.auxEffectInfo = auxEffectInfo;
    }

    @Override
    public void enableTunnelingV21(int tunnelingAudioSessionId) {
        Assertions.checkState(Util.SDK_INT >= 21);
        if (!this.tunneling || this.audioSessionId != tunnelingAudioSessionId) {
            this.tunneling = true;
            this.audioSessionId = tunnelingAudioSessionId;
            this.flush();
        }
    }

    @Override
    public void disableTunneling() {
        if (this.tunneling) {
            this.tunneling = false;
            this.audioSessionId = 0;
            this.flush();
        }
    }

    @Override
    public void setVolume(float volume) {
        if (this.volume != volume) {
            this.volume = volume;
            this.setVolumeInternal();
        }
    }

    private void setVolumeInternal() {
        if (this.isInitialized()) {
            if (Util.SDK_INT >= 21) {
                DefaultAudioSink.setVolumeInternalV21(this.audioTrack, this.volume);
            } else {
                DefaultAudioSink.setVolumeInternalV3(this.audioTrack, this.volume);
            }
        }
    }

    @Override
    public void pause() {
        this.playing = false;
        if (this.isInitialized() && this.audioTrackPositionTracker.pause()) {
            this.audioTrack.pause();
        }
    }

    @Override
    public void flush() {
        if (this.isInitialized()) {
            this.submittedPcmBytes = 0L;
            this.submittedEncodedFrames = 0L;
            this.writtenPcmBytes = 0L;
            this.writtenEncodedFrames = 0L;
            this.framesPerEncodedSample = 0;
            if (this.afterDrainPlaybackParameters != null) {
                this.playbackParameters = this.afterDrainPlaybackParameters;
                this.afterDrainPlaybackParameters = null;
            } else if (!this.playbackParametersCheckpoints.isEmpty()) {
                this.playbackParameters = this.playbackParametersCheckpoints.getLast().playbackParameters;
            }
            this.playbackParametersCheckpoints.clear();
            this.playbackParametersOffsetUs = 0L;
            this.playbackParametersPositionUs = 0L;
            this.trimmingAudioProcessor.resetTrimmedFrameCount();
            this.flushAudioProcessors();
            this.inputBuffer = null;
            this.outputBuffer = null;
            this.handledEndOfStream = false;
            this.drainingAudioProcessorIndex = -1;
            this.avSyncHeader = null;
            this.bytesUntilNextAvSync = 0;
            this.startMediaTimeState = 0;
            if (this.audioTrackPositionTracker.isPlaying()) {
                this.audioTrack.pause();
            }
            final AudioTrack toRelease = this.audioTrack;
            this.audioTrack = null;
            if (this.pendingConfiguration != null) {
                this.configuration = this.pendingConfiguration;
                this.pendingConfiguration = null;
            }
            this.audioTrackPositionTracker.reset();
            this.releasingConditionVariable.close();
            new Thread(){

                @Override
                public void run() {
                    try {
                        toRelease.flush();
                        toRelease.release();
                    }
                    finally {
                        DefaultAudioSink.this.releasingConditionVariable.open();
                    }
                }
            }.start();
        }
    }

    @Override
    public void reset() {
        this.flush();
        this.releaseKeepSessionIdAudioTrack();
        for (AudioProcessor audioProcessor : this.toIntPcmAvailableAudioProcessors) {
            audioProcessor.reset();
        }
        for (AudioProcessor audioProcessor : this.toFloatPcmAvailableAudioProcessors) {
            audioProcessor.reset();
        }
        this.audioSessionId = 0;
        this.playing = false;
    }

    private void releaseKeepSessionIdAudioTrack() {
        if (this.keepSessionIdAudioTrack == null) {
            return;
        }
        final AudioTrack toRelease = this.keepSessionIdAudioTrack;
        this.keepSessionIdAudioTrack = null;
        new Thread(){

            @Override
            public void run() {
                toRelease.release();
            }
        }.start();
    }

    private long applySpeedup(long positionUs) {
        PlaybackParametersCheckpoint checkpoint = null;
        while (!this.playbackParametersCheckpoints.isEmpty() && positionUs >= this.playbackParametersCheckpoints.getFirst().positionUs) {
            checkpoint = this.playbackParametersCheckpoints.remove();
        }
        if (checkpoint != null) {
            this.playbackParameters = checkpoint.playbackParameters;
            this.playbackParametersPositionUs = checkpoint.positionUs;
            this.playbackParametersOffsetUs = checkpoint.mediaTimeUs - this.startMediaTimeUs;
        }
        if (this.playbackParameters.speed == 1.0f) {
            return positionUs + this.playbackParametersOffsetUs - this.playbackParametersPositionUs;
        }
        if (this.playbackParametersCheckpoints.isEmpty()) {
            return this.playbackParametersOffsetUs + this.audioProcessorChain.getMediaDuration(positionUs - this.playbackParametersPositionUs);
        }
        return this.playbackParametersOffsetUs + Util.getMediaDurationForPlayoutDuration(positionUs - this.playbackParametersPositionUs, this.playbackParameters.speed);
    }

    private long applySkipping(long positionUs) {
        return positionUs + this.configuration.framesToDurationUs(this.audioProcessorChain.getSkippedOutputFrameCount());
    }

    private boolean isInitialized() {
        return this.audioTrack != null;
    }

    private long getSubmittedFrames() {
        return this.configuration.isInputPcm ? this.submittedPcmBytes / (long)this.configuration.inputPcmFrameSize : this.submittedEncodedFrames;
    }

    private long getWrittenFrames() {
        return this.configuration.isInputPcm ? this.writtenPcmBytes / (long)this.configuration.outputPcmFrameSize : this.writtenEncodedFrames;
    }

    private static AudioTrack initializeKeepSessionIdAudioTrack(int audioSessionId) {
        int sampleRate = 4000;
        int channelConfig = 4;
        int encoding = 2;
        int bufferSize = 2;
        return new AudioTrack(3, sampleRate, channelConfig, encoding, bufferSize, 0, audioSessionId);
    }

    private static int getChannelConfig(int channelCount, boolean isInputPcm) {
        if (Util.SDK_INT <= 28 && !isInputPcm) {
            if (channelCount == 7) {
                channelCount = 8;
            } else if (channelCount == 3 || channelCount == 4 || channelCount == 5) {
                channelCount = 6;
            }
        }
        if (Util.SDK_INT <= 26 && "fugu".equals(Util.DEVICE) && !isInputPcm && channelCount == 1) {
            channelCount = 2;
        }
        return Util.getAudioTrackChannelConfig(channelCount);
    }

    private static int getMaximumEncodedRateBytesPerSecond(int encoding) {
        switch (encoding) {
            case 5: {
                return 80000;
            }
            case 6: {
                return 768000;
            }
            case 17: {
                return 336000;
            }
            case 7: {
                return 192000;
            }
            case 8: {
                return 2250000;
            }
            case 14: {
                return 3062500;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int getFramesPerEncodedSample(int encoding, ByteBuffer buffer) {
        if (encoding == 7 || encoding == 8) {
            return DtsUtil.parseDtsAudioSampleCount(buffer);
        }
        if (encoding == 5) {
            return Ac3Util.getAc3SyncframeAudioSampleCount();
        }
        if (encoding == 6) {
            return Ac3Util.parseEAc3SyncframeAudioSampleCount(buffer);
        }
        if (encoding == 17) {
            return Ac4Util.parseAc4SyncframeAudioSampleCount(buffer);
        }
        if (encoding == 14) {
            int syncframeOffset = Ac3Util.findTrueHdSyncframeOffset(buffer);
            return syncframeOffset == -1 ? 0 : Ac3Util.parseTrueHdSyncframeAudioSampleCount(buffer, syncframeOffset) * 16;
        }
        throw new IllegalStateException("Unexpected audio encoding: " + encoding);
    }

    @TargetApi(value=21)
    private static int writeNonBlockingV21(AudioTrack audioTrack, ByteBuffer buffer, int size) {
        return audioTrack.write(buffer, size, 1);
    }

    @TargetApi(value=21)
    private int writeNonBlockingWithAvSyncV21(AudioTrack audioTrack, ByteBuffer buffer, int size, long presentationTimeUs) {
        int result;
        int avSyncHeaderBytesRemaining;
        if (this.avSyncHeader == null) {
            this.avSyncHeader = ByteBuffer.allocate(16);
            this.avSyncHeader.order(ByteOrder.BIG_ENDIAN);
            this.avSyncHeader.putInt(0x55550001);
        }
        if (this.bytesUntilNextAvSync == 0) {
            this.avSyncHeader.putInt(4, size);
            this.avSyncHeader.putLong(8, presentationTimeUs * 1000L);
            this.avSyncHeader.position(0);
            this.bytesUntilNextAvSync = size;
        }
        if ((avSyncHeaderBytesRemaining = this.avSyncHeader.remaining()) > 0) {
            result = audioTrack.write(this.avSyncHeader, avSyncHeaderBytesRemaining, 1);
            if (result < 0) {
                this.bytesUntilNextAvSync = 0;
                return result;
            }
            if (result < avSyncHeaderBytesRemaining) {
                return 0;
            }
        }
        if ((result = DefaultAudioSink.writeNonBlockingV21(audioTrack, buffer, size)) < 0) {
            this.bytesUntilNextAvSync = 0;
            return result;
        }
        this.bytesUntilNextAvSync -= result;
        return result;
    }

    @TargetApi(value=21)
    private static void setVolumeInternalV21(AudioTrack audioTrack, float volume) {
        audioTrack.setVolume(volume);
    }

    private static void setVolumeInternalV3(AudioTrack audioTrack, float volume) {
        audioTrack.setStereoVolume(volume, volume);
    }

    private static final class Configuration {
        public final boolean isInputPcm;
        public final int inputPcmFrameSize;
        public final int inputSampleRate;
        public final int outputPcmFrameSize;
        public final int outputSampleRate;
        public final int outputChannelConfig;
        public final int outputEncoding;
        public final int bufferSize;
        public final boolean processingEnabled;
        public final boolean canApplyPlaybackParameters;
        public final AudioProcessor[] availableAudioProcessors;

        public Configuration(boolean isInputPcm, int inputPcmFrameSize, int inputSampleRate, int outputPcmFrameSize, int outputSampleRate, int outputChannelConfig, int outputEncoding, int specifiedBufferSize, boolean processingEnabled, boolean canApplyPlaybackParameters, AudioProcessor[] availableAudioProcessors) {
            this.isInputPcm = isInputPcm;
            this.inputPcmFrameSize = inputPcmFrameSize;
            this.inputSampleRate = inputSampleRate;
            this.outputPcmFrameSize = outputPcmFrameSize;
            this.outputSampleRate = outputSampleRate;
            this.outputChannelConfig = outputChannelConfig;
            this.outputEncoding = outputEncoding;
            this.bufferSize = specifiedBufferSize != 0 ? specifiedBufferSize : this.getDefaultBufferSize();
            this.processingEnabled = processingEnabled;
            this.canApplyPlaybackParameters = canApplyPlaybackParameters;
            this.availableAudioProcessors = availableAudioProcessors;
        }

        public boolean canReuseAudioTrack(Configuration audioTrackConfiguration) {
            return audioTrackConfiguration.outputEncoding == this.outputEncoding && audioTrackConfiguration.outputSampleRate == this.outputSampleRate && audioTrackConfiguration.outputChannelConfig == this.outputChannelConfig;
        }

        public long inputFramesToDurationUs(long frameCount) {
            return frameCount * 1000000L / (long)this.inputSampleRate;
        }

        public long framesToDurationUs(long frameCount) {
            return frameCount * 1000000L / (long)this.outputSampleRate;
        }

        public long durationUsToFrames(long durationUs) {
            return durationUs * (long)this.outputSampleRate / 1000000L;
        }

        public AudioTrack buildAudioTrack(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) throws AudioSink.InitializationException {
            AudioTrack audioTrack;
            if (Util.SDK_INT >= 21) {
                audioTrack = this.createAudioTrackV21(tunneling, audioAttributes, audioSessionId);
            } else {
                int streamType = Util.getStreamTypeForAudioUsage(audioAttributes.usage);
                audioTrack = audioSessionId == 0 ? new AudioTrack(streamType, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, this.bufferSize, 1) : new AudioTrack(streamType, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, this.bufferSize, 1, audioSessionId);
            }
            int state = audioTrack.getState();
            if (state != 1) {
                try {
                    audioTrack.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new AudioSink.InitializationException(state, this.outputSampleRate, this.outputChannelConfig, this.bufferSize);
            }
            return audioTrack;
        }

        @TargetApi(value=21)
        private AudioTrack createAudioTrackV21(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) {
            android.media.AudioAttributes attributes = tunneling ? new AudioAttributes.Builder().setContentType(3).setFlags(16).setUsage(1).build() : audioAttributes.getAudioAttributesV21();
            AudioFormat format = new AudioFormat.Builder().setChannelMask(this.outputChannelConfig).setEncoding(this.outputEncoding).setSampleRate(this.outputSampleRate).build();
            return new AudioTrack(attributes, format, this.bufferSize, 1, audioSessionId != 0 ? audioSessionId : 0);
        }

        private int getDefaultBufferSize() {
            if (this.isInputPcm) {
                int minBufferSize = AudioTrack.getMinBufferSize((int)this.outputSampleRate, (int)this.outputChannelConfig, (int)this.outputEncoding);
                Assertions.checkState(minBufferSize != -2);
                int multipliedBufferSize = minBufferSize * 4;
                int minAppBufferSize = (int)this.durationUsToFrames(250000L) * this.outputPcmFrameSize;
                int maxAppBufferSize = (int)Math.max((long)minBufferSize, this.durationUsToFrames(750000L) * (long)this.outputPcmFrameSize);
                return Util.constrainValue(multipliedBufferSize, minAppBufferSize, maxAppBufferSize);
            }
            int rate = DefaultAudioSink.getMaximumEncodedRateBytesPerSecond(this.outputEncoding);
            if (this.outputEncoding == 5) {
                rate *= 2;
            }
            return (int)(250000L * (long)rate / 1000000L);
        }
    }

    private final class PositionTrackerListener
    implements AudioTrackPositionTracker.Listener {
        private PositionTrackerListener() {
        }

        @Override
        public void onPositionFramesMismatch(long audioTimestampPositionFrames, long audioTimestampSystemTimeUs, long systemTimeUs, long playbackPositionUs) {
            String message = "Spurious audio timestamp (frame position mismatch): " + audioTimestampPositionFrames + ", " + audioTimestampSystemTimeUs + ", " + systemTimeUs + ", " + playbackPositionUs + ", " + DefaultAudioSink.this.getSubmittedFrames() + ", " + DefaultAudioSink.this.getWrittenFrames();
            if (failOnSpuriousAudioTimestamp) {
                throw new InvalidAudioTrackTimestampException(message);
            }
            Log.w(DefaultAudioSink.TAG, message);
        }

        @Override
        public void onSystemTimeUsMismatch(long audioTimestampPositionFrames, long audioTimestampSystemTimeUs, long systemTimeUs, long playbackPositionUs) {
            String message = "Spurious audio timestamp (system clock mismatch): " + audioTimestampPositionFrames + ", " + audioTimestampSystemTimeUs + ", " + systemTimeUs + ", " + playbackPositionUs + ", " + DefaultAudioSink.this.getSubmittedFrames() + ", " + DefaultAudioSink.this.getWrittenFrames();
            if (failOnSpuriousAudioTimestamp) {
                throw new InvalidAudioTrackTimestampException(message);
            }
            Log.w(DefaultAudioSink.TAG, message);
        }

        @Override
        public void onInvalidLatency(long latencyUs) {
            Log.w(DefaultAudioSink.TAG, "Ignoring impossibly large audio latency: " + latencyUs);
        }

        @Override
        public void onUnderrun(int bufferSize, long bufferSizeMs) {
            if (DefaultAudioSink.this.listener != null) {
                long elapsedSinceLastFeedMs = SystemClock.elapsedRealtime() - DefaultAudioSink.this.lastFeedElapsedRealtimeMs;
                DefaultAudioSink.this.listener.onUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }
    }

    private static final class PlaybackParametersCheckpoint {
        private final PlaybackParameters playbackParameters;
        private final long mediaTimeUs;
        private final long positionUs;

        private PlaybackParametersCheckpoint(PlaybackParameters playbackParameters, long mediaTimeUs, long positionUs) {
            this.playbackParameters = playbackParameters;
            this.mediaTimeUs = mediaTimeUs;
            this.positionUs = positionUs;
        }
    }

    public static class DefaultAudioProcessorChain
    implements AudioProcessorChain {
        private final AudioProcessor[] audioProcessors;
        private final SilenceSkippingAudioProcessor silenceSkippingAudioProcessor;
        private final SonicAudioProcessor sonicAudioProcessor;

        public DefaultAudioProcessorChain(AudioProcessor ... audioProcessors) {
            this.audioProcessors = Arrays.copyOf(audioProcessors, audioProcessors.length + 2);
            this.silenceSkippingAudioProcessor = new SilenceSkippingAudioProcessor();
            this.sonicAudioProcessor = new SonicAudioProcessor();
            this.audioProcessors[audioProcessors.length] = this.silenceSkippingAudioProcessor;
            this.audioProcessors[audioProcessors.length + 1] = this.sonicAudioProcessor;
        }

        @Override
        public AudioProcessor[] getAudioProcessors() {
            return this.audioProcessors;
        }

        @Override
        public PlaybackParameters applyPlaybackParameters(PlaybackParameters playbackParameters) {
            this.silenceSkippingAudioProcessor.setEnabled(playbackParameters.skipSilence);
            return new PlaybackParameters(this.sonicAudioProcessor.setSpeed(playbackParameters.speed), this.sonicAudioProcessor.setPitch(playbackParameters.pitch), playbackParameters.skipSilence);
        }

        @Override
        public long getMediaDuration(long playoutDuration) {
            return this.sonicAudioProcessor.scaleDurationForSpeedup(playoutDuration);
        }

        @Override
        public long getSkippedOutputFrameCount() {
            return this.silenceSkippingAudioProcessor.getSkippedFrames();
        }
    }

    public static interface AudioProcessorChain {
        public AudioProcessor[] getAudioProcessors();

        public PlaybackParameters applyPlaybackParameters(PlaybackParameters var1);

        public long getMediaDuration(long var1);

        public long getSkippedOutputFrameCount();
    }

    public static final class InvalidAudioTrackTimestampException
    extends RuntimeException {
        private InvalidAudioTrackTimestampException(String message) {
            super(message);
        }
    }
}

