/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.util.Assertions;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class ChannelMappingAudioProcessor
extends BaseAudioProcessor {
    @Nullable
    private int[] pendingOutputChannels;
    private boolean active;
    @Nullable
    private int[] outputChannels;

    ChannelMappingAudioProcessor() {
    }

    public void setChannelMap(@Nullable int[] outputChannels) {
        this.pendingOutputChannels = outputChannels;
    }

    @Override
    public boolean configure(int sampleRateHz, int channelCount, int encoding) throws AudioProcessor.UnhandledFormatException {
        boolean outputChannelsChanged = !Arrays.equals(this.pendingOutputChannels, this.outputChannels);
        this.outputChannels = this.pendingOutputChannels;
        int[] outputChannels = this.outputChannels;
        if (outputChannels == null) {
            this.active = false;
            return outputChannelsChanged;
        }
        if (encoding != 2) {
            throw new AudioProcessor.UnhandledFormatException(sampleRateHz, channelCount, encoding);
        }
        if (!outputChannelsChanged && !this.setInputFormat(sampleRateHz, channelCount, encoding)) {
            return false;
        }
        this.active = channelCount != outputChannels.length;
        for (int i = 0; i < outputChannels.length; ++i) {
            int channelIndex = outputChannels[i];
            if (channelIndex >= channelCount) {
                throw new AudioProcessor.UnhandledFormatException(sampleRateHz, channelCount, encoding);
            }
            this.active |= channelIndex != i;
        }
        return true;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public int getOutputChannelCount() {
        return this.outputChannels == null ? this.channelCount : this.outputChannels.length;
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        int position;
        int[] outputChannels = Assertions.checkNotNull(this.outputChannels);
        int limit = inputBuffer.limit();
        int frameCount = (limit - position) / (2 * this.channelCount);
        int outputSize = frameCount * outputChannels.length * 2;
        ByteBuffer buffer = this.replaceOutputBuffer(outputSize);
        for (position = inputBuffer.position(); position < limit; position += this.channelCount * 2) {
            for (int channelIndex : outputChannels) {
                buffer.putShort(inputBuffer.getShort(position + 2 * channelIndex));
            }
        }
        inputBuffer.position(limit);
        buffer.flip();
    }

    @Override
    protected void onReset() {
        this.outputChannels = null;
        this.pendingOutputChannels = null;
        this.active = false;
    }
}

