/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.CallSuper;
import com.google.android.exoplayer2.audio.AudioProcessor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class BaseAudioProcessor
implements AudioProcessor {
    protected int sampleRateHz = -1;
    protected int channelCount = -1;
    protected int encoding = -1;
    private ByteBuffer buffer = EMPTY_BUFFER;
    private ByteBuffer outputBuffer = EMPTY_BUFFER;
    private boolean inputEnded;

    @Override
    public boolean isActive() {
        return this.sampleRateHz != -1;
    }

    @Override
    public int getOutputChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getOutputEncoding() {
        return this.encoding;
    }

    @Override
    public int getOutputSampleRateHz() {
        return this.sampleRateHz;
    }

    @Override
    public final void queueEndOfStream() {
        this.inputEnded = true;
        this.onQueueEndOfStream();
    }

    @Override
    @CallSuper
    public ByteBuffer getOutput() {
        ByteBuffer outputBuffer = this.outputBuffer;
        this.outputBuffer = EMPTY_BUFFER;
        return outputBuffer;
    }

    @Override
    @CallSuper
    public boolean isEnded() {
        return this.inputEnded && this.outputBuffer == EMPTY_BUFFER;
    }

    @Override
    public final void flush() {
        this.outputBuffer = EMPTY_BUFFER;
        this.inputEnded = false;
        this.onFlush();
    }

    @Override
    public final void reset() {
        this.flush();
        this.buffer = EMPTY_BUFFER;
        this.sampleRateHz = -1;
        this.channelCount = -1;
        this.encoding = -1;
        this.onReset();
    }

    protected final boolean setInputFormat(int sampleRateHz, int channelCount, int encoding) {
        if (sampleRateHz == this.sampleRateHz && channelCount == this.channelCount && encoding == this.encoding) {
            return false;
        }
        this.sampleRateHz = sampleRateHz;
        this.channelCount = channelCount;
        this.encoding = encoding;
        return true;
    }

    protected final ByteBuffer replaceOutputBuffer(int count) {
        if (this.buffer.capacity() < count) {
            this.buffer = ByteBuffer.allocateDirect(count).order(ByteOrder.nativeOrder());
        } else {
            this.buffer.clear();
        }
        this.outputBuffer = this.buffer;
        return this.buffer;
    }

    protected final boolean hasPendingOutput() {
        return this.outputBuffer.hasRemaining();
    }

    protected void onQueueEndOfStream() {
    }

    protected void onFlush() {
    }

    protected void onReset() {
    }
}

