/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import java.nio.ByteBuffer;

public interface AudioSink {
    public static final long CURRENT_POSITION_NOT_SET = Long.MIN_VALUE;

    public void setListener(Listener var1);

    public boolean supportsOutput(int var1, int var2);

    public long getCurrentPositionUs(boolean var1);

    public void configure(int var1, int var2, int var3, int var4, @Nullable int[] var5, int var6, int var7) throws ConfigurationException;

    public void play();

    public void handleDiscontinuity();

    public boolean handleBuffer(ByteBuffer var1, long var2) throws InitializationException, WriteException;

    public void playToEndOfStream() throws WriteException;

    public boolean isEnded();

    public boolean hasPendingData();

    public PlaybackParameters setPlaybackParameters(PlaybackParameters var1);

    public PlaybackParameters getPlaybackParameters();

    public void setAudioAttributes(AudioAttributes var1);

    public void setAudioSessionId(int var1);

    public void setAuxEffectInfo(AuxEffectInfo var1);

    public void enableTunnelingV21(int var1);

    public void disableTunneling();

    public void setVolume(float var1);

    public void pause();

    public void flush();

    public void reset();

    public static final class WriteException
    extends Exception {
        public final int errorCode;

        public WriteException(int errorCode) {
            super("AudioTrack write failed: " + errorCode);
            this.errorCode = errorCode;
        }
    }

    public static final class InitializationException
    extends Exception {
        public final int audioTrackState;

        public InitializationException(int audioTrackState, int sampleRate, int channelConfig, int bufferSize) {
            super("AudioTrack init failed: " + audioTrackState + ", Config(" + sampleRate + ", " + channelConfig + ", " + bufferSize + ")");
            this.audioTrackState = audioTrackState;
        }
    }

    public static final class ConfigurationException
    extends Exception {
        public ConfigurationException(Throwable cause) {
            super(cause);
        }

        public ConfigurationException(String message) {
            super(message);
        }
    }

    public static interface Listener {
        public void onAudioSessionId(int var1);

        public void onPositionDiscontinuity();

        public void onUnderrun(int var1, long var2, long var4);
    }
}

