/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.util.Assertions;

public interface AudioRendererEventListener {
    default public void onAudioEnabled(DecoderCounters counters) {
    }

    default public void onAudioSessionId(int audioSessionId) {
    }

    default public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    default public void onAudioInputFormatChanged(Format format) {
    }

    default public void onAudioSinkUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    default public void onAudioDisabled(DecoderCounters counters) {
    }

    public static final class EventDispatcher {
        @Nullable
        private final Handler handler;
        @Nullable
        private final AudioRendererEventListener listener;

        public EventDispatcher(@Nullable Handler handler, @Nullable AudioRendererEventListener listener) {
            this.handler = listener != null ? Assertions.checkNotNull(handler) : null;
            this.listener = listener;
        }

        public void enabled(DecoderCounters decoderCounters) {
            if (this.listener != null) {
                this.handler.post(() -> this.listener.onAudioEnabled(decoderCounters));
            }
        }

        public void decoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            if (this.listener != null) {
                this.handler.post(() -> this.listener.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs));
            }
        }

        public void inputFormatChanged(Format format) {
            if (this.listener != null) {
                this.handler.post(() -> this.listener.onAudioInputFormatChanged(format));
            }
        }

        public void audioTrackUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            if (this.listener != null) {
                this.handler.post(() -> this.listener.onAudioSinkUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs));
            }
        }

        public void disabled(DecoderCounters counters) {
            counters.ensureUpdated();
            if (this.listener != null) {
                this.handler.post(() -> {
                    counters.ensureUpdated();
                    this.listener.onAudioDisabled(counters);
                });
            }
        }

        public void audioSessionId(int audioSessionId) {
            if (this.listener != null) {
                this.handler.post(() -> this.listener.onAudioSessionId(audioSessionId));
            }
        }
    }
}

