/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;

public final class AudioCapabilitiesReceiver {
    private final Context context;
    private final Listener listener;
    private final Handler handler;
    @Nullable
    private final BroadcastReceiver receiver;
    @Nullable
    private final ExternalSurroundSoundSettingObserver externalSurroundSoundSettingObserver;
    @Nullable
    AudioCapabilities audioCapabilities;
    private boolean registered;

    public AudioCapabilitiesReceiver(Context context, Listener listener) {
        this.context = context = context.getApplicationContext();
        this.listener = Assertions.checkNotNull(listener);
        this.handler = new Handler(Util.getLooper());
        this.receiver = Util.SDK_INT >= 21 ? new HdmiAudioPlugBroadcastReceiver() : null;
        Uri externalSurroundSoundUri = AudioCapabilities.getExternalSurroundSoundGlobalSettingUri();
        this.externalSurroundSoundSettingObserver = externalSurroundSoundUri != null ? new ExternalSurroundSoundSettingObserver(this.handler, context.getContentResolver(), externalSurroundSoundUri) : null;
    }

    public AudioCapabilities register() {
        if (this.registered) {
            return Assertions.checkNotNull(this.audioCapabilities);
        }
        this.registered = true;
        if (this.externalSurroundSoundSettingObserver != null) {
            this.externalSurroundSoundSettingObserver.register();
        }
        Intent stickyIntent = null;
        if (this.receiver != null) {
            IntentFilter intentFilter = new IntentFilter("android.media.action.HDMI_AUDIO_PLUG");
            stickyIntent = this.context.registerReceiver(this.receiver, intentFilter, null, this.handler);
        }
        this.audioCapabilities = AudioCapabilities.getCapabilities(this.context, stickyIntent);
        return this.audioCapabilities;
    }

    public void unregister() {
        if (!this.registered) {
            return;
        }
        this.audioCapabilities = null;
        if (this.receiver != null) {
            this.context.unregisterReceiver(this.receiver);
        }
        if (this.externalSurroundSoundSettingObserver != null) {
            this.externalSurroundSoundSettingObserver.unregister();
        }
        this.registered = false;
    }

    private void onNewAudioCapabilities(AudioCapabilities newAudioCapabilities) {
        if (this.registered && !newAudioCapabilities.equals(this.audioCapabilities)) {
            this.audioCapabilities = newAudioCapabilities;
            this.listener.onAudioCapabilitiesChanged(newAudioCapabilities);
        }
    }

    private final class ExternalSurroundSoundSettingObserver
    extends ContentObserver {
        private final ContentResolver resolver;
        private final Uri settingUri;

        public ExternalSurroundSoundSettingObserver(Handler handler, ContentResolver resolver, Uri settingUri) {
            super(handler);
            this.resolver = resolver;
            this.settingUri = settingUri;
        }

        public void register() {
            this.resolver.registerContentObserver(this.settingUri, false, (ContentObserver)this);
        }

        public void unregister() {
            this.resolver.unregisterContentObserver((ContentObserver)this);
        }

        public void onChange(boolean selfChange) {
            AudioCapabilitiesReceiver.this.onNewAudioCapabilities(AudioCapabilities.getCapabilities(AudioCapabilitiesReceiver.this.context));
        }
    }

    private final class HdmiAudioPlugBroadcastReceiver
    extends BroadcastReceiver {
        private HdmiAudioPlugBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!this.isInitialStickyBroadcast()) {
                AudioCapabilitiesReceiver.this.onNewAudioCapabilities(AudioCapabilities.getCapabilities(context, intent));
            }
        }
    }

    public static interface Listener {
        public void onAudioCapabilitiesChanged(AudioCapabilities var1);
    }
}

