/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.analytics;

import android.view.Surface;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import java.io.IOException;

public interface AnalyticsListener {
    default public void onPlayerStateChanged(EventTime eventTime, boolean playWhenReady, int playbackState) {
    }

    default public void onTimelineChanged(EventTime eventTime, int reason) {
    }

    default public void onPositionDiscontinuity(EventTime eventTime, int reason) {
    }

    default public void onSeekStarted(EventTime eventTime) {
    }

    default public void onSeekProcessed(EventTime eventTime) {
    }

    default public void onPlaybackParametersChanged(EventTime eventTime, PlaybackParameters playbackParameters) {
    }

    default public void onRepeatModeChanged(EventTime eventTime, int repeatMode) {
    }

    default public void onShuffleModeChanged(EventTime eventTime, boolean shuffleModeEnabled) {
    }

    default public void onLoadingChanged(EventTime eventTime, boolean isLoading) {
    }

    default public void onPlayerError(EventTime eventTime, ExoPlaybackException error) {
    }

    default public void onTracksChanged(EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    default public void onLoadStarted(EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    default public void onLoadCompleted(EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    default public void onLoadCanceled(EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    default public void onLoadError(EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
    }

    default public void onDownstreamFormatChanged(EventTime eventTime, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    default public void onUpstreamDiscarded(EventTime eventTime, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    default public void onMediaPeriodCreated(EventTime eventTime) {
    }

    default public void onMediaPeriodReleased(EventTime eventTime) {
    }

    default public void onReadingStarted(EventTime eventTime) {
    }

    default public void onBandwidthEstimate(EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    default public void onSurfaceSizeChanged(EventTime eventTime, int width, int height) {
    }

    default public void onMetadata(EventTime eventTime, Metadata metadata) {
    }

    default public void onDecoderEnabled(EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    default public void onDecoderInitialized(EventTime eventTime, int trackType, String decoderName, long initializationDurationMs) {
    }

    default public void onDecoderInputFormatChanged(EventTime eventTime, int trackType, Format format) {
    }

    default public void onDecoderDisabled(EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    default public void onAudioSessionId(EventTime eventTime, int audioSessionId) {
    }

    default public void onAudioAttributesChanged(EventTime eventTime, AudioAttributes audioAttributes) {
    }

    default public void onVolumeChanged(EventTime eventTime, float volume) {
    }

    default public void onAudioUnderrun(EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    default public void onDroppedVideoFrames(EventTime eventTime, int droppedFrames, long elapsedMs) {
    }

    default public void onVideoSizeChanged(EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
    }

    default public void onRenderedFirstFrame(EventTime eventTime, @Nullable Surface surface) {
    }

    default public void onDrmSessionAcquired(EventTime eventTime) {
    }

    default public void onDrmKeysLoaded(EventTime eventTime) {
    }

    default public void onDrmSessionManagerError(EventTime eventTime, Exception error) {
    }

    default public void onDrmKeysRestored(EventTime eventTime) {
    }

    default public void onDrmKeysRemoved(EventTime eventTime) {
    }

    default public void onDrmSessionReleased(EventTime eventTime) {
    }

    public static final class EventTime {
        public final long realtimeMs;
        public final Timeline timeline;
        public final int windowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId mediaPeriodId;
        public final long eventPlaybackPositionMs;
        public final long currentPlaybackPositionMs;
        public final long totalBufferedDurationMs;

        public EventTime(long realtimeMs, Timeline timeline, int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, long eventPlaybackPositionMs, long currentPlaybackPositionMs, long totalBufferedDurationMs) {
            this.realtimeMs = realtimeMs;
            this.timeline = timeline;
            this.windowIndex = windowIndex;
            this.mediaPeriodId = mediaPeriodId;
            this.eventPlaybackPositionMs = eventPlaybackPositionMs;
            this.currentPlaybackPositionMs = currentPlaybackPositionMs;
            this.totalBufferedDurationMs = totalBufferedDurationMs;
        }
    }
}

