/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImpl;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioFocusManager;
import com.google.android.exoplayer2.audio.AudioListener;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoFrameMetadataListener;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.android.exoplayer2.video.spherical.CameraMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

public class SimpleExoPlayer
extends BasePlayer
implements ExoPlayer,
Player.AudioComponent,
Player.VideoComponent,
Player.TextComponent,
Player.MetadataComponent {
    private static final String TAG = "SimpleExoPlayer";
    protected final Renderer[] renderers;
    private final ExoPlayerImpl player;
    private final Handler eventHandler;
    private final ComponentListener componentListener;
    private final CopyOnWriteArraySet<com.google.android.exoplayer2.video.VideoListener> videoListeners;
    private final CopyOnWriteArraySet<AudioListener> audioListeners;
    private final CopyOnWriteArraySet<TextOutput> textOutputs;
    private final CopyOnWriteArraySet<MetadataOutput> metadataOutputs;
    private final CopyOnWriteArraySet<VideoRendererEventListener> videoDebugListeners;
    private final CopyOnWriteArraySet<AudioRendererEventListener> audioDebugListeners;
    private final BandwidthMeter bandwidthMeter;
    private final AnalyticsCollector analyticsCollector;
    private final AudioFocusManager audioFocusManager;
    @Nullable
    private Format videoFormat;
    @Nullable
    private Format audioFormat;
    @Nullable
    private Surface surface;
    private boolean ownsSurface;
    private int videoScalingMode;
    @Nullable
    private SurfaceHolder surfaceHolder;
    @Nullable
    private TextureView textureView;
    private int surfaceWidth;
    private int surfaceHeight;
    @Nullable
    private DecoderCounters videoDecoderCounters;
    @Nullable
    private DecoderCounters audioDecoderCounters;
    private int audioSessionId;
    private AudioAttributes audioAttributes;
    private float audioVolume;
    @Nullable
    private MediaSource mediaSource;
    private List<Cue> currentCues;
    @Nullable
    private VideoFrameMetadataListener videoFrameMetadataListener;
    @Nullable
    private CameraMotionListener cameraMotionListener;
    private boolean hasNotifiedFullWrongThreadWarning;
    @Nullable
    private PriorityTaskManager priorityTaskManager;
    private boolean isPriorityTaskManagerRegistered;

    protected SimpleExoPlayer(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, LoadControl loadControl, BandwidthMeter bandwidthMeter, @Nullable DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, Looper looper) {
        this(context, renderersFactory, trackSelector, loadControl, drmSessionManager, bandwidthMeter, new AnalyticsCollector.Factory(), looper);
    }

    protected SimpleExoPlayer(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, LoadControl loadControl, @Nullable DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, BandwidthMeter bandwidthMeter, AnalyticsCollector.Factory analyticsCollectorFactory, Looper looper) {
        this(context, renderersFactory, trackSelector, loadControl, drmSessionManager, bandwidthMeter, analyticsCollectorFactory, Clock.DEFAULT, looper);
    }

    protected SimpleExoPlayer(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, LoadControl loadControl, @Nullable DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, BandwidthMeter bandwidthMeter, AnalyticsCollector.Factory analyticsCollectorFactory, Clock clock, Looper looper) {
        this.bandwidthMeter = bandwidthMeter;
        this.componentListener = new ComponentListener();
        this.videoListeners = new CopyOnWriteArraySet();
        this.audioListeners = new CopyOnWriteArraySet();
        this.textOutputs = new CopyOnWriteArraySet();
        this.metadataOutputs = new CopyOnWriteArraySet();
        this.videoDebugListeners = new CopyOnWriteArraySet();
        this.audioDebugListeners = new CopyOnWriteArraySet();
        this.eventHandler = new Handler(looper);
        this.renderers = renderersFactory.createRenderers(this.eventHandler, this.componentListener, this.componentListener, this.componentListener, this.componentListener, drmSessionManager);
        this.audioVolume = 1.0f;
        this.audioSessionId = 0;
        this.audioAttributes = AudioAttributes.DEFAULT;
        this.videoScalingMode = 1;
        this.currentCues = Collections.emptyList();
        this.player = new ExoPlayerImpl(this.renderers, trackSelector, loadControl, bandwidthMeter, clock, looper);
        this.analyticsCollector = analyticsCollectorFactory.createAnalyticsCollector(this.player, clock);
        this.addListener(this.analyticsCollector);
        this.addListener(this.componentListener);
        this.videoDebugListeners.add(this.analyticsCollector);
        this.videoListeners.add(this.analyticsCollector);
        this.audioDebugListeners.add(this.analyticsCollector);
        this.audioListeners.add(this.analyticsCollector);
        this.addMetadataOutput(this.analyticsCollector);
        bandwidthMeter.addEventListener(this.eventHandler, this.analyticsCollector);
        if (drmSessionManager instanceof DefaultDrmSessionManager) {
            ((DefaultDrmSessionManager)drmSessionManager).addListener(this.eventHandler, this.analyticsCollector);
        }
        this.audioFocusManager = new AudioFocusManager(context, this.componentListener);
    }

    @Override
    @Nullable
    public Player.AudioComponent getAudioComponent() {
        return this;
    }

    @Override
    @Nullable
    public Player.VideoComponent getVideoComponent() {
        return this;
    }

    @Override
    @Nullable
    public Player.TextComponent getTextComponent() {
        return this;
    }

    @Override
    @Nullable
    public Player.MetadataComponent getMetadataComponent() {
        return this;
    }

    @Override
    public void setVideoScalingMode(int videoScalingMode) {
        this.verifyApplicationThread();
        this.videoScalingMode = videoScalingMode;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            this.player.createMessage(renderer).setType(4).setPayload(videoScalingMode).send();
        }
    }

    @Override
    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    @Override
    public void clearVideoSurface() {
        this.verifyApplicationThread();
        this.setVideoSurface(null);
    }

    @Override
    public void clearVideoSurface(Surface surface) {
        this.verifyApplicationThread();
        if (surface != null && surface == this.surface) {
            this.setVideoSurface(null);
        }
    }

    @Override
    public void setVideoSurface(@Nullable Surface surface) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(surface, false);
        int newSurfaceSize = surface == null ? 0 : -1;
        this.maybeNotifySurfaceSizeChanged(newSurfaceSize, newSurfaceSize);
    }

    @Override
    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.surfaceHolder = surfaceHolder;
        if (surfaceHolder == null) {
            this.setVideoSurfaceInternal(null, false);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            if (surface != null && surface.isValid()) {
                this.setVideoSurfaceInternal(surface, false);
                Rect surfaceSize = surfaceHolder.getSurfaceFrame();
                this.maybeNotifySurfaceSizeChanged(surfaceSize.width(), surfaceSize.height());
            } else {
                this.setVideoSurfaceInternal(null, false);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            }
        }
    }

    @Override
    public void clearVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.setVideoSurfaceHolder(null);
        }
    }

    @Override
    public void setVideoSurfaceView(SurfaceView surfaceView) {
        this.setVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    @Override
    public void clearVideoSurfaceView(SurfaceView surfaceView) {
        this.clearVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    @Override
    public void setVideoTextureView(TextureView textureView) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.textureView = textureView;
        if (textureView == null) {
            this.setVideoSurfaceInternal(null, true);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            SurfaceTexture surfaceTexture;
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w(TAG, "Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture2 = surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            if (surfaceTexture == null) {
                this.setVideoSurfaceInternal(null, true);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            } else {
                this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
                this.maybeNotifySurfaceSizeChanged(textureView.getWidth(), textureView.getHeight());
            }
        }
    }

    @Override
    public void clearVideoTextureView(TextureView textureView) {
        this.verifyApplicationThread();
        if (textureView != null && textureView == this.textureView) {
            this.setVideoTextureView(null);
        }
    }

    @Override
    public void addAudioListener(AudioListener listener) {
        this.audioListeners.add(listener);
    }

    @Override
    public void removeAudioListener(AudioListener listener) {
        this.audioListeners.remove(listener);
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        this.setAudioAttributes(audioAttributes, false);
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes, boolean handleAudioFocus) {
        this.verifyApplicationThread();
        if (!Util.areEqual(this.audioAttributes, audioAttributes)) {
            this.audioAttributes = audioAttributes;
            for (Renderer renderer : this.renderers) {
                if (renderer.getTrackType() != 1) continue;
                this.player.createMessage(renderer).setType(3).setPayload(audioAttributes).send();
            }
            for (AudioListener audioListener : this.audioListeners) {
                audioListener.onAudioAttributesChanged(audioAttributes);
            }
        }
        int playerCommand = this.audioFocusManager.setAudioAttributes(handleAudioFocus ? audioAttributes : null, this.getPlayWhenReady(), this.getPlaybackState());
        this.updatePlayWhenReady(this.getPlayWhenReady(), playerCommand);
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        return this.audioAttributes;
    }

    @Override
    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        this.verifyApplicationThread();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 1) continue;
            this.player.createMessage(renderer).setType(5).setPayload(auxEffectInfo).send();
        }
    }

    @Override
    public void clearAuxEffectInfo() {
        this.setAuxEffectInfo(new AuxEffectInfo(0, 0.0f));
    }

    @Override
    public void setVolume(float audioVolume) {
        this.verifyApplicationThread();
        audioVolume = Util.constrainValue(audioVolume, 0.0f, 1.0f);
        if (this.audioVolume == audioVolume) {
            return;
        }
        this.audioVolume = audioVolume;
        this.sendVolumeToRenderers();
        for (AudioListener audioListener : this.audioListeners) {
            audioListener.onVolumeChanged(audioVolume);
        }
    }

    @Override
    public float getVolume() {
        return this.audioVolume;
    }

    @Deprecated
    public void setAudioStreamType(int streamType) {
        int usage = Util.getAudioUsageForStreamType(streamType);
        int contentType = Util.getAudioContentTypeForStreamType(streamType);
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        this.setAudioAttributes(audioAttributes);
    }

    @Deprecated
    public int getAudioStreamType() {
        return Util.getStreamTypeForAudioUsage(this.audioAttributes.usage);
    }

    public AnalyticsCollector getAnalyticsCollector() {
        return this.analyticsCollector;
    }

    public void addAnalyticsListener(AnalyticsListener listener) {
        this.verifyApplicationThread();
        this.analyticsCollector.addListener(listener);
    }

    public void removeAnalyticsListener(AnalyticsListener listener) {
        this.verifyApplicationThread();
        this.analyticsCollector.removeListener(listener);
    }

    public void setPriorityTaskManager(@Nullable PriorityTaskManager priorityTaskManager) {
        this.verifyApplicationThread();
        if (Util.areEqual(this.priorityTaskManager, priorityTaskManager)) {
            return;
        }
        if (this.isPriorityTaskManagerRegistered) {
            Assertions.checkNotNull(this.priorityTaskManager).remove(0);
        }
        if (priorityTaskManager != null && this.isLoading()) {
            priorityTaskManager.add(0);
            this.isPriorityTaskManagerRegistered = true;
        } else {
            this.isPriorityTaskManagerRegistered = false;
        }
        this.priorityTaskManager = priorityTaskManager;
    }

    @Deprecated
    @TargetApi(value=23)
    public void setPlaybackParams(@Nullable PlaybackParams params) {
        PlaybackParameters playbackParameters;
        if (params != null) {
            params.allowDefaults();
            playbackParameters = new PlaybackParameters(params.getSpeed(), params.getPitch());
        } else {
            playbackParameters = null;
        }
        this.setPlaybackParameters(playbackParameters);
    }

    @Nullable
    public Format getVideoFormat() {
        return this.videoFormat;
    }

    @Nullable
    public Format getAudioFormat() {
        return this.audioFormat;
    }

    @Nullable
    public DecoderCounters getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    @Nullable
    public DecoderCounters getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    @Override
    public void addVideoListener(com.google.android.exoplayer2.video.VideoListener listener) {
        this.videoListeners.add(listener);
    }

    @Override
    public void removeVideoListener(com.google.android.exoplayer2.video.VideoListener listener) {
        this.videoListeners.remove(listener);
    }

    @Override
    public void setVideoFrameMetadataListener(VideoFrameMetadataListener listener) {
        this.verifyApplicationThread();
        this.videoFrameMetadataListener = listener;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            this.player.createMessage(renderer).setType(6).setPayload(listener).send();
        }
    }

    @Override
    public void clearVideoFrameMetadataListener(VideoFrameMetadataListener listener) {
        this.verifyApplicationThread();
        if (this.videoFrameMetadataListener != listener) {
            return;
        }
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            this.player.createMessage(renderer).setType(6).setPayload(null).send();
        }
    }

    @Override
    public void setCameraMotionListener(CameraMotionListener listener) {
        this.verifyApplicationThread();
        this.cameraMotionListener = listener;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 5) continue;
            this.player.createMessage(renderer).setType(7).setPayload(listener).send();
        }
    }

    @Override
    public void clearCameraMotionListener(CameraMotionListener listener) {
        this.verifyApplicationThread();
        if (this.cameraMotionListener != listener) {
            return;
        }
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 5) continue;
            this.player.createMessage(renderer).setType(7).setPayload(null).send();
        }
    }

    @Deprecated
    public void setVideoListener(VideoListener listener) {
        this.videoListeners.clear();
        if (listener != null) {
            this.addVideoListener(listener);
        }
    }

    @Deprecated
    public void clearVideoListener(VideoListener listener) {
        this.removeVideoListener(listener);
    }

    @Override
    public void addTextOutput(TextOutput listener) {
        if (!this.currentCues.isEmpty()) {
            listener.onCues(this.currentCues);
        }
        this.textOutputs.add(listener);
    }

    @Override
    public void removeTextOutput(TextOutput listener) {
        this.textOutputs.remove(listener);
    }

    @Deprecated
    public void setTextOutput(TextOutput output) {
        this.textOutputs.clear();
        if (output != null) {
            this.addTextOutput(output);
        }
    }

    @Deprecated
    public void clearTextOutput(TextOutput output) {
        this.removeTextOutput(output);
    }

    @Override
    public void addMetadataOutput(MetadataOutput listener) {
        this.metadataOutputs.add(listener);
    }

    @Override
    public void removeMetadataOutput(MetadataOutput listener) {
        this.metadataOutputs.remove(listener);
    }

    @Deprecated
    public void setMetadataOutput(MetadataOutput output) {
        this.metadataOutputs.retainAll(Collections.singleton(this.analyticsCollector));
        if (output != null) {
            this.addMetadataOutput(output);
        }
    }

    @Deprecated
    public void clearMetadataOutput(MetadataOutput output) {
        this.removeMetadataOutput(output);
    }

    @Deprecated
    public void setVideoDebugListener(VideoRendererEventListener listener) {
        this.videoDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (listener != null) {
            this.addVideoDebugListener(listener);
        }
    }

    @Deprecated
    public void addVideoDebugListener(VideoRendererEventListener listener) {
        this.videoDebugListeners.add(listener);
    }

    @Deprecated
    public void removeVideoDebugListener(VideoRendererEventListener listener) {
        this.videoDebugListeners.remove(listener);
    }

    @Deprecated
    public void setAudioDebugListener(AudioRendererEventListener listener) {
        this.audioDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (listener != null) {
            this.addAudioDebugListener(listener);
        }
    }

    @Deprecated
    public void addAudioDebugListener(AudioRendererEventListener listener) {
        this.audioDebugListeners.add(listener);
    }

    @Deprecated
    public void removeAudioDebugListener(AudioRendererEventListener listener) {
        this.audioDebugListeners.remove(listener);
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    @Override
    public Looper getApplicationLooper() {
        return this.player.getApplicationLooper();
    }

    @Override
    public void addListener(Player.EventListener listener) {
        this.verifyApplicationThread();
        this.player.addListener(listener);
    }

    @Override
    public void removeListener(Player.EventListener listener) {
        this.verifyApplicationThread();
        this.player.removeListener(listener);
    }

    @Override
    public int getPlaybackState() {
        this.verifyApplicationThread();
        return this.player.getPlaybackState();
    }

    @Override
    @Nullable
    public ExoPlaybackException getPlaybackError() {
        this.verifyApplicationThread();
        return this.player.getPlaybackError();
    }

    @Override
    public void retry() {
        this.verifyApplicationThread();
        if (this.mediaSource != null && (this.getPlaybackError() != null || this.getPlaybackState() == 1)) {
            this.prepare(this.mediaSource, false, false);
        }
    }

    @Override
    public void prepare(MediaSource mediaSource) {
        this.prepare(mediaSource, true, true);
    }

    @Override
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.verifyApplicationThread();
        if (this.mediaSource != null) {
            this.mediaSource.removeEventListener(this.analyticsCollector);
            this.analyticsCollector.resetForNewMediaSource();
        }
        this.mediaSource = mediaSource;
        mediaSource.addEventListener(this.eventHandler, this.analyticsCollector);
        int playerCommand = this.audioFocusManager.handlePrepare(this.getPlayWhenReady());
        this.updatePlayWhenReady(this.getPlayWhenReady(), playerCommand);
        this.player.prepare(mediaSource, resetPosition, resetState);
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        this.verifyApplicationThread();
        int playerCommand = this.audioFocusManager.handleSetPlayWhenReady(playWhenReady, this.getPlaybackState());
        this.updatePlayWhenReady(playWhenReady, playerCommand);
    }

    @Override
    public boolean getPlayWhenReady() {
        this.verifyApplicationThread();
        return this.player.getPlayWhenReady();
    }

    @Override
    public int getRepeatMode() {
        this.verifyApplicationThread();
        return this.player.getRepeatMode();
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.verifyApplicationThread();
        this.player.setRepeatMode(repeatMode);
    }

    @Override
    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.verifyApplicationThread();
        this.player.setShuffleModeEnabled(shuffleModeEnabled);
    }

    @Override
    public boolean getShuffleModeEnabled() {
        this.verifyApplicationThread();
        return this.player.getShuffleModeEnabled();
    }

    @Override
    public boolean isLoading() {
        this.verifyApplicationThread();
        return this.player.isLoading();
    }

    @Override
    public void seekTo(int windowIndex, long positionMs) {
        this.verifyApplicationThread();
        this.analyticsCollector.notifySeekStarted();
        this.player.seekTo(windowIndex, positionMs);
    }

    @Override
    public void setPlaybackParameters(@Nullable PlaybackParameters playbackParameters) {
        this.verifyApplicationThread();
        this.player.setPlaybackParameters(playbackParameters);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        this.verifyApplicationThread();
        return this.player.getPlaybackParameters();
    }

    @Override
    public void setSeekParameters(@Nullable SeekParameters seekParameters) {
        this.verifyApplicationThread();
        this.player.setSeekParameters(seekParameters);
    }

    @Override
    public SeekParameters getSeekParameters() {
        this.verifyApplicationThread();
        return this.player.getSeekParameters();
    }

    @Override
    public void setForegroundMode(boolean foregroundMode) {
        this.player.setForegroundMode(foregroundMode);
    }

    @Override
    public void stop(boolean reset) {
        this.verifyApplicationThread();
        this.player.stop(reset);
        if (this.mediaSource != null) {
            this.mediaSource.removeEventListener(this.analyticsCollector);
            this.analyticsCollector.resetForNewMediaSource();
            if (reset) {
                this.mediaSource = null;
            }
        }
        this.audioFocusManager.handleStop();
        this.currentCues = Collections.emptyList();
    }

    @Override
    public void release() {
        this.verifyApplicationThread();
        this.audioFocusManager.handleStop();
        this.player.release();
        this.removeSurfaceCallbacks();
        if (this.surface != null) {
            if (this.ownsSurface) {
                this.surface.release();
            }
            this.surface = null;
        }
        if (this.mediaSource != null) {
            this.mediaSource.removeEventListener(this.analyticsCollector);
            this.mediaSource = null;
        }
        if (this.isPriorityTaskManagerRegistered) {
            Assertions.checkNotNull(this.priorityTaskManager).remove(0);
            this.isPriorityTaskManagerRegistered = false;
        }
        this.bandwidthMeter.removeEventListener(this.analyticsCollector);
        this.currentCues = Collections.emptyList();
    }

    @Override
    @Deprecated
    public void sendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        this.player.sendMessages(messages);
    }

    @Override
    public PlayerMessage createMessage(PlayerMessage.Target target) {
        this.verifyApplicationThread();
        return this.player.createMessage(target);
    }

    @Override
    @Deprecated
    public void blockingSendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        this.player.blockingSendMessages(messages);
    }

    @Override
    public int getRendererCount() {
        this.verifyApplicationThread();
        return this.player.getRendererCount();
    }

    @Override
    public int getRendererType(int index) {
        this.verifyApplicationThread();
        return this.player.getRendererType(index);
    }

    @Override
    public TrackGroupArray getCurrentTrackGroups() {
        this.verifyApplicationThread();
        return this.player.getCurrentTrackGroups();
    }

    @Override
    public TrackSelectionArray getCurrentTrackSelections() {
        this.verifyApplicationThread();
        return this.player.getCurrentTrackSelections();
    }

    @Override
    public Timeline getCurrentTimeline() {
        this.verifyApplicationThread();
        return this.player.getCurrentTimeline();
    }

    @Override
    @Nullable
    public Object getCurrentManifest() {
        this.verifyApplicationThread();
        return this.player.getCurrentManifest();
    }

    @Override
    public int getCurrentPeriodIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentPeriodIndex();
    }

    @Override
    public int getCurrentWindowIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentWindowIndex();
    }

    @Override
    public long getDuration() {
        this.verifyApplicationThread();
        return this.player.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        this.verifyApplicationThread();
        return this.player.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        this.verifyApplicationThread();
        return this.player.getBufferedPosition();
    }

    @Override
    public long getTotalBufferedDuration() {
        this.verifyApplicationThread();
        return this.player.getTotalBufferedDuration();
    }

    @Override
    public boolean isPlayingAd() {
        this.verifyApplicationThread();
        return this.player.isPlayingAd();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentAdGroupIndex();
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        this.verifyApplicationThread();
        return this.player.getCurrentAdIndexInAdGroup();
    }

    @Override
    public long getContentPosition() {
        this.verifyApplicationThread();
        return this.player.getContentPosition();
    }

    @Override
    public long getContentBufferedPosition() {
        this.verifyApplicationThread();
        return this.player.getContentBufferedPosition();
    }

    private void removeSurfaceCallbacks() {
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w(TAG, "SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setVideoSurfaceInternal(@Nullable Surface surface, boolean ownsSurface) {
        ArrayList<PlayerMessage> messages = new ArrayList<PlayerMessage>();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            messages.add(this.player.createMessage(renderer).setType(1).setPayload(surface).send());
        }
        if (this.surface != null && this.surface != surface) {
            try {
                for (PlayerMessage message : messages) {
                    message.blockUntilDelivered();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.ownsSurface) {
                this.surface.release();
            }
        }
        this.surface = surface;
        this.ownsSurface = ownsSurface;
    }

    private void maybeNotifySurfaceSizeChanged(int width, int height) {
        if (width != this.surfaceWidth || height != this.surfaceHeight) {
            this.surfaceWidth = width;
            this.surfaceHeight = height;
            for (com.google.android.exoplayer2.video.VideoListener videoListener : this.videoListeners) {
                videoListener.onSurfaceSizeChanged(width, height);
            }
        }
    }

    private void sendVolumeToRenderers() {
        float scaledVolume = this.audioVolume * this.audioFocusManager.getVolumeMultiplier();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 1) continue;
            this.player.createMessage(renderer).setType(2).setPayload(Float.valueOf(scaledVolume)).send();
        }
    }

    private void updatePlayWhenReady(boolean playWhenReady, int playerCommand) {
        this.player.setPlayWhenReady(playWhenReady && playerCommand != -1, playerCommand != 1);
    }

    private void verifyApplicationThread() {
        if (Looper.myLooper() != this.getApplicationLooper()) {
            Log.w(TAG, "Player is accessed on the wrong thread. See https://exoplayer.dev/troubleshooting.html#what-do-player-is-accessed-on-the-wrong-thread-warnings-mean", this.hasNotifiedFullWrongThreadWarning ? null : new IllegalStateException());
            this.hasNotifiedFullWrongThreadWarning = true;
        }
    }

    private final class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextOutput,
    MetadataOutput,
    SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    AudioFocusManager.PlayerControl,
    Player.EventListener {
        private ComponentListener() {
        }

        @Override
        public void onVideoEnabled(DecoderCounters counters) {
            SimpleExoPlayer.this.videoDecoderCounters = counters;
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoEnabled(counters);
            }
        }

        @Override
        public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
            }
        }

        @Override
        public void onVideoInputFormatChanged(Format format) {
            SimpleExoPlayer.this.videoFormat = format;
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoInputFormatChanged(format);
            }
        }

        @Override
        public void onDroppedFrames(int count, long elapsed) {
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onDroppedFrames(count, elapsed);
            }
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            for (com.google.android.exoplayer2.video.VideoListener videoListener : SimpleExoPlayer.this.videoListeners) {
                if (SimpleExoPlayer.this.videoDebugListeners.contains(videoListener)) continue;
                videoListener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
        }

        @Override
        public void onRenderedFirstFrame(Surface surface) {
            if (SimpleExoPlayer.this.surface == surface) {
                for (com.google.android.exoplayer2.video.VideoListener videoListener : SimpleExoPlayer.this.videoListeners) {
                    videoListener.onRenderedFirstFrame();
                }
            }
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onRenderedFirstFrame(surface);
            }
        }

        @Override
        public void onVideoDisabled(DecoderCounters counters) {
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoDisabled(counters);
            }
            SimpleExoPlayer.this.videoFormat = null;
            SimpleExoPlayer.this.videoDecoderCounters = null;
        }

        @Override
        public void onAudioEnabled(DecoderCounters counters) {
            SimpleExoPlayer.this.audioDecoderCounters = counters;
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioEnabled(counters);
            }
        }

        @Override
        public void onAudioSessionId(int sessionId) {
            if (SimpleExoPlayer.this.audioSessionId == sessionId) {
                return;
            }
            SimpleExoPlayer.this.audioSessionId = sessionId;
            for (AudioListener audioListener : SimpleExoPlayer.this.audioListeners) {
                if (SimpleExoPlayer.this.audioDebugListeners.contains(audioListener)) continue;
                audioListener.onAudioSessionId(sessionId);
            }
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioSessionId(sessionId);
            }
        }

        @Override
        public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
            }
        }

        @Override
        public void onAudioInputFormatChanged(Format format) {
            SimpleExoPlayer.this.audioFormat = format;
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioInputFormatChanged(format);
            }
        }

        @Override
        public void onAudioSinkUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioSinkUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }

        @Override
        public void onAudioDisabled(DecoderCounters counters) {
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioDisabled(counters);
            }
            SimpleExoPlayer.this.audioFormat = null;
            SimpleExoPlayer.this.audioDecoderCounters = null;
            SimpleExoPlayer.this.audioSessionId = 0;
        }

        @Override
        public void onCues(List<Cue> cues) {
            SimpleExoPlayer.this.currentCues = cues;
            for (TextOutput textOutput : SimpleExoPlayer.this.textOutputs) {
                textOutput.onCues(cues);
            }
        }

        @Override
        public void onMetadata(Metadata metadata) {
            for (MetadataOutput metadataOutput : SimpleExoPlayer.this.metadataOutputs) {
                metadataOutput.onMetadata(metadata);
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(holder.getSurface(), false);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, false);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(0, 0);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, true);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(0, 0);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        @Override
        public void setVolumeMultiplier(float volumeMultiplier) {
            SimpleExoPlayer.this.sendVolumeToRenderers();
        }

        @Override
        public void executePlayerCommand(int playerCommand) {
            SimpleExoPlayer.this.updatePlayWhenReady(SimpleExoPlayer.this.getPlayWhenReady(), playerCommand);
        }

        @Override
        public void onLoadingChanged(boolean isLoading) {
            if (SimpleExoPlayer.this.priorityTaskManager != null) {
                if (isLoading && !SimpleExoPlayer.this.isPriorityTaskManagerRegistered) {
                    SimpleExoPlayer.this.priorityTaskManager.add(0);
                    SimpleExoPlayer.this.isPriorityTaskManagerRegistered = true;
                } else if (!isLoading && SimpleExoPlayer.this.isPriorityTaskManagerRegistered) {
                    SimpleExoPlayer.this.priorityTaskManager.remove(0);
                    SimpleExoPlayer.this.isPriorityTaskManagerRegistered = false;
                }
            }
        }
    }

    @Deprecated
    public static interface VideoListener
    extends com.google.android.exoplayer2.video.VideoListener {
    }
}

