/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioListener;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.video.VideoFrameMetadataListener;
import com.google.android.exoplayer2.video.VideoListener;
import com.google.android.exoplayer2.video.spherical.CameraMotionListener;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface Player {
    public static final int STATE_IDLE = 1;
    public static final int STATE_BUFFERING = 2;
    public static final int STATE_READY = 3;
    public static final int STATE_ENDED = 4;
    public static final int REPEAT_MODE_OFF = 0;
    public static final int REPEAT_MODE_ONE = 1;
    public static final int REPEAT_MODE_ALL = 2;
    public static final int DISCONTINUITY_REASON_PERIOD_TRANSITION = 0;
    public static final int DISCONTINUITY_REASON_SEEK = 1;
    public static final int DISCONTINUITY_REASON_SEEK_ADJUSTMENT = 2;
    public static final int DISCONTINUITY_REASON_AD_INSERTION = 3;
    public static final int DISCONTINUITY_REASON_INTERNAL = 4;
    public static final int TIMELINE_CHANGE_REASON_PREPARED = 0;
    public static final int TIMELINE_CHANGE_REASON_RESET = 1;
    public static final int TIMELINE_CHANGE_REASON_DYNAMIC = 2;

    @Nullable
    public AudioComponent getAudioComponent();

    @Nullable
    public VideoComponent getVideoComponent();

    @Nullable
    public TextComponent getTextComponent();

    @Nullable
    public MetadataComponent getMetadataComponent();

    public Looper getApplicationLooper();

    public void addListener(EventListener var1);

    public void removeListener(EventListener var1);

    public int getPlaybackState();

    @Nullable
    public ExoPlaybackException getPlaybackError();

    public void setPlayWhenReady(boolean var1);

    public boolean getPlayWhenReady();

    public void setRepeatMode(int var1);

    public int getRepeatMode();

    public void setShuffleModeEnabled(boolean var1);

    public boolean getShuffleModeEnabled();

    public boolean isLoading();

    public void seekToDefaultPosition();

    public void seekToDefaultPosition(int var1);

    public void seekTo(long var1);

    public void seekTo(int var1, long var2);

    public boolean hasPrevious();

    public void previous();

    public boolean hasNext();

    public void next();

    public void setPlaybackParameters(@Nullable PlaybackParameters var1);

    public PlaybackParameters getPlaybackParameters();

    public void stop();

    public void stop(boolean var1);

    public void release();

    public int getRendererCount();

    public int getRendererType(int var1);

    public TrackGroupArray getCurrentTrackGroups();

    public TrackSelectionArray getCurrentTrackSelections();

    @Nullable
    public Object getCurrentManifest();

    public Timeline getCurrentTimeline();

    public int getCurrentPeriodIndex();

    public int getCurrentWindowIndex();

    public int getNextWindowIndex();

    public int getPreviousWindowIndex();

    @Nullable
    public Object getCurrentTag();

    public long getDuration();

    public long getCurrentPosition();

    public long getBufferedPosition();

    public int getBufferedPercentage();

    public long getTotalBufferedDuration();

    public boolean isCurrentWindowDynamic();

    public boolean isCurrentWindowSeekable();

    public boolean isPlayingAd();

    public int getCurrentAdGroupIndex();

    public int getCurrentAdIndexInAdGroup();

    public long getContentDuration();

    public long getContentPosition();

    public long getContentBufferedPosition();

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimelineChangeReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DiscontinuityReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RepeatMode {
    }

    @Deprecated
    public static abstract class DefaultEventListener
    implements EventListener {
        @Override
        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
            this.onTimelineChanged(timeline, manifest);
        }

        @Deprecated
        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest) {
        }
    }

    public static interface EventListener {
        default public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
        }

        default public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        }

        default public void onLoadingChanged(boolean isLoading) {
        }

        default public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        }

        default public void onRepeatModeChanged(int repeatMode) {
        }

        default public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        }

        default public void onPlayerError(ExoPlaybackException error) {
        }

        default public void onPositionDiscontinuity(int reason) {
        }

        default public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        }

        default public void onSeekProcessed() {
        }
    }

    public static interface MetadataComponent {
        public void addMetadataOutput(MetadataOutput var1);

        public void removeMetadataOutput(MetadataOutput var1);
    }

    public static interface TextComponent {
        public void addTextOutput(TextOutput var1);

        public void removeTextOutput(TextOutput var1);
    }

    public static interface VideoComponent {
        public void setVideoScalingMode(int var1);

        public int getVideoScalingMode();

        public void addVideoListener(VideoListener var1);

        public void removeVideoListener(VideoListener var1);

        public void setVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        public void clearVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        public void setCameraMotionListener(CameraMotionListener var1);

        public void clearCameraMotionListener(CameraMotionListener var1);

        public void clearVideoSurface();

        public void clearVideoSurface(Surface var1);

        public void setVideoSurface(@Nullable Surface var1);

        public void setVideoSurfaceHolder(SurfaceHolder var1);

        public void clearVideoSurfaceHolder(SurfaceHolder var1);

        public void setVideoSurfaceView(SurfaceView var1);

        public void clearVideoSurfaceView(SurfaceView var1);

        public void setVideoTextureView(TextureView var1);

        public void clearVideoTextureView(TextureView var1);
    }

    public static interface AudioComponent {
        public void addAudioListener(AudioListener var1);

        public void removeAudioListener(AudioListener var1);

        @Deprecated
        public void setAudioAttributes(AudioAttributes var1);

        public void setAudioAttributes(AudioAttributes var1, boolean var2);

        public AudioAttributes getAudioAttributes();

        public int getAudioSessionId();

        public void setAuxEffectInfo(AuxEffectInfo var1);

        public void clearAuxEffectInfo();

        public void setVolume(float var1);

        public float getVolume();
    }
}

