/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;

public final class PlaybackParameters {
    public static final PlaybackParameters DEFAULT = new PlaybackParameters(1.0f);
    public final float speed;
    public final float pitch;
    public final boolean skipSilence;
    private final int scaledUsPerMs;

    public PlaybackParameters(float speed) {
        this(speed, 1.0f, false);
    }

    public PlaybackParameters(float speed, float pitch) {
        this(speed, pitch, false);
    }

    public PlaybackParameters(float speed, float pitch, boolean skipSilence) {
        Assertions.checkArgument(speed > 0.0f);
        Assertions.checkArgument(pitch > 0.0f);
        this.speed = speed;
        this.pitch = pitch;
        this.skipSilence = skipSilence;
        this.scaledUsPerMs = Math.round(speed * 1000.0f);
    }

    public long getMediaTimeUsForPlayoutTimeMs(long timeMs) {
        return timeMs * (long)this.scaledUsPerMs;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlaybackParameters other = (PlaybackParameters)obj;
        return this.speed == other.speed && this.pitch == other.pitch && this.skipSilence == other.skipSilence;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Float.floatToRawIntBits(this.speed);
        result = 31 * result + Float.floatToRawIntBits(this.pitch);
        result = 31 * result + (this.skipSilence ? 1 : 0);
        return result;
    }
}

