/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaPeriodHolder;
import com.google.android.exoplayer2.MediaPeriodInfo;
import com.google.android.exoplayer2.PlaybackInfo;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;

final class MediaPeriodQueue {
    private static final int MAXIMUM_BUFFER_AHEAD_PERIODS = 100;
    private final Timeline.Period period = new Timeline.Period();
    private final Timeline.Window window = new Timeline.Window();
    private long nextWindowSequenceNumber;
    private Timeline timeline = Timeline.EMPTY;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    @Nullable
    private MediaPeriodHolder playing;
    @Nullable
    private MediaPeriodHolder reading;
    @Nullable
    private MediaPeriodHolder loading;
    private int length;
    @Nullable
    private Object oldFrontPeriodUid;
    private long oldFrontPeriodWindowSequenceNumber;

    public void setTimeline(Timeline timeline) {
        this.timeline = timeline;
    }

    public boolean updateRepeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
        return this.updateForPlaybackModeChange();
    }

    public boolean updateShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.shuffleModeEnabled = shuffleModeEnabled;
        return this.updateForPlaybackModeChange();
    }

    public boolean isLoading(MediaPeriod mediaPeriod) {
        return this.loading != null && this.loading.mediaPeriod == mediaPeriod;
    }

    public void reevaluateBuffer(long rendererPositionUs) {
        if (this.loading != null) {
            this.loading.reevaluateBuffer(rendererPositionUs);
        }
    }

    public boolean shouldLoadNextMediaPeriod() {
        return this.loading == null || !this.loading.info.isFinal && this.loading.isFullyBuffered() && this.loading.info.durationUs != -9223372036854775807L && this.length < 100;
    }

    @Nullable
    public MediaPeriodInfo getNextMediaPeriodInfo(long rendererPositionUs, PlaybackInfo playbackInfo) {
        return this.loading == null ? this.getFirstMediaPeriodInfo(playbackInfo) : this.getFollowingMediaPeriodInfo(this.loading, rendererPositionUs);
    }

    public MediaPeriod enqueueNextMediaPeriod(RendererCapabilities[] rendererCapabilities, TrackSelector trackSelector, Allocator allocator, MediaSource mediaSource, MediaPeriodInfo info) {
        long rendererPositionOffsetUs = this.loading == null ? info.startPositionUs : this.loading.getRendererOffset() + this.loading.info.durationUs;
        MediaPeriodHolder newPeriodHolder = new MediaPeriodHolder(rendererCapabilities, rendererPositionOffsetUs, trackSelector, allocator, mediaSource, info);
        if (this.loading != null) {
            Assertions.checkState(this.hasPlayingPeriod());
            this.loading.setNext(newPeriodHolder);
        }
        this.oldFrontPeriodUid = null;
        this.loading = newPeriodHolder;
        ++this.length;
        return newPeriodHolder.mediaPeriod;
    }

    public MediaPeriodHolder getLoadingPeriod() {
        return this.loading;
    }

    public MediaPeriodHolder getPlayingPeriod() {
        return this.playing;
    }

    public MediaPeriodHolder getReadingPeriod() {
        return this.reading;
    }

    public MediaPeriodHolder getFrontPeriod() {
        return this.hasPlayingPeriod() ? this.playing : this.loading;
    }

    public boolean hasPlayingPeriod() {
        return this.playing != null;
    }

    public MediaPeriodHolder advanceReadingPeriod() {
        Assertions.checkState(this.reading != null && this.reading.getNext() != null);
        this.reading = this.reading.getNext();
        return this.reading;
    }

    public MediaPeriodHolder advancePlayingPeriod() {
        if (this.playing != null) {
            if (this.playing == this.reading) {
                this.reading = this.playing.getNext();
            }
            this.playing.release();
            --this.length;
            if (this.length == 0) {
                this.loading = null;
                this.oldFrontPeriodUid = this.playing.uid;
                this.oldFrontPeriodWindowSequenceNumber = this.playing.info.id.windowSequenceNumber;
            }
            this.playing = this.playing.getNext();
        } else {
            this.playing = this.loading;
            this.reading = this.loading;
        }
        return this.playing;
    }

    public boolean removeAfter(MediaPeriodHolder mediaPeriodHolder) {
        Assertions.checkState(mediaPeriodHolder != null);
        boolean removedReading = false;
        this.loading = mediaPeriodHolder;
        while (mediaPeriodHolder.getNext() != null) {
            if ((mediaPeriodHolder = mediaPeriodHolder.getNext()) == this.reading) {
                this.reading = this.playing;
                removedReading = true;
            }
            mediaPeriodHolder.release();
            --this.length;
        }
        this.loading.setNext(null);
        return removedReading;
    }

    public void clear(boolean keepFrontPeriodUid) {
        MediaPeriodHolder front = this.getFrontPeriod();
        if (front != null) {
            this.oldFrontPeriodUid = keepFrontPeriodUid ? front.uid : null;
            this.oldFrontPeriodWindowSequenceNumber = front.info.id.windowSequenceNumber;
            front.release();
            this.removeAfter(front);
        } else if (!keepFrontPeriodUid) {
            this.oldFrontPeriodUid = null;
        }
        this.playing = null;
        this.loading = null;
        this.reading = null;
        this.length = 0;
    }

    public boolean updateQueuedPeriods(long rendererPositionUs, long maxRendererReadPositionUs) {
        MediaPeriodHolder previousPeriodHolder = null;
        for (MediaPeriodHolder periodHolder = this.getFrontPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
            MediaPeriodInfo newPeriodInfo;
            MediaPeriodInfo oldPeriodInfo = periodHolder.info;
            if (previousPeriodHolder == null) {
                newPeriodInfo = this.getUpdatedMediaPeriodInfo(oldPeriodInfo);
            } else {
                newPeriodInfo = this.getFollowingMediaPeriodInfo(previousPeriodHolder, rendererPositionUs);
                if (newPeriodInfo == null) {
                    return !this.removeAfter(previousPeriodHolder);
                }
                if (!this.canKeepMediaPeriodHolder(oldPeriodInfo, newPeriodInfo)) {
                    return !this.removeAfter(previousPeriodHolder);
                }
            }
            periodHolder.info = newPeriodInfo.copyWithContentPositionUs(oldPeriodInfo.contentPositionUs);
            if (!this.areDurationsCompatible(oldPeriodInfo.durationUs, newPeriodInfo.durationUs)) {
                long newDurationInRendererTime = newPeriodInfo.durationUs == -9223372036854775807L ? Long.MAX_VALUE : periodHolder.toRendererTime(newPeriodInfo.durationUs);
                boolean isReadingAndReadBeyondNewDuration = periodHolder == this.reading && (maxRendererReadPositionUs == Long.MIN_VALUE || maxRendererReadPositionUs >= newDurationInRendererTime);
                boolean readingPeriodRemoved = this.removeAfter(periodHolder);
                return !readingPeriodRemoved && !isReadingAndReadBeyondNewDuration;
            }
            previousPeriodHolder = periodHolder;
        }
        return true;
    }

    public MediaPeriodInfo getUpdatedMediaPeriodInfo(MediaPeriodInfo info) {
        MediaSource.MediaPeriodId id = info.id;
        boolean isLastInPeriod = this.isLastInPeriod(id);
        boolean isLastInTimeline = this.isLastInTimeline(id, isLastInPeriod);
        this.timeline.getPeriodByUid(info.id.periodUid, this.period);
        long durationUs = id.isAd() ? this.period.getAdDurationUs(id.adGroupIndex, id.adIndexInAdGroup) : (info.endPositionUs == -9223372036854775807L || info.endPositionUs == Long.MIN_VALUE ? this.period.getDurationUs() : info.endPositionUs);
        return new MediaPeriodInfo(id, info.startPositionUs, info.contentPositionUs, info.endPositionUs, durationUs, isLastInPeriod, isLastInTimeline);
    }

    public MediaSource.MediaPeriodId resolveMediaPeriodIdForAds(Object periodUid, long positionUs) {
        long windowSequenceNumber = this.resolvePeriodIndexToWindowSequenceNumber(periodUid);
        return this.resolveMediaPeriodIdForAds(periodUid, positionUs, windowSequenceNumber);
    }

    private MediaSource.MediaPeriodId resolveMediaPeriodIdForAds(Object periodUid, long positionUs, long windowSequenceNumber) {
        this.timeline.getPeriodByUid(periodUid, this.period);
        int adGroupIndex = this.period.getAdGroupIndexForPositionUs(positionUs);
        if (adGroupIndex == -1) {
            int nextAdGroupIndex = this.period.getAdGroupIndexAfterPositionUs(positionUs);
            return new MediaSource.MediaPeriodId(periodUid, windowSequenceNumber, nextAdGroupIndex);
        }
        int adIndexInAdGroup = this.period.getFirstAdIndexToPlay(adGroupIndex);
        return new MediaSource.MediaPeriodId(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber);
    }

    private long resolvePeriodIndexToWindowSequenceNumber(Object periodUid) {
        MediaPeriodHolder mediaPeriodHolder;
        int oldFrontWindowIndex;
        int oldFrontPeriodIndex;
        int windowIndex = this.timeline.getPeriodByUid((Object)periodUid, (Timeline.Period)this.period).windowIndex;
        if (this.oldFrontPeriodUid != null && (oldFrontPeriodIndex = this.timeline.getIndexOfPeriod(this.oldFrontPeriodUid)) != -1 && (oldFrontWindowIndex = this.timeline.getPeriod((int)oldFrontPeriodIndex, (Timeline.Period)this.period).windowIndex) == windowIndex) {
            return this.oldFrontPeriodWindowSequenceNumber;
        }
        for (mediaPeriodHolder = this.getFrontPeriod(); mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            if (!mediaPeriodHolder.uid.equals(periodUid)) continue;
            return mediaPeriodHolder.info.id.windowSequenceNumber;
        }
        for (mediaPeriodHolder = this.getFrontPeriod(); mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            int holderWindowIndex;
            int indexOfHolderInTimeline = this.timeline.getIndexOfPeriod(mediaPeriodHolder.uid);
            if (indexOfHolderInTimeline == -1 || (holderWindowIndex = this.timeline.getPeriod((int)indexOfHolderInTimeline, (Timeline.Period)this.period).windowIndex) != windowIndex) continue;
            return mediaPeriodHolder.info.id.windowSequenceNumber;
        }
        return this.nextWindowSequenceNumber++;
    }

    private boolean canKeepMediaPeriodHolder(MediaPeriodInfo oldInfo, MediaPeriodInfo newInfo) {
        return oldInfo.startPositionUs == newInfo.startPositionUs && oldInfo.id.equals(newInfo.id);
    }

    private boolean areDurationsCompatible(long previousDurationUs, long newDurationUs) {
        return previousDurationUs == -9223372036854775807L || previousDurationUs == newDurationUs;
    }

    private boolean updateForPlaybackModeChange() {
        MediaPeriodHolder lastValidPeriodHolder = this.getFrontPeriod();
        if (lastValidPeriodHolder == null) {
            return true;
        }
        int currentPeriodIndex = this.timeline.getIndexOfPeriod(lastValidPeriodHolder.uid);
        while (true) {
            int nextPeriodHolderPeriodIndex;
            int nextPeriodIndex = this.timeline.getNextPeriodIndex(currentPeriodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled);
            while (lastValidPeriodHolder.getNext() != null && !lastValidPeriodHolder.info.isLastInTimelinePeriod) {
                lastValidPeriodHolder = lastValidPeriodHolder.getNext();
            }
            MediaPeriodHolder nextMediaPeriodHolder = lastValidPeriodHolder.getNext();
            if (nextPeriodIndex == -1 || nextMediaPeriodHolder == null || (nextPeriodHolderPeriodIndex = this.timeline.getIndexOfPeriod(nextMediaPeriodHolder.uid)) != nextPeriodIndex) break;
            lastValidPeriodHolder = nextMediaPeriodHolder;
            currentPeriodIndex = nextPeriodIndex;
        }
        boolean readingPeriodRemoved = this.removeAfter(lastValidPeriodHolder);
        lastValidPeriodHolder.info = this.getUpdatedMediaPeriodInfo(lastValidPeriodHolder.info);
        return !readingPeriodRemoved || !this.hasPlayingPeriod();
    }

    private MediaPeriodInfo getFirstMediaPeriodInfo(PlaybackInfo playbackInfo) {
        return this.getMediaPeriodInfo(playbackInfo.periodId, playbackInfo.contentPositionUs, playbackInfo.startPositionUs);
    }

    @Nullable
    private MediaPeriodInfo getFollowingMediaPeriodInfo(MediaPeriodHolder mediaPeriodHolder, long rendererPositionUs) {
        MediaPeriodInfo mediaPeriodInfo = mediaPeriodHolder.info;
        long bufferedDurationUs = mediaPeriodHolder.getRendererOffset() + mediaPeriodInfo.durationUs - rendererPositionUs;
        if (mediaPeriodInfo.isLastInTimelinePeriod) {
            long startPositionUs;
            int currentPeriodIndex = this.timeline.getIndexOfPeriod(mediaPeriodInfo.id.periodUid);
            int nextPeriodIndex = this.timeline.getNextPeriodIndex(currentPeriodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled);
            if (nextPeriodIndex == -1) {
                return null;
            }
            int nextWindowIndex = this.timeline.getPeriod((int)nextPeriodIndex, (Timeline.Period)this.period, (boolean)true).windowIndex;
            Object nextPeriodUid = this.period.uid;
            long windowSequenceNumber = mediaPeriodInfo.id.windowSequenceNumber;
            if (this.timeline.getWindow((int)nextWindowIndex, (Timeline.Window)this.window).firstPeriodIndex == nextPeriodIndex) {
                Pair<Object, Long> defaultPosition = this.timeline.getPeriodPosition(this.window, this.period, nextWindowIndex, -9223372036854775807L, Math.max(0L, bufferedDurationUs));
                if (defaultPosition == null) {
                    return null;
                }
                nextPeriodUid = defaultPosition.first;
                startPositionUs = (Long)defaultPosition.second;
                MediaPeriodHolder nextMediaPeriodHolder = mediaPeriodHolder.getNext();
                windowSequenceNumber = nextMediaPeriodHolder != null && nextMediaPeriodHolder.uid.equals(nextPeriodUid) ? nextMediaPeriodHolder.info.id.windowSequenceNumber : this.nextWindowSequenceNumber++;
            } else {
                startPositionUs = 0L;
            }
            MediaSource.MediaPeriodId periodId = this.resolveMediaPeriodIdForAds(nextPeriodUid, startPositionUs, windowSequenceNumber);
            return this.getMediaPeriodInfo(periodId, startPositionUs, startPositionUs);
        }
        MediaSource.MediaPeriodId currentPeriodId = mediaPeriodInfo.id;
        this.timeline.getPeriodByUid(currentPeriodId.periodUid, this.period);
        if (currentPeriodId.isAd()) {
            int adGroupIndex = currentPeriodId.adGroupIndex;
            int adCountInCurrentAdGroup = this.period.getAdCountInAdGroup(adGroupIndex);
            if (adCountInCurrentAdGroup == -1) {
                return null;
            }
            int nextAdIndexInAdGroup = this.period.getNextAdIndexToPlay(adGroupIndex, currentPeriodId.adIndexInAdGroup);
            if (nextAdIndexInAdGroup < adCountInCurrentAdGroup) {
                return !this.period.isAdAvailable(adGroupIndex, nextAdIndexInAdGroup) ? null : this.getMediaPeriodInfoForAd(currentPeriodId.periodUid, adGroupIndex, nextAdIndexInAdGroup, mediaPeriodInfo.contentPositionUs, currentPeriodId.windowSequenceNumber);
            }
            long startPositionUs = mediaPeriodInfo.contentPositionUs;
            if (this.period.getAdGroupCount() == 1 && this.period.getAdGroupTimeUs(0) == 0L) {
                Pair<Object, Long> defaultPosition = this.timeline.getPeriodPosition(this.window, this.period, this.period.windowIndex, -9223372036854775807L, Math.max(0L, bufferedDurationUs));
                if (defaultPosition == null) {
                    return null;
                }
                startPositionUs = (Long)defaultPosition.second;
            }
            return this.getMediaPeriodInfoForContent(currentPeriodId.periodUid, startPositionUs, currentPeriodId.windowSequenceNumber);
        }
        int nextAdGroupIndex = this.period.getAdGroupIndexForPositionUs(mediaPeriodInfo.endPositionUs);
        if (nextAdGroupIndex == -1) {
            return this.getMediaPeriodInfoForContent(currentPeriodId.periodUid, mediaPeriodInfo.durationUs, currentPeriodId.windowSequenceNumber);
        }
        int adIndexInAdGroup = this.period.getFirstAdIndexToPlay(nextAdGroupIndex);
        return !this.period.isAdAvailable(nextAdGroupIndex, adIndexInAdGroup) ? null : this.getMediaPeriodInfoForAd(currentPeriodId.periodUid, nextAdGroupIndex, adIndexInAdGroup, mediaPeriodInfo.durationUs, currentPeriodId.windowSequenceNumber);
    }

    private MediaPeriodInfo getMediaPeriodInfo(MediaSource.MediaPeriodId id, long contentPositionUs, long startPositionUs) {
        this.timeline.getPeriodByUid(id.periodUid, this.period);
        if (id.isAd()) {
            if (!this.period.isAdAvailable(id.adGroupIndex, id.adIndexInAdGroup)) {
                return null;
            }
            return this.getMediaPeriodInfoForAd(id.periodUid, id.adGroupIndex, id.adIndexInAdGroup, contentPositionUs, id.windowSequenceNumber);
        }
        return this.getMediaPeriodInfoForContent(id.periodUid, startPositionUs, id.windowSequenceNumber);
    }

    private MediaPeriodInfo getMediaPeriodInfoForAd(Object periodUid, int adGroupIndex, int adIndexInAdGroup, long contentPositionUs, long windowSequenceNumber) {
        MediaSource.MediaPeriodId id = new MediaSource.MediaPeriodId(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber);
        long durationUs = this.timeline.getPeriodByUid(id.periodUid, this.period).getAdDurationUs(id.adGroupIndex, id.adIndexInAdGroup);
        long startPositionUs = adIndexInAdGroup == this.period.getFirstAdIndexToPlay(adGroupIndex) ? this.period.getAdResumePositionUs() : 0L;
        return new MediaPeriodInfo(id, startPositionUs, contentPositionUs, -9223372036854775807L, durationUs, false, false);
    }

    private MediaPeriodInfo getMediaPeriodInfoForContent(Object periodUid, long startPositionUs, long windowSequenceNumber) {
        int nextAdGroupIndex = this.period.getAdGroupIndexAfterPositionUs(startPositionUs);
        MediaSource.MediaPeriodId id = new MediaSource.MediaPeriodId(periodUid, windowSequenceNumber, nextAdGroupIndex);
        boolean isLastInPeriod = this.isLastInPeriod(id);
        boolean isLastInTimeline = this.isLastInTimeline(id, isLastInPeriod);
        long endPositionUs = nextAdGroupIndex != -1 ? this.period.getAdGroupTimeUs(nextAdGroupIndex) : -9223372036854775807L;
        long durationUs = endPositionUs == -9223372036854775807L || endPositionUs == Long.MIN_VALUE ? this.period.durationUs : endPositionUs;
        return new MediaPeriodInfo(id, startPositionUs, -9223372036854775807L, endPositionUs, durationUs, isLastInPeriod, isLastInTimeline);
    }

    private boolean isLastInPeriod(MediaSource.MediaPeriodId id) {
        return !id.isAd() && id.nextAdGroupIndex == -1;
    }

    private boolean isLastInTimeline(MediaSource.MediaPeriodId id, boolean isLastMediaPeriodInPeriod) {
        int periodIndex = this.timeline.getIndexOfPeriod(id.periodUid);
        int windowIndex = this.timeline.getPeriod((int)periodIndex, (Timeline.Period)this.period).windowIndex;
        return !this.timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).isDynamic && this.timeline.isLastPeriod(periodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled) && isLastMediaPeriodInPeriod;
    }
}

