/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.MediaPeriodInfo;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.ClippingMediaPeriod;
import com.google.android.exoplayer2.source.EmptySampleStream;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import org.checkerframework.checker.nullness.compatqual.NullableType;

final class MediaPeriodHolder {
    private static final String TAG = "MediaPeriodHolder";
    public final MediaPeriod mediaPeriod;
    public final Object uid;
    public final @NullableType SampleStream[] sampleStreams;
    public boolean prepared;
    public boolean hasEnabledTracks;
    public MediaPeriodInfo info;
    private final boolean[] mayRetainStreamFlags;
    private final RendererCapabilities[] rendererCapabilities;
    private final TrackSelector trackSelector;
    private final MediaSource mediaSource;
    @Nullable
    private MediaPeriodHolder next;
    @Nullable
    private TrackGroupArray trackGroups;
    @Nullable
    private TrackSelectorResult trackSelectorResult;
    private long rendererPositionOffsetUs;

    public MediaPeriodHolder(RendererCapabilities[] rendererCapabilities, long rendererPositionOffsetUs, TrackSelector trackSelector, Allocator allocator, MediaSource mediaSource, MediaPeriodInfo info) {
        this.rendererCapabilities = rendererCapabilities;
        this.rendererPositionOffsetUs = rendererPositionOffsetUs - info.startPositionUs;
        this.trackSelector = trackSelector;
        this.mediaSource = mediaSource;
        this.uid = info.id.periodUid;
        this.info = info;
        this.sampleStreams = new SampleStream[rendererCapabilities.length];
        this.mayRetainStreamFlags = new boolean[rendererCapabilities.length];
        this.mediaPeriod = MediaPeriodHolder.createMediaPeriod(info.id, mediaSource, allocator, info.startPositionUs, info.endPositionUs);
    }

    public long toRendererTime(long periodTimeUs) {
        return periodTimeUs + this.getRendererOffset();
    }

    public long toPeriodTime(long rendererTimeUs) {
        return rendererTimeUs - this.getRendererOffset();
    }

    public long getRendererOffset() {
        return this.rendererPositionOffsetUs;
    }

    public long getStartPositionRendererTime() {
        return this.info.startPositionUs + this.rendererPositionOffsetUs;
    }

    public boolean isFullyBuffered() {
        return this.prepared && (!this.hasEnabledTracks || this.mediaPeriod.getBufferedPositionUs() == Long.MIN_VALUE);
    }

    public long getBufferedPositionUs() {
        if (!this.prepared) {
            return this.info.startPositionUs;
        }
        long bufferedPositionUs = this.hasEnabledTracks ? this.mediaPeriod.getBufferedPositionUs() : Long.MIN_VALUE;
        return bufferedPositionUs == Long.MIN_VALUE ? this.info.durationUs : bufferedPositionUs;
    }

    public long getNextLoadPositionUs() {
        return !this.prepared ? 0L : this.mediaPeriod.getNextLoadPositionUs();
    }

    public void handlePrepared(float playbackSpeed, Timeline timeline) throws ExoPlaybackException {
        this.prepared = true;
        this.trackGroups = this.mediaPeriod.getTrackGroups();
        TrackSelectorResult selectorResult = Assertions.checkNotNull(this.selectTracks(playbackSpeed, timeline));
        long newStartPositionUs = this.applyTrackSelection(selectorResult, this.info.startPositionUs, false);
        this.rendererPositionOffsetUs += this.info.startPositionUs - newStartPositionUs;
        this.info = this.info.copyWithStartPositionUs(newStartPositionUs);
    }

    public void reevaluateBuffer(long rendererPositionUs) {
        Assertions.checkState(this.isLoadingMediaPeriod());
        if (this.prepared) {
            this.mediaPeriod.reevaluateBuffer(this.toPeriodTime(rendererPositionUs));
        }
    }

    public void continueLoading(long rendererPositionUs) {
        Assertions.checkState(this.isLoadingMediaPeriod());
        long loadingPeriodPositionUs = this.toPeriodTime(rendererPositionUs);
        this.mediaPeriod.continueLoading(loadingPeriodPositionUs);
    }

    @Nullable
    public TrackSelectorResult selectTracks(float playbackSpeed, Timeline timeline) throws ExoPlaybackException {
        TrackSelectorResult selectorResult = this.trackSelector.selectTracks(this.rendererCapabilities, this.getTrackGroups(), this.info.id, timeline);
        if (selectorResult.isEquivalent(this.trackSelectorResult)) {
            return null;
        }
        for (TrackSelection trackSelection : selectorResult.selections.getAll()) {
            if (trackSelection == null) continue;
            trackSelection.onPlaybackSpeed(playbackSpeed);
        }
        return selectorResult;
    }

    public long applyTrackSelection(TrackSelectorResult trackSelectorResult, long positionUs, boolean forceRecreateStreams) {
        return this.applyTrackSelection(trackSelectorResult, positionUs, forceRecreateStreams, new boolean[this.rendererCapabilities.length]);
    }

    public long applyTrackSelection(TrackSelectorResult newTrackSelectorResult, long positionUs, boolean forceRecreateStreams, boolean[] streamResetFlags) {
        for (int i = 0; i < newTrackSelectorResult.length; ++i) {
            this.mayRetainStreamFlags[i] = !forceRecreateStreams && newTrackSelectorResult.isEquivalent(this.trackSelectorResult, i);
        }
        this.disassociateNoSampleRenderersWithEmptySampleStream(this.sampleStreams);
        this.disableTrackSelectionsInResult();
        this.trackSelectorResult = newTrackSelectorResult;
        this.enableTrackSelectionsInResult();
        TrackSelectionArray trackSelections = newTrackSelectorResult.selections;
        positionUs = this.mediaPeriod.selectTracks(trackSelections.getAll(), this.mayRetainStreamFlags, this.sampleStreams, streamResetFlags, positionUs);
        this.associateNoSampleRenderersWithEmptySampleStream(this.sampleStreams);
        this.hasEnabledTracks = false;
        for (int i = 0; i < this.sampleStreams.length; ++i) {
            if (this.sampleStreams[i] != null) {
                Assertions.checkState(newTrackSelectorResult.isRendererEnabled(i));
                if (this.rendererCapabilities[i].getTrackType() == 6) continue;
                this.hasEnabledTracks = true;
                continue;
            }
            Assertions.checkState(trackSelections.get(i) == null);
        }
        return positionUs;
    }

    public void release() {
        this.disableTrackSelectionsInResult();
        this.trackSelectorResult = null;
        MediaPeriodHolder.releaseMediaPeriod(this.info.endPositionUs, this.mediaSource, this.mediaPeriod);
    }

    public void setNext(@Nullable MediaPeriodHolder nextMediaPeriodHolder) {
        if (nextMediaPeriodHolder == this.next) {
            return;
        }
        this.disableTrackSelectionsInResult();
        this.next = nextMediaPeriodHolder;
        this.enableTrackSelectionsInResult();
    }

    @Nullable
    public MediaPeriodHolder getNext() {
        return this.next;
    }

    public TrackGroupArray getTrackGroups() {
        return Assertions.checkNotNull(this.trackGroups);
    }

    public TrackSelectorResult getTrackSelectorResult() {
        return Assertions.checkNotNull(this.trackSelectorResult);
    }

    private void enableTrackSelectionsInResult() {
        TrackSelectorResult trackSelectorResult = this.trackSelectorResult;
        if (!this.isLoadingMediaPeriod() || trackSelectorResult == null) {
            return;
        }
        for (int i = 0; i < trackSelectorResult.length; ++i) {
            boolean rendererEnabled = trackSelectorResult.isRendererEnabled(i);
            TrackSelection trackSelection = trackSelectorResult.selections.get(i);
            if (!rendererEnabled || trackSelection == null) continue;
            trackSelection.enable();
        }
    }

    private void disableTrackSelectionsInResult() {
        TrackSelectorResult trackSelectorResult = this.trackSelectorResult;
        if (!this.isLoadingMediaPeriod() || trackSelectorResult == null) {
            return;
        }
        for (int i = 0; i < trackSelectorResult.length; ++i) {
            boolean rendererEnabled = trackSelectorResult.isRendererEnabled(i);
            TrackSelection trackSelection = trackSelectorResult.selections.get(i);
            if (!rendererEnabled || trackSelection == null) continue;
            trackSelection.disable();
        }
    }

    private void disassociateNoSampleRenderersWithEmptySampleStream(@NullableType SampleStream[] sampleStreams) {
        for (int i = 0; i < this.rendererCapabilities.length; ++i) {
            if (this.rendererCapabilities[i].getTrackType() != 6) continue;
            sampleStreams[i] = null;
        }
    }

    private void associateNoSampleRenderersWithEmptySampleStream(@NullableType SampleStream[] sampleStreams) {
        TrackSelectorResult trackSelectorResult = Assertions.checkNotNull(this.trackSelectorResult);
        for (int i = 0; i < this.rendererCapabilities.length; ++i) {
            if (this.rendererCapabilities[i].getTrackType() != 6 || !trackSelectorResult.isRendererEnabled(i)) continue;
            sampleStreams[i] = new EmptySampleStream();
        }
    }

    private boolean isLoadingMediaPeriod() {
        return this.next == null;
    }

    private static MediaPeriod createMediaPeriod(MediaSource.MediaPeriodId id, MediaSource mediaSource, Allocator allocator, long startPositionUs, long endPositionUs) {
        MediaPeriod mediaPeriod = mediaSource.createPeriod(id, allocator, startPositionUs);
        if (endPositionUs != -9223372036854775807L && endPositionUs != Long.MIN_VALUE) {
            mediaPeriod = new ClippingMediaPeriod(mediaPeriod, true, 0L, endPositionUs);
        }
        return mediaPeriod;
    }

    private static void releaseMediaPeriod(long endPositionUs, MediaSource mediaSource, MediaPeriod mediaPeriod) {
        try {
            if (endPositionUs != -9223372036854775807L && endPositionUs != Long.MIN_VALUE) {
                mediaSource.releasePeriod(((ClippingMediaPeriod)mediaPeriod).mediaPeriod);
            } else {
                mediaSource.releasePeriod(mediaPeriod);
            }
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Period release failed.", e);
        }
    }
}

