/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultMediaClock;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaPeriodHolder;
import com.google.android.exoplayer2.MediaPeriodInfo;
import com.google.android.exoplayer2.MediaPeriodQueue;
import com.google.android.exoplayer2.PlaybackInfo;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;

final class ExoPlayerImplInternal
implements Handler.Callback,
MediaPeriod.Callback,
TrackSelector.InvalidationListener,
MediaSource.SourceInfoRefreshListener,
DefaultMediaClock.PlaybackParameterListener,
PlayerMessage.Sender {
    private static final String TAG = "ExoPlayerImplInternal";
    public static final int MSG_PLAYBACK_INFO_CHANGED = 0;
    public static final int MSG_PLAYBACK_PARAMETERS_CHANGED = 1;
    public static final int MSG_ERROR = 2;
    private static final int MSG_PREPARE = 0;
    private static final int MSG_SET_PLAY_WHEN_READY = 1;
    private static final int MSG_DO_SOME_WORK = 2;
    private static final int MSG_SEEK_TO = 3;
    private static final int MSG_SET_PLAYBACK_PARAMETERS = 4;
    private static final int MSG_SET_SEEK_PARAMETERS = 5;
    private static final int MSG_STOP = 6;
    private static final int MSG_RELEASE = 7;
    private static final int MSG_REFRESH_SOURCE_INFO = 8;
    private static final int MSG_PERIOD_PREPARED = 9;
    private static final int MSG_SOURCE_CONTINUE_LOADING_REQUESTED = 10;
    private static final int MSG_TRACK_SELECTION_INVALIDATED = 11;
    private static final int MSG_SET_REPEAT_MODE = 12;
    private static final int MSG_SET_SHUFFLE_ENABLED = 13;
    private static final int MSG_SET_FOREGROUND_MODE = 14;
    private static final int MSG_SEND_MESSAGE = 15;
    private static final int MSG_SEND_MESSAGE_TO_TARGET_THREAD = 16;
    private static final int MSG_PLAYBACK_PARAMETERS_CHANGED_INTERNAL = 17;
    private static final int PREPARING_SOURCE_INTERVAL_MS = 10;
    private static final int RENDERING_INTERVAL_MS = 10;
    private static final int IDLE_INTERVAL_MS = 1000;
    private final Renderer[] renderers;
    private final RendererCapabilities[] rendererCapabilities;
    private final TrackSelector trackSelector;
    private final TrackSelectorResult emptyTrackSelectorResult;
    private final LoadControl loadControl;
    private final BandwidthMeter bandwidthMeter;
    private final HandlerWrapper handler;
    private final HandlerThread internalPlaybackThread;
    private final Handler eventHandler;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final long backBufferDurationUs;
    private final boolean retainBackBufferFromKeyframe;
    private final DefaultMediaClock mediaClock;
    private final PlaybackInfoUpdate playbackInfoUpdate;
    private final ArrayList<PendingMessageInfo> pendingMessages;
    private final Clock clock;
    private final MediaPeriodQueue queue;
    private SeekParameters seekParameters;
    private PlaybackInfo playbackInfo;
    private MediaSource mediaSource;
    private Renderer[] enabledRenderers;
    private boolean released;
    private boolean playWhenReady;
    private boolean rebuffering;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    private boolean foregroundMode;
    private int pendingPrepareCount;
    private SeekPosition pendingInitialSeekPosition;
    private long rendererPositionUs;
    private int nextPendingMessageIndex;

    public ExoPlayerImplInternal(Renderer[] renderers, TrackSelector trackSelector, TrackSelectorResult emptyTrackSelectorResult, LoadControl loadControl, BandwidthMeter bandwidthMeter, boolean playWhenReady, int repeatMode, boolean shuffleModeEnabled, Handler eventHandler, Clock clock) {
        this.renderers = renderers;
        this.trackSelector = trackSelector;
        this.emptyTrackSelectorResult = emptyTrackSelectorResult;
        this.loadControl = loadControl;
        this.bandwidthMeter = bandwidthMeter;
        this.playWhenReady = playWhenReady;
        this.repeatMode = repeatMode;
        this.shuffleModeEnabled = shuffleModeEnabled;
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.queue = new MediaPeriodQueue();
        this.backBufferDurationUs = loadControl.getBackBufferDurationUs();
        this.retainBackBufferFromKeyframe = loadControl.retainBackBufferFromKeyframe();
        this.seekParameters = SeekParameters.DEFAULT;
        this.playbackInfo = PlaybackInfo.createDummy(-9223372036854775807L, emptyTrackSelectorResult);
        this.playbackInfoUpdate = new PlaybackInfoUpdate();
        this.rendererCapabilities = new RendererCapabilities[renderers.length];
        for (int i = 0; i < renderers.length; ++i) {
            renderers[i].setIndex(i);
            this.rendererCapabilities[i] = renderers[i].getCapabilities();
        }
        this.mediaClock = new DefaultMediaClock(this, clock);
        this.pendingMessages = new ArrayList();
        this.enabledRenderers = new Renderer[0];
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        trackSelector.init(this, bandwidthMeter);
        this.internalPlaybackThread = new HandlerThread("ExoPlayerImplInternal:Handler", -16);
        this.internalPlaybackThread.start();
        this.handler = clock.createHandler(this.internalPlaybackThread.getLooper(), this);
    }

    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.handler.obtainMessage(0, resetPosition ? 1 : 0, resetState ? 1 : 0, mediaSource).sendToTarget();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.handler.obtainMessage(1, playWhenReady ? 1 : 0, 0).sendToTarget();
    }

    public void setRepeatMode(int repeatMode) {
        this.handler.obtainMessage(12, repeatMode, 0).sendToTarget();
    }

    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.handler.obtainMessage(13, shuffleModeEnabled ? 1 : 0, 0).sendToTarget();
    }

    public void seekTo(Timeline timeline, int windowIndex, long positionUs) {
        this.handler.obtainMessage(3, new SeekPosition(timeline, windowIndex, positionUs)).sendToTarget();
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.handler.obtainMessage(4, playbackParameters).sendToTarget();
    }

    public void setSeekParameters(SeekParameters seekParameters) {
        this.handler.obtainMessage(5, seekParameters).sendToTarget();
    }

    public void stop(boolean reset) {
        this.handler.obtainMessage(6, reset ? 1 : 0, 0).sendToTarget();
    }

    @Override
    public synchronized void sendMessage(PlayerMessage message) {
        if (this.released) {
            Log.w(TAG, "Ignoring messages sent after release.");
            message.markAsProcessed(false);
            return;
        }
        this.handler.obtainMessage(15, message).sendToTarget();
    }

    public synchronized void setForegroundMode(boolean foregroundMode) {
        if (foregroundMode) {
            this.handler.obtainMessage(14, 1, 0).sendToTarget();
        } else {
            AtomicBoolean processedFlag = new AtomicBoolean();
            this.handler.obtainMessage(14, 0, 0, processedFlag).sendToTarget();
            boolean wasInterrupted = false;
            while (!processedFlag.get() && !this.released) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void release() {
        if (this.released) {
            return;
        }
        this.handler.sendEmptyMessage(7);
        boolean wasInterrupted = false;
        while (!this.released) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public Looper getPlaybackLooper() {
        return this.internalPlaybackThread.getLooper();
    }

    @Override
    public void onSourceInfoRefreshed(MediaSource source, Timeline timeline, Object manifest) {
        this.handler.obtainMessage(8, new MediaSourceRefreshInfo(source, timeline, manifest)).sendToTarget();
    }

    @Override
    public void onPrepared(MediaPeriod source) {
        this.handler.obtainMessage(9, source).sendToTarget();
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod source) {
        this.handler.obtainMessage(10, source).sendToTarget();
    }

    @Override
    public void onTrackSelectionsInvalidated() {
        this.handler.sendEmptyMessage(11);
    }

    @Override
    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        this.handler.obtainMessage(17, playbackParameters).sendToTarget();
    }

    public boolean handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 0: {
                    this.prepareInternal((MediaSource)msg.obj, msg.arg1 != 0, msg.arg2 != 0);
                    break;
                }
                case 1: {
                    this.setPlayWhenReadyInternal(msg.arg1 != 0);
                    break;
                }
                case 12: {
                    this.setRepeatModeInternal(msg.arg1);
                    break;
                }
                case 13: {
                    this.setShuffleModeEnabledInternal(msg.arg1 != 0);
                    break;
                }
                case 2: {
                    this.doSomeWork();
                    break;
                }
                case 3: {
                    this.seekToInternal((SeekPosition)msg.obj);
                    break;
                }
                case 4: {
                    this.setPlaybackParametersInternal((PlaybackParameters)msg.obj);
                    break;
                }
                case 5: {
                    this.setSeekParametersInternal((SeekParameters)msg.obj);
                    break;
                }
                case 14: {
                    this.setForegroundModeInternal(msg.arg1 != 0, (AtomicBoolean)msg.obj);
                    break;
                }
                case 6: {
                    this.stopInternal(false, msg.arg1 != 0, true);
                    break;
                }
                case 9: {
                    this.handlePeriodPrepared((MediaPeriod)msg.obj);
                    break;
                }
                case 8: {
                    this.handleSourceInfoRefreshed((MediaSourceRefreshInfo)msg.obj);
                    break;
                }
                case 10: {
                    this.handleContinueLoadingRequested((MediaPeriod)msg.obj);
                    break;
                }
                case 11: {
                    this.reselectTracksInternal();
                    break;
                }
                case 17: {
                    this.handlePlaybackParameters((PlaybackParameters)msg.obj);
                    break;
                }
                case 15: {
                    this.sendMessageInternal((PlayerMessage)msg.obj);
                    break;
                }
                case 16: {
                    this.sendMessageToTargetThread((PlayerMessage)msg.obj);
                    break;
                }
                case 7: {
                    this.releaseInternal();
                    return true;
                }
                default: {
                    return false;
                }
            }
            this.maybeNotifyPlaybackInfoChanged();
        }
        catch (ExoPlaybackException e) {
            Log.e(TAG, "Playback error.", e);
            this.eventHandler.obtainMessage(2, (Object)e).sendToTarget();
            this.stopInternal(true, false, false);
            this.maybeNotifyPlaybackInfoChanged();
        }
        catch (IOException e) {
            Log.e(TAG, "Source error.", e);
            this.eventHandler.obtainMessage(2, (Object)ExoPlaybackException.createForSource(e)).sendToTarget();
            this.stopInternal(false, false, false);
            this.maybeNotifyPlaybackInfoChanged();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            Log.e(TAG, "Internal runtime error.", e);
            ExoPlaybackException error = e instanceof OutOfMemoryError ? ExoPlaybackException.createForOutOfMemoryError((OutOfMemoryError)e) : ExoPlaybackException.createForUnexpected((RuntimeException)e);
            this.eventHandler.obtainMessage(2, (Object)error).sendToTarget();
            this.stopInternal(true, false, false);
            this.maybeNotifyPlaybackInfoChanged();
        }
        return true;
    }

    private void setState(int state) {
        if (this.playbackInfo.playbackState != state) {
            this.playbackInfo = this.playbackInfo.copyWithPlaybackState(state);
        }
    }

    private void setIsLoading(boolean isLoading) {
        if (this.playbackInfo.isLoading != isLoading) {
            this.playbackInfo = this.playbackInfo.copyWithIsLoading(isLoading);
        }
    }

    private void maybeNotifyPlaybackInfoChanged() {
        if (this.playbackInfoUpdate.hasPendingUpdate(this.playbackInfo)) {
            this.eventHandler.obtainMessage(0, this.playbackInfoUpdate.operationAcks, this.playbackInfoUpdate.positionDiscontinuity ? this.playbackInfoUpdate.discontinuityReason : -1, (Object)this.playbackInfo).sendToTarget();
            this.playbackInfoUpdate.reset(this.playbackInfo);
        }
    }

    private void prepareInternal(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        ++this.pendingPrepareCount;
        this.resetInternal(false, true, resetPosition, resetState);
        this.loadControl.onPrepared();
        this.mediaSource = mediaSource;
        this.setState(2);
        mediaSource.prepareSource(this, this.bandwidthMeter.getTransferListener());
        this.handler.sendEmptyMessage(2);
    }

    private void setPlayWhenReadyInternal(boolean playWhenReady) throws ExoPlaybackException {
        this.rebuffering = false;
        this.playWhenReady = playWhenReady;
        if (!playWhenReady) {
            this.stopRenderers();
            this.updatePlaybackPositions();
        } else if (this.playbackInfo.playbackState == 3) {
            this.startRenderers();
            this.handler.sendEmptyMessage(2);
        } else if (this.playbackInfo.playbackState == 2) {
            this.handler.sendEmptyMessage(2);
        }
    }

    private void setRepeatModeInternal(int repeatMode) throws ExoPlaybackException {
        this.repeatMode = repeatMode;
        if (!this.queue.updateRepeatMode(repeatMode)) {
            this.seekToCurrentPosition(true);
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void setShuffleModeEnabledInternal(boolean shuffleModeEnabled) throws ExoPlaybackException {
        this.shuffleModeEnabled = shuffleModeEnabled;
        if (!this.queue.updateShuffleModeEnabled(shuffleModeEnabled)) {
            this.seekToCurrentPosition(true);
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void seekToCurrentPosition(boolean sendDiscontinuity) throws ExoPlaybackException {
        MediaSource.MediaPeriodId periodId = this.queue.getPlayingPeriod().info.id;
        long newPositionUs = this.seekToPeriodPosition(periodId, this.playbackInfo.positionUs, true);
        if (newPositionUs != this.playbackInfo.positionUs) {
            this.playbackInfo = this.playbackInfo.copyWithNewPosition(periodId, newPositionUs, this.playbackInfo.contentPositionUs, this.getTotalBufferedDurationUs());
            if (sendDiscontinuity) {
                this.playbackInfoUpdate.setPositionDiscontinuity(4);
            }
        }
    }

    private void startRenderers() throws ExoPlaybackException {
        this.rebuffering = false;
        this.mediaClock.start();
        for (Renderer renderer : this.enabledRenderers) {
            renderer.start();
        }
    }

    private void stopRenderers() throws ExoPlaybackException {
        this.mediaClock.stop();
        for (Renderer renderer : this.enabledRenderers) {
            this.ensureStopped(renderer);
        }
    }

    private void updatePlaybackPositions() throws ExoPlaybackException {
        if (!this.queue.hasPlayingPeriod()) {
            return;
        }
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        long periodPositionUs = playingPeriodHolder.mediaPeriod.readDiscontinuity();
        if (periodPositionUs != -9223372036854775807L) {
            this.resetRendererPosition(periodPositionUs);
            if (periodPositionUs != this.playbackInfo.positionUs) {
                this.playbackInfo = this.playbackInfo.copyWithNewPosition(this.playbackInfo.periodId, periodPositionUs, this.playbackInfo.contentPositionUs, this.getTotalBufferedDurationUs());
                this.playbackInfoUpdate.setPositionDiscontinuity(4);
            }
        } else {
            this.rendererPositionUs = this.mediaClock.syncAndGetPositionUs();
            periodPositionUs = playingPeriodHolder.toPeriodTime(this.rendererPositionUs);
            this.maybeTriggerPendingMessages(this.playbackInfo.positionUs, periodPositionUs);
            this.playbackInfo.positionUs = periodPositionUs;
        }
        MediaPeriodHolder loadingPeriod = this.queue.getLoadingPeriod();
        this.playbackInfo.bufferedPositionUs = loadingPeriod.getBufferedPositionUs();
        this.playbackInfo.totalBufferedDurationUs = this.getTotalBufferedDurationUs();
    }

    private void doSomeWork() throws ExoPlaybackException, IOException {
        long operationStartTimeMs = this.clock.uptimeMillis();
        this.updatePeriods();
        if (!this.queue.hasPlayingPeriod()) {
            this.maybeThrowPeriodPrepareError();
            this.scheduleNextWork(operationStartTimeMs, 10L);
            return;
        }
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        TraceUtil.beginSection("doSomeWork");
        this.updatePlaybackPositions();
        long rendererPositionElapsedRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
        playingPeriodHolder.mediaPeriod.discardBuffer(this.playbackInfo.positionUs - this.backBufferDurationUs, this.retainBackBufferFromKeyframe);
        boolean renderersEnded = true;
        boolean renderersReadyOrEnded = true;
        for (Renderer renderer : this.enabledRenderers) {
            boolean rendererReadyOrEnded;
            renderer.render(this.rendererPositionUs, rendererPositionElapsedRealtimeUs);
            renderersEnded = renderersEnded && renderer.isEnded();
            boolean bl = rendererReadyOrEnded = renderer.isReady() || renderer.isEnded() || this.rendererWaitingForNextStream(renderer);
            if (!rendererReadyOrEnded) {
                renderer.maybeThrowStreamError();
            }
            renderersReadyOrEnded = renderersReadyOrEnded && rendererReadyOrEnded;
        }
        if (!renderersReadyOrEnded) {
            this.maybeThrowPeriodPrepareError();
        }
        long playingPeriodDurationUs = playingPeriodHolder.info.durationUs;
        if (renderersEnded && (playingPeriodDurationUs == -9223372036854775807L || playingPeriodDurationUs <= this.playbackInfo.positionUs) && playingPeriodHolder.info.isFinal) {
            this.setState(4);
            this.stopRenderers();
        } else if (this.playbackInfo.playbackState == 2 && this.shouldTransitionToReadyState(renderersReadyOrEnded)) {
            this.setState(3);
            if (this.playWhenReady) {
                this.startRenderers();
            }
        } else if (this.playbackInfo.playbackState == 3 && !(this.enabledRenderers.length != 0 ? renderersReadyOrEnded : this.isTimelineReady())) {
            this.rebuffering = this.playWhenReady;
            this.setState(2);
            this.stopRenderers();
        }
        if (this.playbackInfo.playbackState == 2) {
            for (Renderer renderer : this.enabledRenderers) {
                renderer.maybeThrowStreamError();
            }
        }
        if (this.playWhenReady && this.playbackInfo.playbackState == 3 || this.playbackInfo.playbackState == 2) {
            this.scheduleNextWork(operationStartTimeMs, 10L);
        } else if (this.enabledRenderers.length != 0 && this.playbackInfo.playbackState != 4) {
            this.scheduleNextWork(operationStartTimeMs, 1000L);
        } else {
            this.handler.removeMessages(2);
        }
        TraceUtil.endSection();
    }

    private void scheduleNextWork(long thisOperationStartTimeMs, long intervalMs) {
        this.handler.removeMessages(2);
        this.handler.sendEmptyMessageAtTime(2, thisOperationStartTimeMs + intervalMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekToInternal(SeekPosition seekPosition) throws ExoPlaybackException {
        boolean seekPositionAdjusted;
        long contentPositionUs;
        long periodPositionUs;
        MediaSource.MediaPeriodId periodId;
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Pair<Object, Long> resolvedSeekPosition = this.resolveSeekPosition(seekPosition, true);
        if (resolvedSeekPosition == null) {
            periodId = this.playbackInfo.getDummyFirstMediaPeriodId(this.shuffleModeEnabled, this.window);
            periodPositionUs = -9223372036854775807L;
            contentPositionUs = -9223372036854775807L;
            seekPositionAdjusted = true;
        } else {
            Object periodUid = resolvedSeekPosition.first;
            contentPositionUs = (Long)resolvedSeekPosition.second;
            periodId = this.queue.resolveMediaPeriodIdForAds(periodUid, contentPositionUs);
            if (periodId.isAd()) {
                periodPositionUs = 0L;
                seekPositionAdjusted = true;
            } else {
                periodPositionUs = (Long)resolvedSeekPosition.second;
                seekPositionAdjusted = seekPosition.windowPositionUs == -9223372036854775807L;
            }
        }
        try {
            if (this.mediaSource == null || this.pendingPrepareCount > 0) {
                this.pendingInitialSeekPosition = seekPosition;
            } else if (periodPositionUs == -9223372036854775807L) {
                this.setState(4);
                this.resetInternal(false, false, true, false);
            } else {
                long newPeriodPositionUs = periodPositionUs;
                if (periodId.equals(this.playbackInfo.periodId)) {
                    MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
                    if (playingPeriodHolder != null && newPeriodPositionUs != 0L) {
                        newPeriodPositionUs = playingPeriodHolder.mediaPeriod.getAdjustedSeekPositionUs(newPeriodPositionUs, this.seekParameters);
                    }
                    if (C.usToMs(newPeriodPositionUs) == C.usToMs(this.playbackInfo.positionUs)) {
                        periodPositionUs = this.playbackInfo.positionUs;
                        return;
                    }
                }
                seekPositionAdjusted |= periodPositionUs != (newPeriodPositionUs = this.seekToPeriodPosition(periodId, newPeriodPositionUs));
                periodPositionUs = newPeriodPositionUs;
            }
        }
        finally {
            this.playbackInfo = this.playbackInfo.copyWithNewPosition(periodId, periodPositionUs, contentPositionUs, this.getTotalBufferedDurationUs());
            if (seekPositionAdjusted) {
                this.playbackInfoUpdate.setPositionDiscontinuity(2);
            }
        }
    }

    private long seekToPeriodPosition(MediaSource.MediaPeriodId periodId, long periodPositionUs) throws ExoPlaybackException {
        return this.seekToPeriodPosition(periodId, periodPositionUs, this.queue.getPlayingPeriod() != this.queue.getReadingPeriod());
    }

    private long seekToPeriodPosition(MediaSource.MediaPeriodId periodId, long periodPositionUs, boolean forceDisableRenderers) throws ExoPlaybackException {
        MediaPeriodHolder oldPlayingPeriodHolder;
        this.stopRenderers();
        this.rebuffering = false;
        this.setState(2);
        MediaPeriodHolder newPlayingPeriodHolder = oldPlayingPeriodHolder = this.queue.getPlayingPeriod();
        while (newPlayingPeriodHolder != null) {
            if (periodId.equals(newPlayingPeriodHolder.info.id) && newPlayingPeriodHolder.prepared) {
                this.queue.removeAfter(newPlayingPeriodHolder);
                break;
            }
            newPlayingPeriodHolder = this.queue.advancePlayingPeriod();
        }
        if (oldPlayingPeriodHolder != newPlayingPeriodHolder || forceDisableRenderers) {
            for (Renderer renderer : this.enabledRenderers) {
                this.disableRenderer(renderer);
            }
            this.enabledRenderers = new Renderer[0];
            oldPlayingPeriodHolder = null;
        }
        if (newPlayingPeriodHolder != null) {
            this.updatePlayingPeriodRenderers(oldPlayingPeriodHolder);
            if (newPlayingPeriodHolder.hasEnabledTracks) {
                periodPositionUs = newPlayingPeriodHolder.mediaPeriod.seekToUs(periodPositionUs);
                newPlayingPeriodHolder.mediaPeriod.discardBuffer(periodPositionUs - this.backBufferDurationUs, this.retainBackBufferFromKeyframe);
            }
            this.resetRendererPosition(periodPositionUs);
            this.maybeContinueLoading();
        } else {
            this.queue.clear(true);
            this.playbackInfo = this.playbackInfo.copyWithTrackInfo(TrackGroupArray.EMPTY, this.emptyTrackSelectorResult);
            this.resetRendererPosition(periodPositionUs);
        }
        this.handleLoadingMediaPeriodChanged(false);
        this.handler.sendEmptyMessage(2);
        return periodPositionUs;
    }

    private void resetRendererPosition(long periodPositionUs) throws ExoPlaybackException {
        this.rendererPositionUs = !this.queue.hasPlayingPeriod() ? periodPositionUs : this.queue.getPlayingPeriod().toRendererTime(periodPositionUs);
        this.mediaClock.resetPosition(this.rendererPositionUs);
        for (Renderer renderer : this.enabledRenderers) {
            renderer.resetPosition(this.rendererPositionUs);
        }
        this.notifyTrackSelectionDiscontinuity();
    }

    private void setPlaybackParametersInternal(PlaybackParameters playbackParameters) {
        this.mediaClock.setPlaybackParameters(playbackParameters);
    }

    private void setSeekParametersInternal(SeekParameters seekParameters) {
        this.seekParameters = seekParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setForegroundModeInternal(boolean foregroundMode, @Nullable AtomicBoolean processedFlag) {
        if (this.foregroundMode != foregroundMode) {
            this.foregroundMode = foregroundMode;
            if (!foregroundMode) {
                for (Renderer renderer : this.renderers) {
                    if (renderer.getState() != 0) continue;
                    renderer.reset();
                }
            }
        }
        if (processedFlag == null) return;
        Renderer[] rendererArray = this;
        synchronized (this) {
            processedFlag.set(true);
            this.notifyAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void stopInternal(boolean forceResetRenderers, boolean resetPositionAndState, boolean acknowledgeStop) {
        this.resetInternal(forceResetRenderers || !this.foregroundMode, true, resetPositionAndState, resetPositionAndState);
        this.playbackInfoUpdate.incrementPendingOperationAcks(this.pendingPrepareCount + (acknowledgeStop ? 1 : 0));
        this.pendingPrepareCount = 0;
        this.loadControl.onStopped();
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal() {
        this.resetInternal(true, true, true, true);
        this.loadControl.onReleased();
        this.setState(1);
        this.internalPlaybackThread.quit();
        ExoPlayerImplInternal exoPlayerImplInternal = this;
        synchronized (exoPlayerImplInternal) {
            this.released = true;
            this.notifyAll();
        }
    }

    private void resetInternal(boolean resetRenderers, boolean releaseMediaSource, boolean resetPosition, boolean resetState) {
        this.handler.removeMessages(2);
        this.rebuffering = false;
        this.mediaClock.stop();
        this.rendererPositionUs = 0L;
        for (Renderer renderer : this.enabledRenderers) {
            try {
                this.disableRenderer(renderer);
            }
            catch (ExoPlaybackException | RuntimeException e) {
                Log.e(TAG, "Disable failed.", e);
            }
        }
        if (resetRenderers) {
            for (Renderer renderer : this.renderers) {
                try {
                    renderer.reset();
                }
                catch (RuntimeException e) {
                    Log.e(TAG, "Reset failed.", e);
                }
            }
        }
        this.enabledRenderers = new Renderer[0];
        if (resetPosition) {
            this.pendingInitialSeekPosition = null;
        } else if (resetState) {
            resetPosition = true;
            if (this.pendingInitialSeekPosition == null && !this.playbackInfo.timeline.isEmpty()) {
                this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.periodId.periodUid, this.period);
                long windowPositionUs = this.playbackInfo.positionUs + this.period.getPositionInWindowUs();
                this.pendingInitialSeekPosition = new SeekPosition(Timeline.EMPTY, this.period.windowIndex, windowPositionUs);
            }
        }
        this.queue.clear(!resetPosition);
        this.setIsLoading(false);
        if (resetState) {
            this.queue.setTimeline(Timeline.EMPTY);
            for (PendingMessageInfo pendingMessageInfo : this.pendingMessages) {
                pendingMessageInfo.message.markAsProcessed(false);
            }
            this.pendingMessages.clear();
            this.nextPendingMessageIndex = 0;
        }
        MediaSource.MediaPeriodId mediaPeriodId = resetPosition ? this.playbackInfo.getDummyFirstMediaPeriodId(this.shuffleModeEnabled, this.window) : this.playbackInfo.periodId;
        long startPositionUs = resetPosition ? -9223372036854775807L : this.playbackInfo.positionUs;
        long contentPositionUs = resetPosition ? -9223372036854775807L : this.playbackInfo.contentPositionUs;
        this.playbackInfo = new PlaybackInfo(resetState ? Timeline.EMPTY : this.playbackInfo.timeline, resetState ? null : this.playbackInfo.manifest, mediaPeriodId, startPositionUs, contentPositionUs, this.playbackInfo.playbackState, false, resetState ? TrackGroupArray.EMPTY : this.playbackInfo.trackGroups, resetState ? this.emptyTrackSelectorResult : this.playbackInfo.trackSelectorResult, mediaPeriodId, startPositionUs, 0L, startPositionUs);
        if (releaseMediaSource && this.mediaSource != null) {
            this.mediaSource.releaseSource(this);
            this.mediaSource = null;
        }
    }

    private void sendMessageInternal(PlayerMessage message) throws ExoPlaybackException {
        if (message.getPositionMs() == -9223372036854775807L) {
            this.sendMessageToTarget(message);
        } else if (this.mediaSource == null || this.pendingPrepareCount > 0) {
            this.pendingMessages.add(new PendingMessageInfo(message));
        } else {
            PendingMessageInfo pendingMessageInfo = new PendingMessageInfo(message);
            if (this.resolvePendingMessagePosition(pendingMessageInfo)) {
                this.pendingMessages.add(pendingMessageInfo);
                Collections.sort(this.pendingMessages);
            } else {
                message.markAsProcessed(false);
            }
        }
    }

    private void sendMessageToTarget(PlayerMessage message) throws ExoPlaybackException {
        if (message.getHandler().getLooper() == this.handler.getLooper()) {
            this.deliverMessage(message);
            if (this.playbackInfo.playbackState == 3 || this.playbackInfo.playbackState == 2) {
                this.handler.sendEmptyMessage(2);
            }
        } else {
            this.handler.obtainMessage(16, message).sendToTarget();
        }
    }

    private void sendMessageToTargetThread(PlayerMessage message) {
        Handler handler = message.getHandler();
        handler.post(() -> {
            try {
                this.deliverMessage(message);
            }
            catch (ExoPlaybackException e) {
                Log.e(TAG, "Unexpected error delivering message on external thread.", e);
                throw new RuntimeException(e);
            }
        });
    }

    private void deliverMessage(PlayerMessage message) throws ExoPlaybackException {
        if (message.isCanceled()) {
            return;
        }
        try {
            message.getTarget().handleMessage(message.getType(), message.getPayload());
        }
        finally {
            message.markAsProcessed(true);
        }
    }

    private void resolvePendingMessagePositions() {
        for (int i = this.pendingMessages.size() - 1; i >= 0; --i) {
            if (this.resolvePendingMessagePosition(this.pendingMessages.get(i))) continue;
            this.pendingMessages.get((int)i).message.markAsProcessed(false);
            this.pendingMessages.remove(i);
        }
        Collections.sort(this.pendingMessages);
    }

    private boolean resolvePendingMessagePosition(PendingMessageInfo pendingMessageInfo) {
        if (pendingMessageInfo.resolvedPeriodUid == null) {
            Pair<Object, Long> periodPosition = this.resolveSeekPosition(new SeekPosition(pendingMessageInfo.message.getTimeline(), pendingMessageInfo.message.getWindowIndex(), C.msToUs(pendingMessageInfo.message.getPositionMs())), false);
            if (periodPosition == null) {
                return false;
            }
            pendingMessageInfo.setResolvedPosition(this.playbackInfo.timeline.getIndexOfPeriod(periodPosition.first), (Long)periodPosition.second, periodPosition.first);
        } else {
            int index = this.playbackInfo.timeline.getIndexOfPeriod(pendingMessageInfo.resolvedPeriodUid);
            if (index == -1) {
                return false;
            }
            pendingMessageInfo.resolvedPeriodIndex = index;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeTriggerPendingMessages(long oldPeriodPositionUs, long newPeriodPositionUs) throws ExoPlaybackException {
        PendingMessageInfo nextInfo;
        PendingMessageInfo previousInfo;
        if (this.pendingMessages.isEmpty() || this.playbackInfo.periodId.isAd()) {
            return;
        }
        if (this.playbackInfo.startPositionUs == oldPeriodPositionUs) {
            --oldPeriodPositionUs;
        }
        int currentPeriodIndex = this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
        PendingMessageInfo pendingMessageInfo = previousInfo = this.nextPendingMessageIndex > 0 ? this.pendingMessages.get(this.nextPendingMessageIndex - 1) : null;
        while (previousInfo != null && (previousInfo.resolvedPeriodIndex > currentPeriodIndex || previousInfo.resolvedPeriodIndex == currentPeriodIndex && previousInfo.resolvedPeriodTimeUs > oldPeriodPositionUs)) {
            --this.nextPendingMessageIndex;
            previousInfo = this.nextPendingMessageIndex > 0 ? this.pendingMessages.get(this.nextPendingMessageIndex - 1) : null;
        }
        PendingMessageInfo pendingMessageInfo2 = nextInfo = this.nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(this.nextPendingMessageIndex) : null;
        while (nextInfo != null && nextInfo.resolvedPeriodUid != null && (nextInfo.resolvedPeriodIndex < currentPeriodIndex || nextInfo.resolvedPeriodIndex == currentPeriodIndex && nextInfo.resolvedPeriodTimeUs <= oldPeriodPositionUs)) {
            ++this.nextPendingMessageIndex;
            nextInfo = this.nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(this.nextPendingMessageIndex) : null;
        }
        while (nextInfo != null && nextInfo.resolvedPeriodUid != null && nextInfo.resolvedPeriodIndex == currentPeriodIndex && nextInfo.resolvedPeriodTimeUs > oldPeriodPositionUs && nextInfo.resolvedPeriodTimeUs <= newPeriodPositionUs) {
            try {
                this.sendMessageToTarget(nextInfo.message);
            }
            finally {
                if (nextInfo.message.getDeleteAfterDelivery() || nextInfo.message.isCanceled()) {
                    this.pendingMessages.remove(this.nextPendingMessageIndex);
                } else {
                    ++this.nextPendingMessageIndex;
                }
            }
            nextInfo = this.nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(this.nextPendingMessageIndex) : null;
        }
    }

    private void ensureStopped(Renderer renderer) throws ExoPlaybackException {
        if (renderer.getState() == 2) {
            renderer.stop();
        }
    }

    private void disableRenderer(Renderer renderer) throws ExoPlaybackException {
        this.mediaClock.onRendererDisabled(renderer);
        this.ensureStopped(renderer);
        renderer.disable();
    }

    private void reselectTracksInternal() throws ExoPlaybackException {
        TrackSelectorResult newTrackSelectorResult;
        if (!this.queue.hasPlayingPeriod()) {
            return;
        }
        float playbackSpeed = this.mediaClock.getPlaybackParameters().speed;
        MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod();
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        boolean selectionsChangedForReadPeriod = true;
        while (true) {
            if (periodHolder == null || !periodHolder.prepared) {
                return;
            }
            newTrackSelectorResult = periodHolder.selectTracks(playbackSpeed, this.playbackInfo.timeline);
            if (newTrackSelectorResult != null) break;
            if (periodHolder == readingPeriodHolder) {
                selectionsChangedForReadPeriod = false;
            }
            periodHolder = periodHolder.getNext();
        }
        if (selectionsChangedForReadPeriod) {
            MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
            boolean recreateStreams = this.queue.removeAfter(playingPeriodHolder);
            boolean[] streamResetFlags = new boolean[this.renderers.length];
            long periodPositionUs = playingPeriodHolder.applyTrackSelection(newTrackSelectorResult, this.playbackInfo.positionUs, recreateStreams, streamResetFlags);
            if (this.playbackInfo.playbackState != 4 && periodPositionUs != this.playbackInfo.positionUs) {
                this.playbackInfo = this.playbackInfo.copyWithNewPosition(this.playbackInfo.periodId, periodPositionUs, this.playbackInfo.contentPositionUs, this.getTotalBufferedDurationUs());
                this.playbackInfoUpdate.setPositionDiscontinuity(4);
                this.resetRendererPosition(periodPositionUs);
            }
            int enabledRendererCount = 0;
            boolean[] rendererWasEnabledFlags = new boolean[this.renderers.length];
            for (int i = 0; i < this.renderers.length; ++i) {
                Renderer renderer = this.renderers[i];
                rendererWasEnabledFlags[i] = renderer.getState() != 0;
                SampleStream sampleStream = playingPeriodHolder.sampleStreams[i];
                if (sampleStream != null) {
                    ++enabledRendererCount;
                }
                if (!rendererWasEnabledFlags[i]) continue;
                if (sampleStream != renderer.getStream()) {
                    this.disableRenderer(renderer);
                    continue;
                }
                if (!streamResetFlags[i]) continue;
                renderer.resetPosition(this.rendererPositionUs);
            }
            this.playbackInfo = this.playbackInfo.copyWithTrackInfo(playingPeriodHolder.getTrackGroups(), playingPeriodHolder.getTrackSelectorResult());
            this.enableRenderers(rendererWasEnabledFlags, enabledRendererCount);
        } else {
            this.queue.removeAfter(periodHolder);
            if (periodHolder.prepared) {
                long loadingPeriodPositionUs = Math.max(periodHolder.info.startPositionUs, periodHolder.toPeriodTime(this.rendererPositionUs));
                periodHolder.applyTrackSelection(newTrackSelectorResult, loadingPeriodPositionUs, false);
            }
        }
        this.handleLoadingMediaPeriodChanged(true);
        if (this.playbackInfo.playbackState != 4) {
            this.maybeContinueLoading();
            this.updatePlaybackPositions();
            this.handler.sendEmptyMessage(2);
        }
    }

    private void updateTrackSelectionPlaybackSpeed(float playbackSpeed) {
        for (MediaPeriodHolder periodHolder = this.queue.getFrontPeriod(); periodHolder != null && periodHolder.prepared; periodHolder = periodHolder.getNext()) {
            TrackSelection[] trackSelections;
            for (TrackSelection trackSelection : trackSelections = periodHolder.getTrackSelectorResult().selections.getAll()) {
                if (trackSelection == null) continue;
                trackSelection.onPlaybackSpeed(playbackSpeed);
            }
        }
    }

    private void notifyTrackSelectionDiscontinuity() {
        for (MediaPeriodHolder periodHolder = this.queue.getFrontPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
            TrackSelection[] trackSelections;
            TrackSelectorResult trackSelectorResult = periodHolder.getTrackSelectorResult();
            if (trackSelectorResult == null) continue;
            for (TrackSelection trackSelection : trackSelections = trackSelectorResult.selections.getAll()) {
                if (trackSelection == null) continue;
                trackSelection.onDiscontinuity();
            }
        }
    }

    private boolean shouldTransitionToReadyState(boolean renderersReadyOrEnded) {
        if (this.enabledRenderers.length == 0) {
            return this.isTimelineReady();
        }
        if (!renderersReadyOrEnded) {
            return false;
        }
        if (!this.playbackInfo.isLoading) {
            return true;
        }
        MediaPeriodHolder loadingHolder = this.queue.getLoadingPeriod();
        boolean bufferedToEnd = loadingHolder.isFullyBuffered() && loadingHolder.info.isFinal;
        return bufferedToEnd || this.loadControl.shouldStartPlayback(this.getTotalBufferedDurationUs(), this.mediaClock.getPlaybackParameters().speed, this.rebuffering);
    }

    private boolean isTimelineReady() {
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        MediaPeriodHolder nextPeriodHolder = playingPeriodHolder.getNext();
        long playingPeriodDurationUs = playingPeriodHolder.info.durationUs;
        return playingPeriodDurationUs == -9223372036854775807L || this.playbackInfo.positionUs < playingPeriodDurationUs || nextPeriodHolder != null && (nextPeriodHolder.prepared || nextPeriodHolder.info.id.isAd());
    }

    private void maybeThrowSourceInfoRefreshError() throws IOException {
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        if (loadingPeriodHolder != null) {
            for (Renderer renderer : this.enabledRenderers) {
                if (renderer.hasReadStreamToEnd()) continue;
                return;
            }
        }
        this.mediaSource.maybeThrowSourceInfoRefreshError();
    }

    private void maybeThrowPeriodPrepareError() throws IOException {
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        if (!(loadingPeriodHolder == null || loadingPeriodHolder.prepared || readingPeriodHolder != null && readingPeriodHolder.getNext() != loadingPeriodHolder)) {
            for (Renderer renderer : this.enabledRenderers) {
                if (renderer.hasReadStreamToEnd()) continue;
                return;
            }
            loadingPeriodHolder.mediaPeriod.maybeThrowPrepareError();
        }
    }

    private void handleSourceInfoRefreshed(MediaSourceRefreshInfo sourceRefreshInfo) throws ExoPlaybackException {
        long oldContentPositionUs;
        if (sourceRefreshInfo.source != this.mediaSource) {
            return;
        }
        this.playbackInfoUpdate.incrementPendingOperationAcks(this.pendingPrepareCount);
        this.pendingPrepareCount = 0;
        Timeline oldTimeline = this.playbackInfo.timeline;
        Timeline timeline = sourceRefreshInfo.timeline;
        Object manifest = sourceRefreshInfo.manifest;
        this.queue.setTimeline(timeline);
        this.playbackInfo = this.playbackInfo.copyWithTimeline(timeline, manifest);
        this.resolvePendingMessagePositions();
        MediaSource.MediaPeriodId newPeriodId = this.playbackInfo.periodId;
        long newContentPositionUs = oldContentPositionUs = this.playbackInfo.periodId.isAd() ? this.playbackInfo.contentPositionUs : this.playbackInfo.positionUs;
        if (this.pendingInitialSeekPosition != null) {
            Pair<Object, Long> periodPosition = this.resolveSeekPosition(this.pendingInitialSeekPosition, true);
            this.pendingInitialSeekPosition = null;
            if (periodPosition == null) {
                this.handleSourceInfoRefreshEndedPlayback();
                return;
            }
            newContentPositionUs = (Long)periodPosition.second;
            newPeriodId = this.queue.resolveMediaPeriodIdForAds(periodPosition.first, newContentPositionUs);
        } else if (oldContentPositionUs == -9223372036854775807L && !timeline.isEmpty()) {
            Pair<Object, Long> defaultPosition = this.getPeriodPosition(timeline, timeline.getFirstWindowIndex(this.shuffleModeEnabled), -9223372036854775807L);
            newContentPositionUs = (Long)defaultPosition.second;
            newPeriodId = this.queue.resolveMediaPeriodIdForAds(defaultPosition.first, newContentPositionUs);
        } else if (timeline.getIndexOfPeriod(newPeriodId.periodUid) == -1) {
            Object newPeriodUid = this.resolveSubsequentPeriod(newPeriodId.periodUid, oldTimeline, timeline);
            if (newPeriodUid == null) {
                this.handleSourceInfoRefreshEndedPlayback();
                return;
            }
            Pair<Object, Long> defaultPosition = this.getPeriodPosition(timeline, timeline.getPeriodByUid((Object)newPeriodUid, (Timeline.Period)this.period).windowIndex, -9223372036854775807L);
            newContentPositionUs = (Long)defaultPosition.second;
            newPeriodId = this.queue.resolveMediaPeriodIdForAds(defaultPosition.first, newContentPositionUs);
        } else if (newPeriodId.isAd()) {
            newPeriodId = this.queue.resolveMediaPeriodIdForAds(newPeriodId.periodUid, newContentPositionUs);
        }
        if (this.playbackInfo.periodId.equals(newPeriodId) && oldContentPositionUs == newContentPositionUs) {
            if (!this.queue.updateQueuedPeriods(this.rendererPositionUs, this.getMaxRendererReadPositionUs())) {
                this.seekToCurrentPosition(false);
            }
        } else {
            MediaPeriodHolder periodHolder = this.queue.getFrontPeriod();
            if (periodHolder != null) {
                while (periodHolder.getNext() != null) {
                    periodHolder = periodHolder.getNext();
                    if (!periodHolder.info.id.equals(newPeriodId)) continue;
                    periodHolder.info = this.queue.getUpdatedMediaPeriodInfo(periodHolder.info);
                }
            }
            long newPositionUs = newPeriodId.isAd() ? 0L : newContentPositionUs;
            long seekedToPositionUs = this.seekToPeriodPosition(newPeriodId, newPositionUs);
            this.playbackInfo = this.playbackInfo.copyWithNewPosition(newPeriodId, seekedToPositionUs, newContentPositionUs, this.getTotalBufferedDurationUs());
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private long getMaxRendererReadPositionUs() {
        MediaPeriodHolder readingHolder = this.queue.getReadingPeriod();
        if (readingHolder == null) {
            return 0L;
        }
        long maxReadPositionUs = readingHolder.getRendererOffset();
        for (int i = 0; i < this.renderers.length; ++i) {
            if (this.renderers[i].getState() == 0 || this.renderers[i].getStream() != readingHolder.sampleStreams[i]) continue;
            long readingPositionUs = this.renderers[i].getReadingPositionUs();
            if (readingPositionUs == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            maxReadPositionUs = Math.max(readingPositionUs, maxReadPositionUs);
        }
        return maxReadPositionUs;
    }

    private void handleSourceInfoRefreshEndedPlayback() {
        this.setState(4);
        this.resetInternal(false, false, true, false);
    }

    @Nullable
    private Object resolveSubsequentPeriod(Object oldPeriodUid, Timeline oldTimeline, Timeline newTimeline) {
        int oldPeriodIndex = oldTimeline.getIndexOfPeriod(oldPeriodUid);
        int newPeriodIndex = -1;
        int maxIterations = oldTimeline.getPeriodCount();
        for (int i = 0; i < maxIterations && newPeriodIndex == -1 && (oldPeriodIndex = oldTimeline.getNextPeriodIndex(oldPeriodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled)) != -1; ++i) {
            newPeriodIndex = newTimeline.getIndexOfPeriod(oldTimeline.getUidOfPeriod(oldPeriodIndex));
        }
        return newPeriodIndex == -1 ? null : newTimeline.getUidOfPeriod(newPeriodIndex);
    }

    private Pair<Object, Long> resolveSeekPosition(SeekPosition seekPosition, boolean trySubsequentPeriods) {
        Object periodUid;
        Pair<Object, Long> periodPosition;
        Timeline timeline = this.playbackInfo.timeline;
        Timeline seekTimeline = seekPosition.timeline;
        if (timeline.isEmpty()) {
            return null;
        }
        if (seekTimeline.isEmpty()) {
            seekTimeline = timeline;
        }
        try {
            periodPosition = seekTimeline.getPeriodPosition(this.window, this.period, seekPosition.windowIndex, seekPosition.windowPositionUs);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (timeline == seekTimeline) {
            return periodPosition;
        }
        int periodIndex = timeline.getIndexOfPeriod(periodPosition.first);
        if (periodIndex != -1) {
            return periodPosition;
        }
        if (trySubsequentPeriods && (periodUid = this.resolveSubsequentPeriod(periodPosition.first, seekTimeline, timeline)) != null) {
            return this.getPeriodPosition(timeline, timeline.getPeriod((int)periodIndex, (Timeline.Period)this.period).windowIndex, -9223372036854775807L);
        }
        return null;
    }

    private Pair<Object, Long> getPeriodPosition(Timeline timeline, int windowIndex, long windowPositionUs) {
        return timeline.getPeriodPosition(this.window, this.period, windowIndex, windowPositionUs);
    }

    private void updatePeriods() throws ExoPlaybackException, IOException {
        Renderer renderer;
        int i;
        if (this.mediaSource == null) {
            return;
        }
        if (this.pendingPrepareCount > 0) {
            this.mediaSource.maybeThrowSourceInfoRefreshError();
            return;
        }
        this.maybeUpdateLoadingPeriod();
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        if (loadingPeriodHolder == null || loadingPeriodHolder.isFullyBuffered()) {
            this.setIsLoading(false);
        } else if (!this.playbackInfo.isLoading) {
            this.maybeContinueLoading();
        }
        if (!this.queue.hasPlayingPeriod()) {
            return;
        }
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        boolean advancedPlayingPeriod = false;
        while (this.playWhenReady && playingPeriodHolder != readingPeriodHolder && this.rendererPositionUs >= playingPeriodHolder.getNext().getStartPositionRendererTime()) {
            if (advancedPlayingPeriod) {
                this.maybeNotifyPlaybackInfoChanged();
            }
            int discontinuityReason = playingPeriodHolder.info.isLastInTimelinePeriod ? 0 : 3;
            MediaPeriodHolder oldPlayingPeriodHolder = playingPeriodHolder;
            playingPeriodHolder = this.queue.advancePlayingPeriod();
            this.updatePlayingPeriodRenderers(oldPlayingPeriodHolder);
            this.playbackInfo = this.playbackInfo.copyWithNewPosition(playingPeriodHolder.info.id, playingPeriodHolder.info.startPositionUs, playingPeriodHolder.info.contentPositionUs, this.getTotalBufferedDurationUs());
            this.playbackInfoUpdate.setPositionDiscontinuity(discontinuityReason);
            this.updatePlaybackPositions();
            advancedPlayingPeriod = true;
        }
        if (readingPeriodHolder.info.isFinal) {
            for (i = 0; i < this.renderers.length; ++i) {
                renderer = this.renderers[i];
                SampleStream sampleStream = readingPeriodHolder.sampleStreams[i];
                if (sampleStream == null || renderer.getStream() != sampleStream || !renderer.hasReadStreamToEnd()) continue;
                renderer.setCurrentStreamFinal();
            }
            return;
        }
        if (readingPeriodHolder.getNext() == null) {
            return;
        }
        for (i = 0; i < this.renderers.length; ++i) {
            renderer = this.renderers[i];
            SampleStream sampleStream = readingPeriodHolder.sampleStreams[i];
            if (renderer.getStream() == sampleStream && (sampleStream == null || renderer.hasReadStreamToEnd())) continue;
            return;
        }
        if (!readingPeriodHolder.getNext().prepared) {
            this.maybeThrowPeriodPrepareError();
            return;
        }
        TrackSelectorResult oldTrackSelectorResult = readingPeriodHolder.getTrackSelectorResult();
        readingPeriodHolder = this.queue.advanceReadingPeriod();
        TrackSelectorResult newTrackSelectorResult = readingPeriodHolder.getTrackSelectorResult();
        boolean initialDiscontinuity = readingPeriodHolder.mediaPeriod.readDiscontinuity() != -9223372036854775807L;
        for (int i2 = 0; i2 < this.renderers.length; ++i2) {
            Renderer renderer2 = this.renderers[i2];
            boolean rendererWasEnabled = oldTrackSelectorResult.isRendererEnabled(i2);
            if (!rendererWasEnabled) continue;
            if (initialDiscontinuity) {
                renderer2.setCurrentStreamFinal();
                continue;
            }
            if (renderer2.isCurrentStreamFinal()) continue;
            TrackSelection newSelection = newTrackSelectorResult.selections.get(i2);
            boolean newRendererEnabled = newTrackSelectorResult.isRendererEnabled(i2);
            boolean isNoSampleRenderer = this.rendererCapabilities[i2].getTrackType() == 6;
            RendererConfiguration oldConfig = oldTrackSelectorResult.rendererConfigurations[i2];
            RendererConfiguration newConfig = newTrackSelectorResult.rendererConfigurations[i2];
            if (newRendererEnabled && newConfig.equals(oldConfig) && !isNoSampleRenderer) {
                Format[] formats = ExoPlayerImplInternal.getFormats(newSelection);
                renderer2.replaceStream(formats, readingPeriodHolder.sampleStreams[i2], readingPeriodHolder.getRendererOffset());
                continue;
            }
            renderer2.setCurrentStreamFinal();
        }
    }

    private void maybeUpdateLoadingPeriod() throws IOException {
        this.queue.reevaluateBuffer(this.rendererPositionUs);
        if (this.queue.shouldLoadNextMediaPeriod()) {
            MediaPeriodInfo info = this.queue.getNextMediaPeriodInfo(this.rendererPositionUs, this.playbackInfo);
            if (info == null) {
                this.maybeThrowSourceInfoRefreshError();
            } else {
                MediaPeriod mediaPeriod = this.queue.enqueueNextMediaPeriod(this.rendererCapabilities, this.trackSelector, this.loadControl.getAllocator(), this.mediaSource, info);
                mediaPeriod.prepare(this, info.startPositionUs);
                this.setIsLoading(true);
                this.handleLoadingMediaPeriodChanged(false);
            }
        }
    }

    private void handlePeriodPrepared(MediaPeriod mediaPeriod) throws ExoPlaybackException {
        if (!this.queue.isLoading(mediaPeriod)) {
            return;
        }
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        loadingPeriodHolder.handlePrepared(this.mediaClock.getPlaybackParameters().speed, this.playbackInfo.timeline);
        this.updateLoadControlTrackSelection(loadingPeriodHolder.getTrackGroups(), loadingPeriodHolder.getTrackSelectorResult());
        if (!this.queue.hasPlayingPeriod()) {
            MediaPeriodHolder playingPeriodHolder = this.queue.advancePlayingPeriod();
            this.resetRendererPosition(playingPeriodHolder.info.startPositionUs);
            this.updatePlayingPeriodRenderers(null);
        }
        this.maybeContinueLoading();
    }

    private void handleContinueLoadingRequested(MediaPeriod mediaPeriod) {
        if (!this.queue.isLoading(mediaPeriod)) {
            return;
        }
        this.queue.reevaluateBuffer(this.rendererPositionUs);
        this.maybeContinueLoading();
    }

    private void handlePlaybackParameters(PlaybackParameters playbackParameters) throws ExoPlaybackException {
        this.eventHandler.obtainMessage(1, (Object)playbackParameters).sendToTarget();
        this.updateTrackSelectionPlaybackSpeed(playbackParameters.speed);
        for (Renderer renderer : this.renderers) {
            if (renderer == null) continue;
            renderer.setOperatingRate(playbackParameters.speed);
        }
    }

    private void maybeContinueLoading() {
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        long nextLoadPositionUs = loadingPeriodHolder.getNextLoadPositionUs();
        if (nextLoadPositionUs == Long.MIN_VALUE) {
            this.setIsLoading(false);
            return;
        }
        long bufferedDurationUs = this.getTotalBufferedDurationUs(nextLoadPositionUs);
        boolean continueLoading = this.loadControl.shouldContinueLoading(bufferedDurationUs, this.mediaClock.getPlaybackParameters().speed);
        this.setIsLoading(continueLoading);
        if (continueLoading) {
            loadingPeriodHolder.continueLoading(this.rendererPositionUs);
        }
    }

    private void updatePlayingPeriodRenderers(@Nullable MediaPeriodHolder oldPlayingPeriodHolder) throws ExoPlaybackException {
        MediaPeriodHolder newPlayingPeriodHolder = this.queue.getPlayingPeriod();
        if (newPlayingPeriodHolder == null || oldPlayingPeriodHolder == newPlayingPeriodHolder) {
            return;
        }
        int enabledRendererCount = 0;
        boolean[] rendererWasEnabledFlags = new boolean[this.renderers.length];
        for (int i = 0; i < this.renderers.length; ++i) {
            Renderer renderer = this.renderers[i];
            boolean bl = rendererWasEnabledFlags[i] = renderer.getState() != 0;
            if (newPlayingPeriodHolder.getTrackSelectorResult().isRendererEnabled(i)) {
                ++enabledRendererCount;
            }
            if (!rendererWasEnabledFlags[i] || newPlayingPeriodHolder.getTrackSelectorResult().isRendererEnabled(i) && (!renderer.isCurrentStreamFinal() || renderer.getStream() != oldPlayingPeriodHolder.sampleStreams[i])) continue;
            this.disableRenderer(renderer);
        }
        this.playbackInfo = this.playbackInfo.copyWithTrackInfo(newPlayingPeriodHolder.getTrackGroups(), newPlayingPeriodHolder.getTrackSelectorResult());
        this.enableRenderers(rendererWasEnabledFlags, enabledRendererCount);
    }

    private void enableRenderers(boolean[] rendererWasEnabledFlags, int totalEnabledRendererCount) throws ExoPlaybackException {
        int i;
        this.enabledRenderers = new Renderer[totalEnabledRendererCount];
        int enabledRendererCount = 0;
        TrackSelectorResult trackSelectorResult = this.queue.getPlayingPeriod().getTrackSelectorResult();
        for (i = 0; i < this.renderers.length; ++i) {
            if (trackSelectorResult.isRendererEnabled(i)) continue;
            this.renderers[i].reset();
        }
        for (i = 0; i < this.renderers.length; ++i) {
            if (!trackSelectorResult.isRendererEnabled(i)) continue;
            this.enableRenderer(i, rendererWasEnabledFlags[i], enabledRendererCount++);
        }
    }

    private void enableRenderer(int rendererIndex, boolean wasRendererEnabled, int enabledRendererIndex) throws ExoPlaybackException {
        Renderer renderer;
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        this.enabledRenderers[enabledRendererIndex] = renderer = this.renderers[rendererIndex];
        if (renderer.getState() == 0) {
            TrackSelectorResult trackSelectorResult = playingPeriodHolder.getTrackSelectorResult();
            RendererConfiguration rendererConfiguration = trackSelectorResult.rendererConfigurations[rendererIndex];
            TrackSelection newSelection = trackSelectorResult.selections.get(rendererIndex);
            Format[] formats = ExoPlayerImplInternal.getFormats(newSelection);
            boolean playing = this.playWhenReady && this.playbackInfo.playbackState == 3;
            boolean joining = !wasRendererEnabled && playing;
            renderer.enable(rendererConfiguration, formats, playingPeriodHolder.sampleStreams[rendererIndex], this.rendererPositionUs, joining, playingPeriodHolder.getRendererOffset());
            this.mediaClock.onRendererEnabled(renderer);
            if (playing) {
                renderer.start();
            }
        }
    }

    private boolean rendererWaitingForNextStream(Renderer renderer) {
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        MediaPeriodHolder nextPeriodHolder = readingPeriodHolder.getNext();
        return nextPeriodHolder != null && nextPeriodHolder.prepared && renderer.hasReadStreamToEnd();
    }

    private void handleLoadingMediaPeriodChanged(boolean loadingTrackSelectionChanged) {
        boolean loadingMediaPeriodChanged;
        MediaPeriodHolder loadingMediaPeriodHolder = this.queue.getLoadingPeriod();
        MediaSource.MediaPeriodId loadingMediaPeriodId = loadingMediaPeriodHolder == null ? this.playbackInfo.periodId : loadingMediaPeriodHolder.info.id;
        boolean bl = loadingMediaPeriodChanged = !this.playbackInfo.loadingMediaPeriodId.equals(loadingMediaPeriodId);
        if (loadingMediaPeriodChanged) {
            this.playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(loadingMediaPeriodId);
        }
        this.playbackInfo.bufferedPositionUs = loadingMediaPeriodHolder == null ? this.playbackInfo.positionUs : loadingMediaPeriodHolder.getBufferedPositionUs();
        this.playbackInfo.totalBufferedDurationUs = this.getTotalBufferedDurationUs();
        if ((loadingMediaPeriodChanged || loadingTrackSelectionChanged) && loadingMediaPeriodHolder != null && loadingMediaPeriodHolder.prepared) {
            this.updateLoadControlTrackSelection(loadingMediaPeriodHolder.getTrackGroups(), loadingMediaPeriodHolder.getTrackSelectorResult());
        }
    }

    private long getTotalBufferedDurationUs() {
        return this.getTotalBufferedDurationUs(this.playbackInfo.bufferedPositionUs);
    }

    private long getTotalBufferedDurationUs(long bufferedPositionInLoadingPeriodUs) {
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        return loadingPeriodHolder == null ? 0L : bufferedPositionInLoadingPeriodUs - loadingPeriodHolder.toPeriodTime(this.rendererPositionUs);
    }

    private void updateLoadControlTrackSelection(TrackGroupArray trackGroups, TrackSelectorResult trackSelectorResult) {
        this.loadControl.onTracksSelected(this.renderers, trackGroups, trackSelectorResult.selections);
    }

    private static Format[] getFormats(TrackSelection newSelection) {
        int length = newSelection != null ? newSelection.length() : 0;
        Format[] formats = new Format[length];
        for (int i = 0; i < length; ++i) {
            formats[i] = newSelection.getFormat(i);
        }
        return formats;
    }

    private static final class PlaybackInfoUpdate {
        private PlaybackInfo lastPlaybackInfo;
        private int operationAcks;
        private boolean positionDiscontinuity;
        private int discontinuityReason;

        private PlaybackInfoUpdate() {
        }

        public boolean hasPendingUpdate(PlaybackInfo playbackInfo) {
            return playbackInfo != this.lastPlaybackInfo || this.operationAcks > 0 || this.positionDiscontinuity;
        }

        public void reset(PlaybackInfo playbackInfo) {
            this.lastPlaybackInfo = playbackInfo;
            this.operationAcks = 0;
            this.positionDiscontinuity = false;
        }

        public void incrementPendingOperationAcks(int operationAcks) {
            this.operationAcks += operationAcks;
        }

        public void setPositionDiscontinuity(int discontinuityReason) {
            if (this.positionDiscontinuity && this.discontinuityReason != 4) {
                Assertions.checkArgument(discontinuityReason == 4);
                return;
            }
            this.positionDiscontinuity = true;
            this.discontinuityReason = discontinuityReason;
        }
    }

    private static final class MediaSourceRefreshInfo {
        public final MediaSource source;
        public final Timeline timeline;
        public final Object manifest;

        public MediaSourceRefreshInfo(MediaSource source, Timeline timeline, Object manifest) {
            this.source = source;
            this.timeline = timeline;
            this.manifest = manifest;
        }
    }

    private static final class PendingMessageInfo
    implements Comparable<PendingMessageInfo> {
        public final PlayerMessage message;
        public int resolvedPeriodIndex;
        public long resolvedPeriodTimeUs;
        @Nullable
        public Object resolvedPeriodUid;

        public PendingMessageInfo(PlayerMessage message) {
            this.message = message;
        }

        public void setResolvedPosition(int periodIndex, long periodTimeUs, Object periodUid) {
            this.resolvedPeriodIndex = periodIndex;
            this.resolvedPeriodTimeUs = periodTimeUs;
            this.resolvedPeriodUid = periodUid;
        }

        @Override
        public int compareTo(@NonNull PendingMessageInfo other) {
            if (this.resolvedPeriodUid == null != (other.resolvedPeriodUid == null)) {
                return this.resolvedPeriodUid != null ? -1 : 1;
            }
            if (this.resolvedPeriodUid == null) {
                return 0;
            }
            int comparePeriodIndex = this.resolvedPeriodIndex - other.resolvedPeriodIndex;
            if (comparePeriodIndex != 0) {
                return comparePeriodIndex;
            }
            return Util.compareLong(this.resolvedPeriodTimeUs, other.resolvedPeriodTimeUs);
        }
    }

    private static final class SeekPosition {
        public final Timeline timeline;
        public final int windowIndex;
        public final long windowPositionUs;

        public SeekPosition(Timeline timeline, int windowIndex, long windowPositionUs) {
            this.timeline = timeline;
            this.windowIndex = windowIndex;
            this.windowPositionUs = windowPositionUs;
        }
    }
}

