/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImplInternal;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.IllegalSeekPositionException;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackInfo;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

final class ExoPlayerImpl
extends BasePlayer
implements ExoPlayer {
    private static final String TAG = "ExoPlayerImpl";
    final TrackSelectorResult emptyTrackSelectorResult;
    private final Renderer[] renderers;
    private final TrackSelector trackSelector;
    private final Handler eventHandler;
    private final ExoPlayerImplInternal internalPlayer;
    private final Handler internalPlayerHandler;
    private final CopyOnWriteArrayList<BasePlayer.ListenerHolder> listeners;
    private final Timeline.Period period;
    private final ArrayDeque<Runnable> pendingListenerNotifications;
    private MediaSource mediaSource;
    private boolean playWhenReady;
    private boolean internalPlayWhenReady;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    private int pendingOperationAcks;
    private boolean hasPendingPrepare;
    private boolean hasPendingSeek;
    private boolean foregroundMode;
    private PlaybackParameters playbackParameters;
    private SeekParameters seekParameters;
    @Nullable
    private ExoPlaybackException playbackError;
    private PlaybackInfo playbackInfo;
    private int maskingWindowIndex;
    private int maskingPeriodIndex;
    private long maskingWindowPositionMs;

    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImpl(Renderer[] renderers, TrackSelector trackSelector, LoadControl loadControl, BandwidthMeter bandwidthMeter, Clock clock, Looper looper) {
        Log.i(TAG, "Init " + Integer.toHexString(System.identityHashCode(this)) + " [" + "ExoPlayerLib/2.10.1" + "] [" + Util.DEVICE_DEBUG_INFO + "]");
        Assertions.checkState(renderers.length > 0);
        this.renderers = Assertions.checkNotNull(renderers);
        this.trackSelector = Assertions.checkNotNull(trackSelector);
        this.playWhenReady = false;
        this.repeatMode = 0;
        this.shuffleModeEnabled = false;
        this.listeners = new CopyOnWriteArrayList();
        this.emptyTrackSelectorResult = new TrackSelectorResult(new RendererConfiguration[renderers.length], new TrackSelection[renderers.length], null);
        this.period = new Timeline.Period();
        this.playbackParameters = PlaybackParameters.DEFAULT;
        this.seekParameters = SeekParameters.DEFAULT;
        this.eventHandler = new Handler(looper){

            public void handleMessage(Message msg) {
                ExoPlayerImpl.this.handleEvent(msg);
            }
        };
        this.playbackInfo = PlaybackInfo.createDummy(0L, this.emptyTrackSelectorResult);
        this.pendingListenerNotifications = new ArrayDeque();
        this.internalPlayer = new ExoPlayerImplInternal(renderers, trackSelector, this.emptyTrackSelectorResult, loadControl, bandwidthMeter, this.playWhenReady, this.repeatMode, this.shuffleModeEnabled, this.eventHandler, clock);
        this.internalPlayerHandler = new Handler(this.internalPlayer.getPlaybackLooper());
    }

    @Override
    @Nullable
    public Player.AudioComponent getAudioComponent() {
        return null;
    }

    @Override
    @Nullable
    public Player.VideoComponent getVideoComponent() {
        return null;
    }

    @Override
    @Nullable
    public Player.TextComponent getTextComponent() {
        return null;
    }

    @Override
    @Nullable
    public Player.MetadataComponent getMetadataComponent() {
        return null;
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.internalPlayer.getPlaybackLooper();
    }

    @Override
    public Looper getApplicationLooper() {
        return this.eventHandler.getLooper();
    }

    @Override
    public void addListener(Player.EventListener listener) {
        this.listeners.addIfAbsent(new BasePlayer.ListenerHolder(listener));
    }

    @Override
    public void removeListener(Player.EventListener listener) {
        for (BasePlayer.ListenerHolder listenerHolder : this.listeners) {
            if (!listenerHolder.listener.equals(listener)) continue;
            listenerHolder.release();
            this.listeners.remove(listenerHolder);
        }
    }

    @Override
    public int getPlaybackState() {
        return this.playbackInfo.playbackState;
    }

    @Override
    @Nullable
    public ExoPlaybackException getPlaybackError() {
        return this.playbackError;
    }

    @Override
    public void retry() {
        if (this.mediaSource != null && (this.playbackError != null || this.playbackInfo.playbackState == 1)) {
            this.prepare(this.mediaSource, false, false);
        }
    }

    @Override
    public void prepare(MediaSource mediaSource) {
        this.prepare(mediaSource, true, true);
    }

    @Override
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.playbackError = null;
        this.mediaSource = mediaSource;
        PlaybackInfo playbackInfo = this.getResetPlaybackInfo(resetPosition, resetState, 2);
        this.hasPendingPrepare = true;
        ++this.pendingOperationAcks;
        this.internalPlayer.prepare(mediaSource, resetPosition, resetState);
        this.updatePlaybackInfo(playbackInfo, false, 4, 1, false);
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        this.setPlayWhenReady(playWhenReady, false);
    }

    public void setPlayWhenReady(boolean playWhenReady, boolean suppressPlayback) {
        boolean internalPlayWhenReady;
        boolean bl = internalPlayWhenReady = playWhenReady && !suppressPlayback;
        if (this.internalPlayWhenReady != internalPlayWhenReady) {
            this.internalPlayWhenReady = internalPlayWhenReady;
            this.internalPlayer.setPlayWhenReady(internalPlayWhenReady);
        }
        if (this.playWhenReady != playWhenReady) {
            this.playWhenReady = playWhenReady;
            int playbackState = this.playbackInfo.playbackState;
            this.notifyListeners((Player.EventListener listener) -> listener.onPlayerStateChanged(playWhenReady, playbackState));
        }
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.playWhenReady;
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        if (this.repeatMode != repeatMode) {
            this.repeatMode = repeatMode;
            this.internalPlayer.setRepeatMode(repeatMode);
            this.notifyListeners((Player.EventListener listener) -> listener.onRepeatModeChanged(repeatMode));
        }
    }

    @Override
    public int getRepeatMode() {
        return this.repeatMode;
    }

    @Override
    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        if (this.shuffleModeEnabled != shuffleModeEnabled) {
            this.shuffleModeEnabled = shuffleModeEnabled;
            this.internalPlayer.setShuffleModeEnabled(shuffleModeEnabled);
            this.notifyListeners((Player.EventListener listener) -> listener.onShuffleModeEnabledChanged(shuffleModeEnabled));
        }
    }

    @Override
    public boolean getShuffleModeEnabled() {
        return this.shuffleModeEnabled;
    }

    @Override
    public boolean isLoading() {
        return this.playbackInfo.isLoading;
    }

    @Override
    public void seekTo(int windowIndex, long positionMs) {
        Timeline timeline = this.playbackInfo.timeline;
        if (windowIndex < 0 || !timeline.isEmpty() && windowIndex >= timeline.getWindowCount()) {
            throw new IllegalSeekPositionException(timeline, windowIndex, positionMs);
        }
        this.hasPendingSeek = true;
        ++this.pendingOperationAcks;
        if (this.isPlayingAd()) {
            Log.w(TAG, "seekTo ignored because an ad is playing");
            this.eventHandler.obtainMessage(0, 1, -1, (Object)this.playbackInfo).sendToTarget();
            return;
        }
        this.maskingWindowIndex = windowIndex;
        if (timeline.isEmpty()) {
            this.maskingWindowPositionMs = positionMs == -9223372036854775807L ? 0L : positionMs;
            this.maskingPeriodIndex = 0;
        } else {
            long windowPositionUs = positionMs == -9223372036854775807L ? timeline.getWindow(windowIndex, this.window).getDefaultPositionUs() : C.msToUs(positionMs);
            Pair<Object, Long> periodUidAndPosition = timeline.getPeriodPosition(this.window, this.period, windowIndex, windowPositionUs);
            this.maskingWindowPositionMs = C.usToMs(windowPositionUs);
            this.maskingPeriodIndex = timeline.getIndexOfPeriod(periodUidAndPosition.first);
        }
        this.internalPlayer.seekTo(timeline, windowIndex, C.msToUs(positionMs));
        this.notifyListeners((Player.EventListener listener) -> listener.onPositionDiscontinuity(1));
    }

    @Override
    public void setPlaybackParameters(@Nullable PlaybackParameters playbackParameters) {
        if (playbackParameters == null) {
            playbackParameters = PlaybackParameters.DEFAULT;
        }
        this.internalPlayer.setPlaybackParameters(playbackParameters);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.playbackParameters;
    }

    @Override
    public void setSeekParameters(@Nullable SeekParameters seekParameters) {
        if (seekParameters == null) {
            seekParameters = SeekParameters.DEFAULT;
        }
        if (!this.seekParameters.equals(seekParameters)) {
            this.seekParameters = seekParameters;
            this.internalPlayer.setSeekParameters(seekParameters);
        }
    }

    @Override
    public SeekParameters getSeekParameters() {
        return this.seekParameters;
    }

    @Override
    public void setForegroundMode(boolean foregroundMode) {
        if (this.foregroundMode != foregroundMode) {
            this.foregroundMode = foregroundMode;
            this.internalPlayer.setForegroundMode(foregroundMode);
        }
    }

    @Override
    public void stop(boolean reset) {
        if (reset) {
            this.playbackError = null;
            this.mediaSource = null;
        }
        PlaybackInfo playbackInfo = this.getResetPlaybackInfo(reset, reset, 1);
        ++this.pendingOperationAcks;
        this.internalPlayer.stop(reset);
        this.updatePlaybackInfo(playbackInfo, false, 4, 1, false);
    }

    @Override
    public void release() {
        Log.i(TAG, "Release " + Integer.toHexString(System.identityHashCode(this)) + " [" + "ExoPlayerLib/2.10.1" + "] [" + Util.DEVICE_DEBUG_INFO + "] [" + ExoPlayerLibraryInfo.registeredModules() + "]");
        this.mediaSource = null;
        this.internalPlayer.release();
        this.eventHandler.removeCallbacksAndMessages(null);
        this.playbackInfo = this.getResetPlaybackInfo(false, false, 1);
    }

    @Override
    @Deprecated
    public void sendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        for (ExoPlayer.ExoPlayerMessage message : messages) {
            this.createMessage(message.target).setType(message.messageType).setPayload(message.message).send();
        }
    }

    @Override
    public PlayerMessage createMessage(PlayerMessage.Target target) {
        return new PlayerMessage(this.internalPlayer, target, this.playbackInfo.timeline, this.getCurrentWindowIndex(), this.internalPlayerHandler);
    }

    @Override
    @Deprecated
    public void blockingSendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        ArrayList<PlayerMessage> playerMessages = new ArrayList<PlayerMessage>();
        for (ExoPlayer.ExoPlayerMessage message : messages) {
            playerMessages.add(this.createMessage(message.target).setType(message.messageType).setPayload(message.message).send());
        }
        boolean wasInterrupted = false;
        for (PlayerMessage message : playerMessages) {
            boolean blockMessage = true;
            while (blockMessage) {
                try {
                    message.blockUntilDelivered();
                    blockMessage = false;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public int getCurrentPeriodIndex() {
        if (this.shouldMaskPosition()) {
            return this.maskingPeriodIndex;
        }
        return this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
    }

    @Override
    public int getCurrentWindowIndex() {
        if (this.shouldMaskPosition()) {
            return this.maskingWindowIndex;
        }
        return this.playbackInfo.timeline.getPeriodByUid((Object)this.playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
    }

    @Override
    public long getDuration() {
        if (this.isPlayingAd()) {
            MediaSource.MediaPeriodId periodId = this.playbackInfo.periodId;
            this.playbackInfo.timeline.getPeriodByUid(periodId.periodUid, this.period);
            long adDurationUs = this.period.getAdDurationUs(periodId.adGroupIndex, periodId.adIndexInAdGroup);
            return C.usToMs(adDurationUs);
        }
        return this.getContentDuration();
    }

    @Override
    public long getCurrentPosition() {
        if (this.shouldMaskPosition()) {
            return this.maskingWindowPositionMs;
        }
        if (this.playbackInfo.periodId.isAd()) {
            return C.usToMs(this.playbackInfo.positionUs);
        }
        return this.periodPositionUsToWindowPositionMs(this.playbackInfo.periodId, this.playbackInfo.positionUs);
    }

    @Override
    public long getBufferedPosition() {
        if (this.isPlayingAd()) {
            return this.playbackInfo.loadingMediaPeriodId.equals(this.playbackInfo.periodId) ? C.usToMs(this.playbackInfo.bufferedPositionUs) : this.getDuration();
        }
        return this.getContentBufferedPosition();
    }

    @Override
    public long getTotalBufferedDuration() {
        return Math.max(0L, C.usToMs(this.playbackInfo.totalBufferedDurationUs));
    }

    @Override
    public boolean isPlayingAd() {
        return !this.shouldMaskPosition() && this.playbackInfo.periodId.isAd();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        return this.isPlayingAd() ? this.playbackInfo.periodId.adGroupIndex : -1;
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        return this.isPlayingAd() ? this.playbackInfo.periodId.adIndexInAdGroup : -1;
    }

    @Override
    public long getContentPosition() {
        if (this.isPlayingAd()) {
            this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.periodId.periodUid, this.period);
            return this.period.getPositionInWindowMs() + C.usToMs(this.playbackInfo.contentPositionUs);
        }
        return this.getCurrentPosition();
    }

    @Override
    public long getContentBufferedPosition() {
        Timeline.Period loadingPeriod;
        if (this.shouldMaskPosition()) {
            return this.maskingWindowPositionMs;
        }
        if (this.playbackInfo.loadingMediaPeriodId.windowSequenceNumber != this.playbackInfo.periodId.windowSequenceNumber) {
            return this.playbackInfo.timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDurationMs();
        }
        long contentBufferedPositionUs = this.playbackInfo.bufferedPositionUs;
        if (this.playbackInfo.loadingMediaPeriodId.isAd() && (contentBufferedPositionUs = (loadingPeriod = this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.loadingMediaPeriodId.periodUid, this.period)).getAdGroupTimeUs(this.playbackInfo.loadingMediaPeriodId.adGroupIndex)) == Long.MIN_VALUE) {
            contentBufferedPositionUs = loadingPeriod.durationUs;
        }
        return this.periodPositionUsToWindowPositionMs(this.playbackInfo.loadingMediaPeriodId, contentBufferedPositionUs);
    }

    @Override
    public int getRendererCount() {
        return this.renderers.length;
    }

    @Override
    public int getRendererType(int index) {
        return this.renderers[index].getTrackType();
    }

    @Override
    public TrackGroupArray getCurrentTrackGroups() {
        return this.playbackInfo.trackGroups;
    }

    @Override
    public TrackSelectionArray getCurrentTrackSelections() {
        return this.playbackInfo.trackSelectorResult.selections;
    }

    @Override
    public Timeline getCurrentTimeline() {
        return this.playbackInfo.timeline;
    }

    @Override
    public Object getCurrentManifest() {
        return this.playbackInfo.manifest;
    }

    void handleEvent(Message msg) {
        switch (msg.what) {
            case 0: {
                this.handlePlaybackInfo((PlaybackInfo)msg.obj, msg.arg1, msg.arg2 != -1, msg.arg2);
                break;
            }
            case 1: {
                PlaybackParameters playbackParameters = (PlaybackParameters)msg.obj;
                if (this.playbackParameters.equals(playbackParameters)) break;
                this.playbackParameters = playbackParameters;
                this.notifyListeners((Player.EventListener listener) -> listener.onPlaybackParametersChanged(playbackParameters));
                break;
            }
            case 2: {
                ExoPlaybackException playbackError;
                this.playbackError = playbackError = (ExoPlaybackException)msg.obj;
                this.notifyListeners((Player.EventListener listener) -> listener.onPlayerError(playbackError));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void handlePlaybackInfo(PlaybackInfo playbackInfo, int operationAcks, boolean positionDiscontinuity, int positionDiscontinuityReason) {
        this.pendingOperationAcks -= operationAcks;
        if (this.pendingOperationAcks == 0) {
            if (playbackInfo.startPositionUs == -9223372036854775807L) {
                playbackInfo = playbackInfo.resetToNewPosition(playbackInfo.periodId, 0L, playbackInfo.contentPositionUs);
            }
            if (!this.playbackInfo.timeline.isEmpty() && playbackInfo.timeline.isEmpty()) {
                this.maskingPeriodIndex = 0;
                this.maskingWindowIndex = 0;
                this.maskingWindowPositionMs = 0L;
            }
            int timelineChangeReason = this.hasPendingPrepare ? 0 : 2;
            boolean seekProcessed = this.hasPendingSeek;
            this.hasPendingPrepare = false;
            this.hasPendingSeek = false;
            this.updatePlaybackInfo(playbackInfo, positionDiscontinuity, positionDiscontinuityReason, timelineChangeReason, seekProcessed);
        }
    }

    private PlaybackInfo getResetPlaybackInfo(boolean resetPosition, boolean resetState, int playbackState) {
        if (resetPosition) {
            this.maskingWindowIndex = 0;
            this.maskingPeriodIndex = 0;
            this.maskingWindowPositionMs = 0L;
        } else {
            this.maskingWindowIndex = this.getCurrentWindowIndex();
            this.maskingPeriodIndex = this.getCurrentPeriodIndex();
            this.maskingWindowPositionMs = this.getCurrentPosition();
        }
        resetPosition = resetPosition || resetState;
        MediaSource.MediaPeriodId mediaPeriodId = resetPosition ? this.playbackInfo.getDummyFirstMediaPeriodId(this.shuffleModeEnabled, this.window) : this.playbackInfo.periodId;
        long startPositionUs = resetPosition ? 0L : this.playbackInfo.positionUs;
        long contentPositionUs = resetPosition ? -9223372036854775807L : this.playbackInfo.contentPositionUs;
        return new PlaybackInfo(resetState ? Timeline.EMPTY : this.playbackInfo.timeline, resetState ? null : this.playbackInfo.manifest, mediaPeriodId, startPositionUs, contentPositionUs, playbackState, false, resetState ? TrackGroupArray.EMPTY : this.playbackInfo.trackGroups, resetState ? this.emptyTrackSelectorResult : this.playbackInfo.trackSelectorResult, mediaPeriodId, startPositionUs, 0L, startPositionUs);
    }

    private void updatePlaybackInfo(PlaybackInfo playbackInfo, boolean positionDiscontinuity, int positionDiscontinuityReason, int timelineChangeReason, boolean seekProcessed) {
        PlaybackInfo previousPlaybackInfo = this.playbackInfo;
        this.playbackInfo = playbackInfo;
        this.notifyListeners(new PlaybackInfoUpdate(playbackInfo, previousPlaybackInfo, this.listeners, this.trackSelector, positionDiscontinuity, positionDiscontinuityReason, timelineChangeReason, seekProcessed, this.playWhenReady));
    }

    private void notifyListeners(BasePlayer.ListenerInvocation listenerInvocation) {
        CopyOnWriteArrayList<BasePlayer.ListenerHolder> listenerSnapshot = new CopyOnWriteArrayList<BasePlayer.ListenerHolder>(this.listeners);
        this.notifyListeners(() -> ExoPlayerImpl.invokeAll(listenerSnapshot, listenerInvocation));
    }

    private void notifyListeners(Runnable listenerNotificationRunnable) {
        boolean isRunningRecursiveListenerNotification = !this.pendingListenerNotifications.isEmpty();
        this.pendingListenerNotifications.addLast(listenerNotificationRunnable);
        if (isRunningRecursiveListenerNotification) {
            return;
        }
        while (!this.pendingListenerNotifications.isEmpty()) {
            this.pendingListenerNotifications.peekFirst().run();
            this.pendingListenerNotifications.removeFirst();
        }
    }

    private long periodPositionUsToWindowPositionMs(MediaSource.MediaPeriodId periodId, long positionUs) {
        long positionMs = C.usToMs(positionUs);
        this.playbackInfo.timeline.getPeriodByUid(periodId.periodUid, this.period);
        return positionMs += this.period.getPositionInWindowMs();
    }

    private boolean shouldMaskPosition() {
        return this.playbackInfo.timeline.isEmpty() || this.pendingOperationAcks > 0;
    }

    private static void invokeAll(CopyOnWriteArrayList<BasePlayer.ListenerHolder> listeners, BasePlayer.ListenerInvocation listenerInvocation) {
        for (BasePlayer.ListenerHolder listenerHolder : listeners) {
            listenerHolder.invoke(listenerInvocation);
        }
    }

    private static final class PlaybackInfoUpdate
    implements Runnable {
        private final PlaybackInfo playbackInfo;
        private final CopyOnWriteArrayList<BasePlayer.ListenerHolder> listenerSnapshot;
        private final TrackSelector trackSelector;
        private final boolean positionDiscontinuity;
        private final int positionDiscontinuityReason;
        private final int timelineChangeReason;
        private final boolean seekProcessed;
        private final boolean playbackStateChanged;
        private final boolean timelineOrManifestChanged;
        private final boolean isLoadingChanged;
        private final boolean trackSelectorResultChanged;
        private final boolean playWhenReady;

        public PlaybackInfoUpdate(PlaybackInfo playbackInfo, PlaybackInfo previousPlaybackInfo, CopyOnWriteArrayList<BasePlayer.ListenerHolder> listeners, TrackSelector trackSelector, boolean positionDiscontinuity, int positionDiscontinuityReason, int timelineChangeReason, boolean seekProcessed, boolean playWhenReady) {
            this.playbackInfo = playbackInfo;
            this.listenerSnapshot = new CopyOnWriteArrayList<BasePlayer.ListenerHolder>(listeners);
            this.trackSelector = trackSelector;
            this.positionDiscontinuity = positionDiscontinuity;
            this.positionDiscontinuityReason = positionDiscontinuityReason;
            this.timelineChangeReason = timelineChangeReason;
            this.seekProcessed = seekProcessed;
            this.playWhenReady = playWhenReady;
            this.playbackStateChanged = previousPlaybackInfo.playbackState != playbackInfo.playbackState;
            this.timelineOrManifestChanged = previousPlaybackInfo.timeline != playbackInfo.timeline || previousPlaybackInfo.manifest != playbackInfo.manifest;
            this.isLoadingChanged = previousPlaybackInfo.isLoading != playbackInfo.isLoading;
            this.trackSelectorResultChanged = previousPlaybackInfo.trackSelectorResult != playbackInfo.trackSelectorResult;
        }

        @Override
        public void run() {
            if (this.timelineOrManifestChanged || this.timelineChangeReason == 0) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onTimelineChanged(this.playbackInfo.timeline, this.playbackInfo.manifest, this.timelineChangeReason));
            }
            if (this.positionDiscontinuity) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPositionDiscontinuity(this.positionDiscontinuityReason));
            }
            if (this.trackSelectorResultChanged) {
                this.trackSelector.onSelectionActivated(this.playbackInfo.trackSelectorResult.info);
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onTracksChanged(this.playbackInfo.trackGroups, this.playbackInfo.trackSelectorResult.selections));
            }
            if (this.isLoadingChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onLoadingChanged(this.playbackInfo.isLoading));
            }
            if (this.playbackStateChanged) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, listener -> listener.onPlayerStateChanged(this.playWhenReady, this.playbackInfo.playbackState));
            }
            if (this.seekProcessed) {
                ExoPlayerImpl.invokeAll(this.listenerSnapshot, Player.EventListener::onSeekProcessed);
            }
        }
    }
}

