/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ExoPlaybackException
extends Exception {
    public static final int TYPE_SOURCE = 0;
    public static final int TYPE_RENDERER = 1;
    public static final int TYPE_UNEXPECTED = 2;
    public static final int TYPE_REMOTE = 3;
    public static final int TYPE_OUT_OF_MEMORY = 4;
    public final int type;
    public final int rendererIndex;
    @Nullable
    private final Throwable cause;

    public static ExoPlaybackException createForSource(IOException cause) {
        return new ExoPlaybackException(0, cause, -1);
    }

    public static ExoPlaybackException createForRenderer(Exception cause, int rendererIndex) {
        return new ExoPlaybackException(1, cause, rendererIndex);
    }

    public static ExoPlaybackException createForUnexpected(RuntimeException cause) {
        return new ExoPlaybackException(2, cause, -1);
    }

    public static ExoPlaybackException createForRemote(String message) {
        return new ExoPlaybackException(3, message);
    }

    public static ExoPlaybackException createForOutOfMemoryError(OutOfMemoryError cause) {
        return new ExoPlaybackException(4, cause, -1);
    }

    private ExoPlaybackException(int type, Throwable cause, int rendererIndex) {
        super(cause);
        this.type = type;
        this.cause = cause;
        this.rendererIndex = rendererIndex;
    }

    private ExoPlaybackException(int type, String message) {
        super(message);
        this.type = type;
        this.rendererIndex = -1;
        this.cause = null;
    }

    public IOException getSourceException() {
        Assertions.checkState(this.type == 0);
        return (IOException)Assertions.checkNotNull(this.cause);
    }

    public Exception getRendererException() {
        Assertions.checkState(this.type == 1);
        return (Exception)Assertions.checkNotNull(this.cause);
    }

    public RuntimeException getUnexpectedException() {
        Assertions.checkState(this.type == 2);
        return (RuntimeException)Assertions.checkNotNull(this.cause);
    }

    public OutOfMemoryError getOutOfMemoryError() {
        Assertions.checkState(this.type == 4);
        return (OutOfMemoryError)Assertions.checkNotNull(this.cause);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

