/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.util.Util;

public abstract class BasePlayer
implements Player {
    protected final Timeline.Window window = new Timeline.Window();

    @Override
    public final void seekToDefaultPosition() {
        this.seekToDefaultPosition(this.getCurrentWindowIndex());
    }

    @Override
    public final void seekToDefaultPosition(int windowIndex) {
        this.seekTo(windowIndex, -9223372036854775807L);
    }

    @Override
    public final void seekTo(long positionMs) {
        this.seekTo(this.getCurrentWindowIndex(), positionMs);
    }

    @Override
    public final boolean hasPrevious() {
        return this.getPreviousWindowIndex() != -1;
    }

    @Override
    public final void previous() {
        int previousWindowIndex = this.getPreviousWindowIndex();
        if (previousWindowIndex != -1) {
            this.seekToDefaultPosition(previousWindowIndex);
        }
    }

    @Override
    public final boolean hasNext() {
        return this.getNextWindowIndex() != -1;
    }

    @Override
    public final void next() {
        int nextWindowIndex = this.getNextWindowIndex();
        if (nextWindowIndex != -1) {
            this.seekToDefaultPosition(nextWindowIndex);
        }
    }

    @Override
    public final void stop() {
        this.stop(false);
    }

    @Override
    public final int getNextWindowIndex() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -1 : timeline.getNextWindowIndex(this.getCurrentWindowIndex(), this.getRepeatModeForNavigation(), this.getShuffleModeEnabled());
    }

    @Override
    public final int getPreviousWindowIndex() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -1 : timeline.getPreviousWindowIndex(this.getCurrentWindowIndex(), this.getRepeatModeForNavigation(), this.getShuffleModeEnabled());
    }

    @Override
    @Nullable
    public final Object getCurrentTag() {
        Timeline timeline;
        int windowIndex = this.getCurrentWindowIndex();
        return windowIndex >= (timeline = this.getCurrentTimeline()).getWindowCount() ? null : timeline.getWindow((int)windowIndex, (Timeline.Window)this.window, (boolean)true).tag;
    }

    @Override
    public final int getBufferedPercentage() {
        long position = this.getBufferedPosition();
        long duration = this.getDuration();
        return position == -9223372036854775807L || duration == -9223372036854775807L ? 0 : (duration == 0L ? 100 : Util.constrainValue((int)(position * 100L / duration), 0, 100));
    }

    @Override
    public final boolean isCurrentWindowDynamic() {
        Timeline timeline = this.getCurrentTimeline();
        return !timeline.isEmpty() && timeline.getWindow((int)this.getCurrentWindowIndex(), (Timeline.Window)this.window).isDynamic;
    }

    @Override
    public final boolean isCurrentWindowSeekable() {
        Timeline timeline = this.getCurrentTimeline();
        return !timeline.isEmpty() && timeline.getWindow((int)this.getCurrentWindowIndex(), (Timeline.Window)this.window).isSeekable;
    }

    @Override
    public final long getContentDuration() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -9223372036854775807L : timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDurationMs();
    }

    private int getRepeatModeForNavigation() {
        int repeatMode = this.getRepeatMode();
        return repeatMode == 1 ? 0 : repeatMode;
    }

    protected static interface ListenerInvocation {
        public void invokeListener(Player.EventListener var1);
    }

    protected static final class ListenerHolder {
        public final Player.EventListener listener;
        private boolean released;

        public ListenerHolder(Player.EventListener listener) {
            this.listener = listener;
        }

        public void release() {
            this.released = true;
        }

        public void invoke(ListenerInvocation listenerInvocation) {
            if (!this.released) {
                listenerInvocation.invokeListener(this.listener);
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.listener.equals(((ListenerHolder)other).listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

